from pathlib import Path
import argparse

import numpy as np
from rhodent.response import ResponseFromWaveFunctions


parser = argparse.ArgumentParser()
parser.add_argument('dpath', type=Path)

args = parser.parse_args()

# Set up a representative TDDFT perturbation
perturbation = {'name': 'SincPulse', 'strength': 1e-6, 'cutoff_freq': 8,
                'time0': 5.25, 'relative_t0': True}

# Set up a Gaussian pulse of interest
pulse = {'name': 'GaussianPulse', 'strength': 1e-6,
         'frequency': 3.8, 'time0': 10e3, 'sigma': 0.3}

response = ResponseFromWaveFunctions(wfs_fname=args.dpath / 'wfs.ulm',
                                     ksd=args.dpath / 'ksd.ulm',
                                     perturbation=perturbation)

# Perform pulse convolution and calculate the density matrices
# for the following times. By default real and imaginary parts
# are computed, but no derivatives.
response.write_in_time(str(args.dpath / 'pulserho/t{time:09.1f}{tag}.npy'),
                       times=np.arange(10, 30e3, 25),
                       pulses=[pulse],
                       derivative_order_s=[0, 1])
