#include <stdio.h>
#include <sys/sysinfo.h>
#include <unistd.h>
#include <time.h>

int main(void) {
    time_t start, now;
    struct sysinfo info;
    float elapsed, total_MiB, free_MiB;

    time(&start);

    printf("# %10s %10s %10s\n", "Time (s)", "Free (MiB)", "Used (MiB)");
    for (int i = 0; 1 ; i++) {
        time(&now);
        sysinfo(&info);
        total_MiB = (info.totalram * info.mem_unit) / 1024 / 1024;
        free_MiB = (info.freeram * info.mem_unit) / 1024 / 1024;
        elapsed = difftime(now, start);
        printf("  %-10.1f %-10.1f %-10.1f\n", elapsed, free_MiB, total_MiB - free_MiB);
        if (i % 20 == 0) fflush(stdout);  // Flush sometimes
        sleep(1);
    }
}
