# Benchmarking of rhodent package

This dataset contains benchmark scripts and results for an exemplary rhodent
workflow. These benchmark results were calculated on a system with dual
AMD EPYC Zen2 2.25 GHz processors with 128 cores per node and 850 GB available memory,
and presented in the article "rhodent: A Python package for analyzing real-time TDDFT response".

This text file contains instructions on how to generate test data for the
benchmark, how to execute the benchmark on a distributed environment using
SLURM, and how to analyze the results.


## Polling memory usage

The program `poll_memory_usage.c` measures free and used memory every second and
prints the information to the standard output stream. The program can be
compiled with, e.g., gcc:

```
gcc poll_memory_usage.c -O3 -o poll_memory_usage
```

During benchmarking, the program should be executed in the background. See the
SLURM batch scripts `submit_cores.sh` and `submit_basis.sh` for a working example.


## Executing the workflow in SLURM

In this workflow, time-dependent wave function files are read from
disk and transformed into density matrices in the Kohn-Sham basis. Then, pulse
convolution is performed through the fast Fourier transform and its inverse.
The resulting density matrices are written to disk.

There are two submission scripts `submit_basis.sh` and `submit_cores.sh`.
The former submits a series of jobs with increasing number of basis functions,
while the latter submits a job for a fixed number of basis functions, but varied
number of cores.

All benchmark results are generated by the following jobs:

```
sbatch -A ... submit_basis.sh
sbatch -A ... -N 1 -n 4 submit_cores.sh
sbatch -A ... -N 1 -n 8 submit_cores.sh
sbatch -A ... -N 1 -n 16 submit_cores.sh
sbatch -A ... -N 1 -n 32 submit_cores.sh
sbatch -A ... -N 1 -n 64 submit_cores.sh
sbatch -A ... -N 2 -n 256 submit_cores.sh
sbatch -A ... -N 3 -n 384 submit_cores.sh
sbatch -A ... -N 4 -n 512 submit_cores.sh
```

## Aggregating the results

```
find data/ -name result.log | xargs cat | head -n 1 > results.dat
find data/ -name result.log | sort | xargs cat | grep -v '#' >> results.dat
```

## Analyzing the results

All result figures in the article are plotted by executing the Jupyter notebook
`results.ipynb` in a Jupyter Notebook or Jupyter Lab environment. For example:

```
jupyter-lab results.ipynb
```

### Details about the workflow

The entire rhodent workflow is contained in one of two scripts
`run_benchmark_full.py` and `run_benchmark_single.py`, which calculate
density matrices at all time instances, or a single time instance.

Additionally, the script `generate_data.py` generates a time-dependent
wave-functions file and a Kohn-Sham decomposition file filled with random
numbers that can be read by rhodent. The number of basis functions in these
files are supplied as an argument to this script (this is handled by the
submission scripts).
The number of occupied states in the time-dependent wave functions file is
chosen to be one third of the number of basis functions, and 300 time steps are
generated. This is representative of typical calculations for Ag nanoparticles.
