# Method2Model — Stage-2 Formula & I/O Package (Example Deliverable)

**Dual-Platform mRNA Therapy for X-Linked ALD (LNP + EV, Peripheral-First → CNS)**

This Zenodo record shares an **example Stage-2 deliverable package** for a dual-platform mRNA therapy in X-linked adrenoleukodystrophy (ALD), using lipid nanoparticles (LNP) and extracellular vesicles (EV) in a *peripheral-first → CNS* strategy.

It is published as an **example of what a client can expect as a Stage-2 output** from the Method2Model pipeline: a pair of *implementation-ready* specifications (Formula Pack + I/O Contract), plus a non-technical **Model Explainer** that connects the math back to protocol and program decisions.

Stage-2 sits **after** Stage-1 (Logic + Architecture) and **before** any heavy coding, calibration, or full simulation runs. It is the point where the science is locked tightly enough that an internal or external modeling team can implement the model without re-negotiating definitions in email threads.

---

## Why Stage-2 Exists (and What Pain It Solves)

Most ambitious mRNA / gene-therapy programs struggle at the hand-off between:

- Concept and architecture (what we want to represent), and  
- Actual implementation (what gets coded, calibrated, and used for decisions).

Even when a solid Stage-1 architecture exists, teams still run into:

- **Ambiguous equations** (“is this per kg, per organ, or per cell type?”).
- **Unstated units and ranges** (“is NfL in pg/mL or ng/L?”).
- **Drifting CSV / HDF5 schemas** as different groups add columns and flags ad hoc.
- **Scope creep during coding** as new states and outputs are quietly added without going back through scientific review.

**Stage-2 removes that failure mode** by forcing the project through three concrete artifacts:

1. A **Formula Pack**: every state, parameter, and relationship written in explicit mathematical form.  
2. An **I/O Contract**: all files, fields, units, types, and shapes fixed in one place.  
3. A **Model Explainer**: plain-language mapping between blocks, files, and real protocol questions.

For sponsors and technical reviewers, Stage-2 is the point where we can say:

> **“The model is fully specified and safe to implement. Any change from here is a versioned scientific change, not a silent tweak.”**

---

## Files in This Record

### 1) Stage-2 Formula Pack  
**File:** `ALD_mRNA_Therapy_Formula.pdf`

**What it is**  
A **complete mathematical specification** of the model, consistent with the Stage-1 architecture but now written at equation level. It formalizes:

- Index sets (design, species, phenotype, platform, route, compartment, CNS cell type, scenarios, runs).  
- All **states, flows, and observables** for Blocks A–G:
  - **Block A:** delivery / PK / CNS exposure, including FUS-modulated BBB effects.
  - **Block B:** mRNA kinetics, ALDP expression, peroxisomal targeting vs mislocalization, and effective β-oxidation capacity \(V_\beta(t)\).
  - **Block C:** disease / PD dynamics, with explicit mouse and human-projected branches (VLCFA, inflammation, axonal injury, NfL, Loes).
  - **Block D:** safety / immunogenicity markers (cytokines, ALT/AST, ADA).
  - **Block E:** CMC-driven modifications to potency, escape, and related parameters.
  - **Block F:** priors, scenario overlays, and uncertainty propagation.
  - **Block G:** decision metrics and Go / No-Go / Pivot regions.
- How CMC metrics, priors, and scenarios mathematically alter parameters and outputs.  
- Any threshold, composite score, or derived index used in decision logic.

**Why it matters**  
This is the **single source of truth** for what the model is allowed to do. It prevents “equation drift” between what is agreed in design reviews and what is later coded.

**Primary audience**  
Modeling / quant teams, technical reviewers, and anyone who needs to check or modify the exact mathematical form.

---

### 2) Stage-2 I/O Contract (Official Schema)  
**File:** `ALD_mRNA_Therapy_Stage_2_IO_Contract.pdf`

**What it is**  
A **formal schema** for every input and output file used by the model, including:

- File-level overview (names, formats, and which blocks they feed or receive).  
- Identifier conventions (`design_id`, `scenario_id`, `run_id`, `batch_id`, `species`, `phenotype`, `subject_id`).  
- Detailed schemas for:
  - `dosing_schedule.csv` (dose, route, platform, mg/kg, arm).
  - `fus_schedule.csv` (FUS timing, duration, BBB permeability multiplier).
  - `params_fixed.csv` and `params_prior.csv` (fixed values and priors for uncertain parameters).
  - `cmc_batches.csv` (EE%, size, PDI, potency, impurities, and optional derived potency terms).
  - `cohort_definition.csv` (phenotypes and baseline states).
  - Observed data files (`obs_mouse.csv`, `obs_human.csv`, `obs_safety.csv`).
  - Scenario definitions (`scenarios.json`).
  - Simulation outputs:
    - `sim_timeseries.h5` (time series layout per design / scenario / run).
    - `sim_summary.csv` (run-level summary metrics).
    - `decision_metrics.csv` (aggregated probabilities and decisions).
- Units, allowed ranges, and validation rules (hard vs soft bounds).

**Why it matters**  
The I/O Contract is what allows **independent implementation** without e-mail archaeology. It fixes:

- Exact file names and locations.  
- Column names, types, units, and allowed values.  
- HDF5 group and dataset layout for time-series outputs.

**Primary audience**  
Modeling / data engineering teams, data managers, and anyone responsible for connecting protocol / CMC / study data into the model.

---

### 3) Stage-2 Model Explainer (for Medical & Translational Researchers)  
**File:** `ALD_mRNA_Therapy_Stage_2_Explain.pdf`

**What it is**  
A **plain-language explainer** written for PIs, clinical scientists, translational leads, and CMC teams who do not need to read every equation, but still need to understand:

- What each block (A–G) does in **clinical / biological terms**.  
- What questions the model answers (e.g., CNS exposure, NfL / Loes response, safety margins).  
- What the main input files mean at protocol level (dosing, FUS, cohorts, scenarios).  
- How the Stage-2 package protects the trial from **fragile assumptions**.

It answers questions like:

- “If we change FUS timing, how does that alter CNS exposure and Loes trajectory?”  
- “Under uncertainty and batch variability, how often does this design meet our efficacy + safety criteria?”  
- “Which assumptions (CNS delivery, microglial activation, CMC potency) are our most fragile points?”

**Primary audience**  
Non-quantitative stakeholders who need to **use the model as a decision tool**, not as a codebase.

---

## How These Pieces Fit Together

Think of the three files as three layers of the same Stage-2 object:

1. **Model Explainer (PDF)** — *What this model does and why it matters*  
   → For medical, translational, and CMC stakeholders.

2. **I/O Contract (PDF)** — *Exactly how data flows in and out*  
   → For modeling, data, and implementation teams.

3. **Formula Pack (PDF)** — *Exactly how the math is written*  
   → For quant developers and technical reviewers.

Together, they:

- Lock the **scientific content** (states, equations, thresholds, scenarios).  
- Lock the **data contract** (files, fields, units, and shapes).  
- Enable a clean hand-off from **Stage-1 Architecture** to **Stage-3 Implementation / Calibration**, similar to how Stage-1 provides a complete architecture package in the earlier record.

**Recommended reading order (for a new stakeholder):**

1. `ALD_mRNA_Therapy_Stage_2_Explain.pdf`  
2. `ALD_mRNA_Therapy_Stage_2_IO_Contract.pdf`  
3. `ALD_mRNA_Therapy_Formula.pdf`

---

## What Stage-2 Is Not

To avoid misunderstanding:

- Stage-2 is **not** a calibrated or validated model. It defines the equations and the data contract **before** calibration.  
- Stage-2 is **not** full protocol finalization or regulatory submission. It informs those steps by clarifying assumptions and decision metrics.  
- Stage-2 is **not** tied to a particular software stack (Python, R, Julia, etc.). It locks the **science and schemas**, not the implementation technology.  
- Stage-2 is **not** a guarantee of clinical success. It is a tool for **surfacing fragility and de-risking decisions** before large investments.

Execution, calibration, validation, and operationalization belong to later stages (coding + Stage-3/Stage-4 workflows), which can be done within Method2Model or by your in-house modeling team using this Stage-2 package as the foundation.

---

## Re-Use and Adaptation

Although this record is framed around ALD and a dual-platform ABCD1 mRNA therapy, the Stage-2 pattern is reusable for:

- Other monogenic neurological diseases with peripheral + CNS components.  
- Gene-replacement or gene-editing programs where delivery, targeting, safety, and CMC must be modeled together.  
- Any program where architecture is already defined (Stage-1 level), but where **drift between “intended model” and “implemented code”** is a real risk.

You may adapt:

- The block structure (A–G) and the separation of Stage-1 vs Stage-2 roles.  
- The pattern “Formula Pack + I/O Contract + Explainer”.  
- The way decision metrics (Go / No-Go / Pivot) are made explicit and file-backed,

as long as you respect the licensing terms of this deposit.

---

## How to Cite

If you use or adapt this Stage-2 package, please cite the Zenodo record for this deposit.

- **DOI:** `10.5281/zenodo.18093206`

Convenience link (DOI URL):

```text
https://doi.org/10.5281/zenodo.18093206
```

For consistency, mirror the exact author list, title, and version shown on the Zenodo page in any manuscripts or presentations.

---

## License / Use

This deposit is intended for **research and educational use**.

For **commercial use**, redistribution, or inclusion in a paid deliverable, please follow the license terms listed on the Zenodo record and/or obtain permission from Method2Model.

---

## Contact and Collaboration

This package was created within the **Method2Model** framework: turning complex protocols into executable, reviewable models with clear decision hooks across Stage-0, Stage-1, and Stage-2.

For collaborations, bespoke Stage-2 packages in other indications, or integration with your in-house modeling team:

- **Name:** Dr. Ramyar Azar  
- **Role:** Founder, Method2Model  
- **Email:** drazar@method2model.com  
- **Website:** https://method2model.com/

Stage-2 is where the equations, files, and decisions line up—*before* time, budget, animals, or patients are committed to a model that nobody can fully trace.
