# Module 1: What is Human-Centered Data Science?

## What this module is
A plug-and-play introduction to Human-Centered Data Science (HCDS), based on Chapter 1 of *Human-Centered Data Science: An Introduction*. The goal is to be skimmable, partially adoptable, and easy to critique.

## Where it fits in a course
- Graduate or advanced undergraduate courses in Data Science, HCI, AI ethics, or responsible AI
- Week 1–2 framing content, or a standalone guest lecture

## What students will be able to do after
- Define human-centered data science and explain what “human-centered” adds to data science
- Identify key human roles across the data science lifecycle (problem framing → data → modeling → deployment)
- Explain why aggregate performance can hide group-level harms

## How an instructor might use it
- One lecture: slides + guided discussion
- One week: lecture + optional notebook lab
- Notebook-only: short lab inside a broader ML / AI course

## What’s included (files)
- `Module 1: What is Human Centered Data Science: Slide Deck.pptx`
- `Module 1: What is Human Centered Data Science: Slide Notes.docx`
- `Module 1: What is Human Centered Data Science: Instructor Guide.docx`
- `Module 1: What is Human Centered Data Science: Codebook.ipynb`

## Feedback (choose the easiest option)
We’re collecting light beta feedback focused on fit and usability.

1) **GitHub Issue (preferred):**
- Click the “Issues” tab at the top of this repo → “New issue”
- Title: “Module 1 beta feedback – <name/institution>”
- Answer the three questions below

2) **Google Form (no GitHub account needed):**
- https://forms.gle/Z3D1viuHZ3x9MHWC8

3) **Email:**
- hcds.uoft@gmail.com

**Three questions (5 minutes):**
1) Fit: Where (if anywhere) would this module fit in a course you teach?
2) Clarity: What, if anything, was confusing or missing for you to run it?
3) Workload: Is the scope right for one session / one week?

## How to cite

If you use any part of Module 1, please cite:

Guha, S., Chui, V., Silver, M., & Irfan, M. (2025). *uofthcdslab/hcds-pedagogy-toolkit: Module 1 beta* (All versions). Zenodo. https://doi.org/10.5281/zenodo.18092859




