# Unified Universal Theory (UUT)  
### A Hydrodynamic Reformulation of Gravitational, Orbital, Thermal and Optical Phenomena

**Author:** Mario César Calarco  
**ORCID:** https://orcid.org/0009-0000-1364-6861  
**DOI:** https://doi.org/10.5281/zenodo.18079128  
**License:** Attribution–NonCommercial–ShareAlike 4.0 International (CC BY-NC-SA 4.0)  

**Project website:** https://www.unifieduniversaltheory.com/  
**YouTube channel:** https://www.youtube.com/@UnifiedUniversalTheory  

---

## Overview

This repository contains the complete manuscript of the **Unified Universal Theory (UUT)**, a hydrodynamic reinterpretation of gravitational, orbital, thermal, and optical phenomena based on a single physical premise:

> the universe is permeated by a continuous fundamental medium capable of forming stable, confined vortical structures across all scales.

Within this framework, gravitation is not treated as a force nor as a manifestation of spacetime curvature.  
Instead, the effective acceleration experienced by material bodies arises from the **convective derivative of an organized macroscopic velocity field** of the medium.

All classical gravitational phenomena emerge naturally from this kinematic structure, without introducing new forces, additional fields, or modifications to established empirical laws.

---

## Main Contributions

The Unified Universal Theory develops a single, integrated physical framework that:

- Derives the inverse-square gravitational law from a stationary radial inflow profile.
- Explains planetary orbits, orbital stability, and secular effects through vortex geometry.
- Accounts for perihelion precession via shear and subdominant swirl structure.
- Reinterprets thermal phenomena as volumetric energy density and fine-scale turbulence.
- Describes electromagnetic propagation as coherent transport through the medium.
- Explains gravitational optical effects (bending, delay, redshift) as flow-induced refractive structure.
- Interprets planets, moons, rings, binaries, and interstellar objects as embedded vortices.
- Connects cosmic-scale dynamics to repeated local interactions at microscopic scales.

The theory reproduces all validated gravitational observations at leading order while offering new, testable physical interpretations and predictions.

---

## Structure of the Manuscript

The manuscript includes:

- Hydrodynamic foundations and governing equations
- Reconstruction of the Solar Macrovortex
- Orbital dynamics and secular corrections
- Optical propagation and gravitational lensing
- Thermal phenomena and planetary heat budgets
- Planet-by-planet analysis of the Solar System
- Interstellar objects as probes of the macrovortex
- Discussion of scope, limitations, and future developments
- Appendices addressing continuity, stationarity, and closure

---

## Intended Audience

This work is intended for readers with backgrounds in:

- Classical and relativistic gravitation
- Fluid dynamics and vortex theory
- Astrophysics and planetary science
- Theoretical physics and foundations of physics

The presentation emphasizes physical intuition while maintaining mathematical rigor.

---

## Open Development and Independent Research

This work is developed independently and is accompanied by an open online presence.

A project website and a YouTube channel are currently in formation and are intended as spaces for:

- documenting ongoing developments of the Unified Universal Theory,
- presenting clarifications, derivations, and visual explanations,
- sharing intermediate results and future directions,
- fostering discussion and potential academic collaboration.

All scientific content remains openly accessible and independent of any form of financial support.

For those who wish to support the continuity of this independent research effort, **voluntary contributions** may be made through the platforms linked on the project website.  
Such support is intended solely to help sustain time, infrastructure, and dissemination activities, and does **not** grant privileged access, influence over results, or endorsement of the theory.

---

## License

This work is licensed under the  
**Attribution–NonCommercial–ShareAlike 4.0 International License (CC BY-NC-SA 4.0)**.

You are free to share and adapt the material **for non-commercial purposes**, provided that proper attribution is given and derivative works are distributed under the same license.

License text:  
https://creativecommons.org/licenses/by-nc-sa/4.0/

---

## Citation

If you use or reference this work, please cite it as described in the `CITATION.cff` file or using the following reference:

```bibtex
@misc{Calarco2025UUT,
  author       = {Calarco, Mario César},
  title        = {Unified Universal Theory (UUT): A Hydrodynamic Reformulation of Gravitational, Orbital, Thermal and Optical Phenomena},
  year         = {2025},
  doi          = {10.5281/zenodo.18079128},
  publisher    = {Zenodo},
  license      = {CC BY-NC-SA 4.0}
}
