# Investigation #1: Comparative Dynamics (3x+1 vs 5x+1)

**Date**: December 28, 2025  
**Status**: Complete  
**Type**: Calibration Experiment  
**Tribute**: Feynman #1 of 100

---

## Problem Statement

**Objective**: Compare dynamics of Collatz (3x+1) vs generalized Syracuse (5x+1)

**Known results**:
- 3x+1: Conjectured to converge (verified to 2.36×10²¹)
- 5x+1: Known to diverge for many starting values

**Our contribution**: Empirical validation and framework sensitivity test

---

## Findings

### Empirical Observations

**Collatz (3x+1)**:
- n=7: Converges in 17 steps (7→11→17→13→5→1)
- All tested values converge

**Syracuse (5x+1)**:
- n=7: Grows to 9×10¹⁵ in 100K steps (divergent)
- n=9: Also diverges (reaches billions)
- n=5: Oscillates but bounded
- n=1,3,15,19: Converge

**Conclusion**: Confirms known phase transition between contractive (3x+1) and expansive (5x+1) regimes.

---

## Framework Validation

**Spike Cost / Energy predictions**:

For 3x+1: Average multiplier ≈ 3/2^k ≈ 0.75 < 1 (contractive)  
For 5x+1: Average multiplier ≈ 5/2^k ≈ 1.25 > 1 (expansive)

**Our framework correctly predicts**:
- Higher multiplier → increased spike pressure
- Energy arguments fail earlier for 5x+1
- Bounded-k regimes collapse faster

**Status**: ✅ Framework sensitivity validated

---

## Value of Investigation #1

**NOT a new result**: 5x+1 divergence is known in literature

**IS valuable as**:
1. ✅ Calibration experiment (methodology works fast)
2. ✅ Control system baseline (3x+1 critical, 5x+1 supercritical)
3. ✅ Framework validation (spike cost sensitivity confirmed)
4. ✅ Phase transition demonstration

---

## Honest Assessment

**Overclaim corrected**: Initially stated "Syracuse conjecture FALSE" - this is known, not new

**Accurate claim**: "Comparative dynamics confirm phase transition and validate framework"

**Lesson**: Keep claims as tight as the math (following "Room at the Bottom")

---

## Next Steps

**Investigation #2 options**:
1. Phase diagram for ax+1 (find critical a)
2. Target unknown territory (different problem class)
3. Formalize energy/spike-cost connection to multiplier

---

*Investigation #1 of 100 - Calibration complete*

