# Attacking the Third Horn: Unbounded k Growth

**Goal**: Prove k(n) cannot grow without bound  
**Date**: December 28, 2025

---

## The Gap

**Spike Cost proves**: Each fixed K has finitely many K-spikes

**Does NOT prove**: k(n) cannot grow as 3,3,4,5,5,6,7,7,8,... (slowly unbounded)

---

## Approach 1: Growth Rate Bounds

**Strategy**: Prove max k(n) ≤ f(log n) for some function f

**Idea**: 
- Each k-spike compresses by factor 3/2^k
- After compression, need growth to reach next spike
- Growth rate limited by 3/2 per step
- Can we bound how high k can get before compression dominates?

**To explore**:
- Formalize "energy" = log n - α·max k(n) for some α
- Show energy decreases on average
- Contradiction if k → ∞

---

## Approach 2: 2-adic Analysis

**Strategy**: Use p-adic (p=2) valuation properties

**Known results** (Lagarias):
- 2-adic analysis shows local constraints
- Certain residue classes force specific k-values

**Our extension**:
- Can we show k-growth violates 2-adic coherence?
- Forbidden residue pattern (2^(2m)-1)/3 suggests structure

**To explore**:
- 2-adic limit of trajectory
- Coherence conditions for unbounded k

---

## Approach 3: Probabilistic/Density Arguments

**Strategy**: Combine with Tao-style "almost all" results

**Tao 2019**: Almost all trajectories descend logarithmically

**Our contribution**: 
- Spike Cost + bounded-k convergence
- Can we show unbounded k has measure zero?

**To explore**:
- Density of k-values in long trajectories
- Probabilistic bounds on k-growth

---

## Approach 4: Energy/Potential Functions

**Strategy**: Find Lyapunov-like function that decreases

**Candidates**:
1. E(n) = log n - β·Σk(nᵢ) for some β
2. E(n) = n / 2^(max k seen)
3. E(n) = weighted combination

**To explore**:
- Which function decreases on average?
- Can we prove unbounded k → E → -∞ (contradiction)?

---

## Approach 5: Forbidden Residue Forcing

**Strategy**: Extend forbidden residue analysis

**Observation**: Forbidden residues (2^(2m)-1)/3 force k > K₀

**Question**: As K₀ → ∞, do forbidden residues become "dense"?

**To explore**:
- Density of forbidden residues in limit
- Can unbounded k avoid all forbidden residues?

---

## Recommended First Attack

**Start with Approach 4** (Energy Functions):

**Reason**:
- Most concrete and testable
- Can verify computationally
- Natural extension of Spike Cost

**Specific plan**:
1. Test candidate energy functions on trajectories
2. Measure average decrease rate
3. Prove formal bound
4. Show unbounded k contradicts bound

---

## Next Steps

1. Implement energy function tests
2. Run on 10,000 trajectories
3. Analyze which function works best
4. Formalize proof if pattern found

---

*Ready to attack - December 28, 2025*
