# Stage 2: Hypothesis Exploration for General K₀

**Goal**: Generate testable hypotheses, NOT proofs  
**Method**: Ollama proposes → Kernel tests → Log failures

---

## Hypotheses to Test (10 candidates)

### H1: Residue 1 Absorption
**Claim**: For any K₀, residue 1 (mod 2^(K₀+1)) always has k=2  
**Test**: Verify for K₀=2,3,4,5,6  
**Status**: Pending

### H2: Forbidden Residue Pattern
**Claim**: Forbidden residues follow pattern 2^K₀+1 (mod 2^(K₀+1))  
**Test**: Check K₀=2 (5 mod 8), K₀=3 (5 mod 16), K₀=4 (21 mod 32)  
**Status**: Pending

### H3: k=1 Density Bound
**Claim**: Avoiding forbidden residues limits k=1 density below divergence threshold  
**Test**: Compute transition graphs for K₀=2,3,4  
**Status**: Pending

### H4: Eventual k≤2
**Claim**: All trajectories with k≤K₀ eventually reach k≤2  
**Test**: Trace paths in transition graphs  
**Status**: Pending

### H5: Spike Cost Applies
**Claim**: k=K₀ cannot occur infinitely often (by Spike Cost)  
**Test**: Verify Spike Cost constraints for each K₀  
**Status**: Pending

### H6: Modular Periodicity
**Claim**: Transition structure repeats with period 2^(K₀+1)  
**Test**: Check transitions for K₀=3,4  
**Status**: Pending

### H7: Absorption Time Bound
**Claim**: Time to absorption into residue 1 is O(K₀)  
**Test**: Empirical measurement  
**Status**: Pending

### H8: No Cycles Except {1}
**Claim**: Only residue 1 forms a cycle in transition graph  
**Test**: Exhaustive cycle search  
**Status**: Pending

### H9: Compression Dominates
**Claim**: Even without forbidden residues, compression wins for k≤K₀  
**Test**: Growth factor analysis  
**Status**: Pending

### H10: Inductive Structure
**Claim**: K₀ transition graph embeds K₀-1 graph  
**Test**: Graph isomorphism check  
**Status**: Pending

---

## Testing Protocol

1. **Generate hypothesis** (Ollama or manual)
2. **Formalize as testable claim**
3. **Run kernel verification**
4. **Log result**: PASS / FAIL / UNCERTAIN
5. **If FAIL**: Record exact counterexample
6. **Classify failure type**

---

## Failure Taxonomy (to build)

- Parity violations
- Growth bursts
- Modular contradictions
- Absorption failures
- Other

---

**Next**: Test H1 with kernel

*December 28, 2025*
