# PROOF ENGINEERING PIPELINE
## Operational Doctrine for Collatz Investigation

**Core Principle**: Proof is not construction. Proof is elimination.

---

## STAGE 0: PROBLEM SANITIZATION ✅

**Status**: COMPLETE

**Artifact**: `problem.spec`

**Output**:
- Formal statement with explicit quantifiers
- Domain and transition rules defined
- Known vs unknown clearly separated
- Forbidden assumptions listed

**Verification**: Problem is now mechanically checkable

---

## STAGE 1: MECHANIZATION ✅

**Status**: COMPLETE

**Artifacts**:
- `state.ts` - State representation
- `transition.ts` - Transition rules
- `verifier.ts` - Verification engine

**Output**:
- Executable state machine
- Deterministic transitions
- Reverse tree construction
- Verification infrastructure

**Key Achievement**: Problem is now a machine, not just math

---

## STAGE 2: INVARIANT & STRUCTURE EXPLORATION 🔄

**Status**: IN PROGRESS

**Goal**: Explore structure WITHOUT trying to prove anything

### Actions

1. **Generate Candidates** (Human + LLM)
   - Use `t1c/deepseek-math-7b-rl` for proposals
   - Strict prompt: "Propose testable hypotheses, NOT proofs"
   - Target: 10 initial candidates

2. **Test Each Candidate**
   - Forward trajectory testing
   - Reverse transition testing
   - Counterexample search

3. **Log Failures**
   - Exact failure case
   - Minimal counterexample
   - Classification of failure type

### Forbidden

❌ "Seems to decrease"  
❌ "On average"  
❌ "Empirically always"

### Required

✅ Exact failure case  
✅ Minimal counterexample  
✅ Classification of failure

### Output Artifact

`invariant_failures.json` - A map of impossibility

### Progress Metric

Success = Understanding WHY invariants fail, not finding one that works

---

## STAGE 3: PROOF SPACE PRUNING ⏳

**Status**: NOT STARTED

**Goal**: Eliminate entire CLASSES of proof strategies

### Actions

1. **Group Failures by Type**
   - Parity instability
   - Growth bursts
   - Reverse-density explosion
   - Modular violations

2. **Prove Meta-Statements**
   - "No invariant depending only on X can work"
   - "Any monotonic function of Y fails"

These are **theorems about proofs**, not about the conjecture.

### Output Artifact

`no_go_theorems.md` - Machine-verified rejection claims

### Key Insight

> Most mathematicians never reach this stage because it feels like "no progress".  
> It is actually the **hardest progress**.

---

## STAGE 4: LOCAL NECESSITY LEMMAS ⏳

**Status**: NOT STARTED

**Goal**: Prove small, necessary truths

### Rules

Lemmas must be:
- Local
- Unavoidable
- Independently valuable

Each lemma must:
- Remove a remaining proof path
- OR constrain structure sharply

### Examples

- "Any nontrivial cycle must satisfy condition X"
- "Any counterexample must grow faster than f(n)"

### Verification

Lemma must be:
- Symbolically checkable
- Contradiction-tested
- Non-heuristic

### Output Artifact

`lemmas/lemma_01.md` - Each lemma stands alone

---

## STAGE 5: SYNTHESIS ⏳

**Status**: NOT STARTED

**Goal**: Combine constraints into inevitability

### Characteristics

- Fewer ideas, not more
- Heavy reuse of earlier failures
- Proof feels tight, not clever
- Almost boring when correct

### Warning Sign

If the proof feels "exciting", it's probably wrong.

---

## WHERE MATH LLMs FIT

### Allowed (Stages 2-3 only)

✅ Invariant proposal  
✅ Algebraic manipulation  
✅ Contradiction explanation  
✅ Alternative formulations

### NEVER Allowed

❌ Declare success  
❌ Conclude truth  
❌ Invent missing steps

**Role**: Idea generators under surveillance

---

## PROGRESS INDICATORS

### You ARE Getting Closer If:

✅ Number of possible proof paths shrinks  
✅ Explanations get shorter  
✅ Fewer invariants survive testing  
✅ You can explain why others failed

### You are NOT Getting Closer If:

❌ You have more ideas  
❌ You feel excited  
❌ You jump problems  
❌ You rely on computation for belief

---

## CURRENT STATUS

- **Stage 0**: ✅ Complete
- **Stage 1**: ✅ Complete
- **Stage 2**: 🔄 In Progress (0/10 invariants tested)
- **Stage 3**: ⏳ Waiting
- **Stage 4**: ⏳ Waiting
- **Stage 5**: ⏳ Waiting

---

## NEXT IMMEDIATE ACTIONS

1. Generate 10 invariant candidates using LLM
2. Verify each with kernel
3. Classify all failures
4. Build failure taxonomy
5. Identify eliminated classes

**Timeline**: 4-5 hours of focused work

---

## ONE-PAGE EXECUTIVE SUMMARY

**Proof is not construction. Proof is elimination.**

> Success comes from proving that *nothing else can happen*.

---

## GUARANTEED OUTCOMES

If you follow this pipeline **strictly**, two outcomes are guaranteed:

1. You will never fool yourself
2. Even if you don't solve the conjecture, you will produce *real mathematics*

**That is the correct path.**
