# Spike Cost Lemmas - Complete Chain

## Foundation: Stage 4 Local Necessity Lemmas

**Status**: Lemmas A₁, A₂, A₃ proven. A₄ in progress.

---

## Lemma A₁: Spike Compression ✅

### Statement

Let n be an odd positive integer. Define k = v₂(3n+1), and define the odd-to-odd Collatz map:

```
T(n) = (3n+1) / 2^k
```

Then:

1. **Exact upper bound**: T(n) ≤ (3n/2^k) + 1

2. **Uniform compression for spikes** (k ≥ 2): T(n) ≤ (3/4)n + 1

3. **Strong compression for large spikes** (k ≥ 3): T(n) ≤ (3/8)n + 1

### Proof

**Step 1**: T(n) = (3n+1)/2^k = (3n/2^k) + (1/2^k)

**Step 2**: Since k ≥ 1, we have 1/2^k ≤ 1, therefore T(n) ≤ (3n/2^k) + 1

**Step 3**: If k ≥ 2, then 2^k ≥ 4, so T(n) ≤ (3n/4) + 1

**Step 4**: If k ≥ 3, then 2^k ≥ 8, so T(n) ≤ (3n/8) + 1

∎

---

## Lemma A₂: Spike Rarity ✅

### Statement

Let n be an odd integer and let k = v₂(3n+1).

Then k ≥ K **if and only if**: n ≡ -3^(-1) (mod 2^K)

Equivalently: The set of odd integers producing a k-spike of size ≥ K lies in **exactly one residue class modulo 2^K**.

### Proof

**Step 1**: k = v₂(3n+1) ≥ K ⟺ 2^K | (3n+1) ⟺ 3n + 1 ≡ 0 (mod 2^K)

**Step 2**: Since gcd(3, 2^K) = 1, multiply by 3^(-1): n ≡ -3^(-1) (mod 2^K)

**Step 3**: This defines exactly one residue class. Only 1 out of every 2^K odd integers can satisfy k ≥ K.

∎

### Corollary A₂.1 (Exponential Rarity)

```
#{n ≤ N : v₂(3n+1) ≥ K} ≤ N/2^K + 1
```

---

## Lemma A₃: Spike Separation ✅

### Statement

Fix K ≥ 2. Suppose k(n) ≥ K (a K-spike) occurs at n. Then **before another K-spike can occur**, the trajectory must undergo at least cK odd-to-odd steps (for some constant c > 0) during which n must regrow to re-enter the unique residue class modulo 2^K required for a K-spike.

**Equivalently**: Two K-spikes cannot occur arbitrarily close together; they must be separated by a growth phase of length Ω(K).

### Proof

**Step 1 (Compression ejects from spike class)**:

By Lemma A₁, if k(n) ≥ K, then:
```
n₁ := T(n) ≤ (3/2^K)n + 1
```

For K ≥ 2, 3/2^K ≤ 3/4 < 1, so n₁ < n for large n.

Division by 2^K **destroys congruence information modulo 2^K**. After the spike, n₁ has no reason to satisfy n₁ ≡ a_K (mod 2^K).

Thus, the trajectory is **ejected** from the unique residue class capable of producing another K-spike.

**Step 2 (Re-entry requires regrowth)**:

To re-enter the class a_K (mod 2^K), the iterate n_j must satisfy a single congruence modulo 2^K.

The maximal multiplicative growth per odd step is bounded by 3 (from the 3n+1 operation).

Starting from n₁, to reach any number congruent to a_K (mod 2^K) with magnitude comparable to the original scale requires enough odd steps to multiply size by ≈ 2^K.

This requires at least:
```
j ≥ K / log₂(3)
```
odd-to-odd steps.

**Step 3 (Separation bound)**:

Combining:
- K-spike causes compression by factor ≤ 3/2^K
- Re-entering spike class requires regrowth by factor ≳ 2^K  
- Each odd step grows by at most factor 3

Therefore, between any two K-spikes, there must be at least **Ω(K)** odd-to-odd steps.

∎

### Interpretation

- **Spikes are costly** (A₁): they shrink n
- **Spikes are rare** (A₂): they require unique congruence
- **Spikes cannot cluster** (A₃): after spike, trajectory must regrow substantially before another is arithmetically possible

This is the **debt mechanism** made rigorous.

---

## What We Have Now

A **closed, logical chain**:

1. **A₁ — Spike Compression** (local cost)
2. **A₂ — Spike Rarity** (arithmetic restriction)  
3. **A₃ — Spike Separation** (temporal spacing)

This completes the **structural debt mechanism**.

---

## Next: Lemma A₄ (No Infinite Debt)

**Goal**: Show that infinite spikes imply impossible infinite regrowth, contradicting bounded expansion per step.

**Why this matters**: This will prove that the debt mechanism is not just structural but **impossible to violate**.

---

## Status Summary

- ✅ Lemma A₁: Spike Compression (PROVEN - pure inequalities)
- ✅ Lemma A₂: Spike Rarity (PROVEN - modular arithmetic)
- ✅ Lemma A₃: Spike Separation (PROVEN - congruence + growth bounds)
- 🔄 Lemma A₄: No Infinite Debt (awaiting formal proof)

**The chain is nearly complete. Awaiting A₄ to close the loop.**
