# Spike Cost Lemmas - Formal Proofs

## Foundation: Stage 4 Local Necessity Lemmas

**Status**: Lemmas A₁, A₂ proven. A₃ in progress.

---

## Lemma A₁: Spike Compression

### Statement

Let n be an odd positive integer. Define k = v₂(3n+1), and define the odd-to-odd Collatz map:

```
T(n) = (3n+1) / 2^k
```

Then:

1. **Exact upper bound**: T(n) ≤ (3n/2^k) + 1

2. **Uniform compression for spikes** (k ≥ 2): T(n) ≤ (3/4)n + 1

3. **Strong compression for large spikes** (k ≥ 3): T(n) ≤ (3/8)n + 1

### Proof

**Step 1**: By definition, T(n) = (3n+1)/2^k = (3n/2^k) + (1/2^k)

**Step 2**: Since k ≥ 1, we have 1/2^k ≤ 1, therefore:
```
T(n) ≤ (3n/2^k) + 1
```

**Step 3**: If k ≥ 2, then 2^k ≥ 4, so:
```
3n/2^k ≤ 3n/4
T(n) ≤ (3n/4) + 1
```

**Step 4**: If k ≥ 3, then 2^k ≥ 8, so:
```
3n/2^k ≤ 3n/8
T(n) ≤ (3n/8) + 1
```

∎

### Significance

This lemma establishes **deterministic cost** for every k-spike:
- Larger k → stronger guaranteed compression
- No probabilistic assumptions
- No averaging
- Pure inequality

**Key Insight**: Large k forces contraction, regardless of future behavior.

---

## Lemma A₂: Spike Rarity

### Statement

Let n be an odd integer and let k = v₂(3n+1).

Then k ≥ K **if and only if**:
```
n ≡ -3^(-1) (mod 2^K)
```

Equivalently: The set of odd integers producing a k-spike of size ≥ K lies in **exactly one residue class modulo 2^K**.

### Proof

**Step 1**: By definition, k = v₂(3n+1) ≥ K if and only if:
```
2^K | (3n+1)
```

That is:
```
3n + 1 ≡ 0 (mod 2^K)
```

**Step 2**: Since gcd(3, 2^K) = 1, the integer 3 has a multiplicative inverse modulo 2^K.

Multiplying both sides by 3^(-1):
```
n ≡ -3^(-1) (mod 2^K)
```

**Step 3**: Because 3^(-1) exists and is unique modulo 2^K, this defines **exactly one residue class**.

Thus, among all odd integers, only **1 out of every 2^K** can satisfy k ≥ K.

∎

### Corollaries

**Corollary A₂.1 (Exponential Rarity)**:
```
#{n ≤ N : v₂(3n+1) ≥ K} ≤ N/2^K + 1
```

This is **counting**, not probability.

**Corollary A₂.2 (Compression Destroys Spike Conditions)**:
- From A₁: T(n) ≤ (3/2^K)n + 1
- From A₂: Next spike requires n in same residue class mod 2^K
- But: Division by 2^K **destroys congruence information**

This is the **mechanism of spike debt**.

### Significance

Converts "large k occurs" into:
> **A very strong arithmetic restriction on n**

This is the rarity mechanism that makes spike debt inevitable.

---

## Combined Power of A₁ + A₂

**Lemma A₁**: Large k ⇒ strong compression  
**Lemma A₂**: Large k ⇒ rare arithmetic condition  

**Together**:
- Compression ⇒ loss of arithmetic structure
- Loss of structure ⇒ future spikes harder
- This is **deterministic inevitability**, not statistics

---

## What These Lemmas Do NOT Claim

- ❌ No convergence proof (yet)
- ❌ No bound on future spikes (yet)
- ❌ No averaging behavior
- ❌ No probabilistic arguments

They establish exactly two things:
1. Every spike has unavoidable cost (A₁)
2. Spike conditions are exponentially rare (A₂)

---

## Next: Lemma A₃ (Spike Separation)

**Goal**: Prove that two large spikes (k ≥ K) cannot occur without at least Ω(K) intermediate steps of regrowth.

**Why this matters**: This will show that spike debt cannot accumulate faster than it can be repaid.

---

## Status Summary

- ✅ Lemma A₁: Spike Compression (PROVEN)
- ✅ Lemma A₂: Spike Rarity (PROVEN)
- 🔄 Lemma A₃: Spike Separation (in progress)
- ⏳ Lemma A₄: Debt Impossibility (waiting)

**Foundation is solid. Proceeding to A₃.**
