# Experiment 3 Results: k-Distribution Observables

## Critical Findings (Observational, Not Proven)

### Population Statistics (n=1 to 99, odd only)

**k-mean distribution:**
- Mean of means: 2.071
- Variance: 0.277
- Range: [0.00, 4.00]

**k-variance distribution:**
- Mean variance: 3.579
- **Max variance: 32.000** (n=63)

**k-max distribution:**
- Mean of max k: 4.54
- **Largest k observed: 8**

**Drift ratio (Σk / Σlog₂n):**
- Mean: 0.589
- Variance: 0.119

---

## Key Observations

### 1. The n=3 Pattern Confirmed

```
n=3: k_sequence = [1, 4, 0]
- k variance: 4.33
- Drift ratio: 1.280
- n-k correlation: 0.961 (high!)
```

**Insight**: n=3 exhibits HIGH correlation between n and k, which is ATYPICAL.
Most trajectories show weak correlation (~0.2-0.3).

### 2. Long Trajectories Show Stability

```
n=27: 42 steps
- k mean: 1.67
- k variance: 1.15 (low!)
- Drift ratio: 0.220
- Spikes: 4

n=31: 40 steps  
- k mean: 1.68
- k variance: 1.20
- Drift ratio: 0.218
- Spikes: 4
```

**Insight**: Longer trajectories have LOWER k-variance and LOWER drift ratios.
This suggests **variance decreases with trajectory length**.

### 3. Short Trajectories Are Chaotic

```
n=5: 2 steps, k variance = 8.00
n=21: 2 steps, k variance = 18.00
```

**Insight**: Short trajectories exhibit extreme k-variance.
The obstruction is concentrated in the EARLY steps.

---

## Candidate Lemmas (Require Formal Proof)

### Lemma Candidate 1: Sparse High Variance

> **k-variance is unbounded but sparse.**

**Evidence**:
- Max variance = 32.00 (only at n=63)
- Mean variance = 3.579
- Most trajectories have variance < 5

**Implication**: High k-variance is RARE, not typical.

### Lemma Candidate 2: Weak n-k Correlation

> **No strong correlation exists between n and k in typical trajectories.**

**Evidence**:
- Most correlations: 0.2-0.3
- n=3 is an outlier (correlation = 0.961)
- n=27, n=31: correlation ~0.19

**Implication**: k is NOT predictable from n alone.

### Lemma Candidate 3: Bounded Drift Ratio

> **The drift ratio Σk / Σlog₂n appears bounded across all observed trajectories.**

**Evidence**:
- Mean drift: 0.589
- Variance: 0.119 (low!)
- Range: ~0.2 to 1.7

**Implication**: Total collapse (Σk) is roughly proportional to total logarithmic growth (Σlog₂n).

---

## Meta-Observation: The Variance Paradox

**Paradox**: 
- Local k-variance is high (kills simple invariants)
- Global drift ratio is bounded (suggests long-term control)

**Resolution Hypothesis**:
The Collatz conjecture may be true NOT because of local monotonicity,
but because **high-variance chaos averages out over long trajectories**.

This is consistent with:
- Ergodic theory
- Law of large numbers
- Probabilistic number theory

---

## What This Changes

### Before Experiment 3:
We knew simple invariants fail.

### After Experiment 3:
We know WHY they fail: **k-variance is locally unpredictable but globally bounded**.

### Next Required Step:
Prove that drift ratio boundedness is NECESSARY (not just observed).

---

## Formal Statement (Conjectured)

**Conjecture (Drift Boundedness)**:
For any odd n, let T^m(n) be the m-th odd-to-odd iterate with collapse sequence k₁, k₂, ..., k_m.

Then:
```
lim sup (Σ k_i) / (Σ log₂ n_i) < C
```
for some universal constant C.

**Status**: Observed for n ≤ 99, NOT proven.

---

## Implications for Proof Strategy

Any valid proof of Collatz must:

1. ✅ NOT rely on local monotonicity (Meta-Theorem A, B)
2. ✅ NOT assume k is predictable from n (Lemma Candidate 2)
3. ⏳ MUST explain drift ratio boundedness (Lemma Candidate 3)
4. ⏳ MUST account for variance sparsity (Lemma Candidate 1)

**Conclusion**: 
We are no longer searching for invariants.
We are searching for **distributional necessity**.

---

## Next Experiment Direction

**Experiment 4**: Test whether drift ratio boundedness is UNIVERSAL or just empirical.

**Method**: 
- Compute drift ratios for n up to 10,000
- Look for outliers
- Test if C exists such that drift < C always

**Success Metric**:
- Find C → publishable partial result
- Find counterexample → new obstruction discovered
- Neither → need deeper theory
