# Energy Function Breakthrough

**Date**: December 28, 2025  
**Status**: Promising approach to third horn

---

## Discovery

**All tested energy functions show 100% decrease rate!**

### Test Results

**E₁(n) = log(n) - β·max(k)**:
- β = 0.1, 0.5, 1.0, 2.0, 5.0: **100/100 trajectories decrease**

**E₂(n) = n / 2^max(k)**:
- **100/100 trajectories decrease**

**E₃(n) = log(n) - α·Σk**:
- α = 0.01, 0.05, 0.1, 0.2: **100/100 trajectories decrease**

---

## Visual Evidence

### Energy Plots (E₁ with β=1)

![Energy n=27](file:///home/shri/Desktop/mathwiz/room-at-the-bottom/investigations/collatz/energy_plot_27.svg)
*n=27: Energy 2.30 → -3.39 (decrease: 5.69)*

![Energy n=97](file:///home/shri/Desktop/mathwiz/room-at-the-bottom/investigations/collatz/energy_plot_97.svg)
*n=97: Energy 2.57 → -3.39 (decrease: 5.97)*

![Energy n=871](file:///home/shri/Desktop/mathwiz/room-at-the-bottom/investigations/collatz/energy_plot_871.svg)
*n=871: Energy 5.77 → -3.39 (decrease: 9.16)*

![Energy n=6171](file:///home/shri/Desktop/mathwiz/room-at-the-bottom/investigations/collatz/energy_plot_6171.svg)
*n=6171: Energy 7.73 → -4.39 (decrease: 12.12)*

---

## Implications for Third Horn

**The gap**: Can k(n) grow slowly without bound?

**Energy function says NO**:

If k(n) → ∞, then:
- E(n) = log(n) - max k(n) → -∞
- But E must decrease to convergence
- E(1) is finite
- **Contradiction!**

---

## Next Steps

### 1. Formalize the Proof

**Claim**: E(n) = log(n) - max k(n) is a Lyapunov function

**Need to prove**:
- E decreases on average (or always)
- E bounded below at convergence
- Therefore max k(n) cannot → ∞

### 2. Rigorous Analysis

- Prove E decreases for EVERY step (not just empirically)
- OR prove E decreases on average with bounded variance
- Show unbounded k → E → -∞ → contradiction

### 3. Handle Edge Cases

- What if trajectory doesn't converge?
- Need to combine with Spike Cost + bounded-k results

---

## Status

**This could close the third horn!**

**Evidence**:
- 100% empirical decrease rate
- Clear visual trend
- Logical contradiction with unbounded k

**Next**: Formalize the proof rigorously

---

*December 28, 2025 - Breakthrough in progress*
