# Bounded-k Regime Analysis - Initial Framework

## Context: What Spike Cost Eliminated

**Spike Cost Principle (PROVEN)**: For any K ≥ 2, no trajectory contains infinitely many K-spikes.

**Consequence**: Any diverging trajectory must have uniformly bounded k(n).

---

## The Remaining Problem (Precisely Stated)

**Open Question**: Can a trajectory diverge (n → ∞) while maintaining k(n) ≤ K₀ for some fixed K₀?

**Why This Matters**: This is the ONLY remaining possible obstruction to Collatz convergence.

---

## The Bounded-k Map (Formal Definition)

If k(n) ≤ K₀ for all steps, then every odd-to-odd transition satisfies:

```
n_(i+1) = (3n_i + 1) / 2^(k_i)
```

where k_i ∈ {1, 2, ..., K₀}.

### Growth Bounds (Deterministic)

**Lower bound**: 
```
n_(i+1) ≥ (3n_i + 1) / 2^(K₀) ≥ 3n_i / 2^(K₀)
```

**Upper bound**:
```
n_(i+1) ≤ (3n_i + 1) / 2^1 = (3n_i + 1) / 2
```

### Key Observation

For K₀ = 1: n_(i+1) ≈ 1.5n_i (growth)
For K₀ = 2: n_(i+1) ≈ 0.75n_i (decay)

**Critical threshold**: K₀ = 2 is the boundary between growth and decay.

---

## Strategy: Prove Bounded-k Growth is Impossible

We must show that sustained growth with bounded k leads to contradiction.

### Three Potential Approaches

**Approach 1: Congruence Exhaustion**
- Show that bounded-k growth forces n into shrinking residue classes
- Eventually no valid n exists

**Approach 2: Entropy Deficit**
- Show that bounded k limits expansion too severely
- Growth cannot overcome inherent losses

**Approach 3: Drift Imbalance**
- Show that even maximal bounded-k growth cannot offset map structure
- Net effect is bounded or decreasing

---

## What We Know from Experiments

From Experiment 3 (k-distribution analysis):

- **Drift ratio**: Σk / Σlog₂(n) ≈ 0.589 (appears bounded)
- **k-variance**: Unbounded but sparse
- **Long trajectories**: Lower k-variance, lower drift ratio

**Hypothesis**: Bounded-k trajectories have even more constrained drift.

---

## The Deterministic Sandwich (Key Insight)

If k(n) ≤ K₀ always, then:

```
(3/2^(K₀)) · n_i ≤ n_(i+1) ≤ (3/2) · n_i + 1
```

This is a **linear recurrence with bounded coefficients**.

### For K₀ = 2:

```
0.75n_i ≤ n_(i+1) ≤ 1.5n_i + 1
```

**Question**: Can this recurrence diverge?

---

## Lemma B₁ (Target - Not Yet Proven)

**Claim**: If k(n) ≤ 2 for all steps, then the trajectory is bounded.

**Proof Strategy**:
1. Show that k=2 steps dominate k=1 steps in frequency
2. Net multiplicative factor < 1
3. Trajectory cannot diverge

**Status**: CONJECTURED, needs proof

---

## Lemma B₂ (Target - Not Yet Proven)

**Claim**: For any K₀ ≥ 2, bounded-k trajectories cannot diverge.

**Proof Strategy**:
1. Generalize B₁ argument
2. Show arithmetic constraints accumulate
3. Prove impossibility

**Status**: CONJECTURED, needs proof

---

## What We Must NOT Do

❌ No probabilistic arguments ("on average k=2 occurs more often")
❌ No simulations as proof
❌ No "seems bounded" claims
❌ No mixing with spike arguments (Spike Cost is separate)

**Only**: Deterministic inequalities, modular arithmetic, contradiction.

---

## Next Immediate Actions

### Phase 1: Understand k-Distribution Under Bounded-k Constraint

**Question**: If k ≤ K₀, what are the possible k-sequences?

**Approach**: 
- Enumerate valid k-patterns
- Identify arithmetic constraints
- Find contradictions

### Phase 2: Prove K₀ = 2 Case First

**Why**: This is the critical threshold. If we prove this, higher K₀ follows.

**Method**:
- Analyze k ∈ {1, 2} dynamics
- Show net compression
- Prove boundedness

### Phase 3: Generalize to Arbitrary K₀

**Method**:
- Extend B₁ proof structure
- Show general impossibility
- Complete the reduction

---

## Success Criteria

**Theorem B (Target)**: There does not exist an odd Collatz trajectory such that:
- k(n) ≤ K₀ for all steps, AND
- n → ∞

**If proven**: Combined with Spike Cost, this proves Collatz convergence.

---

## Status

- ✅ Spike Cost Principle (PROVEN - kernel enforced)
- 🔄 Bounded-k impossibility (OPEN - analysis in progress)
- ⏳ Full Collatz convergence (pending Theorem B)

**The final regime is isolated. Now we prove it's impossible.**

---

*Bounded-k Analysis Framework*
*Where understanding the last remaining mechanism is victory.*
