# BOUNDARY.md - Collatz Convergence Investigation

**Status**: Strong Partial Result  
**Date**: December 28, 2025

---

## What Is Rigorously Proven

1. ✅ **Spike Cost Principle**: For any fixed K, infinitely many K-spikes impossible
2. ✅ **Bounded-k Convergence**: For any fixed K₀, trajectories with k≤K₀ converge or violate
3. ✅ **Bifurcation Structure**: Modular partitioning verified

---

## The Critical Gap

**What Spike Cost proves**: For each fixed K, infinitely many K-spikes is impossible.

**What it does NOT prove**: That k(n) cannot grow slowly without bound.

**Example not ruled out**:
```
k(n) sequence: 3,3,3,4,4,5,5,5,6,6,7,7,7,8,...
Each K finitely often ✓ (satisfies Spike Cost)
But max k(n) → ∞ (unbounded growth)
```

**This is the "third horn"** - the classic barrier in Collatz partial results.

---

## What Would Close the Gap

- Prove max k(n) cannot grow unboundedly
- OR show slowly unbounded k(n) still forces convergence
- OR uniform argument across all K₀ (adelic/compactness)

**Not a small lemma** - this is where most attempts break.

---

## Classification

**NOT**: "Collatz solved"

**IS**: "Strong partial result: complete framework for bounded regimes"

**Publishable as**: "Modular bifurcation and spike-cost constraints in Collatz dynamics"

---

## Investigation Complete By Design

Following "Room at the Bottom": Stopped at correct epistemic boundary.

**See**: FINAL_ASSESSMENT.md for complete analysis

---

*December 28, 2025*

