# Beal Conjecture - Stage 0: Problem Sanitization

## Prize Information
- **Prize**: $1,000,000 (private, offered by Andrew Beal)
- **Year Proposed**: 1993
- **Status**: Unsolved
- **Category**: Diophantine Equations / Number Theory

---

## Formal Statement

**Beal Conjecture**: If
```
a^x + b^y = c^z
```
where a, b, c, x, y, z are positive integers with x, y, z > 2, then a, b, c must have a common prime factor.

**Equivalently**: There are no solutions to a^x + b^y = c^z with x,y,z > 2 where gcd(a,b,c) = 1.

---

## Domain Specification

### Variables
- a, b, c: positive integers (bases)
- x, y, z: positive integers > 2 (exponents)

### Constraints
- x, y, z ≥ 3 (strictly greater than 2)
- a, b, c ≥ 1
- gcd(a,b,c) = 1 (coprime condition for counterexample)

### Search Space
For computational verification:
- Bounded search: a,b,c ≤ N, x,y,z ≤ M
- Verified up to: a,b,c ≤ 1000, x,y,z ≤ 100 (approximate)

---

## Known Facts

### ✅ Special Cases Proven
1. **Fermat's Last Theorem** (proven 1995): a^n + b^n = c^n has no solutions for n > 2
   - This is Beal with x=y=z
   
2. **Small exponents**: Many cases verified computationally

### ❌ Unknown
- General case with different exponents
- Whether ANY counterexample exists

---

## Why This Problem Fits Our Methodology

### 1. Clear State Space
- Discrete: (a,b,c,x,y,z) ∈ ℕ^6
- Finite per bound: searchable computationally
- Deterministic: equation check is exact

### 2. Failed Heuristic Approaches
- Brute force search (limited by exponential growth)
- Modular arithmetic constraints (insufficient)
- Algebraic factorization (incomplete)

### 3. Systematic Falsification Applicable
- Can test "near-miss" solutions
- Can analyze distribution of gcd(a,b,c) for solutions
- Can identify structural obstructions

### 4. Kernel-Enforceable
- Primality testing: deterministic
- GCD computation: deterministic
- Equation verification: exact arithmetic

---

## Proof Engineering Strategy

### Stage 0: Problem Sanitization ✅ (this document)
- Formal specification
- Domain constraints
- Known/unknown separation

### Stage 1: Mechanization (next)
- State representation: (a,b,c,x,y,z)
- Transition rules: search strategy
- Verification engine: equation + gcd checker

### Stage 2: Systematic Falsification
- **Experiment 1**: Test "near-coprime" solutions (gcd(a,b,c) = small prime)
- **Experiment 2**: Analyze exponent patterns (which x,y,z combinations appear?)
- **Experiment 3**: Distribution analysis (how does gcd grow with solution size?)

### Stage 3: Observational Analysis
- Identify patterns in solutions with gcd > 1
- Look for structural obstructions to gcd = 1
- Analyze modular constraints

### Stage 4: Local Necessity Lemmas
- Prove impossibility results for specific cases
- Build "no-go theorems" like we did for Collatz
- Eliminate classes of potential counterexamples

### Stage 5: Kernel Enforcement
- Encode proven impossibilities as hard constraints
- Prevent regression in search
- Build structural knowledge

---

## Key Differences from Collatz

### Similarities
- Discrete state space
- Computational verification possible
- Failed heuristics exist
- Systematic approach applicable

### Differences
- **Search vs Trajectory**: Beal is search-based, Collatz is trajectory-based
- **Finite vs Infinite**: Beal search is bounded, Collatz trajectories are unbounded
- **Existence vs Universality**: Beal asks "does counterexample exist?", Collatz asks "do all converge?"

### Adaptation Required
- **Search strategy**: Need intelligent search, not just trajectory following
- **Falsification target**: Looking for counterexample, not invariant
- **Success metric**: Proving NO counterexample exists (impossibility)

---

## Initial Hypotheses to Test

### Hypothesis 1: Modular Obstruction
**Claim**: Solutions with gcd(a,b,c) = 1 are impossible modulo certain primes.

**Test**: Check a^x + b^y ≡ c^z (mod p) for small primes p.

### Hypothesis 2: Exponent Constraints
**Claim**: Certain (x,y,z) triples cannot produce coprime solutions.

**Test**: Exhaustive search for specific exponent combinations.

### Hypothesis 3: Growth Rate Mismatch
**Claim**: For gcd(a,b,c) = 1, the growth rates of a^x, b^y, c^z are incompatible.

**Test**: Analyze ratio distributions in near-miss solutions.

---

## Success Definition

Following our Collatz philosophy:

**Success ≠ Finding counterexample**
**Success = Understanding why counterexamples cannot exist**

We aim to:
1. Systematically eliminate classes of potential counterexamples
2. Build impossibility theorems
3. Narrow the search space to provable emptiness

---

## Next Steps

1. **Create verification kernel** (Stage 1)
   - Equation checker
   - GCD computation
   - Prime factorization

2. **Design search strategy**
   - Intelligent bounds
   - Symmetry reduction
   - Early termination

3. **Run Experiment 1**
   - Test near-coprime solutions
   - Build failure taxonomy
   - Identify patterns

---

**Status**: Stage 0 complete. Ready for mechanization.

**Prize**: $1,000,000 awaits rigorous impossibility proof.
