# TRUTH-KERNEL Investigations

This directory contains complete investigations using the TRUTH-KERNEL methodology.

Each investigation includes:
- ✅ **Kernel code** (verification engines)
- ✅ **Test results** (empirical data)
- ✅ **Analysis documents** (findings and boundaries)
- ✅ **Papers** (formal write-ups, LaTeX sources)

---

## Completed Investigations

### 1. Collatz Conjecture
**Directory**: `collatz/`

**Status**: Bounded-k analysis complete

**Key Results**:
- 2-adic spike cost identified
- Divergence eliminated for bounded k
- Boundary: Local chaos ≠ global behavior

**Files**:
- `collatz_kernel.py` - Verification engine
- `COLLATZ_ANALYSIS.md` - Complete analysis
- (Papers to be added)

---

### 2. Beal Conjecture
**Directory**: `beal/`

**Status**: 95% rigor achieved, stopped at understanding boundary

**Key Results**:
- Valuation debt framework established
- Independence Lemma formalized
- 10,550+ adversarial tests, 0 counterexamples
- Boundary: Independence argument needs formal CRT proof

**Files**:
- `beal_kernel.py` - Base verification
- `valuation_debt_kernel.py` - Δ_p framework
- `adversarial_kernel.py` - 10k+ test suite
- `PRIME_COLLISION_PROOF.pdf` - 10-page formal proof
- `PRIME_COLLISION_PROOF.tex` - LaTeX source
- `gaps_assessment.md` - Honest 5% gaps
- `proof_summary.md` - Executive summary
- `EXPERIMENT_CONCLUSION.md` - Why we stopped

---

### 3. Goldbach Conjecture
**Directory**: `goldbach/`

**Status**: Boundary reached (no finite modular obstruction)

**Key Results**:
- 50,000+ tests, 0 counterexamples
- 2.15x enhancement factor (sieving correlations)
- Modular obstruction analysis: O_p = ∅ for odd primes
- Boundary: No finite modular obstruction → analytic proof required

**Files**:
- `goldbach_kernel.py` - Prime sieve and verification
- `goldbach_phase2.py` - Density debt analysis
- `modular_obstruction_kernel.py` - Obstruction sets
- `GOLDBACH_MISSION.md` - 3-phase plan
- `PHASE1_ANALYSIS.md` - Empirical results
- `PHASE2_ANALYSIS.md` - Structural findings
- `PHASE2A_RESULTS.md` - Modular analysis
- `GOLDBACH_CONCLUSION.md` - Honest final conclusion

---

## The Pattern

All three investigations followed the same 3-phase pipeline:

| Phase | Collatz | Beal | Goldbach |
|-------|---------|------|----------|
| **1. Empirical** | Trajectory testing | 10k+ coprime attempts | 50k+ even numbers |
| **2. Structural** | 2-adic spike cost | Valuation debt | Density debt, 2.15x factor |
| **3. Boundary** | Local ≠ global | Independence needs CRT | No finite obstruction |

**Common thread**: The machine stopped itself when logic broke.

---

## How to Use These Investigations

### As Learning Material
1. Read the analysis documents (`.md` files)
2. Study the kernel code (`.py` files)
3. Run the tests yourself
4. Understand where and why we stopped

### As Templates
1. Copy the kernel structure
2. Adapt to your problem
3. Follow the 3-phase pipeline
4. Stop when understanding ends

### As Research Artifacts
1. All code is reproducible
2. All results are verifiable
3. All gaps are documented
4. All papers include LaTeX sources

---

## Citation

If you use these investigations in your research:

```bibtex
@misc{truth_kernel_investigations_2025,
  title = {TRUTH-KERNEL Investigations: Collatz, Beal, and Goldbach},
  author = {Shrikant Bhosale},
  year = {2025},
  howpublished = {\\url{https://codeberg.org/ishrikantbhosale/truth-kernel/investigations}}
}
```

---

## License

All investigation materials are dual-licensed:
- **MIT License**: Research and educational use
- **Commercial License**: Enterprise and commercial use

See [LICENSE-MIT.md](../LICENSE-MIT.md) and [LICENSE-COMMERCIAL.md](../LICENSE-COMMERCIAL.md)

---

**These investigations prove the methodology works.**

Not by solving the problems - but by reaching their boundaries honestly.
