# Prize Hunt: 19 Major Unsolved Mathematical Problems

**Status**: Systematic tracking for proof engineering targets  
**Methodology**: Room at the Bottom - foundations first, honest boundaries

---

## Overview

This document tracks 19 major unsolved mathematical problems across three tiers, assessed for proof engineering methodology fit.

**Philosophy**: Not chasing prizes blindly. Building verification infrastructure systematically.

---

## Tier 1: Millennium Prize Problems ($1M each)

| # | Problem | Field | Status | Methodology Fit |
|---|---------|-------|--------|-----------------|
| 1 | **P vs NP** | Computational complexity | Open | Low (computational theory) |
| 2 | **Riemann Hypothesis** | Analytic number theory | Open | Medium (requires deep analysis) |
| 3 | **Birch and Swinnerton-Dyer** | Elliptic curves | Open | Low (algebraic geometry) |
| 4 | **Hodge Conjecture** | Algebraic geometry | Open | Low (requires topology) |
| 5 | **Navier-Stokes** | Fluid dynamics PDEs | Open | Medium (physics + analysis) |
| 6 | **Yang-Mills Mass Gap** | Quantum field theory | Open | Low (requires QFT) |

**Assessment**: Most require specialized mathematical machinery beyond current kernel capabilities.

---

## Tier 2: High-Value Private Prizes

| # | Problem | Prize | Status | Progress |
|---|---------|-------|--------|----------|
| 7 | **Beal Conjecture** | $1M | **IN PROGRESS** | 95% rigor (p-adic valuation) |
| 8 | **Collatz Conjecture** | Fame | **PARTIAL** | Divergence eliminated ✅ |

### Beal Conjecture
- **Statement**: If A^x + B^y = C^z where A,B,C,x,y,z are positive integers and x,y,z > 2, then A, B, and C must have a common prime factor.
- **Our Work**: `investigations/beal/` - 95% rigor proof using p-adic valuation
- **Status**: Formalization in progress
- **Next**: Independence proof for remaining 5%

### Collatz Conjecture  
- **Statement**: For any positive integer n, the sequence n → n/2 (if even) or 3n+1 (if odd) eventually reaches 1.
- **Our Work**: `investigations/collatz/` - Proved divergence is impossible
- **Proven**: Spike Cost Principle, Lemma B₁, Inevitability Theorem
- **Remaining**: Convergence to 1, cycle analysis

---

## Tier 3: Legendary Open Problems

| # | Problem | Year | Methodology Fit | Priority |
|---|---------|------|-----------------|----------|
| 9 | **Goldbach Conjecture** | 1742 | **HIGH** | Secondary |
| 10 | **Twin Prime Conjecture** | Ancient | Medium | Research |
| 11 | **abc Conjecture** | 1985 | Medium | Research |
| 12 | **Legendre's Conjecture** | ~1800 | Medium | Research |
| 13 | **Brocard's Conjecture** | 1876 | High | Tertiary |
| 14 | **Odd Perfect Numbers** | Ancient | **HIGH** | Tertiary |
| 15 | **Hadwiger Conjecture** | 1943 | Low | - |
| 16 | **Erdős-Ginzburg-Ziv** | 1961+ | Low | - |
| 17 | **Lonely Runner** | 1960s | Low | - |
| 18 | **Kahn-Kalai** | 2006 | Low | - |
| 19 | **Erdős-Ulam** | 1940s-80s | Low | - |

### High-Priority Targets

#### Goldbach Conjecture (Secondary Target)
- **Statement**: Every even integer > 2 is the sum of two primes
- **Methodology Fit**: Number theory, modular arithmetic, kernel verification
- **Our Work**: `investigations/goldbach/` - Honest boundary reached
- **Status**: No finite modular obstruction found
- **Approach**: Systematic elimination, falsification-first

#### Odd Perfect Numbers (Tertiary Target)
- **Statement**: Do odd perfect numbers exist?
- **Methodology Fit**: Excellent for falsification approach
- **Verification**: σ(n) = 2n where σ is divisor sum
- **Approach**: Prove non-existence for increasingly large bounds
- **Status**: Not started

#### Brocard's Conjecture (Tertiary Target)
- **Statement**: n! + 1 = m² has only finitely many solutions
- **Known Solutions**: Only 3 (n = 4, 5, 7)
- **Methodology Fit**: Computational + theoretical bounds
- **Approach**: Prove no solutions beyond known cases
- **Status**: Not started

---

## Methodology Assessment Criteria

**HIGH Fit** (Can apply Collatz-style proof engineering):
- Number theory foundations
- Kernel verification possible
- Falsification tests feasible
- Modular arithmetic applicable
- Computational bounds available

**MEDIUM Fit** (Partial methodology application):
- Requires some specialized theory
- Verification partially possible
- Some aspects testable

**LOW Fit** (Requires different approach):
- Deep specialized mathematics
- Hard to build verification kernel
- Limited falsification opportunities

---

## Current Focus

### Active Investigations
1. **Beal Conjecture** - Finalizing 95% → 100% rigor
2. **Collatz Conjecture** - Convergence proof (divergence done)

### Next Targets (Prioritized)
1. **Goldbach** - Systematic modular analysis
2. **Odd Perfect Numbers** - Falsification approach
3. **Brocard** - Computational + theoretical bounds

### Research Targets (Long-term)
- Twin Prime Conjecture
- Legendre's Conjecture
- abc Conjecture (if Mochizuki proof fails)

---

## Philosophy

> **"There's plenty of room at the bottom"**

We don't chase all 19 problems. We:
1. **Select** based on methodology fit
2. **Build** verification infrastructure
3. **Attack** systematically
4. **Stop** when logic breaks
5. **Document** honest boundaries

**Not the prize. The infrastructure.**

---

## Progress Tracking

| Investigation | Status | Rigor | Boundary |
|---------------|--------|-------|----------|
| Collatz | Partial | 100% | Convergence proof |
| Beal | Active | 95% | Independence formalization |
| Goldbach | Complete | 100% | No finite obstruction |
| Odd Perfect | Not started | - | - |
| Brocard | Not started | - | - |

---

## Resources

- **Investigations**: `investigations/` directory
- **Kernels**: `kernels/` directory  
- **Docker Lab**: `docker/mathlab/` for integrated research environment
- **Methodology**: `docs/PHILOSOPHY.md`, `docs/THINKING_MACHINE.md`

---

**Last Updated**: December 27, 2025  
**Repository**: https://codeberg.org/ishrikantbhosale/room-at-the-bottom
