# Method2Model — Stage-1 Package (Example Deliverable)

**Dual-Platform mRNA Therapy for X-Linked ALD (LNP + EV, Peripheral-First → CNS)**

This Zenodo record shares a **complete Stage-1 modeling package** for a dual-platform mRNA therapy in X-linked adrenoleukodystrophy (ALD), using lipid nanoparticles (LNP) and extracellular vesicles (EV) in a *peripheral-first → CNS* strategy.

It is published as an **example of what a client can expect as a Stage-1 output** from the Method2Model pipeline: a review-ready logic and architecture dossier that sits *between* the initial idea and any heavy implementation, coding, or clinical commitment.

---

## Why Stage-1 Exists (and What Pain It Solves)

Most ambitious mRNA / gene-therapy programs do not fail because the science was irrational or the team was unqualified. They fail because:

- Critical assumptions about delivery, CNS access, targeting, immune risk, and CMC variability stay implicit until **after** expensive experiments have been run.
- Preclinical design, CMC, and modeling move in parallel but do not share a single explicit architecture of **“what connects to what.”**
- By the time IRB / sponsor / internal review pushes back, the only options are late-stage rewrites, scope drift, and sunk costs.

**Stage-1 removes that failure mode** by forcing all of the following onto one coherent, reviewable page of reality:

- What exactly we are trying to achieve (**use-case and scope lock**).
- How biology, delivery, safety, CMC, and decisions are connected in a **mechanistic model**, not disconnected spreadsheets.
- Which assumptions are guesses, their impact, confidence, and how they will be validated (**Assumptions Map / MRR**).
- What experiments must exist so the model is actually calibratable (**Study Execution Guide**).

This record is therefore both:

- A concrete Stage-1 deliverable for the ALD mRNA project, and  
- A template of what Method2Model delivers at Stage-1 for other therapies and indications.

---

## Files in This Record

### 1) Stage-1 Logic and Architecture Package  
**File:** `ALD_mRNA_Therapy_Stage_1_Output.pdf`

**What it is:**  
A compact, review-oriented summary of the entire Stage-1 package—written so a PI, translational lead, or sponsor can quickly understand:

- Which pre-defined Method2Model use-cases this project commits to (e.g., *“Before you commit to sample size, test power under real-world noise”*).
- What is in-scope vs out-of-scope for Stage-1 (logic and architecture are fixed; calibration and protocol finalization come later).
- The **Assumptions Map / Log** (delivery, targeting, safety, and CMC assumptions with confidence, impact, and validation plan).
- The **Input Specification Sheet (ISS)**: variables required for later calibration (VLCFA, ALDP, CQAs, NfL, Loes, etc.) with units, ranges, and noise expectations.
- A high-level architecture summary framed as blocks **A–G** (Delivery/Transport, Targeting, PD, Safety, CMC, Uncertainty/Scenarios, Decisions).
- A definition-level **Scenario Pack v1** (baseline and stress scenarios).
- A verification plan outline (how code–architecture equivalence will be proven at later stages).

**Who should start here:**  
PIs, program leads, sponsors, reviewers—and anyone asking:  
**“What exactly are we doing, and why is Stage-1 worth paying for?”**

---

### 2) Stage-1 Architecture Specification (Version 2)  
**File:** `ALD_mRNA_Therapy_Architecture.pdf`

**What it is:**  
A detailed, implementation-ready architecture document: **the blueprint for the model itself**.

It defines, block by block:

- Indices (species, phenotype, carrier type, route, compartment, CNS cell type, etc.).
- The separation between **simulated states**, **observables**, and **policies** (critical for calibration and reporting).
- For each block (A–G), the states, observables, inputs, and core equations:
  - **Block A:** PBPK/transport for LNP and EV, including FUS-modulated BBB permeability and CNS uptake.
  - **Block B:** mRNA kinetics, ALDP translation, peroxisomal targeting vs mislocalization, composite targeting scores.
  - **Block C:** Disease/PD with mouse branch (preclinical endpoints) and human-projected branch (VLCFA, NfL, Loes).
  - **Block D:** Safety/immunogenicity (cytokine spikes, complement, ALT/AST, anti-PEG).
  - **Block E:** CMC / batch variability (potency distributions, stability, freeze–thaw effects).
  - **Block F:** Uncertainty + scenario engine (priors, sampling, robustness metrics).
  - **Block G:** Defensibility + decision logic (Go/No-Go/Pivot, first-break mechanisms, decision surfaces).

**Why it matters:**  
It prevents “architecture drift” between what stakeholders believe is being modeled and what is actually implemented—and enables an independent modeling team to implement the core without re-deriving requirements from emails and slide decks.

**Primary audience:**  
Modeling/quant teams and technical reviewers.

---

### 3) Study Execution Guide v1  
**File:** `The_Study_Execution_Guide.pdf`

**What it is:**  
A step-wise operational manual for executing the experimental program in a way that is fully aligned with the Stage-1 architecture.

It is written for wet-lab and translational teams and explains:

- How the program is split into **four workstreams**:
  1. *In vitro* cellular studies (Aim 1) — ALDP expression/targeting and VLCFA reduction in patient-derived cells.
  2. *In vivo* mouse studies (Aim 2) — efficacy, CNS effect, imaging, and safety in ALD models.
  3. CMC and analytics — LNP/EV batches, potency, CQAs, stability.
  4. Decision/iteration workflow — how results update assumptions and trigger scenario reruns / decision surfaces.
- What to measure, why it matters, and **how it maps to Blocks A–G**, so every assay has a downstream role in calibration/decisions.

---

## How These Pieces Fit Together

Think of the three files as three layers of the same object:

1. **Logic/Architecture Package** — *What we are doing and why it matters* (PI/sponsor-readable).
2. **Architecture Specification** — *Exactly how the model is structured* (engineer’s blueprint).
3. **Study Execution Guide** — *How to run experiments so the blueprint can be populated and tested*.

Together, they:

- Lock the scope and use-cases so the project doesn’t drift into undefined “more analyses.”
- Make assumptions explicit, so they can be updated with evidence instead of silently breaking later.
- Ensure planned measurements have a downstream role (reducing low-information endpoints and unconnected assays).
- Provide a traceable path from raw data → mechanistic states → defensible decisions.

**Recommended reading order (10 minutes):**  
1) `ALD_mRNA_Therapy_Stage_1_Output.pdf` → 2) `ALD_mRNA_Therapy_Architecture.pdf` → 3) `The_Study_Execution_Guide.pdf`

---

## What Stage-1 Is Not

To avoid misunderstanding:

- Stage-1 does **not** deliver a fully calibrated, validated model or a final clinical protocol.
- Stage-1 does **not** claim regulatory-grade power calculations; it sets up the structure so they can be done correctly later.
- Stage-1 does **not** lock you into a specific solver/platform—**it locks the architecture and logic**, not implementation details.

Those parts belong to subsequent stages (implementation, calibration, validation), either within Method2Model or with your in-house modeling team using this Stage-1 dossier as the foundation.

---

## Re-Use and Adaptation

Although the biological context here is X-linked ALD with dual-platform mRNA (LNP + EV), the pattern is reusable for:

- Other monogenic neurological diseases with peripheral + CNS components.
- Gene-replacement or gene-editing programs facing similar delivery/targeting/safety trade-offs.
- Any project where CMC variability, immune risk, and translational uncertainty undermine efficacy—even when early biology looks promising.

You are welcome to adapt:

- The block structure (A–G),
- The Assumptions Map / MRR pattern,
- The Study Execution Guide structure (workstreams + data-flow mapping),

as long as you respect the licensing terms of this deposit.

---

## How to Cite

If you use or adapt this Stage-1 package, please cite the Zenodo record:

- **DOI:** `10.5281/zenodo.18069680`

Convenience link (DOI URL):

```text
https://doi.org/10.5281/zenodo.18069680
```

> Tip: Once your author list / title / version on Zenodo is final, mirror that exact citation string here for perfect consistency.

---

## Contact and Collaboration

This package was created within the **Method2Model** framework: turning complex protocols into executable, reviewable models with clear decision hooks.

For collaborations, bespoke Stage-1 packages in other indications, or integration with your in-house modeling team:

- **Name:** Dr. Ramyar Azar  
- **Role:** Founder, Method2Model  
- **Email:** drazar@method2model.com  
- **Website:** https://method2model.com/

Stage-1 is where hidden assumptions surface, architecture stops drifting, and teams align—*before* time, budget, animals, or patients are committed.
