clear all 
close all

load('C:\Users\chand\OneDrive - UvA\cyclic_compression\single_particle_all_data\2023-10-12-singlehydrogel_5steps-strain_0_05_strain_rate_0_002_wait_time_3000_start_strain1percent_3cycles_shell-Velocity-0.037267mmscycle3.mat')

% load('C:\Users\shaky006\OneDrive - UvA\cyclic_compression\single_particle_all_data\2023-10-12-singlehydrogel_5steps-strain_0_05_strain_rate_0_002_wait_time_3000_start_strain1percent_3cycles_shell-Velocity-0.037267mmscycle3.mat')
close all

figure
for i=1:9
    plot(approach_data(:,i,1))
    hold on  
end
hold off


%% constant definition
g=9.81; %m/s^2
rho_medium=1000; %kg/m^3
dia_indenter=8/1000; %diameter of indenter in m
buoyancy_factor=rho_medium*g*pi()*((dia_indenter)^2)/4;
nu=0.5;

%% conversion of forces
forces=((approach_data-(MeanSignalZero/1000))*calibration_constant)+calibration_offset; %in N
strain_all=indent_val_per_step/mean(dia_upper);
indentation_time=indent_val_per_step/velocity;
datapoints_to_skip=diff(indentation_time*sampling_rate);
r_particle=(l/2)/1000;

% [relax_maxF,relax_maxindex]=max(F_relax);
relax_maxindex=630;
disp_relax=indent_val_per_step/1000;

for j=1:3
    
figure
for i=1:length(strain_all)
time_array_total=[0:time_approach_end(i,j)/length(forces(:,i,j)):time_approach_end(i,j)];
time_array_compression(i,:,j)=time_array_total(2:end);
time_array_relax_comp(i,:,j)=time_array_compression(i,relax_maxindex:end,j);
F_relax(i,:,j)=forces(relax_maxindex:end,i,j)-buoyancy_factor*disp_relax(i);
G(i,:,j)=(F_relax(i,:,j)/2)*(3/4)*(1-nu)/((r_particle^0.5)*(disp_relax(i)^1.5));
plot(time_array_relax_comp(i,:,j),F_relax(i,:,j))
hold on
end
hold off
end


% time_relax=structure.relaxation.time-min(structure.relaxation.time);
% G=(F_relax/2)*(3/4)*(1-nu)/((r_particle^0.5)*(disp_relax^1.5));
figure
i=9;
j=3;
plot(time_array_relax_comp(i,:,j),G(i,:,j))

%% plot normalized raw data

for j=1:3
    figure
    for i=1:length(strain_all)
        semilogy(time_array_relax_comp(i,:,j),(F_relax(i,:,j)-min(F_relax(i,:,j)))/max(F_relax(i,:,j)),'DisplayName',num2str(strain_all(i)))
        hold on
    end
    hold off
    box on
end


%% only relaxation
processing_step=5;
processing_cycle=1;
disp_relax=indent_val_per_step(processing_step)/1000; % in m
F_relax=forces(:,processing_step,processing_cycle)-buoyancy_factor*disp_relax;
% [relax_maxF,relax_maxindex]=max(F_relax);
relax_maxindex=600;

figure
plot(forces(:,processing_step,processing_cycle))
hold on
plot(F_relax)
plot(F_relax(relax_maxindex:end))
hold off

%% 
coeff_exp_decay_G_single=fit_exp_decay_regular(time_array_relax_comp(9,:,2),movmean(G(9,:,2),10),2000,'single');
coeff_exp_decay_G_double=fit_double_exp_decay_successive(time_array_relax_comp(9,:,2),movmean(G(9,:,2),10));


f=figure
sz=3*ones(size(squeeze(G(9,:,1))));
scatter(time_array_relax_comp(9,:,1),movmean(G(9,:,1),10)-coeff_exp_decay_G_double.F_e,sz)
hold on
y_plot=coeff_exp_decay_G_double.F_e+(coeff_exp_decay_G_double.F_l1*exp(-time_array_relax_comp(9,:,1)/coeff_exp_decay_G_double.tau1))+(coeff_exp_decay_G_double.F_l2*exp(-time_array_relax_comp(9,:,1)/coeff_exp_decay_G_double.tau2));
plot(time_array_relax_comp(9,:,1),y_plot-coeff_exp_decay_G_double.F_e,'LineWidth',3)
hold off
xlabel('time (s)')
ylabel('G-G_e')
set(gca,'yscale','log')
box on
ax = gca;
ax.LineWidth=2;
ax.FontSize = 25;
ax.YAxis.Exponent = 3;
ax.XAxis.Exponent = 3;
axis('square')
f.Position=[200 300 560 500]



f=figure
sz=3*ones(size(squeeze(G(9,:,1))));
scatter(time_array_relax_comp(9,:,1),movmean(G(9,:,1),10)-coeff_exp_decay_G_single.G(2),sz)
hold on
y_plot=coeff_exp_decay_G_single.G(2)+(coeff_exp_decay_G_single.G(3)*exp(-time_array_relax_comp(9,:,1)/coeff_exp_decay_G_single.G(4)));
plot(time_array_relax_comp(9,:,1),y_plot-coeff_exp_decay_G_single.G(2),'LineWidth',3)
hold off
xlabel('time (s)')
ylabel('G - G_e [Pa]')
set(gca,'yscale','log')
box on
ax = gca;
ax.LineWidth=2;
ax.FontSize = 25;
ax.YAxis.Exponent = 3;
ax.XAxis.Exponent = 3;
axis('square')
f.Position=[200 300 560 500]

%% figure 9b
f=figure
sz=20*ones(size(squeeze(G(9,:,2))));
scatter(time_array_relax_comp(9,:,2),movmean(G(9,:,2),10),sz,'filled','DisplayName','Experiment')
hold on
y_plot=coeff_exp_decay_G_single.G(2)+(coeff_exp_decay_G_single.G(3)*exp(-time_array_relax_comp(9,:,2)/coeff_exp_decay_G_single.G(4)));
plot(time_array_relax_comp(9,:,2),y_plot,'LineWidth',3,'DisplayName','Single exp')
y_plot=coeff_exp_decay_G_double.F_e+(coeff_exp_decay_G_double.F_l1*exp(-time_array_relax_comp(9,:,2)/coeff_exp_decay_G_double.tau1))+(coeff_exp_decay_G_double.F_l2*exp(-time_array_relax_comp(9,:,2)/coeff_exp_decay_G_double.tau2));
plot(time_array_relax_comp(9,:,2),y_plot,'LineWidth',3,'DisplayName','Double exp')
hold off
xlabel('t [s]')
ylabel('G [Pa]')
lgd = legend('Location','southwest','Interpreter','latex');
lgd.FontSize = 18;
% set(gca,'yscale','log')
box on
ax = gca;
ax.LineWidth=2;
ax.FontSize = 20;
ax.YAxis.Exponent = 3;
ax.XAxis.Exponent = 3;
axis('square')
rectangle('Position', [2.6e3, 14.45e3, 0.4e3, 0.2e3], 'EdgeColor', 'g');
axes('position',[.6 .64 .2 .2])
box on % put box around new pair of axes
sz=20*ones(size(squeeze(G(9,:,2))));
scatter(time_array_relax_comp(9,:,2),movmean(G(9,:,2),10),sz,'filled','DisplayName','Experiment')
hold on
y_plot=coeff_exp_decay_G_single.G(2)+(coeff_exp_decay_G_single.G(3)*exp(-time_array_relax_comp(9,:,2)/coeff_exp_decay_G_single.G(4)));
plot(time_array_relax_comp(9,:,2),y_plot,'LineWidth',3,'DisplayName','Single exp')
y_plot=coeff_exp_decay_G_double.F_e+(coeff_exp_decay_G_double.F_l1*exp(-time_array_relax_comp(9,:,2)/coeff_exp_decay_G_double.tau1))+(coeff_exp_decay_G_double.F_l2*exp(-time_array_relax_comp(9,:,2)/coeff_exp_decay_G_double.tau2));
plot(time_array_relax_comp(9,:,2),y_plot,'LineWidth',3,'DisplayName','Double exp')
hold off
ylim([14.45e3 14.65e3])
xlim([2.6e3 3e3])
box on
ax4 = gca;
ax4.LineWidth=1;
ax4.FontSize = 14;
ax4.YAxis.Exponent = 3;
ax4.XAxis.Exponent = 3;
f.Position=[200 300 560 500];
AddLetters2Plots({ax},{'b)'}, 'HShift', 0.1, 'VShift', 0, 'FontSize', 18)
saveas(gcf,'M:\paper_writing\inter_particle_shear\G_vs_time_indent_confined','epsc')
saveas(gcf,'M:\paper_writing\inter_particle_shear\09b_G_vs_time_indent_confined.tif')

