function exp_decay=fit_exp_decay_regular(x,y,tau_init,titletext) 
% y=y_min+(ymax-ymin)*e^(-lambda*x)

%y=base+y0*exp(-(x*lambda));
tbl=table(x(:),y(:));

y_min=min(y);
init(1)=y_min*0.8;%0.78913;%y_min extimate
init(3)=tau_init; %lambda estimate
init(2)=max(y)-init(1);
modelfun=@(b,x) b(1)+(b(2)*exp(-(x/b(3)))); 
beta0=[init(1) ; init(2); init(3)];
mdl=fitnlm(tbl,modelfun,beta0);
coefficients=mdl.Coefficients{:,'Estimate'};

fitted=coefficients(1)+(coefficients(2)*exp(-(x/coefficients(3)))); 

% figure
% sz=3*ones(size(y));
% scatter(x,y,sz,'DisplayName','experimental data')
% hold on
% semilogy(x,fitted,'DisplayName','fitted relaxation moduli')
% hold off
% xlabel('time (s)')
% ylabel('Response')
% legend
% title(titletext)



correction.x=x;
correction.residual=fitted-y;
correction.rms=sum(sqrt(correction.residual.*correction.residual));

% figure
% area(x,correction.residual)
% xlabel('time (t)')
% ylabel('Residual to response')

figure
sz=3*ones(size(y));
scatter(x,y-coefficients(1),sz,'DisplayName','experimental data')
hold on
semilogy(x,fitted-coefficients(1),'DisplayName','fitted Response','LineWidth',2)
hold off
xlabel('time (s)')
ylabel('Response-Response_e')
set(gca,'yscale','log')
title(titletext)


exp_decay.G=[y_min; coefficients];
exp_decay.correction=correction;
exp_decay.fitted=fitted;



end

