% x=time_relax;
% y=G;

function exp_decay=fit_double_exp_decay_successive(x,y)
si_ze=length(x);
long_relax_array=floor(si_ze/4);
titletext='long';
coeff_long=fit_exp_decay_regular(x(long_relax_array:end),y(long_relax_array:end),2000,titletext);

F_e1=coeff_long.G(2);
F_l1=coeff_long.G(3);
tau1=coeff_long.G(4);

F_pred=F_e1+F_l1*exp(-x/tau1);
y_residual=y-F_pred;
titletext='short';
short_relax_array=floor(si_ze/4);
coeff_short=fit_exp_decay_regular(x(1:short_relax_array),y_residual(1:short_relax_array),200,titletext);
F_e2=coeff_short.G(2);
F_l2=coeff_short.G(3);
tau2=coeff_short.G(4);

F_pred_tot=(F_e1+F_e2)+(F_l1*exp(-x/tau1))+(F_l2*exp(-x/tau2));

figure
sz=3*ones(size(y));
scatter(x,y,sz,'DisplayName','experimental data')
hold on
semilogy(x,F_pred_tot,'DisplayName','fitted relaxation moduli')
hold off
xlabel('time (s)')
ylabel('Response')
legend

figure
sz=3*ones(size(y));
scatter(x,y-(F_e1+F_e2),sz,'DisplayName','experimental data')
hold on
semilogy(x,F_pred_tot-(F_e1+F_e2),'DisplayName','fitted relaxation moduli')
hold off
xlabel('time (s)')
ylabel('Response-Response_e')
set(gca,'yscale','log')
legend
title('double decay')


% return values
exp_decay.F_e=(F_e1+F_e2);
exp_decay.F_l1=F_l1;
exp_decay.tau1=tau1;
exp_decay.F_l2=F_l2;
exp_decay.tau2=tau2;
end

