close all 
clear all
cd 'M:\Rheometer\scripts'
% Calculate force on particles using Jian et al, Powder Technology 350
% (2019), p 51.  Equation 14, 17, and 23


%  Based on a standard linear solid (spring in parallel with MAxwell
%  element)
%
% Ge=1.25e+04;  % shear modulus at t->inf
% G1=0.25*Ge; % "relaxable" part of shear modulus 
% eta=1; %viscosity
% vp=0.5;  %Poisson ratio
% T= 100%0.05*(1/(5.6164e-04)); %relaxation time
% R=(18.5/2)/1000;   %sphere radius
% Rstar=R/2;   %1/R=1/R1+1/R2
% str_ain=0.018;
% dmax=str_ain*2*2*R;  % deformation of sphere when they are exactly on top of each other
% y=2*R-dmax;  %vertical distance between centers of spheres


Ge=0.45e+04;  % shear modulus at t->inf
G1=4.0*Ge; % "relaxable" part of shear modulus 
eta=1; %viscosity
vp=0.5;  %Poisson ratio
T= 2000%0.05*(1/(5.6164e-04)); %relaxation time
R=(18.5/2)/1000;   %sphere radius
Rstar=R/2;   %1/R=1/R1+1/R2
str_ain=0.018;
dmax=str_ain*2*2*R;  % deformation of sphere when they are exactly on top of each other
y=2*R-dmax;  %vertical distance between centers of spheres



v_char=sqrt(4*R^2-y^2)/T;
geometric_travel=sqrt(4*R^2-y^2)/T;

v_fact=2.38e-5*[1 2 5 10]%*logspace(-4,4,91);
col=hsv(2*length(v_fact));
mu=5e-3;



for m=1:length(v_fact)
% m=1;
v=v_fact(m);%*3.96e-04;  %velocity of moving sphere
 
%define t=to and x=0 as point where spheres are on top of each other and 
%time of first contact:d=2*R
 
to=sqrt(4*R^2-y^2)/v;  %time at which beads are on top of each other
dt=to/200;  %time increment
t=[0:dt:2*to];   
x=v*(t); %x-position of sphere
xo=v*to;%x-position of fixed sphere
d=sqrt(y^2+(x-xo).^2); 
del=(2*R-d); %indentation
%  
% ddeldt=-v^2*(t-to)./(2*d); %ddelta/dt=-0.5dd/dt=-(x/2d)*v
 
%Elastic Hertzian part:
Fe=(4*Ge*sqrt(Rstar)/(3*(1-vp)))*del.^(3/2);  %elastic force

force_struct(m).x=x;
force_struct(m).Fe=Fe;
force_struct(m).Fe_hz=((x-xo).*Fe./d);

force_struct(m).del=del;

%Dissipation during elastic contact

dissipation_elastic_x(m)=trapz(x,((x-xo).*Fe./d));
 
%Dissipative part:
pref=4*sqrt(Rstar)/(2*(1-vp));
ds=dt/500;  %time step for numerical integration (eq 23)
Fd=zeros(size(t));
 
for i=2:length(t)
    s=[0:ds:t(i)];
    xi=v*(s);
    di=sqrt(y^2+(xi-xo).^2);
    deli=(2*R-di);
    d12i=deli.^(1/2);
    ddoti=-(xi-xo)*v./(2*di);
    del_t=t(i)-s;
    expo=exp(-(del_t)/T);
    integ(i).arr=G1*exp(-(del_t)/T).*d12i.*ddoti;
    Fd(i)=pref*trapz(s,integ(i).arr); %numerical integral for Fd
end

force_struct(m).Fd=Fd;

Res(m,:)=Fe+Fd;
force_struct(m).Res=Fe+Fd;
force_struct(m).Res_x=(x-xo).*(Fe+Fd)./d;
force_struct(m).x=x;

trigger_val=0;
x_zero(m)=x(end);
[max_Res,max_Res_pos]=max(Res(m,:));
[min_Res,min_Res_pos]=min(Res(m,:));
for i=min(min_Res_pos,max_Res_pos)+10:max(min_Res_pos,max_Res_pos)-1
    if or(and(Res(m,i)<0,Res(m,i+1)>0),and(Res(m,i)>0,Res(m,i+1)<0))
        zero_fit=polyfit(x(i:i+1),Res(m,i:i+1),1);
        x_zero_array=x(i:i+1);
        y_zero_array=Res(m,i:i+1);
        x_zero(m)=-zero_fit(2)/zero_fit(1);
        trigger_val=1;
        break
    end
end


if trigger_val==1
    x_cut(m).contact_length=[(x(1:i)),(x_zero(m))];
    res_cut(m).resultant_viscoelastic=[Res(m,1:i),0];
    res_cut(m).resultant_viscoelastic_x=[(x(1:i)-xo).*Res(m,1:i)./d(1:i),0];
else
    x_cut(m).contact_length=x;
    res_cut(m).resultant_viscoelastic=Res(m,:);
    res_cut(m).resultant_viscoelastic_x=(x-xo).*Res(m,:)./d;
end

dissipation(m)=trapz((x_cut(m).contact_length),(res_cut(m).resultant_viscoelastic_x));

%% friction dissipation
res_cut(m).friction=mu*res_cut(m).resultant_viscoelastic;

if trigger_val==1
res_cut(m).friction_x= [mu*y*Res(m,1:i)./d(1:i),0];%y*res_cut(m).friction(m,:)./[d(1:i),0];
else
res_cut(m).friction_x= mu*y*Res(m,:)./d;%y*res_cut(m).friction(m,:)./[d(1:i),0];    
end

res_cut(m)
res_cut(m).resultant_x=res_cut(m).resultant_viscoelastic_x-res_cut(m).friction_x;

dissipation_friction(m)=trapz(x_cut(m).contact_length,res_cut(m).friction_x);


for i=1:length(Res(m,:))
    if and(Fe(i)>0,Res(m,i)>0)
        Res_mod(m,i)=Res(m,i);
    elseif and(Fe(i)<0,Res(m,i)<0)
        Res_mod(m,i)=Res(m,i);
    else
       Res_mod(m,i)=0;   
    end
end

Array=Res_mod(m,2:end);
cross_end_index(m)=find(Array==0,1,'first')+1;
x_end(m)=x(cross_end_index(m));
dist_char(m)=v*T;

%Frictional Part
FF=mu*Res_mod(m,:);



FxH(m,:)=(x-xo).*Fe./d;  %x-component for force, Hertz contribution
FyH(m,:)=y.*Fe./d;  %y-component for force, Hertz contribution
FxD(m,:)=(x-xo).*Fd./d;  %x-component for force, dissipative contribution
FyD(m,:)=y.*Fd./d;  %y-component for force, dissipative contribution

Resx(m,:)= (x-xo).*Res_mod(m,:)./d;
Resy(m,:)= y.*Res_mod(m,:)./d;
FxF(m,:)=y.*FF./d;  %x-component for force, Frictional contribution
FyF(m,:)=(x-xo).*FF./d; %y-component for force, Frictional contribution


x_plot(m,:)=x;

%% minimum cycle length
x_geometric(m)=x(end);


%% clear used variables
clear Fe Fd FF x d v dt t del pref ds i s xi di deli d12i ddoti del_t expo integ trigger_val max_Res max_Res_pos ...
    min_Res min_Res_pos zero_fit x_zero_array y_zero_array Array FF5

%% dissipation
% in the direction of contact


end
%% plot vertical forces for paper
% figure 8b
f=figure
for i=1:m
    name_tag=sprintf('%0.2e',v_fact(i));
    plot(x_plot(i,:),Resy(i,:)+FyF(i,:),"DisplayName",name_tag,'LineWidth',2)
    hold on
end
yline(0,"DisplayName","Baseline")
hold off
xlim([0 10e-3])
ylim([-10e-3 50e-3])
xlabel("$\theta$ [m]",'Interpreter','latex')
ylabel("$F_v$ [N]",'Interpreter','latex')
lgd = legend('Location','south','Interpreter','latex');
lgd_title=sprintf('v [m/s]')
lgd.Title.String = lgd_title;
lgd.FontSize = 18;
ax1 = gca;
ax1.LineWidth=2;
ax1.FontSize = 20;
ax1.YAxis.Exponent = -3;
ax1.XAxis.Exponent = -3;
axis('square')
f.Position=[200 300 560 500]
AddLetters2Plots({ax1},{'b)'}, 'HShift', 0.06, 'VShift', 0, 'FontSize', 18)
saveas(gcf,'M:\paper_writing\inter_particle_shear\ver_force_vs_disp_simulation.svg')
saveas(gcf,'M:\paper_writing\inter_particle_shear\ver_force_vs_disp_simulation','epsc')

%% minimum cycle length
normalized_x=x_zero./x_geometric;
normalized_vel=v_fact/v_char;
[x_min,x_min_pos]=min(normalized_x);
vel_min_x_norm=normalized_vel(x_min_pos);
% 
% 
