% file_path='M:\indentation_setup\Edu_innov_Hydrogel\';
% file_name='single_particle_contact_minus545mN.csv';
% r_particle=19/(2*1000);
% nu=0.5; %poission's ratio
% window_hist=50;

function structure=process_single_particle_in_medium(file_path,file_name,r_particle,nu,window_hist)

%% import data
structure=import_data_script(file_path,file_name)

%% constant definition
g=9.81; %m/s^2
rho_medium=1000; %kg/m^3
dia_indenter=8/1000; %diameter of indenter in m
buoyancy_factor=rho_medium*g*pi()*((dia_indenter)^2)/4;

%% indentation data process
disp_raw=(structure.indent.position(1)-structure.indent.position)/1000;   %raw displacemnts during indentation in m
time_ind_raw=structure.indent.time-structure.indent.time(1);    %raw recorded times in s
structure.vel_exp=(disp_raw(1)-disp_raw(end))/(time_ind_raw(end)-time_ind_raw(1)); %actual average velocity m/s
F_raw=structure.indent.force/1000; % raw forces in N
F_raw=F_raw-buoyancy_factor*disp_raw;

figure
plot(disp_raw,F_raw)
xlabel('Displacement (m)')
ylabel('Force (N)')


%% baseline search


figure
hist(F_raw,window_hist)

i=1;
j=1;
% for j=1:2
%     for i=1:(count-1)
        [Fbin(i).N,Fbin(i).edges] = histcounts(F_raw,window_hist);
        [mode,I]=max(Fbin(i).N);
        int_start_F_raw(i)=Fbin(i).edges(1,I);
        if (I==1)
            int_prev_F_raw(i)=1;
        else
            int_prev_F_raw(i)=Fbin(i).edges(1,I-1);
        end
        int_end_F_raw(i)=Fbin(i).edges(1,I+1);
%     end
% end

F_baseline=int_end_F_raw; %baseline definition

logic=(F_raw>=F_baseline); %logic vector definition
logic_movmean=floor(movmean(logic,[0 window_hist]));

figure
plot((F_raw-F_baseline)/max(F_raw))
hold on
plot(logic)
plot(logic_movmean)
hold off

%% index of data structure at contact
index_contact=find(logic_movmean,1,'first');

%% rescaling forces, displacement anf time at contact to zero
F=F_raw(index_contact:end)-F_raw(index_contact);
disp=disp_raw(index_contact:end)-disp_raw(index_contact);
time=time_ind_raw(index_contact:end)-time_ind_raw(index_contact);

figure
plot(disp,F)

figure
scatter(disp.^(3/2),F)
hold on
fit=polyfit(disp.^(3/2),F,1);

m_slope=(disp.^(3/2))\F;
plot(disp.^(3/2),m_slope*(disp.^(3/2)))
plot(disp.^(3/2),polyval(fit,disp.^(3/2)))
hold off
xlabel('Indentation depth ^( 3/2)')
ylabel('Force (N)')


%E_asterisk=m_slope/((4/3)*(r_particle^0.5));

E_asterisk=fit(1)/((4/3)*(r_particle^0.5));
E_0=E_asterisk*(1-(nu^2));  %elastic modulus
G_0=E_0/(2*(1+nu)); %shear modulus

F_pred=(4/3)*E_asterisk*(r_particle^0.5)*(disp.^1.5);

figure
scatter(disp,F,'DisplayName','Experiment')
hold on
plot(disp,F_pred,'DisplayName','Hertz model fit')
hold on
xlabel('Displacement(m)')
ylabel('Force (N)')

structure.indentfit.G_0=G_0;
structure.indentfit.disp=disp;
structure.indentfit.F=F;
structure.indentfit.error=F-F_pred;
structure.indentfit.error_rms=sum(sqrt(structure.indentfit.error.*structure.indentfit.error));

figure
area(disp,structure.indentfit.error)
xlabel('Displacement (m)')
ylabel('Experimental Forces-Hertz Forces (N)')
title('Residuals from hertz model')

%% relaxation test

%% for 230gm load
disp_relax=disp(end);%constant strain for relaxaxtion test
strain=disp_relax/(2*r_particle);
structure.strain=strain;

F_relax_raw=(structure.relaxation.force/1000)-(buoyancy_factor*disp_relax); %convert force to N
correction_F=F_relax_raw(1)-F(end);
F_relax=F_relax_raw-correction_F;
time_relax=structure.relaxation.time-min(structure.relaxation.time);
G=(F_relax/2)*(3/4)*(1-nu)/((r_particle^0.5)*(disp_relax^1.5));

structure.relaxation.time_relax=time_relax;
structure.relaxation.G=G;
structure.relaxation.F_relax=F_relax;

figure
scatter(time_relax,F_relax)
title('Relaxation')
xlabel('time (s)')
ylabel('Normal Force (N)')

figure
loglog(time_relax,G)
hold on
yline(G_0)
hold off
title('Decay of Shear modulus')
xlabel('time (s)')
ylabel('G')



%% relaxation times

%% single relaxation time
coeff_exp_decay_G=fit_exp_decay(time_relax,G);

structure.tau=1/coeff_exp_decay_G.G(3);
structure.G_e=coeff_exp_decay_G.G(2);
structure.G_l=coeff_exp_decay_G.G(1)-coeff_exp_decay_G.G(2);
structure.G_l_to_G_e=structure.G_l/structure.G_e;
structure.error=coeff_exp_decay_G.correction;
structure.fitted=coeff_exp_decay_G.fitted;




%% double relaxation time
coeff_double_exp_decay_G=fit_double_exp_decay(time_relax,G);
structure.double_exp.tau1=1/coeff_double_exp_decay_G.G(4);
structure.double_exp.tau2=1/coeff_double_exp_decay_G.G(6);
structure.double_exp.G_e=coeff_double_exp_decay_G.G(2);
structure.double_exp.G_l1=coeff_double_exp_decay_G.G(3);
structure.double_exp.G_l2=coeff_double_exp_decay_G.G(5);
structure.double_exp.error=coeff_double_exp_decay_G.correction;
structure.double_exp.fitted=coeff_double_exp_decay_G.fitted;


%% double relaxation time lsq

coeff_double_exp_decay_G_lsq=fit_double_exp_decay_lsq(time_relax,G);
structure.double_exp_lsq.tau1=1/coeff_double_exp_decay_G_lsq.G(4);
structure.double_exp_lsq.tau2=1/coeff_double_exp_decay_G_lsq.G(6);
structure.double_exp_lsq.G_e=coeff_double_exp_decay_G_lsq.G(2);
structure.double_exp_lsq.G_l1=coeff_double_exp_decay_G_lsq.G(3);
structure.double_exp_lsq.G_l2=coeff_double_exp_decay_G_lsq.G(5);
structure.double_exp_lsq.error=coeff_double_exp_decay_G_lsq.correction;
structure.double_exp_lsq.fitted=coeff_double_exp_decay_G_lsq.fitted;

%% double relaxation time lsq smoothened

coeff_double_exp_decay_G_lsq_smooth=fit_double_exp_decay_lsq(time_relax,smooth(G,5));
structure.double_exp_lsq_smooth.tau1=1/coeff_double_exp_decay_G_lsq_smooth.G(4);
structure.double_exp_lsq_smooth.tau2=1/coeff_double_exp_decay_G_lsq_smooth.G(6);
structure.double_exp_lsq_smooth.G_e=coeff_double_exp_decay_G_lsq_smooth.G(2);
structure.double_exp_lsq_smooth.G_l1=coeff_double_exp_decay_G_lsq_smooth.G(3);
structure.double_exp_lsq_smooth.G_l2=coeff_double_exp_decay_G_lsq_smooth.G(5);
structure.double_exp_lsq_smooth.error=coeff_double_exp_decay_G_lsq_smooth.correction;
structure.double_exp_lsq_smooth.fitted=coeff_double_exp_decay_G_lsq_smooth.fitted;


end
