clear all
close all

nu=0.5; %poission's ratio
window_hist=60;


%% hydrogel indentation data

file_path='M:\indentation_setup\Edu_innov_Hydrogel\';

% single particle confined tests

file_name='single_particle_contact_minus545mN.csv';
Hydrogel.r_particle=19/(2*1000);
Hydrogel.stress(1).confined=process_single_particle_in_medium(file_path,file_name,Hydrogel.r_particle,nu,window_hist);

file_name='single_particle_contact_minus300mN.csv';
Hydrogel.r_particle=19/(2*1000);
Hydrogel.stress(2).confined=process_single_particle_in_medium(file_path,file_name,Hydrogel.r_particle,nu,window_hist);

file_name='single_particle_contact_0mN.csv';
Hydrogel.r_particle=19/(2*1000);
Hydrogel.stress(3).confined=process_single_particle_in_medium(file_path,file_name,Hydrogel.r_particle,nu,window_hist);

for i=1:3
    strain_sing(i)=Hydrogel.stress(i).confined.strain;
    G_e_sing(i)=Hydrogel.stress(i).confined.double_exp_lsq.G_e;
    if Hydrogel.stress(i).confined.double_exp_lsq.tau1<=Hydrogel.stress(i).confined.double_exp_lsq.tau2
        G_l1_sing(i)=Hydrogel.stress(i).confined.double_exp_lsq.G_l1;
        tau_1_sing(i)=Hydrogel.stress(i).confined.double_exp_lsq.tau1;
        G_l2_sing(i)=Hydrogel.stress(i).confined.double_exp_lsq.G_l2;
        tau_2_sing(i)=Hydrogel.stress(i).confined.double_exp_lsq.tau2;
    else
        G_l1_sing(i)=Hydrogel.stress(i).confined.double_exp_lsq.G_l2;
        tau_1_sing(i)=Hydrogel.stress(i).confined.double_exp_lsq.tau2;
        G_l2_sing(i)=Hydrogel.stress(i).confined.double_exp_lsq.G_l1;
        tau_2_sing(i)=Hydrogel.stress(i).confined.double_exp_lsq.tau1;
    end
end


for i=1:3
    strain_sing(i)=Hydrogel.stress(i).confined.strain;
    G_e_sing_smooth(i)=Hydrogel.stress(i).confined.double_exp_lsq_smooth.G_e;
    if Hydrogel.stress(i).confined.double_exp_lsq_smooth.tau1<=Hydrogel.stress(i).confined.double_exp_lsq_smooth.tau2
        G_l1_sing_smooth(i)=Hydrogel.stress(i).confined.double_exp_lsq_smooth.G_l1;
        tau_1_sing_smooth(i)=Hydrogel.stress(i).confined.double_exp_lsq_smooth.tau1;
        G_l2_sing_smooth(i)=Hydrogel.stress(i).confined.double_exp_lsq_smooth.G_l2;
        tau_2_sing_smooth(i)=Hydrogel.stress(i).confined.double_exp_lsq_smooth.tau2;
    else
        G_l1_sing_smooth(i)=Hydrogel.stress(i).confined.double_exp_lsq_smooth.G_l2;
        tau_1_sing_smooth(i)=Hydrogel.stress(i).confined.double_exp_lsq_smooth.tau2;
        G_l2_sing_smooth(i)=Hydrogel.stress(i).confined.double_exp_lsq_smooth.G_l1;
        tau_2_sing_smooth(i)=Hydrogel.stress(i).confined.double_exp_lsq_smooth.tau1;
    end
end

close all

%% 2 particle indentation tests

nu=0.5; %poission's ratio
rho_medium=1000; %kg/m^3

file_name='Particle_particle_contact_minus615mN.csv';
Hydrogel_2particle.r1=19/(2*1000);
Hydrogel_2particle.r2=19/(2*1000);
Hydrogel_2particle.stress(1).confined=process_2particle(file_path,file_name,Hydrogel_2particle.r1,Hydrogel_2particle.r2,nu,window_hist,rho_medium)

file_name='Particle_particle_contact_minus600mN.csv';
Hydrogel_2particle.r1=19/(2*1000);
Hydrogel_2particle.r2=19/(2*1000);
Hydrogel_2particle.stress(2).confined=process_2particle(file_path,file_name,Hydrogel_2particle.r1,Hydrogel_2particle.r2,nu,window_hist,rho_medium)

file_name='Particle_particle_contact_minus300mN.csv';
Hydrogel_2particle.r1=19/(2*1000);
Hydrogel_2particle.r2=19/(2*1000);
Hydrogel_2particle.stress(3).confined=process_2particle(file_path,file_name,Hydrogel_2particle.r1,Hydrogel_2particle.r2,nu,window_hist,rho_medium)

file_name='Particle_particle_contact_0mN.csv';
Hydrogel_2particle.r1=19/(2*1000);
Hydrogel_2particle.r2=19/(2*1000);
Hydrogel_2particle.stress(4).confined=process_2particle(file_path,file_name,Hydrogel_2particle.r1,Hydrogel_2particle.r2,nu,window_hist,rho_medium)

for i=1:4
    strain_particle(i)=Hydrogel_2particle.stress(i).confined.strain;
    G_e_2particle(i)=Hydrogel_2particle.stress(i).confined.double_exp_lsq.G_e;
    if Hydrogel_2particle.stress(i).confined.double_exp_lsq.tau1<=Hydrogel_2particle.stress(i).confined.double_exp_lsq.tau2
        G_l1_2particle(i)=Hydrogel_2particle.stress(i).confined.double_exp_lsq.G_l1;
        tau_1_2particle(i)=Hydrogel_2particle.stress(i).confined.double_exp_lsq.tau1;
        G_l2_2particle(i)=Hydrogel_2particle.stress(i).confined.double_exp_lsq.G_l2;
        tau_2_2particle(i)=Hydrogel_2particle.stress(i).confined.double_exp_lsq.tau2;
    else
        G_l1_2particle(i)=Hydrogel_2particle.stress(i).confined.double_exp_lsq.G_l2;
        tau_1_2particle(i)=Hydrogel_2particle.stress(i).confined.double_exp_lsq.tau2;
        G_l2_2particle(i)=Hydrogel_2particle.stress(i).confined.double_exp_lsq.G_l1;
        tau_2_2particle(i)=Hydrogel_2particle.stress(i).confined.double_exp_lsq.tau1;
    end
end


for i=1:4
    strain_2particle(i)=Hydrogel_2particle.stress(i).confined.strain;
    G_e_2particle_smooth(i)=Hydrogel_2particle.stress(i).confined.double_exp_lsq_smooth.G_e;
    if Hydrogel_2particle.stress(i).confined.double_exp_lsq_smooth.tau1<=Hydrogel_2particle.stress(i).confined.double_exp_lsq_smooth.tau2
        G_l1_2particle_smooth(i)=Hydrogel_2particle.stress(i).confined.double_exp_lsq_smooth.G_l1;
        tau_1_2particle_smooth(i)=Hydrogel_2particle.stress(i).confined.double_exp_lsq_smooth.tau1;
        G_l2_2particle_smooth(i)=Hydrogel_2particle.stress(i).confined.double_exp_lsq_smooth.G_l2;
        tau_2_2particle_smooth(i)=Hydrogel_2particle.stress(i).confined.double_exp_lsq_smooth.tau2;
    else
        G_l1_2particle_smooth(i)=Hydrogel_2particle.stress(i).confined.double_exp_lsq_smooth.G_l2;
        tau_1_2particle_smooth(i)=Hydrogel_2particle.stress(i).confined.double_exp_lsq_smooth.tau2;
        G_l2_2particle_smooth(i)=Hydrogel_2particle.stress(i).confined.double_exp_lsq_smooth.G_l1;
        tau_2_2particle_smooth(i)=Hydrogel_2particle.stress(i).confined.double_exp_lsq_smooth.tau1;
    end
end
close all

%% smoothened data

figure
subplot(3,2,1)
plot(strain_sing,G_e_sing_smooth,'DisplayName','Single particle')
hold on
plot(strain_2particle,G_e_2particle_smooth,'DisplayName','Two particle')
hold off
xlabel('Strain')
ylabel('G_e(Pa)')

subplot(3,2,3)
plot(strain_sing,G_l1_sing_smooth,'DisplayName','Single particle')
hold on
plot(strain_2particle,G_l1_2particle_smooth,'DisplayName','Two particle')
hold off
xlabel('Strain')
ylabel('G_{l1}(Pa)')

subplot(3,2,4)
plot(strain_sing,tau_1_sing_smooth,'DisplayName','Single particle')
hold on
plot(strain_2particle,tau_1_2particle_smooth,'DisplayName','Two particle')
hold off
xlabel('Strain')
ylabel('\tau_1(Pa)')

subplot(3,2,5)
plot(strain_sing,G_l2_sing_smooth,'DisplayName','Single particle')
hold on
plot(strain_2particle,G_l2_2particle_smooth,'DisplayName','Two particle')
hold off
xlabel('Strain')
ylabel('G_{l2}(Pa)')

subplot(3,2,6)
plot(strain_sing,tau_2_sing_smooth,'DisplayName','Single particle')
hold on
plot(strain_2particle,tau_2_2particle_smooth,'DisplayName','Two particle')
hold off
xlabel('Strain')
ylabel('\tau_2(Pa)')


%% unsmoothened data
figure
subplot(3,2,1)
plot(strain_sing,G_e_sing,'DisplayName','Single particle')
hold on
plot(strain_2particle,G_e_2particle,'DisplayName','Two particle')
hold off
xlabel('Strain')
ylabel('G_e(Pa)')

subplot(3,2,3)
plot(strain_sing,G_l1_sing,'DisplayName','Single particle')
hold on
plot(strain_2particle,G_l1_2particle,'DisplayName','Two particle')
hold off
xlabel('Strain')
ylabel('G_{l1}(Pa)')

subplot(3,2,4)
plot(strain_sing,tau_1_sing,'DisplayName','Single particle')
hold on
plot(strain_2particle,tau_1_2particle,'DisplayName','Two particle')
hold off
xlabel('Strain')
ylabel('\tau_1(Pa)')

subplot(3,2,5)
plot(strain_sing,G_l2_sing,'DisplayName','Single particle')
hold on
plot(strain_2particle,G_l2_2particle,'DisplayName','Two particle')
hold off
xlabel('Strain')
ylabel('G_{l2}(Pa)')

subplot(3,2,6)
plot(strain_sing,tau_2_sing,'DisplayName','Single particle')
hold on
plot(strain_2particle,tau_2_2particle,'DisplayName','Two particle')
hold off
xlabel('Strain')
ylabel('\tau_2(Pa)')

%% residual summary

%% single particle
figure
for i=1:3
subplot(3,3,i*3-2) 
    scatter(Hydrogel.stress(i).confined.relaxation.time_relax,Hydrogel.stress(i).confined.relaxation.G)
    hold on
    plot(Hydrogel.stress(i).confined.relaxation.time_relax,Hydrogel.stress(i).confined.double_exp_lsq.fitted)
    hold on
    plot(Hydrogel.stress(i).confined.relaxation.time_relax,Hydrogel.stress(i).confined.double_exp_lsq_smooth.fitted)
    hold off
    ylabel('G(t) (Pa)')
    xlabel('time(s)')
    title('raw fits')
subplot(3,3,i*3-1) 
    area(Hydrogel.stress(i).confined.relaxation.time_relax,Hydrogel.stress(i).confined.error.residual)
    ylabel('G(t)- Gpredicted(t) (Pa)')
    xlabel('time(s)')
    title('residuals single exponent')
subplot(3,3,i*3) 

    area(Hydrogel.stress(i).confined.relaxation.time_relax,Hydrogel.stress(i).confined.double_exp_lsq.error.residual)
    hold on
    area(Hydrogel.stress(i).confined.relaxation.time_relax,Hydrogel.stress(i).confined.double_exp_lsq_smooth.error.residual)
    hold off
    ylabel('G(t)- Gpredicted(t) (Pa)')
    xlabel('time(s)')
    title('residuals double exponent')    
end
suptitle('Fitting Summary for 1 particle indentation')


%% 2 particles
figure
for i=1:4
subplot(4,3,i*3-2) 
    scatter(Hydrogel_2particle.stress(i).confined.relaxation.time_relax,Hydrogel_2particle.stress(i).confined.relaxation.G)
    hold on
    plot(Hydrogel_2particle.stress(i).confined.relaxation.time_relax,Hydrogel_2particle.stress(i).confined.double_exp_lsq.fitted)
    hold on
    plot(Hydrogel_2particle.stress(i).confined.relaxation.time_relax,Hydrogel_2particle.stress(i).confined.double_exp_lsq_smooth.fitted)
    hold off
    ylabel('G(t) (Pa)')
    xlabel('time(s)')
    title('raw fits')
subplot(4,3,i*3-1) 
    area(Hydrogel_2particle.stress(i).confined.relaxation.time_relax,Hydrogel_2particle.stress(i).confined.error.residual)
    ylabel('G(t)- Gpredicted(t) (Pa)')
    xlabel('time(s)')
    title('residuals single exponent')
subplot(4,3,i*3) 

    area(Hydrogel_2particle.stress(i).confined.relaxation.time_relax,Hydrogel_2particle.stress(i).confined.double_exp_lsq.error.residual)
    hold on
    area(Hydrogel_2particle.stress(i).confined.relaxation.time_relax,Hydrogel_2particle.stress(i).confined.double_exp_lsq_smooth.error.residual)
    hold off
    ylabel('G(t)- Gpredicted(t) (Pa)')
    xlabel('time(s)')
    title('residuals double exponent')    
end
suptitle('Fitting Summary for 2 particle indentation')
close all

%% plots for paper
% figure 2b)
f=figure
sz=3*ones(size(Hydrogel.stress(2).confined.indentfit.F));
scatter(Hydrogel.stress(2).confined.indentfit.disp,Hydrogel.stress(2).confined.indentfit.F)
clear sz
xlabel('$\delta [m]$','Interpreter','latex')
ylabel('$F_v [N]$','Interpreter','latex')
box on
ax = gca;
ax.LineWidth=2;
ax.FontSize = 25;
ax.YAxis.Exponent = 0;
ax.XAxis.Exponent = 0;
axis('square')
f.Position=[200 300 560 500]
saveas(gcf,'M:\paper_writing\inter_particle_shear\force_vs_disp_indent.svg')

% figure 2c)
f=figure
sz=3*ones(size(Hydrogel.stress(2).confined.relaxation.F_relax));
scatter(Hydrogel.stress(2).confined.relaxation.time,Hydrogel.stress(2).confined.relaxation.F_relax,sz)
xlabel('$t [s]$','Interpreter','latex')
ylabel('$F_v [N]$','Interpreter','latex')
box on
ax = gca;
ax.LineWidth=2;
ax.FontSize = 25;
ax.YAxis.Exponent = 0;
ax.XAxis.Exponent = 0;
axis('square')
f.Position=[200 300 560 500]
saveas(gcf,'M:\paper_writing\inter_particle_shear\force_vs_time_indent.svg')


