%% Import data from text file
% Script for importing data from the following text file:
%
%    filename: M:\indentation_setup\PDMS\PDMS_5_to_1_dia8_75mm.csv
%
% Auto-generated by MATLAB on 28-Jul-2022 16:14:04

function structure=import_data_script(file_path,file_name)
file_loc=strcat(file_path,file_name);
cols_to_import = 5;


%% numeric import
%% Setup the Import Options and import the data
opts = delimitedTextImportOptions("NumVariables", cols_to_import);

% Specify range and delimiter
opts.DataLines = [4, Inf];
opts.Delimiter = ",";

% Specify column names and types
opts.VariableNames = ["No", "Time", "StagePosition", "Mass", "Force"];
opts.VariableTypes = ["double", "double", "double", "double", "double"];

% Specify file level properties
opts.ExtraColumnsRule = "ignore";
opts.EmptyLineRule = "read";

% Import the data
data_numeric = readtable(file_loc, opts);


%% Clear temporary variables
clear opts

%% string import
opts = delimitedTextImportOptions("NumVariables", cols_to_import);

% Specify range and delimiter
opts.DataLines = [4, Inf];
opts.Delimiter = ",";

% Specify column names and types
opts.VariableNames = ["No", "Time", "StagePosition", "Mass", "Force"];
opts.VariableTypes = ["string", "string", "string", "string", "string"];

% Specify file level properties
opts.ExtraColumnsRule = "ignore";
opts.EmptyLineRule = "read";

% Import the data
data_string = readtable(file_loc, opts);


%% Clear temporary variables
clear opts


%% storedata to variables
linenos_start_reference=find(data_string.No=="No"); %find sting "No"
indent_interval=(linenos_start_reference(1)+3):(linenos_start_reference(2)-4);
end_point=length(data_string.No);
relax_interval=(linenos_start_reference(2)+3):end_point;

structure.indent.No=data_numeric.No(indent_interval); %serial number
structure.indent.time=data_numeric.Time(indent_interval); %time in seconds
structure.indent.position=data_numeric.StagePosition(indent_interval);  %position in mm
structure.indent.mass=data_numeric.Mass(indent_interval); %mass in grams
structure.indent.force=data_numeric.Force(indent_interval); %Force in mN

structure.relaxation.No=data_numeric.No(relax_interval); %serial number
structure.relaxation.time=data_numeric.Time(relax_interval); %time in seconds
structure.relaxation.position=data_numeric.StagePosition(relax_interval);  %position in mm
structure.relaxation.mass=data_numeric.Mass(relax_interval); %mass in grams
structure.relaxation.force=data_numeric.Force(relax_interval); %Force in mN

end
