clear all
close all

file_path='C:\Users\shaky006\OneDrive - Wageningen University & Research\Rheometer\MCR 501\particle_particle_shear_data\Chandan-Particle_particle_shear_constant_w_mulitiple_level_06_01_2022\';

%Test 1
upper_particle_setup_dim=29.53/1000;
lower_particle_setup_dim=31.25/1000;
particle_dia_upper_para=18.16/1000;
particle_dia_upper_perp=18.55/1000;
particle_dia_lower_para=18.79/1000;
particle_dia_lower_perp=19.32/1000;
moment_arm=27/1000;

%upper particle
r_upper_mid=(particle_dia_upper_para+particle_dia_upper_perp)/2;
r_lower_mid=(particle_dia_lower_para+particle_dia_lower_perp)/2;
%650ml of milliQ water as medium

%% gap_1 %rep1
gap_no=1;
rep_no=1;
file_name='Test_59_9.txt';
file_loc=strcat(file_path,file_name);
cols_to_import=12;
Samplegap(gap_no).rep(rep_no).data=data_import(file_loc,cols_to_import);

% figure
% F_tan=(Samplegap(gap_no).rep(rep_no).data(3).torque/moment_arm)/1000; %tangentaial force in N
% F_norm=Samplegap(gap_no).rep(rep_no).data(3).normal_force;
% def_ang=Samplegap(gap_no).rep(rep_no).data(3).defangle;
% overlap_avg=upper_particle_setup_dim+lower_particle_setup_dim-(mean(Samplegap(gap_no).rep(rep_no).data(3).gap)/1000);
% plot (def_ang,F_tan,"DisplayName"," Hz. Force")
% hold on
% plot (def_ang,F_norm,"DisplayName"," Ver. Force")
% yline(0)
% hold off
% xlabel("Angular Displacement(mrad)") 
% ylabel("Force (N)")
% legend
% set(gca,'FontSize',17)
% saveas(gcf,'M:\Rheometer\MCR 501\Figures\raw_data.emf')

Samplegap(gap_no).rep(rep_no).processed_data=process(Samplegap(gap_no).rep(rep_no).data,moment_arm,upper_particle_setup_dim,lower_particle_setup_dim,particle_dia_lower_perp,particle_dia_upper_perp);

%% plot
f=figure
sf1=subplot(2,2,1)
for i=1:4
    name_tag=sprintf('%0.2e',Samplegap(1).rep.processed_data.tofit(i, 1).v_hz_mean)
%     name_tag=strcat(num2str(Samplegap(1).rep.processed_data.tofit(i, 1).v_hz_mean))
    plot(Samplegap(1).rep.processed_data.tofit(i, 1).x,Samplegap(1).rep.processed_data.tofit(i, 1).ver,'DisplayName',name_tag)
    hold on
end
yline(0,"DisplayName","Baseline")
hold off
xlabel("$\theta$ [m]",'Interpreter','latex')
ylabel("$F_v$ [N]",'Interpreter','latex')
lgd = legend('Location','south','Interpreter','latex');
lgd_title=sprintf('$v$ [m/s]')
lgd.Title.String = lgd_title;
lgd.FontSize = 10;
ax1 = gca;
ax1.LineWidth=1;
ax1.FontSize = 12;
ax1.YAxis.Exponent = -3;
ax1.XAxis.Exponent = -3;
axis('square')

sf2=subplot(2,2,2)
plot(Samplegap(1).rep.data(3).defangle.*moment_arm/1000,(Samplegap(1).rep.data(3).torque/moment_arm)/1000,'DisplayName','Clockwise')
% hold on
% plot(Samplegap(1).rep.data(5).defangle.*moment_arm/1000,(Samplegap(1).rep.data(5).torque/moment_arm)/1000,'DisplayName','Anti-Clockwise')
% hold off
[ymin,idx_min] = min((Samplegap(1).rep.data(3).torque/moment_arm)/1000) ;
[ymax,idx_max] = max((Samplegap(1).rep.data(3).torque/moment_arm)/1000) ; 
text(Samplegap(1).rep.data(3).defangle(idx_min).*moment_arm/1000,ymin,['t: ' num2str(round(ymin,4))]);
text(Samplegap(1).rep.data(3).defangle(idx_max).*moment_arm/1000,ymax,['p: ' num2str(round(ymax,4))]);
xlim([0.0045 0.0175])
xlabel("$\theta$ [m]",'Interpreter','latex')
ylabel("$F_h$ [N]",'Interpreter','latex')
ax2 = gca;
ax2.LineWidth=1;
ax2.FontSize = 12;
ax2.YAxis.Exponent = -3;
ax2.XAxis.Exponent = -3;
axis('square')


sf3=subplot(2,2,3)
plot(Samplegap(1).rep.data(3).defangle.*moment_arm/1000,(Samplegap(1).rep.data(3).torque/moment_arm)/1000,'DisplayName','C')
hold on
plot(Samplegap(1).rep.data(5).defangle.*moment_arm/1000,(Samplegap(1).rep.data(5).torque/moment_arm)/1000,'DisplayName','AC')
xline(Samplegap(1).rep.data(3).defangle(Samplegap(1).rep.processed_data.filter.lim_start_index(1,1)).*moment_arm/1000,'green','HandleVisibility','off')%'DisplayName',' Contact Clockwise')
xline(Samplegap(1).rep.data(5).defangle(Samplegap(1).rep.processed_data.filter.lim_start_index(1,2)).*moment_arm/1000,'m','HandleVisibility','off')%'DisplayName',' Contact Anti-Clockwise')
xline(mean([Samplegap(1).rep.data(3).defangle(Samplegap(1).rep.processed_data.filter.lim_start_index(1,1)),Samplegap(1).rep.data(5).defangle(Samplegap(1).rep.processed_data.filter.lim_start_index(1,2))]).*moment_arm/1000,'cyan','HandleVisibility','off')%'DisplayName','Mid Point')
yline(0,'HandleVisibility','off')%'DisplayName','Baseline')
hold off
xlim([0.0045 0.0175])
xlabel("$\theta$ [m]",'Interpreter','latex')
ylabel("$F_h$ [N]",'Interpreter','latex')
lgd = legend('Location','southwest');
lgd_title=sprintf('Dir')
lgd.Title.String = lgd_title;
lgd.FontSize = 10;
ax3 = gca;
ax3.LineWidth=1;
ax3.FontSize = 12;
ax3.YAxis.Exponent = -3;
ax3.XAxis.Exponent = -3;
axis('square')
axes('position',[.32 .33 .1 .1])
box on % put box around new pair of axes
plot(Samplegap(1).rep.data(3).defangle.*moment_arm/1000,(Samplegap(1).rep.data(3).torque/moment_arm)/1000,'DisplayName','C')
hold on
plot(Samplegap(1).rep.data(5).defangle.*moment_arm/1000,(Samplegap(1).rep.data(5).torque/moment_arm)/1000,'DisplayName','AC')
xline(mean([Samplegap(1).rep.data(3).defangle(Samplegap(1).rep.processed_data.filter.lim_start_index(1,1)),Samplegap(1).rep.data(5).defangle(Samplegap(1).rep.processed_data.filter.lim_start_index(1,2))]).*moment_arm/1000,'cyan','HandleVisibility','off')%'DisplayName','Mid Point')
yline(0,'HandleVisibility','off')%'DisplayName','Baseline')
hold off
ylim([-0.0003509122479578407 0.0003752653418182289])
xlim([0.010428698412224 0.010999628833344])
hold off
ax4 = gca;
ax4.LineWidth=1;
ax4.FontSize = 8;
ax4.YAxis.Exponent = -3;
ax4.XAxis.Exponent = -3;

sf4=subplot(2,2,4)
for i=1:4
    name_tag=sprintf('%0.2e',Samplegap(1).rep.processed_data.tofit(i, 1).v_hz_mean)
%     name_tag=strcat(num2str(Samplegap(1).rep.processed_data.tofit(i, 1).v_hz_mean))
    plot(Samplegap(1).rep.processed_data.tofit(i, 1).x,Samplegap(1).rep.processed_data.tofit(i, 1).F_hz,'DisplayName',name_tag)
    hold on
end
yline(0,"DisplayName","Baseline")
hold off
xlabel("$\theta$ [m]",'Interpreter','latex')
ylabel("$F_h$ [N]",'Interpreter','latex')
lgd = legend('Location','southwest','Interpreter','latex');
lgd_title=sprintf('$v$ [m/s]')
lgd.Title.String = lgd_title;
lgd.FontSize = 10;
ax5 = gca;
ax5.LineWidth=1;
ax5.FontSize = 12;
ax5.YAxis.Exponent = -3;
ax5.XAxis.Exponent = -3;
axis('square')

f.Position=[200 300 800 700]

AddLetters2Plots({ax1, ax2, ax3, ax5},{'a)', 'b)', 'c)', 'd)'}, 'HShift', [0.03, 0.03, 0.03, 0.03], 'VShift', 0)
saveas(gcf,'M:\paper_writing\inter_particle_shear\exp_results_matlab.svg')
saveas(gcf,'M:\paper_writing\inter_particle_shear\exp_results_matlab.eps','epsc')

%% vertical forces for paper
f=figure
for i=1:4
    name_tag=sprintf('%0.2e',Samplegap(1).rep.processed_data.tofit(i, 1).v_hz_mean)
%     name_tag=strcat(num2str(Samplegap(1).rep.processed_data.tofit(i, 1).v_hz_mean))
    plot(Samplegap(1).rep.processed_data.tofit(i, 1).x,Samplegap(1).rep.processed_data.tofit(i, 1).ver,'DisplayName',name_tag)
    hold on
end
yline(0,"DisplayName","Baseline")
hold off
xlim([0 10e-3])
ylim([-10e-3 50e-3])
xlabel("$\theta$ [m]",'Interpreter','latex')
ylabel("$F_v$ [N]",'Interpreter','latex')
lgd = legend('Location','south','Interpreter','latex');
lgd_title=sprintf('v [m/s]')
lgd.Title.String = lgd_title;
lgd.FontSize = 18;
ax1 = gca;
ax1.LineWidth=2;
ax1.FontSize = 20;
ax1.YAxis.Exponent = -3;
ax1.XAxis.Exponent = -3;
axis('square')
f.Position=[200 300 560 500]
AddLetters2Plots({ax1},{'a)'}, 'HShift', 0.06, 'VShift', 0, 'FontSize', 18)
saveas(gcf,'M:\paper_writing\inter_particle_shear\ver_force_vs_disp.svg')
saveas(gcf,'M:\paper_writing\inter_particle_shear\ver_force_vs_disp','epsc')
saveas(gcf,'M:\paper_writing\inter_particle_shear\ver_force_vs_disp.emf')



%% horizontal forces for paper
f=figure
plot(Samplegap(1).rep.data(3).defangle.*moment_arm/1000,(Samplegap(1).rep.data(3).torque/moment_arm)/1000,'DisplayName','Clockwise')
% hold on
% plot(Samplegap(1).rep.data(5).defangle.*moment_arm/1000,(Samplegap(1).rep.data(5).torque/moment_arm)/1000,'DisplayName','Anti-Clockwise')
% hold off
[ymin,idx_min] = min((Samplegap(1).rep.data(3).torque/moment_arm)/1000) ;
[ymax,idx_max] = max((Samplegap(1).rep.data(3).torque/moment_arm)/1000) ; 
text(Samplegap(1).rep.data(3).defangle(idx_min).*moment_arm/1000,ymin,['t: ' num2str(round(ymin,4))],'FontSize',18);
text(Samplegap(1).rep.data(3).defangle(idx_max).*moment_arm/1000,ymax,['p: ' num2str(round(ymax,4))],'FontSize',18);
xlim([0.0045 0.0175])
ylim([-0.0043 0.0043])
xlabel("$\theta$ [m]",'Interpreter','latex')
ylabel("$F_h$ [N]",'Interpreter','latex')
ax2 = gca;
ax2.LineWidth=2;
ax2.FontSize = 20;
ax2.YAxis.Exponent = -3;
ax2.XAxis.Exponent = -3;
axis('square')
f.Position=[200 300 560 500]
AddLetters2Plots({ax2},{'a)'}, 'HShift', 0.06, 'VShift', 0, 'FontSize', 18)
saveas(gcf,'M:\paper_writing\inter_particle_shear\hz_force_vs_disp_ampdiff.svg')
% saveas(gcf,'M:\paper_writing\inter_particle_shear\hz_force_vs_disp_ampdiff','epsc')
% % eps file conversion after inkscape edit

%% contact lengths
f=figure
scatter(mean(abs(Samplegap(1).rep.processed_data.v_hz_mean),2),Samplegap(1).rep.processed_data.contact_def_len(:,1)*1000,80,'filled','DisplayName','$l_c$ C')
hold on
scatter(mean(abs(Samplegap(1).rep.processed_data.v_hz_mean),2),Samplegap(1).rep.processed_data.contact_def_len(:,2)*1000,80,'filled','DisplayName','$l_c$ AC')
scatter(mean(abs(Samplegap(1).rep.processed_data.v_hz_mean),2),Samplegap(1).rep.processed_data.lin_disp_m*1000,80,'d','filled','DisplayName','$l_g$')
hold off
xlabel("$v$ [m/s]",'Interpreter','latex')
ylabel("$l$ [mm]",'Interpreter','latex')
lgd = legend('Location','southeast');
set(lgd, 'Interpreter','latex')
lgd.FontSize = 18;
ax1 = gca;
ax1.LineWidth=2;
ax1.FontSize = 20;
% ax1.YAxis.Exponent = -3;
ax1.XAxis.Exponent = -3;
axis('square')
box on
f.Position=[200 300 560 500];
% AddLetters2Plots({ax1},{'b)'}, 'HShift', 0.06, 'VShift', 0.1, 'FontSize', 18)
saveas(gcf,'M:\paper_writing\inter_particle_shear\contact_length_v_vel.svg')
saveas(gcf,'M:\paper_writing\inter_particle_shear\contact_length_v_vel','epsc')
saveas(gcf,'M:\paper_writing\inter_particle_shear\contact_length_v_vel.emf')
%% different velocities
f=figure
for i=1:4
    name_tag=sprintf('%0.2e',Samplegap(1).rep.processed_data.tofit(i, 1).v_hz_mean)
%     name_tag=strcat(num2str(Samplegap(1).rep.processed_data.tofit(i, 1).v_hz_mean))
    plot(Samplegap(1).rep.processed_data.tofit(i, 1).x,Samplegap(1).rep.processed_data.tofit(i, 1).F_hz,'DisplayName',name_tag)
    hold on
end
yline(0,"DisplayName","Baseline")
rectangle('Position', [9.1e-3, -0.2e-3, 0.4e-3, 0.4e-3], 'EdgeColor', 'g');
hold off
xlabel("$\theta$ [m]",'Interpreter','latex')
ylabel("$F_h$ [N]",'Interpreter','latex')
lgd = legend('Location','southwest','Interpreter','latex');
lgd_title=sprintf('$v$ [m/s]')
lgd.Title.String = lgd_title;
lgd.FontSize = 18;
ax1 = gca;
ax1.LineWidth=2;
ax1.FontSize =20;
ax1.YAxis.Exponent = -3;
ax1.XAxis.Exponent = -3;
axis('square')
axes('position',[.6 .66 .2 .2])
box on % put box around new pair of axes
for i=1:4
    name_tag=sprintf('%0.2e',Samplegap(1).rep.processed_data.tofit(i, 1).v_hz_mean)
%     name_tag=strcat(num2str(Samplegap(1).rep.processed_data.tofit(i, 1).v_hz_mean))
    plot(Samplegap(1).rep.processed_data.tofit(i, 1).x,Samplegap(1).rep.processed_data.tofit(i, 1).F_hz,'DisplayName',name_tag)
    hold on
end
yline(0,'HandleVisibility','off')%'DisplayName','Baseline')
hold off
ylim([-0.2e-3 0.2e-3])
xlim([9.1e-3 9.5e-3])
hold off
ax4 = gca;
ax4.LineWidth=1;
ax4.FontSize = 14;
ax4.YAxis.Exponent = -3;
ax4.XAxis.Exponent = -3;
f.Position=[200 300 560 500];
AddLetters2Plots({ax1},{'a)'}, 'HShift', 0.06, 'VShift', 0, 'FontSize', 18)
saveas(gcf,'M:\paper_writing\inter_particle_shear\hz_force_diff_vel.svg')
saveas(gcf,'M:\paper_writing\inter_particle_shear\hz_force_diff_vel','epsc')
saveas(gcf,'M:\paper_writing\inter_particle_shear\hz_force_diff_vel.emf')

%% contact lengths both directions
f=figure
plot(Samplegap(1).rep.data(3).defangle.*moment_arm/1000,(Samplegap(1).rep.data(3).torque/moment_arm)/1000,'DisplayName','C')
hold on
plot(Samplegap(1).rep.data(5).defangle.*moment_arm/1000,(Samplegap(1).rep.data(5).torque/moment_arm)/1000,'DisplayName','AC')
% xline(Samplegap(1).rep.data(3).defangle(Samplegap(1).rep.processed_data.filter.lim_start_index(1,1)).*moment_arm/1000,'green','HandleVisibility','off')%'DisplayName',' Contact Clockwise')
% xline(Samplegap(1).rep.data(5).defangle(Samplegap(1).rep.processed_data.filter.lim_start_index(1,2)).*moment_arm/1000,'m','HandleVisibility','off')%'DisplayName',' Contact Anti-Clockwise')
xline(mean([Samplegap(1).rep.data(3).defangle(Samplegap(1).rep.processed_data.filter.lim_start_index(1,1)),Samplegap(1).rep.data(5).defangle(Samplegap(1).rep.processed_data.filter.lim_start_index(1,2))]).*moment_arm/1000,'black','HandleVisibility','off')%'DisplayName','Mid Point')
yline(0,'HandleVisibility','off')%'DisplayName','Baseline')
rectangle('Position', [0.010428698412224, -0.0003509122479578407, 0.010999628833344-0.010428698412224, 0.0003752653418182289-(-0.0003509122479578407)], 'EdgeColor', 'g');
hold off
xlim([0.0045 0.0175])
xlabel("$\theta$ [m]",'Interpreter','latex')
ylabel("$F_h$ [N]",'Interpreter','latex')
lgd = legend('Location','southwest');
lgd_title=sprintf('Dir')
lgd.Title.String = lgd_title;
lgd.FontSize = 18;
ax3 = gca;
ax3.LineWidth=2;
ax3.FontSize = 20;
ax3.YAxis.Exponent = -3;
ax3.XAxis.Exponent = -3;
axis('square')
axes('position',[.6 .66 .2 .2])
box on % put box around new pair of axes
plot(Samplegap(1).rep.data(3).defangle.*moment_arm/1000,(Samplegap(1).rep.data(3).torque/moment_arm)/1000,'DisplayName','C')
hold on
plot(Samplegap(1).rep.data(5).defangle.*moment_arm/1000,(Samplegap(1).rep.data(5).torque/moment_arm)/1000,'DisplayName','AC')
xline(mean([Samplegap(1).rep.data(3).defangle(Samplegap(1).rep.processed_data.filter.lim_start_index(1,1)),Samplegap(1).rep.data(5).defangle(Samplegap(1).rep.processed_data.filter.lim_start_index(1,2))]).*moment_arm/1000,'black','HandleVisibility','off')%'DisplayName','Mid Point')
yline(0,'HandleVisibility','off')%'DisplayName','Baseline')
hold off
ylim([-0.0003509122479578407 0.0003752653418182289])
xlim([0.010428698412224 0.010999628833344])
hold off
ax4 = gca;
ax4.LineWidth=1;
ax4.FontSize = 14;
ax4.YAxis.Exponent = -3;
ax4.XAxis.Exponent = -3;
f.Position=[200 300 560 500]
AddLetters2Plots({ax3},{'b)'}, 'HShift', 0.06, 'VShift', 0, 'FontSize', 18)
saveas(gcf,'M:\paper_writing\inter_particle_shear\hz_force_vs_disp_diff_direction.svg')
saveas(gcf,'M:\paper_writing\inter_particle_shear\hz_force_vs_disp_diff_direction','epsc')


%% 
figure
plot(Samplegap(1).rep.data(3).defangle.*moment_arm/1000,(Samplegap(1).rep.data(3).torque/moment_arm)/1000,'DisplayName','Clockwise')
hold on
% plot(Samplegap.rep.data(5).defangle.*moment_arm/1000,(Samplegap.rep.data(5).torque/moment_arm)/1000,'DisplayName','Anti-Clockwise')
xline(Samplegap(1).rep.data(3).defangle(Samplegap(1).rep.processed_data.filter.lim_start_index(1,1)).*moment_arm/1000,'green','DisplayName',' Contact Clockwise')
xline(Samplegap(1).rep.data(3).defangle(Samplegap(1).rep.processed_data.filter.lim_stop_index(1,1)).*moment_arm/1000,'m','DisplayName',' Contact lost')
xline(mean([Samplegap(1).rep.data(3).defangle(Samplegap(1).rep.processed_data.filter.lim_start_index(1,1)),Samplegap(1).rep.data(3).defangle(Samplegap(1).rep.processed_data.filter.lim_stop_index(1,1))]).*moment_arm/1000,'cyan','DisplayName','Mid Point')
yline(0,'DisplayName','Baseline')
hold off
xlim([0.0045 0.0175])
xlabel('Displacement(m)')
ylabel('Raw Horizontal Force(N)')
lgd = legend('Location','south');
lgd.Title.String = 'Rotational direction';


figure
plot(Samplegap(1).rep.processed_data.tofit(1, 1).x/(mean([particle_dia_lower_perp particle_dia_upper_perp])/2),Samplegap(1).rep.processed_data.tofit(1, 1).F_hz/Samplegap(1).rep.processed_data.overlap(1,1))
hold on
xline((Samplegap(1).rep.processed_data.lin_disp_m(1)/2)/(mean([particle_dia_lower_perp particle_dia_upper_perp])/2))
yline(0)
hold off
xlabel('^{Displacement}/_{Avg. Radius}')
ylabel('^{Horizontal Force(N)}/_{Max. overlap(m)}')


% horizontal force vs displacement
f=figure
plot(Samplegap(1).rep.processed_data.tofit(1, 1).x,Samplegap(1).rep.processed_data.tofit(1, 1).F_hz,'LineWidth',2)
hold on
% xline((Samplegap.rep.processed_data.lin_disp_m(1)/2)/(mean([particle_dia_lower_perp particle_dia_upper_perp])/2))
yline(0)
hold off
box on
xlabel('$\theta$ [m]','Interpreter','latex')
ylabel('$F_h$ [N]','Interpreter','latex')
ax = gca;
ax.LineWidth=2;
ax.FontSize = 25;
ax.YAxis.Exponent = -3;
ax.XAxis.Exponent = -3;
axis('square')
f.Position=[200 300 560 500]
% hFig = figure(1);
% set(gcf,'PaperPosition',[10 10 20 20])
saveas(gcf,'M:\paper_writing\inter_particle_shear\Hz_force_vs_disp.svg')


% vertical force vs displacement
f=figure
plot(Samplegap(1).rep.processed_data.tofit(1, 1).x,Samplegap(1).rep.processed_data.tofit(1, 1).ver,'LineWidth',2)
hold on
% xline(Samplegap.rep.processed_data.lin_disp_m(1)/2)
yline(0)
hold off
box on
xlabel('$\theta$ [m]','Interpreter','latex')
ylabel('$F_v$ [N]','Interpreter','latex')
ax = gca;
ax.LineWidth=2;
ax.FontSize = 25;
ax.YAxis.Exponent = -3;
ax.XAxis.Exponent = -3;
axis('square')
f.Position=[200 300 560 500]
saveas(gcf,'M:\paper_writing\inter_particle_shear\Ver_force_vs_disp.svg')

% comparing hz force signals

figure
vel_mean=mean(abs(Samplegap(1).rep.processed_data.v_hz_mean),2);
seperation_mean=mean(abs(Samplegap(1).rep.processed_data.sep_clock),2);
scatter(vel_mean,seperation_mean,'filled')
xlabel('Rotational velocity(m/s)')
ylabel('Difference detachment and contact(m)')

% change in contact length with velocity
figure
vel_mean=mean(abs(Samplegap(1).rep.processed_data.v_hz_mean),2);
seperation_mean_ratio=mean(abs(Samplegap(1).rep.processed_data.sep_clock),2)./Samplegap(1).rep.processed_data.lin_disp_m;
scatter(vel_mean,seperation_mean,'filled')
xlabel('Rotational velocity(m/s)')
ylabel('Change in contact length(m)/geometric contact length')


figure
scatter(vel_mean,Samplegap(1).rep.processed_data.avg_contact_len'./Samplegap(1).rep.processed_data.lin_disp_m)
xlabel('Rotational velocity(m/s)')
ylabel('$\frac{force contact length}{geometric contact length}$','Interpreter','latex','FontSize',20)

% data export to fit in x/x_e vs v/v_char
lin_disp_m=Samplegap.rep(1).processed_data.lin_disp_m;
save('vel_variables_1.mat','seperation_mean','vel_mean', 'lin_disp_m')

lin_disp_m_array(gap_no,rep_no)=mean(lin_disp_m);
lin_disp_m_array_error(gap_no,rep_no)=max(lin_disp_m)-min(lin_disp_m);



figure
peak_first=mean(Samplegap.rep.processed_data.max_amp,2);
peak_second=abs(mean(Samplegap.rep.processed_data.min_amp,2));
scatter(Samplegap.rep.processed_data.v_hz_mean(:,1),peak_first,'filled','MarkerFaceColor',[0 0.4470 0.7410],'MarkerEdgeColor',[0 0.4470 0.7410],'DisplayName','First Peak')
hold on
scatter(Samplegap.rep.processed_data.v_hz_mean(:,2),peak_second,'filled','MarkerFaceColor',[0.8500 0.3250 0.0980],'MarkerEdgeColor',[0.8500 0.3250 0.0980],'DisplayName','Second Peak')
hold off
xlabel('Rotational velocity(m/s)')
ylabel('Amplitudes(N)')


peak_first=mean(Samplegap(1).rep.processed_data.max_amp,2);
peak_second=(mean(Samplegap(1).rep.processed_data.min_amp,2));
figure
scatter(Samplegap(1).rep.processed_data.v_hz_mean(:,1),peak_first+peak_second,'filled','MarkerFaceColor',[0 0.4470 0.7410],'MarkerEdgeColor',[0 0.4470 0.7410],'DisplayName','First Peak')

xlabel('Rotational velocity(m/s)')
ylabel('Diff. in Amplitudes(N)')


figure
mean_geom_cycle_center=mean(Samplegap(1).rep.processed_data.lin_disp_m)/2;
x_zero_mean=mean(Samplegap(1).rep.processed_data.x_zero_exp,2)
scatter(Samplegap(1).rep.processed_data.v_hz_mean(:,1),abs(mean_geom_cycle_center-x_zero_mean),'filled')%,'MarkerFaceColor',[0 0.4470 0.7410],'MarkerEdgeColor',[0 0.4470 0.7410])

xlabel('Rotational velocity(m/s)')
ylabel('Central Shift(m)')

%% horizontal force signal analysis
figure
peak_first=mean(Samplegap(1).rep.processed_data.max_amp,2);
peak_second=(mean(Samplegap(1).rep.processed_data.min_amp,2));
subplot(1,2,1)
scatter(Samplegap(1).rep.processed_data.v_hz_mean(:,1),peak_first+peak_second,'filled','MarkerFaceColor',[0 0.4470 0.7410],'MarkerEdgeColor',[0 0.4470 0.7410])
xlabel('Rotational velocity(m/s)')
ylabel('Diff. in Amplitudes(N)')

subplot(1,2,2)
scatter(vel_mean,Samplegap(1).rep.processed_data.avg_contact_len'./Samplegap(1).rep.processed_data.lin_disp_m,'filled','MarkerFaceColor',[0 0.4470 0.7410],'MarkerEdgeColor',[0 0.4470 0.7410])
xlabel('Rotational velocity(m/s)')
ylabel('$\frac{force contact length}{geometric contact length}$','Interpreter','latex','FontSize',20)


%% horizontal force signal analysis
figure
peak_first=mean(Samplegap(1).rep.processed_data.max_amp,2);
peak_second=(mean(Samplegap(1).rep.processed_data.min_amp,2));
subplot(1,3,1)
scatter(Samplegap(1).rep.processed_data.v_hz_mean(:,1),peak_first+peak_second,'filled','MarkerFaceColor',[0 0.4470 0.7410],'MarkerEdgeColor',[0 0.4470 0.7410])

xlabel('Rotational velocity(m/s)')
ylabel('Difference in Amplitudes(N)')

subplot(1,3,2)
scatter(vel_mean,Samplegap(1).rep.processed_data.avg_contact_len','filled','MarkerFaceColor',[0 0.4470 0.7410],'MarkerEdgeColor',[0 0.4470 0.7410])
xlabel('Rotational velocity(m/s)')
ylabel('Force contact length (m)')

subplot(1,3,3)
for i=1:1
scatter(Samplegap(i).rep.processed_data.v_hz_mean(:,1),Samplegap(i).rep.processed_data.x_zero_exp(:,1),'filled','MarkerFaceColor',[0 0.4470 0.7410],'MarkerEdgeColor',[0 0.4470 0.7410],'DisplayName','Clockwise');
hold on;
scatter(Samplegap(i).rep.processed_data.v_hz_mean(:,end),Samplegap(i).rep.processed_data.x_zero_exp(:,end),'MarkerEdgeColor',[0 0.4470 0.7410],'DisplayName','Anticlockwise');
end
hold off
xlabel('Rotational velocity(m/s)')
ylabel('Asymmetry in zero crossing (m)')
legend


%% mu vs v
% for j=1:2
%     
%     for i=1:4
%         mu_array(i,j)=Samplegap.rep.processed_data.numeric(i,j).hertz_friction.mu_optim;
%     end
% end
% vel_lin=[1 2 5 10];
% figure
% loglog(vel_lin,mu_array(:,1),'-o')
% hold on
% loglog(vel_lin,mu_array(:,2),'-o')
% hold off

%% hertz fit manual
% x=((Samplegap.rep.data(3).defangle(799:1580)-Samplegap.rep.data(3).defangle(799))/1000)*moment_arm;
% y=-(Samplegap.rep.data(3).torque(799:1580)/1000)/(moment_arm);
% ver=(Samplegap.rep.data(3).normal_force(799:1580))-mean(Samplegap.rep.data(3).normal_force(500:798));
% E=23.0*10^4; % Pa %from elastic_modulus_extraction_21_01_2022
% nu=0.5; %assumed poission's ratio
% mu1=10^-2*1; %coefficient of friction
% mu2=10^-1*0.5; %coefficient of friction
% r2=particle_dia_lower_perp;
% r1=particle_dia_upper_perp; %moving sphere
% overlap_exp=upper_particle_setup_dim+lower_particle_setup_dim-(mean(Samplegap.rep.data(3).gap(799:1580))/1000);
% hertz_fit(x,y,ver,r1,r2,overlap_exp,E,nu,mu1,mu2,Samplegap.rep.processed_data.filter.x_zero_exp(1,1))
% 
% figure
% plot(x,(Samplegap.rep.data(3).gap(799:1580)-Samplegap.rep.data(3).gap(799))/1000)
% 
% figure
% for i=1:4
%     plot(Samplegap(gap_no).rep(rep_no).processed_data.tofit(i, 1).x,Samplegap(gap_no).rep(rep_no).processed_data.numeric(i, 1).hertz_friction.fric.hz_resi,"DisplayName",num2str(i))
% hold on
% end
% yline(0)
% hold off

% %% gap_1 %rep2
% gap_no=1;
% rep_no=2;
% file_name='Test2_59_9.txt';
% file_loc=strcat(file_path,file_name);
% cols_to_import=12;
% Samplegap(gap_no).rep(rep_no).data=data_import(file_loc,cols_to_import);
% 
% figure
% F_tan=(Samplegap(gap_no).rep(rep_no).data(3).torque/moment_arm)/1000; %tangentaial force in N
% F_norm=Samplegap(gap_no).rep(rep_no).data(3).normal_force;
% def_ang=Samplegap(gap_no).rep(rep_no).data(3).defangle;
% overlap_avg=upper_particle_setup_dim+lower_particle_setup_dim-(mean(Samplegap(gap_no).rep(rep_no).data(3).gap)/1000);
% plot (def_ang,F_tan,"DisplayName"," Hz. Force")
% hold on
% plot (def_ang,F_norm,"DisplayName"," Ver. Force")
% yline(0)
% hold off
% xlabel("Angular Displacement(mrad)")
% ylabel("Force (N)")
% legend
% set(gca,'FontSize',17)
% % saveas(gcf,'M:\Rheometer\MCR 501\Figures\raw_data.emf')
% 
% Samplegap(gap_no).rep(rep_no).processed_data=process(Samplegap(gap_no).rep(rep_no).data,moment_arm,upper_particle_setup_dim,lower_particle_setup_dim);
% 

%% for ovelap fit
disp_mean(1)=mean(Samplegap(gap_no).rep.processed_data.lin_disp_m);
gap_mean(1)=mean(Samplegap(gap_no).rep.data(1).gap);

%% gap_2 %rep1
gap_no=2;
rep_no=1;
file_name='Test_59_8.txt';
file_loc=strcat(file_path,file_name);
cols_to_import=12;
Samplegap(gap_no).rep(rep_no).data=data_import(file_loc,cols_to_import);

Samplegap(gap_no).rep(rep_no).processed_data=process(Samplegap(gap_no).rep(rep_no).data,moment_arm,upper_particle_setup_dim,lower_particle_setup_dim,particle_dia_lower_perp,particle_dia_upper_perp);

% 
% figure
% plot(Samplegap(1).rep.processed_data.numeric(1, 1).hertz_friction.exp.mu_exp)
% hold on
% plot(Samplegap(2).rep.processed_data.numeric(1, 1).hertz_friction.exp.mu_exp)
% hold off
% 
% figure
% for i=1:4
%     plot(Samplegap(gap_no).rep(rep_no).processed_data.tofit(i, 1).x,Samplegap(gap_no).rep(rep_no).processed_data.numeric(i, 1).hertz_friction.fric.hz_resi,"DisplayName",num2str(i))
% hold on
% end
% yline(0)
% hold off
figure
vel_mean=mean(abs(Samplegap(gap_no).rep.processed_data.v_hz_mean),2);
seperation_mean=mean(abs(Samplegap(gap_no).rep.processed_data.sep_clock),2);
scatter(vel_mean,seperation_mean,'filled')
xlabel('Rotational velocity(m/s)')
ylabel('Difference detachment and contact(m)')

% data export to fit in x/x_e vs v/v_char
lin_disp_m=Samplegap(gap_no).rep(1).processed_data.lin_disp_m;
save('vel_variables_2.mat','seperation_mean','vel_mean', 'lin_disp_m')
lin_disp_m_array(gap_no,rep_no)=mean(lin_disp_m);
lin_disp_m_array_error(gap_no,rep_no)=max(lin_disp_m)-min(lin_disp_m);

%% for ovelap fit
disp_mean(2)=mean(Samplegap(gap_no).rep.processed_data.lin_disp_m);
gap_mean(2)=mean(Samplegap(gap_no).rep.data(1).gap);


para_overlap.gap1_2=over_lap(disp_mean(1),disp_mean(2),particle_dia_upper_para,particle_dia_lower_para,gap_mean(1),gap_mean(2))

%% gap_3 %rep1
gap_no=3;
rep_no=1;
file_name='Test_59_7.txt';
file_loc=strcat(file_path,file_name);
cols_to_import=12;
Samplegap(gap_no).rep(rep_no).data=data_import(file_loc,cols_to_import);

Samplegap(gap_no).rep(rep_no).processed_data=process(Samplegap(gap_no).rep(rep_no).data,moment_arm,upper_particle_setup_dim,lower_particle_setup_dim,particle_dia_lower_perp,particle_dia_upper_perp);


figure
vel_mean=mean(abs(Samplegap(gap_no).rep.processed_data.v_hz_mean),2);
seperation_mean=mean(abs(Samplegap(gap_no).rep.processed_data.sep_clock),2);
scatter(vel_mean,seperation_mean,'filled')
xlabel('Rotational velocity(m/s)')
ylabel('Difference detachment and contact(m)')

% data export to fit in x/x_e vs v/v_char
lin_disp_m=Samplegap(gap_no).rep(1).processed_data.lin_disp_m;
save('vel_variables_3.mat','seperation_mean','vel_mean', 'lin_disp_m')

lin_disp_m_array(gap_no,rep_no)=mean(lin_disp_m);
lin_disp_m_array_error(gap_no,rep_no)=max(lin_disp_m)-min(lin_disp_m);

%% for ovelap fit
disp_mean(3)=mean(Samplegap(gap_no).rep.processed_data.lin_disp_m);
gap_mean(3)=mean(Samplegap(gap_no).rep.data(1).gap);


para_overlap.gap2_3=over_lap(disp_mean(2),disp_mean(3),particle_dia_upper_para,particle_dia_lower_para,gap_mean(2),gap_mean(3))


%% gap_4 %rep1
gap_no=4;
rep_no=1;
file_name='Test_59_6.txt';
file_loc=strcat(file_path,file_name);
cols_to_import=12;
Samplegap(gap_no).rep(rep_no).data=data_import(file_loc,cols_to_import);

Samplegap(gap_no).rep(rep_no).processed_data=process(Samplegap(gap_no).rep(rep_no).data,moment_arm,upper_particle_setup_dim,lower_particle_setup_dim,particle_dia_lower_perp,particle_dia_upper_perp);

figure
vel_mean=mean(abs(Samplegap(gap_no).rep.processed_data.v_hz_mean),2);
seperation_mean=mean(abs(Samplegap(gap_no).rep.processed_data.sep_clock),2);
scatter(vel_mean,seperation_mean,'filled')
xlabel('Rotational velocity(m/s)')
ylabel('Difference detachment and contact(m)')

% data export to fit in x/x_e vs v/v_char
lin_disp_m=Samplegap(gap_no).rep(1).processed_data.lin_disp_m;
save('vel_variables_4.mat','seperation_mean','vel_mean', 'lin_disp_m')

lin_disp_m_array(gap_no,rep_no)=mean(lin_disp_m);
lin_disp_m_array_error(gap_no,rep_no)=max(lin_disp_m)-min(lin_disp_m);

%% gap_5 %rep1
gap_no=5;
rep_no=1;
file_name='Test_59_5.txt';
file_loc=strcat(file_path,file_name);
cols_to_import=12;
Samplegap(gap_no).rep(rep_no).data=data_import(file_loc,cols_to_import);

Samplegap(gap_no).rep(rep_no).processed_data=process(Samplegap(gap_no).rep(rep_no).data,moment_arm,upper_particle_setup_dim,lower_particle_setup_dim,particle_dia_lower_perp,particle_dia_upper_perp);

figure
vel_mean=mean(abs(Samplegap(gap_no).rep.processed_data.v_hz_mean),2);
seperation_mean=mean(abs(Samplegap(gap_no).rep.processed_data.sep_clock),2);
scatter(vel_mean,seperation_mean,'filled')
xlabel('Rotational velocity(m/s)')
ylabel('Difference detachment and contact(m)')

% data export to fit in x/x_e vs v/v_char
lin_disp_m=Samplegap(gap_no).rep(1).processed_data.lin_disp_m;
save('vel_variables_5.mat','seperation_mean','vel_mean', 'lin_disp_m')

lin_disp_m_array(gap_no,rep_no)=mean(lin_disp_m);
lin_disp_m_array_error(gap_no,rep_no)=max(lin_disp_m)-min(lin_disp_m);

%% fitting the geometry

for i=1:gap_no
    contact_length(i)=Samplegap(i).rep.processed_data.lin_disp_m(1)/2;
    overlap_tofit(i)=mean(Samplegap(i).rep.processed_data.overlap(1,:));
end
figure
scatter(contact_length,overlap_tofit)
hold on
fit_contact_len=polyfit(contact_length,overlap_tofit,2)
corrected_overlap_contact_len_mm=fit_contact_len(3)*1000
plot([0 contact_length],polyval(fit_contact_len,[0 contact_length]))
hold off
axis equal
ylabel('experimntal overlap (m)')
xlabel('contact length(m)')


figure
scatter(contact_length,overlap_tofit)
hold on
fit_contact_len = polyfit(contact_length,overlap_tofit,3);
% corrected_overlap_contact_len_mm=fit_contact_len(3)*1000;
plot(contact_length,polyval(fit_contact_len,contact_length))
hold off
% axis equal
ylabel('experimntal overlap (m)')
xlabel('contact length(m)')
%% error scaling with overlap
% for gap_i=1:5
%     for i=1:4
%         error_vert(gap_i,i)=Samplegap(gap_i).rep(1).processed_data.numeric(i,1).hertz_friction.optim.error_ver;
%     end
% end


%% forces rescaled
% j=1;
% figure
% for gap=1:5
% %     for i=1:4
%         i=4;
%         plot(Samplegap(gap).rep.processed_data.rescaled(i, j).disp,Samplegap(gap).rep.processed_data.rescaled(i, j).F_hz_rescaled)
%         hold on
% %     end
% end
% yline(0)
% xline(0.5)
% hold off

j=1;
figure
for gap=1:5
    i=4;
    x(gap)=Samplegap(gap).rep.processed_data.overlap(i,j)-0.00055;
    y(gap)=Samplegap(gap).rep.processed_data.filter.max_lin_disp_m_avg;
   
end
scatter(x,y,"DisplayName","Experimental datapoints after constant correction")
overlap_max=max(x);
over_lap=0:overlap_max/100:overlap_max;
for k=1:101
y_theo(k)=2*sqrt((particle_dia_upper_para+particle_dia_lower_para).^2-(particle_dia_upper_para+particle_dia_lower_para-over_lap(k)).^2)
end
hold on
plot(over_lap,y_theo,"DisplayName","Theoretical Predictions  Hertz model")
xlabel('overlap(m)')
ylabel('max displacement(m)')
hold off   
title("Overlap vs. displacement(width of horizontal force diagram)")

%% overlap vs. max vertical force

%% for velocity level 1
for i=1:5 %changing gap level
    overlap_representative(i)= mean(mean(Samplegap(i).rep.processed_data.overlap)); % means are done twice for 2 different directions
    max_vert_force(i,1)=max(Samplegap(i).rep.processed_data.tofit(1, 1).ver); 
    max_vert_force(i,2)=max(Samplegap(i).rep.processed_data.tofit(1, 2).ver);
    mean_max_vert_force_single(i)=mean(max_vert_force(i,:));
end

% plot considering Hz 
figure
scatter(overlap_representative.^1.5,mean_max_vert_force_single)
hold on
fit_overlap=polyfit(overlap_representative.^1.5,mean_max_vert_force_single,1);
plot([0 overlap_representative.^1.5],polyval(fit_overlap,[0 overlap_representative.^1.5]))
hold off
ylabel('Max. vertical force (N)')
xlabel('experimetal overlap (m) ^{1.5}')
overlap_correction=(-fit_overlap(2)/fit_overlap(1))^(2/3);
corrected_overlap_by_ver_force_mm=(overlap_representative+overlap_correction)*1000;
corrected_overlap_by_ver_force_m=(overlap_representative+overlap_correction);

% correction_used=overlap_correction;
correction_used=-1.0e-4;
overlap_theo=linspace(0,max(overlap_representative),100);
figure
scatter(overlap_representative+correction_used,mean_max_vert_force_single)
hold on
plot(overlap_theo,fit_overlap(1)*(overlap_theo.^1.5))
hold off

%% for all velocity levels
for j=1:4 %changing velocity levels
for i=1:5 %changing gap level
    max_vert_force(i,1)=max(Samplegap(i).rep.processed_data.tofit(j, 1).ver); 
    max_vert_force(i,2)=max(Samplegap(i).rep.processed_data.tofit(j, 2).ver);
    mean_max_vert_force(j,i)=mean(max_vert_force(i,:));
end
end
% correction_used=overlap_correction;
correction_used=-1e-4;
overlap_theo=linspace(0,max(overlap_representative),100);

figure
subplot(2,2,1)
scatter(overlap_representative+correction_used,mean_max_vert_force(1,:),'DisplayName', 'Corrected')
hold on
scatter(overlap_representative,mean_max_vert_force(1,:),'DisplayName', 'Experimental')
plot(overlap_theo,fit_overlap(1)*(overlap_theo.^1.5)','DisplayName', 'Hertz')
hold off
xlabel('maximum overlap [m]')
ylabel('maximum vertical force [N]')
legend('Location','northwest')
title('v=2.38e-05 [m/s]')
subplot(2,2,2)
scatter(overlap_representative+correction_used,squeeze(mean_max_vert_force(2,:)),'DisplayName', 'Corrected')
hold on
scatter(overlap_representative,squeeze(mean_max_vert_force(2,:)),'DisplayName', 'Experimental')
plot(overlap_theo,fit_overlap(1)*(overlap_theo.^1.5),'DisplayName', 'Hertz')
hold off
xlabel('maximum overlap [m]')
ylabel('maximum vertical force [N]')
legend('Location','northwest')
title('v=4.75e-05 [m/s]')
subplot(2,2,3)
scatter(overlap_representative+correction_used,squeeze(mean_max_vert_force(3,:)),'DisplayName', 'Corrected')
hold on
scatter(overlap_representative,squeeze(mean_max_vert_force(3,:)),'DisplayName', 'Experimental')
plot(overlap_theo,fit_overlap(1)*(overlap_theo.^1.5),'DisplayName', 'Hertz')
hold off
xlabel('maximum overlap [m]')
ylabel('maximum vertical force [N]')
legend('Location','northwest')
title('v=1.19e-04 [m/s]')
subplot(2,2,4)
scatter(overlap_representative+correction_used,squeeze(mean_max_vert_force(4,:)),'DisplayName', 'Corrected')
hold on
scatter(overlap_representative,squeeze(mean_max_vert_force(4,:)),'DisplayName', 'Experimental')
plot(overlap_theo,fit_overlap(1)*(overlap_theo.^1.5),'DisplayName', 'Hertz')
hold off
xlabel('maximum overlap [m]')
ylabel('maximum vertical force [N]')
legend('Location','northwest')
title('v=2.38e-04 [m/s]')

figure
subplot(2,2,1)
loglog(overlap_theo,fit_overlap(1)*(overlap_theo.^1.5))
hold on
scatter(overlap_representative+correction_used,mean_max_vert_force(1,:))
hold off
subplot(2,2,2)
loglog(overlap_theo,fit_overlap(1)*(overlap_theo.^1.5))
hold on
scatter(overlap_representative+correction_used,squeeze(mean_max_vert_force(2,:)))
hold off
subplot(2,2,3)
loglog(overlap_theo,fit_overlap(1)*(overlap_theo.^1.5))
hold on
scatter(overlap_representative+correction_used,squeeze(mean_max_vert_force(3,:)))
hold off
subplot(2,2,4)
loglog(overlap_theo,fit_overlap(1)*(overlap_theo.^1.5))
hold on
scatter(overlap_representative+correction_used,squeeze(mean_max_vert_force(4,:)))
hold off

%% contact length vs. overlap

j=1;
figure
for gap=1:5
    i=4;
    x(gap)=Samplegap(gap).rep.processed_data.overlap(i,j)+overlap_correction;
    y(gap)=Samplegap(gap).rep.processed_data.filter.max_lin_disp_m_avg;
   
end
scatter(x,y,"DisplayName","Experimental datapoints after constant correction")
overlap_max=max(x);
over_lap=0:overlap_max/100:overlap_max;
for k=1:101
y_theo(k)=2*sqrt((particle_dia_upper_para+particle_dia_lower_para).^2-(particle_dia_upper_para+particle_dia_lower_para-over_lap(k)).^2)
end
hold on
plot(over_lap,y_theo,"DisplayName","Theoretical Predictions  Hertz model")
xlabel('overlap(m)')
ylabel('max displacement(m)')
hold off   
title("Overlap vs. displacement(width of horizontal force diagram)")

%% fit with hertz
%% for velocity level 1
for i=1:5 %changing gap level
    overlap_representative(i)= mean(mean(Samplegap(i).rep.processed_data.overlap)); % means are done twice for 2 different directions
    max_vert_force(i,1)=max(Samplegap(i).rep.processed_data.tofit(1, 1).ver); 
    max_vert_force(i,2)=max(Samplegap(i).rep.processed_data.tofit(1, 2).ver);
    mean_max_vert_force(i)=mean(max_vert_force(i,:));
end

% slope of overlap vs force log log plot
log_overlap=log(overlap_representative);
log_force=log(mean_max_vert_force(1,:));
fit_params=polyfit(log_overlap,log_force,1);
fit_paramter(1,:)=fit_params;
E_star=(20*(10^3))/(2*(1-0.5^2));
R1=r_upper_mid;
R2=r_lower_mid;
R_eff=R1*R2/(R1+R2);
expected_log_offset=log(4/3)+log(E_star)+0.5*log(R_eff)

figure
loglog(overlap_representative,(overlap_representative.^1.5))
hold on
scatter(overlap_representative,mean_max_vert_force(1,:))
hold off

figure
scatter(log_overlap,log_force,'DisplayName','Experimental datapoint')
hold on
plot(log_overlap,(1.5*log_overlap)+7.4,'DisplayName','Reference line with power 1.5')
hold off
xlabel('log(overlap)')
ylabel('log(max vertical force)')
% title(strcat('v = ',num2str()))
legend

%% for velocity level 2
for i=1:5 %changing gap level
    overlap_representative(i)= mean(mean(Samplegap(i).rep.processed_data.overlap)); % means are done twice for 2 different directions
    max_vert_force(i,1)=max(Samplegap(i).rep.processed_data.tofit(2, 1).ver); 
    max_vert_force(i,2)=max(Samplegap(i).rep.processed_data.tofit(2, 2).ver);
    mean_max_vert_force(i)=mean(max_vert_force(i,:));
end

% slope of overlap vs force log log plot
log_overlap=log(overlap_representative);
log_force=log(mean_max_vert_force);
fit_params=polyfit(log_overlap,log_force,1);
fit_paramter(2,:)=fit_params;

figure
loglog(overlap_representative,(overlap_representative.^1.5))
hold on
scatter(overlap_representative,mean_max_vert_force)
hold off

figure
scatter(log_overlap,log_force,'DisplayName','Experimental datapoint')
hold on
plot(log_overlap,(1.5*log_overlap)+7.4,'DisplayName','Reference line with power 1.5')
hold off
xlabel('log(overlap)')
ylabel('log(max vertical force)')
legend

%% for velocity level 3
for i=1:5 %changing gap level
    overlap_representative(i)= mean(mean(Samplegap(i).rep.processed_data.overlap)); % means are done twice for 2 different directions
    max_vert_force(i,1)=max(Samplegap(i).rep.processed_data.tofit(3, 1).ver); 
    max_vert_force(i,2)=max(Samplegap(i).rep.processed_data.tofit(3, 2).ver);
    mean_max_vert_force(i)=mean(max_vert_force(i,:));
end

% slope of overlap vs force log log plot
log_overlap=log(overlap_representative);
log_force=log(mean_max_vert_force);
fit_params=polyfit(log_overlap,log_force,1);
fit_paramter(3,:)=fit_params;

figure
loglog(overlap_representative,(overlap_representative.^1.5))
hold on
scatter(overlap_representative,mean_max_vert_force)
hold off

figure
scatter(log_overlap,log_force,'DisplayName','Experimental datapoint')
hold on
plot(log_overlap,(1.5*log_overlap)+7.4,'DisplayName','Reference line with power 1.5')
hold off
xlabel('log(overlap)')
ylabel('log(max vertical force)')
legend

%% for velocity level 4
for i=1:5 %changing gap level
    overlap_representative(i)= mean(mean(Samplegap(i).rep.processed_data.overlap)); % means are done twice for 2 different directions
    max_vert_force(i,1)=max(Samplegap(i).rep.processed_data.tofit(4, 1).ver); 
    max_vert_force(i,2)=max(Samplegap(i).rep.processed_data.tofit(4, 2).ver);
    mean_max_vert_force(i)=mean(max_vert_force(i,:));
end

% slope of overlap vs force log log plot
log_overlap=log(overlap_representative);
log_force=log(mean_max_vert_force);
fit_params=polyfit(log_overlap,log_force,1);
fit_paramter(4,:)=fit_params;

figure
loglog(overlap_representative,(overlap_representative.^1.5))
hold on
scatter(overlap_representative,mean_max_vert_force)
hold off

figure
scatter(log_overlap,log_force,'DisplayName','Experimental datapoint')
hold on
plot(log_overlap,(1.5*log_overlap)+7.4,'DisplayName','Reference line with power 1.5')
hold off
xlabel('log(overlap)')
ylabel('log(max vertical force)')
legend


%% horizontal force signal analysis for different overlaps normalized with geometric length
figure
subplot(1,2,1)
for i=1:gap_no
peak_first=mean(Samplegap(i).rep.processed_data.max_amp,2);
peak_second=(mean(Samplegap(i).rep.processed_data.min_amp,2));
scatter(Samplegap(i).rep.processed_data.v_hz_mean(:,1),(peak_first+peak_second)'./Samplegap(i).rep.processed_data.lin_disp_m,'filled','DisplayName',num2str(corrected_overlap_by_ver_force_mm(i)))%,'MarkerFaceColor',[0 0.4470 0.7410],'MarkerEdgeColor',[0 0.4470 0.7410])
hold on
end
hold off
xlabel('Rotational velocity(m/s)')
% ylabel('^{Diff. in Amplitudes(N)}{geometric contact length}$','Interpreter','latex','FontSize',20)
ylabel('^{Diff. in Amplitudes(N)}/_{geometric contact length}','FontSize',15)
lgd = legend('Location','northeast');
lgd.Title.String = 'overlap (mm)';

subplot(1,2,2)
for i=1:gap_no
    vel_mean=mean(abs(Samplegap(gap_no).rep.processed_data.v_hz_mean),2);
    scatter(vel_mean,Samplegap(i).rep.processed_data.avg_contact_len'./Samplegap(i).rep.processed_data.lin_disp_m,'filled','DisplayName',num2str(corrected_overlap_by_ver_force_mm(i)))%,'MarkerFaceColor',[0 0.4470 0.7410],'MarkerEdgeColor',[0 0.4470 0.7410])
    geometric_contact_length(i)=mean(Samplegap(i).rep.processed_data.lin_disp_m);
    hold on
end
hold off
xlabel('Rotational velocity(m/s)')
ylabel('^{Observed contact length}/_{geometric contact length}','FontSize',15)
%ylabel('$\frac{force contact length}{geometric contact length}$','Interpreter','latex','FontSize',20)
lgd = legend('Location','southeast');
lgd.Title.String = 'overlap (mm)';

sgtitle('Normalized by geometric length')



%% horizontal force signal analysis for different overlaps
figure
subplot(1,2,1)
for i=1:gap_no
peak_first=mean(Samplegap(i).rep.processed_data.max_amp,2);
peak_second=(mean(Samplegap(i).rep.processed_data.min_amp,2));

plot(Samplegap(i).rep.processed_data.v_hz_mean(:,1),peak_first+peak_second,'-*','DisplayName',num2str(corrected_overlap_by_ver_force_mm(i)))%,'MarkerFaceColor',[0 0.4470 0.7410],'MarkerEdgeColor',[0 0.4470 0.7410])
hold on
end
hold off
xlabel('Rotational velocity(m/s)')
ylabel('Diff. in Amplitudes(N)')
lgd = legend('Location','northeast');
lgd.Title.String = 'overlap (mm)';

subplot(1,2,2)
for i=1:gap_no
    vel_mean=mean(abs(Samplegap(gap_no).rep.processed_data.v_hz_mean),2);
    plot(vel_mean,Samplegap(i).rep.processed_data.avg_contact_len','-*','DisplayName',num2str(corrected_overlap_by_ver_force_mm(i)))%,'MarkerFaceColor',[0 0.4470 0.7410],'MarkerEdgeColor',[0 0.4470 0.7410])
    hold on
end
hold off
xlabel('Rotational velocity(m/s)')
ylabel('Force contact length(m)')
lgd = legend('Location','northeast');
lgd.Title.String = 'overlap (mm)';

%% horizontal force signal analysis for different overlaps scaled by overlap^(3/2)
figure
subplot(1,2,1)
for i=1:gap_no
peak_first=mean(Samplegap(i).rep.processed_data.max_amp,2);
peak_second=(mean(Samplegap(i).rep.processed_data.min_amp,2));

plot(Samplegap(i).rep.processed_data.v_hz_mean(:,1),(peak_first+peak_second)/((corrected_overlap_by_ver_force_mm(i)/1000)^1.5),'-*','DisplayName',num2str(corrected_overlap_by_ver_force_mm(i)))%,'MarkerFaceColor',[0 0.4470 0.7410],'MarkerEdgeColor',[0 0.4470 0.7410])
hold on
end
hold off
xlabel('Rotational velocity(m/s)')
ylabel('Diff. in Amplitudes(N)/(overlap^{1.5})')
lgd = legend('Location','northeast');
lgd.Title.String = 'overlap (mm)';

subplot(1,2,2)
for i=1:gap_no
    vel_mean=mean(abs(Samplegap(gap_no).rep.processed_data.v_hz_mean),2);
    plot(vel_mean,Samplegap(i).rep.processed_data.avg_contact_len'/((corrected_overlap_by_ver_force_mm(i)/1000)^1.5),'-*','DisplayName',num2str(corrected_overlap_by_ver_force_mm(i)))%,'MarkerFaceColor',[0 0.4470 0.7410],'MarkerEdgeColor',[0 0.4470 0.7410])
    hold on
end
hold off
xlabel('Rotational velocity(m/s)')
ylabel('Observed contact length(m)/(overlap^{1.5})')
lgd = legend('Location','northeast');
lgd.Title.String = 'overlap (mm)';

sgtitle('Normalized by overlap^{3/2}')


%% zero crossing check
cmap = parula(512);
cmap = cmap(1:360, :);    % dark blue to green (360 colors)
c = corrected_overlap_by_ver_force_mm;
c = (c-min(c))/(max(c)-min(c))*359+1;
c_floor=floor(c);
cou_nt=1;

figure
subplot(1,3,1)
for i=1:gap_no
peak_first=mean(Samplegap(i).rep.processed_data.max_amp,2);
peak_second=(mean(Samplegap(i).rep.processed_data.min_amp,2));

plot(Samplegap(i).rep.processed_data.v_hz_mean(:,1),peak_first+peak_second,'-*','DisplayName',num2str(corrected_overlap_by_ver_force_mm(i)),'Color',cmap(c_floor(i),:))%,'MarkerFaceColor',[0 0.4470 0.7410],'MarkerEdgeColor',[0 0.4470 0.7410])
hold on
end
hold off
xlabel('Rotational velocity(m/s)')
ylabel('Diff. in Amplitudes(N)')


subplot(1,3,2)
for i=1:gap_no
    vel_mean=mean(abs(Samplegap(gap_no).rep.processed_data.v_hz_mean),2);
    plot(vel_mean,Samplegap(i).rep.processed_data.avg_contact_len','-*','DisplayName',num2str(corrected_overlap_by_ver_force_mm(i)),'Color',cmap(c_floor(i),:))%,'MarkerFaceColor',[0 0.4470 0.7410],'MarkerEdgeColor',[0 0.4470 0.7410])
    hold on
end
hold off
xlabel('Rotational velocity(m/s)')
ylabel('Force contact length(m)')


subplot(1,3,3)
for i=1:5
plot(abs(Samplegap(i).rep.processed_data.v_hz_mean(:,1)),Samplegap(i).rep.processed_data.x_zero_exp(:,1),'-*','Color',cmap(c_floor(i),:));
hold on;
plot(abs(Samplegap(i).rep.processed_data.v_hz_mean(:,end)),Samplegap(i).rep.processed_data.x_zero_exp(:,end),'--o','Color',cmap(c_floor(i),:));
end
hold off
xlabel('Rotational velocity(m/s)')
ylabel('Asymmetry in zero crossing (m)')


%% plots for ppt
figure
plot(Samplegap(1).rep.data(3).defangle.*moment_arm/1000,(Samplegap(1).rep.data(3).torque/moment_arm)/1000,'DisplayName','Clockwise')
% hold on
% plot(Samplegap(1).rep.data(5).defangle.*moment_arm/1000,(Samplegap(1).rep.data(5).torque/moment_arm)/1000,'DisplayName','Anti-Clockwise')
% hold off
[ymin,idx_min] = min((Samplegap(1).rep.data(3).torque/moment_arm)/1000) ;
[ymax,idx_max] = max((Samplegap(1).rep.data(3).torque/moment_arm)/1000) ; 
text(Samplegap(1).rep.data(3).defangle(idx_min).*moment_arm/1000,ymin,['t: ' num2str(ymin)]);
text(Samplegap(1).rep.data(3).defangle(idx_max).*moment_arm/1000,ymax,['p: ' num2str(ymax)]);
xlim([0.0045 0.0175])
xlabel('Raw Displacement(m)')
ylabel('Raw Horizontal Force(N)')
% lgd = legend('Location','southwest');
% lgd.Title.String = 'Rotational direction';

figure
plot(Samplegap(1).rep.data(3).defangle.*moment_arm/1000,(Samplegap(1).rep.data(3).torque/moment_arm)/1000,'DisplayName','Clockwise')
hold on
plot(Samplegap(1).rep.data(5).defangle.*moment_arm/1000,(Samplegap(1).rep.data(5).torque/moment_arm)/1000,'DisplayName','Anti-Clockwise')
% xline(Samplegap(1).rep.data(3).defangle(Samplegap(1).rep.processed_data.filter.lim_start_index(1,1)).*moment_arm/1000,'green','HandleVisibility','off')%'DisplayName',' Contact Clockwise')
% xline(Samplegap(1).rep.data(5).defangle(Samplegap(1).rep.processed_data.filter.lim_start_index(1,2)).*moment_arm/1000,'m','HandleVisibility','off')%'DisplayName',' Contact Anti-Clockwise')
% xline(mean([Samplegap(1).rep.data(3).defangle(Samplegap(1).rep.processed_data.filter.lim_start_index(1,1)),Samplegap(1).rep.data(5).defangle(Samplegap(1).rep.processed_data.filter.lim_start_index(1,2))]).*moment_arm/1000,'cyan','HandleVisibility','off')%'DisplayName','Mid Point')
yline(0,'HandleVisibility','off')%'DisplayName','Baseline')
hold off
xlim([0.0045 0.0175])
xlabel('Raw Displacement(m)')
ylabel('Raw Horizontal Force(N)')
lgd = legend('Location','southwest');
lgd.Title.String = 'Rotational direction';


figure
plot(Samplegap(1).rep.data(3).defangle.*moment_arm/1000,(Samplegap(1).rep.data(3).torque/moment_arm)/1000,'DisplayName','Clockwise')
hold on
plot(Samplegap(1).rep.data(5).defangle.*moment_arm/1000,(Samplegap(1).rep.data(5).torque/moment_arm)/1000,'DisplayName','Anti-Clockwise')
xline(Samplegap(1).rep.data(3).defangle(Samplegap(1).rep.processed_data.filter.lim_start_index(1,1)).*moment_arm/1000,'green','HandleVisibility','off')%'DisplayName',' Contact Clockwise')
xline(Samplegap(1).rep.data(5).defangle(Samplegap(1).rep.processed_data.filter.lim_start_index(1,2)).*moment_arm/1000,'m','HandleVisibility','off')%'DisplayName',' Contact Anti-Clockwise')
xline(mean([Samplegap(1).rep.data(3).defangle(Samplegap(1).rep.processed_data.filter.lim_start_index(1,1)),Samplegap(1).rep.data(5).defangle(Samplegap(1).rep.processed_data.filter.lim_start_index(1,2))]).*moment_arm/1000,'cyan','HandleVisibility','off')%'DisplayName','Mid Point')
yline(0,'HandleVisibility','off')%'DisplayName','Baseline')
hold off
xlim([0.0045 0.0175])
xlabel('Raw Displacement(m)')
ylabel('Raw Horizontal Force(N)')
lgd = legend('Location','southwest');
lgd.Title.String = 'Rotational direction';


%% for paper
f=figure
gap_no=5;
for i=1:gap_no
    over_lap_mean=(mean(mean(Samplegap(i).rep.processed_data.overlap)))-1e-4;
    name_tag=sprintf('%0.2e',over_lap_mean);
    start_angle=(Samplegap(i).rep.processed_data.def_angle_start(1,1)*moment_arm/1000);
    plot(Samplegap(i).rep.processed_data.tofit(1, 1).x+start_angle,Samplegap(i).rep.processed_data.tofit(1, 1).F_hz,'DisplayName',name_tag)
    hold on
end
yline(0,'HandleVisibility','off')
hold off
xlabel("$\theta$ [m]",'Interpreter','latex')
ylabel("$F_h$ [N]",'Interpreter','latex')
lgd = legend('Location','southwest','Interpreter','latex');
lgd_title='$\delta_{max}$ [m]';
lgd.Title.String = lgd_title;
lgd.FontSize = 17;
ax1 = gca;
ax1.LineWidth=2;
ax1.FontSize =20;
ax1.YAxis.Exponent = -3;
ax1.XAxis.Exponent = -3;
axis('square')
f.Position=[200 300 560 500];
AddLetters2Plots({ax1},{'a)'}, 'HShift', 0.06, 'VShift', 0, 'FontSize', 18)
saveas(gcf,'M:\paper_writing\inter_particle_shear\hz_force_diff_overlap.svg')
saveas(gcf,'M:\paper_writing\inter_particle_shear\hz_force_diff_overlap','epsc')
saveas(gcf,'M:\paper_writing\inter_particle_shear\hz_force_diff_overlap.emf')


f=figure
gap_no=5;
for i=1:gap_no
    over_lap_mean=(mean(mean(Samplegap(i).rep.processed_data.overlap)))-1e-4;
     name_tag=sprintf('%0.2e',over_lap_mean);
    scatter(Samplegap(i).rep(1).processed_data.v_hz_mean_avg,Samplegap(i).rep(1).processed_data.contact_def_len_mean/Samplegap(i).rep(1).processed_data.contact_def_len_geometric,80,'filled','DisplayName',name_tag)
    hold on
end
hold off
% xlim([0 10e-3])
ytickformat('%.2f')
xlabel("$v$ [m/s]",'Interpreter','latex')
ylabel("${l_c}/{l_g}$",'Interpreter','latex')
lgd = legend('Location','southeast','Interpreter','latex');
lgd_title='$\delta_{max} [m]$';
lgd.Title.String = lgd_title;
lgd.FontSize = 18;
ax1 = gca;
ax1.LineWidth=2;
ax1.FontSize = 20;
% ax1.YAxis.Exponent = -3;
ax1.XAxis.Exponent = -3;
axis('square')
box on
f.Position=[200 300 560 500]
AddLetters2Plots({ax1},{'b)'}, 'HShift', 0.06, 'VShift', 0, 'FontSize', 18)
saveas(gcf,'M:\paper_writing\inter_particle_shear\l_c_by_lg.svg')
saveas(gcf,'M:\paper_writing\inter_particle_shear\l_c_by_lg','epsc')
saveas(gcf,'M:\paper_writing\inter_particle_shear\l_c_by_lg.emf')


f=figure
for i=1:gap_no
    over_lap_mean=(mean(mean(Samplegap(i).rep.processed_data.overlap)))-1e-4;
    name_tag=sprintf('%0.2e',over_lap_mean);
    scatter(Samplegap(i).rep(1).processed_data.v_hz_mean_avg,Samplegap(i).rep.processed_data.mu_exp_mean,80,'filled','DisplayName',name_tag)
    hold on
end
hold off
box on
set(gca,'xscale','log')
set(gca,'yscale','log')
xlabel("$v$ [m/s]",'Interpreter','latex')
ylabel("$\mu$",'Interpreter','latex')
lgd = legend('Location','northeast','Interpreter','latex');
lgd_title='$\delta_{max} [m]$';
lgd.Title.String = lgd_title;
lgd.FontSize = 18;
ax1 = gca;
ax1.LineWidth=2;
ax1.FontSize = 20;
ax1.YAxis.Exponent = -3;
ax1.XAxis.Exponent = -3;
axis('square')
box on
f.Position=[200 300 560 500]
AddLetters2Plots({ax1},{'c)'}, 'HShift', 0.06, 'VShift', 0, 'FontSize', 18)
saveas(gcf,'M:\paper_writing\inter_particle_shear\mu_vs_v.svg')
saveas(gcf,'M:\paper_writing\inter_particle_shear\mu_vs_v','epsc')
saveas(gcf,'M:\paper_writing\inter_particle_shear\mu_vs_v.emf')

