*************************************************************
* Dofile used to export wealth and income shares in France *
*************************************************************


* I) Wealth shares 
*********************
* Raw data from from Garbinti, Goupille-Lebret and Piketty (2021)
{
	local i=0
	clear
	set obs 45
	gen year =1969+_n
	gen sex=`i'
	gen gperc=0
	merge 1:m year sex gperc using "$calibrawdata/Inequality/gperc_19702014.dta"
	keep year gperc sex  thr ytop b n y0
	keep if sex==`i'
	drop sex 
	* Pop above the threshold
		gsort + year - gperc 
		bys year : gen npop =sum(n)
				
	* Definition of wealth groups
		keep if gperc==0 | gperc==10 | gperc==50 | gperc==90  | gperc==990 | gperc==9990 | gperc==99990 | gperc==99999 
		
	* Wealth shares
		sort year gperc
		bys year : egen ytot=sum(npop*ytop*(gperc==0))
		gen share=ytop*npop
		replace share=share[_n-1]-share if gperc==10 
		replace share=share-share[_n+2] if gperc==0 
		replace share=share-share[_n+1] if gperc==50  
		replace share=share/ytot
		
	* Total population
		bys year : egen poptot=sum(npop*(gperc==0))
		
	* Population by groups
		replace n=npop-npop[_n+2] if gperc==0
		replace n=npop[_n-1]-npop if gperc==10
		replace n=npop-npop[_n+1] if gperc==50
		replace n=npop if gperc>=90

	* Average wealth by groups
		gen yint=share*ytot/n
	
	* Other
		bys year : egen yav=sum(ytop*(gperc==0))
	* Keep only groups up to top 0.1%
		keep if gperc <=9990
		keep  year gperc n thr share yint  poptot ytot yav
		order year gperc n thr share yint  poptot ytot yav
		rename share sh_w_
		rename gperc bperc
	save "$calibwf/shares/share_w.dta",replace
}
	
	
* II) Pretax income shares 
****************************
* Raw data from Bozio, Garbinti, Goupille-Lebret, Guillot, and Piketty (2024)
	clear
	local loop="r_pretax_lumpCN_equal"
	* broad groups (P0-50, P50-90, P90-100,...)
		use "$calibrawdata/Inequality/dperc`loop'.dta",clear
		keep year dperc share_dperc
		gen bperc=dperc
		replace bperc=0 if dperc<50
		replace bperc=50 if dperc >=50 & dperc<90
		replace bperc=90 if dperc ==95
		replace bperc=99 if dperc ==995
		replace bperc=999 if dperc ==9999
		collapse (sum) share_dperc ,by(year bperc)
		replace share_dperc=. if share_dperc==0
		rename share_dperc  sh_yt_
		order year bperc sh_yt_
		* Top 10 and top 1
			replace sh_yt_ =  sh_yt_+sh_yt_[_n+1] if bperc==99
			replace sh_yt_ =sh_yt_+sh_yt_[_n+1] if bperc==90
	save "$calibwf/shares/share_yt.dta",replace
				
* III) Posttax income shares 
********************************
* Raw data from Bozio, Garbinti, Goupille-Lebret, Guillot, and Piketty (2024)
	clear
	local loop="r_posttax_lumpCN_equal"
	* broad groups (P0-50, P50-90, P90-100,...)
		use "$calibrawdata/Inequality/dperc`loop'.dta",clear
		keep year dperc share_dperc
		gen bperc=dperc
		replace bperc=0 if dperc<50
		replace bperc=50 if dperc >=50 & dperc<90
		replace bperc=90 if dperc ==95
		replace bperc=99 if dperc ==995
		replace bperc=999 if dperc ==9999
		collapse (sum) share_dperc ,by(year bperc)
		replace share_dperc=. if share_dperc==0
		rename share_dperc  sh_ypost_
		order year bperc sh_ypost_
		* Top 10 and top 1
			replace sh_ypost_ =  sh_ypost_+sh_ypost_[_n+1] if bperc==99
			replace sh_ypost_ =sh_ypost_+sh_ypost_[_n+1] if bperc==90
	save "$calibwf/shares/share_ypost.dta",replace


* IV) Merge all files 
***********************
	use "$calibwf/shares/share_w.dta",clear
	keep year bperc sh_w_
	drop if bperc==10
	replace bperc=99 if bperc==990
	replace bperc=999 if bperc==9990
	merge 1:1 year bperc using "$calibwf/shares/share_yt.dta"
	drop _merge
	merge 1:1 year bperc using "$calibwf/shares/share_ypost.dta"
	drop _merge
	keep if year>=1984
	save "$calibwf/shares/shares.dta", replace
	
	

