**************************
*  Docreate_datasetaegg  *
**************************

* Dofile used to import stats from various datasources and export them in the xls file dataset_aegg that gather all parameters of interests for the calibration or the comparison exercice of the macro model



* Export Inequality shares 
***************************
	
	use "$calibwf/shares/shares.dta",clear
	keep year bperc  sh_yt_ sh_ypost_ sh_w_
	reshape wide sh_yt_ sh_ypost_ sh_w_,i(year) j(bperc)
	order year sh_yt_* sh_ypost_* sh_w_*
	export excel using "$projmacro/dataset_aegg.xlsx", sheet("Inequalities")   sheetmodify cell(A3) firstrow(variable)  keepcellfmt				

* Export Markups and VA concentration parameters
***************************************************
	
	* Markups
	import excel using "$calibrawdata/Markups/markups_data.xlsx", first clear sheet("markups")  cellrange(A3:F36)
		keep year cor_smoo_markup_agg  markup_agg_final  theta 
		order year cor_smoo_markup_agg  markup_agg_final  theta 
		* add level of markup in 2017 and 2018 equal to year 2016
		expand 3 if year ==2016
		sort year
		replace year=year[_n-1]+1 if year==2016
	export excel using "$projmacro/dataset_aegg.xlsx", sheet("Markup")   sheetmodify cell(A3) firstrow(variable)  keepcellfmt	
	
	* VA concentration
	import excel using "$calibrawdata/Markups/markups_data.xlsx", first clear sheet("VAshares")  cellrange(A3:F36)
	export excel using "$projmacro/dataset_aegg.xlsx", sheet("sh_VA")   sheetmodify cell(A3) firstrow(variable)  keepcellfmt	
	
* Export tax parameters
***************************	
	* Main scenario
	use "${calibwftaxreg}/results_full.dta",clear
		drop N_*
		* Fill missing years
		expand 4 if year==1984
		expand 6 if year==1988
		sort year
		replace year=1983+_n
	export excel using "$projmacro/dataset_aegg.xlsx", sheet("Taxes")   sheetmodify cell(A2) firstrow(variable)  keepcellfmt	
	
	* Variant for 1984: one unique progressive tax rate 
	use "${calibwftaxreg}/results_one_rate.dta",clear
	drop year
	export excel using "$projmacro/dataset_aegg.xlsx", sheet("Taxes")   sheetmodify cell(AN2) firstrow(variable)  keepcellfmt	
	

* Export National Account parameters
***************************************	
	
	* Series of GDP from Bergeaud, Cette and Lecat (2016) : longtermproductivity database, v2.4
	import excel using "$calibrawdata/National Accounts/BCLDatabase_online_v2.4.xlsx",  clear first sheet("GDP per capita")  cellrange(A1:L131)
		keep Year FRA
		rename Year year
		rename FRA gdp_per_capita
		destring year, replace
		keep if year>=1970 & year<=2018
	export excel using "$projmacro/dataset_aegg.xlsx",  sheet("GDP")  sheetmodify cell(A2) firstrow(variable)  keepcellfmt	

	* Ownership rate
	import excel using "$calibrawdata/National Accounts/cond-logt-statut-occup.xlsx",  clear sheet("Données")  cellrange(D5:AL5) 
		xpose, varname clear
		gen year=1983+_n
		rename v1 Ownership_rate  
		keep year Ownership_rate  
		order year Ownership_rate
	export excel using "$projmacro/dataset_aegg.xlsx",  sheet("Home Ownership")  sheetmodify cell(A2) firstrow(variable)  keepcellfmt	
	
	* National Account Parameters on Income and wealth 
	import excel using "$calibrawdata/National Accounts/comptanatmacro.xlsx",  clear first sheet("Parameters")  cellrange(A4:BF53)
		keep if year>=1984	
		
		* Rates of housing and financial capital gains are needed for the year 1985 (evolution from 1984 to 1985) => Normalized to 0 in 1984 
		replace dph=0 if year==1984
		replace dpk=0 if year==1984
		
		* Normalized GDP per capita
		foreach var of varlist  PRETAX_obs adult_pop {
			quiet sum `var' if year==1984
			local `var'_84=r(mean)
		}
		gen ni_pc_norm=(PRETAX_obs/adult_pop/priceindex84)/(`PRETAX_obs_84'/`adult_pop_84')
		
		* Consumption shares
		gen CIratio_obs=CONSO_obs/PRETAX_obs
		rename g g_over_y
		
		order year delta dph dpk shH_W_obs	shM_W_obs shK_W_obs	WIratio_obs ni_pc_norm g_over_y LABOR_sh_obs CIratio_obs CONSO_obs PRETAX_obs adult_pop priceindex84
		keep year delta dph dpk shH_W_obs	shM_W_obs shK_W_obs	WIratio_obs ni_pc_norm g_over_y LABOR_sh_obs CIratio_obs CONSO_obs PRETAX_obs adult_pop priceindex84 
	export excel using "$projmacro/dataset_aegg.xlsx",  sheet("National_Accounts")  sheetmodify cell(A2) firstrow(variable)  keepcellfmt	

		
