*********************************************************************
* Dofile used to compute the tax parameters used in the macro model *
**********************************************************************

* Start from the synthetic tax rates by income groups
* Compute the tax parameters of interests
* Compute graphs depicting tax rates by income groups


* I) Data harmonization
**************************
	* Append the different database (tax#year)
	local rate phi
	use "${calibrawdata}/Tax Rates/temp_1984_`rate'.dta", clear 
	foreach y of numlist  1984 1988 1994/2018 {	
		foreach rate in phi k w transf {
			if !( `y' == 1984 & "`rate'" == "phi"){
			append using "${calibrawdata}/Tax Rates/temp_`y'_`rate'.dta"	
			}
		}
	} 
	*tab year, mi 
	*tab tax, mi
	compress 
	save "${calibwftax}/synthetic_dperc_raw.dta", replace

	
* II) Define the program to compute the tax parameters and generate the associated graphs
************************************************************************************************

* Graph with one segment (no kink)
*************************************
	* Used for capital taxes
	cap program drop tax_rate_nokink
	program tax_rate_nokink 
	args year rate var title xvar ymin ymax ygap
 	
	use "${calibwftax}/synthetic_dperc_raw.dta", clear 	
	*grstyle init 
	preserve
		keep if year == `year' & tax == "`rate'"			
		twoway ///
		(scatter rate logtaxbase_bin if label_perc_order <= 11,  yaxis(1) sort mlabel(label_perc ) mlabposition(8) mlabangle(45) mlabgap(1.5) ytitle("") legend(off))		///
		(lfit rate logtaxbase_bin if label_perc_order <=11 [aw=a_taxbase], yaxis(1)  ytitle("") legend(off)) ///
		(scatter rate logtaxbase_bin if label_perc =="top 0.1",  mlabel(label_perc ) mlabposition(8) mlabangle(45) mlabgap(1.5) ytitle("") legend(off)),graphregion(color(white)) title("") xtitle("log (`xvar'/average `xvar')") ///
		yscale(range(`ymin' `ymax')) ylabel(`ymin' (`ygap') `ymax')  
		graph export "${calibwftaxgraphs}/`rate'_bin_`year'.pdf",replace
		if `year'==1984 | `year'==2018 graph export "${projoutput}/Appendix B/`rate'_bin_`year'.pdf",replace
		
		*Data		
		reg lt logtaxbase_bin if label_perc_order <= 11 [aw=a_taxbase], r 
		g t`rate'bar1=1-exp(_b[_cons])
		g eta_t`rate'1=_b[logtaxbase_bin]
		g N_`rate'_1=e(N)
				
		summ at_rate if label_perc == "top 0.1" 
		sca at_`rate'_p999=r(sum)
		summ a_taxbase if label_perc == "top 0.1" 
		sca a_`var'_p999=r(sum)					
		g t`rate'bartop01=at_`rate'_p999/a_`var'_p999 
		
		keep t`rate'* eta* N* thres_trate_bin*
		duplicates drop	
		g thres_t`rate'1 = 0
		g thres_t`rate'2 = 0
		g thres_t`rate'3 = thres_trate_bin_top01
		g t`rate'bar2 = t`rate'bar1
		g eta_t`rate'2 = eta_t`rate'1 
		g year=`year'	
		rename t`rate'bartop01 t`rate'barmax
		drop thres_trate_bin* 
		order year t`rate'bar1 t`rate'bar2 t`rate'barmax ///
			thres_t`rate'1 thres_t`rate'2 thres_t`rate'3 ///
			eta_t`rate'1 eta_t`rate'2	
		save "${calibwftax}/Reg/temp/temp_`year'_results_`rate'.dta",replace
	restore 
end


* Graph with 3 segments (2 kinks)
**************************************
	* Used for SS contributions, income tax, and monetary transfers
	cap program drop tax_rate_2kink
	program tax_rate_2kink 
		args year rate var knot1 knot2 title xvar ymin ymax ygap
		* knot1 : last bin of the first segment
		* knot2 : last bin of the second segment	
		use "${calibwftax}/synthetic_dperc_raw.dta", clear 	
		*grstyle init 
		preserve
			keep if year == `year' & tax == "`rate'"
			
			*Graph
			twoway ///
			(scatter rate logtaxbase_bin if label_perc_order <= 11,  yaxis(1) sort mlabel(label_perc ) mlabposition(8) mlabangle(45) mlabgap(1.5) ytitle("") legend(off))		///
			(lfit rate logtaxbase_bin if label_perc_order <=`knot1' [aw=a_taxbase], yaxis(1)  ytitle("") legend(off)) ///
			(lfit rate logtaxbase_bin if label_perc_order > `knot1' & label_perc_order <= `knot2' [aw=a_taxbase], yaxis(1) ytitle("") legend(off)) ///
			(lfit rate logtaxbase_bin if label_perc_order > `knot2' & label_perc_order < 12   [aw=a_taxbase], yaxis(1) ytitle("") legend(off)) ///
			(scatter rate logtaxbase_bin if label_perc =="top 0.1",  mlabel(label_perc ) mlabposition(8) mlabangle(45) mlabgap(1.5) ytitle("") legend(off)),graphregion(color(white)) title("") xtitle("log (`xvar'/average `xvar')") ///
			yscale(range(`ymin' `ymax')) ylabel(`ymin' (`ygap') `ymax')  
			graph export "${calibwftaxgraphs}/`rate'_bin_`year'.pdf",replace	
			if `year'==1984 | `year'==2018 graph export "${projoutput}/Appendix B/`rate'_bin_`year'.pdf",replace
	 
			*Data		
			reg lt  logtaxbase_bin if label_perc_order <=`knot1' [aw=a_taxbase], r 
			g t`rate'bar1  = 1-exp(_b[_cons])
			g eta_t`rate'1 = _b[logtaxbase_bin]
			g N_`rate'_1   = e(N)
				
			reg lt logtaxbase_bin if label_perc_order > `knot1' & label_perc_order <= `knot2' [aw=a_taxbase], r	
			g t`rate'bar2  = 1-exp(_b[_cons])
			g eta_t`rate'2 = _b[logtaxbase_bin]
			g N_`rate'_2   = e(N)
					
			reg lt  logtaxbase_bin if label_perc_order > `knot2' & label_perc_order < 12   [aw=a_taxbase], r	
			g t`rate'bar3  = 1-exp(_b[_cons])
			g eta_t`rate'3 = _b[logtaxbase_bin]
			g N_`rate'_3   = e(N)				
			
			summ at_rate   if label_perc == "top 0.1" 
			sca at_`rate'_p999 = r(sum)
			summ a_taxbase if label_perc == "top 0.1" 
			sca a_`var'_p999   = r(sum)					
			g t`rate'bartop01  = at_`rate'_p999/a_`var'_p999 
			
			keep t`rate'* eta* N* thres_trate_bin*
			duplicates drop	
			g thres_t`rate'1 = thres_trate_bin`knot1'
			g thres_t`rate'2 = thres_trate_bin`knot2'
			g thres_t`rate'3 = thres_trate_bin_top01
			g year = `year'	
			rename t`rate'bartop01 t`rate'barmax
			*rename thres_t`rate'top01 thres_t`rate'3
			drop thres_trate_bin* 
			order year t`rate'bar1 t`rate'bar2 t`rate'bar3 t`rate'barmax ///
				thres_t`rate'1 thres_t`rate'2 thres_t`rate'3  ///
				eta_t`rate'1 eta_t`rate'2 eta_t`rate'3		
			save "${calibwftax}/Reg/temp/temp_`year'_results_`rate'.dta",replace
		restore 
	end


* III) Launch the program to compute the tax parameters and generate the associated graphs
************************************************************************************************
	
	* 1984
	********
	tax_rate_2kink  1984 w      labor_inc 2 6 "Social security tax" "pretax labor income" 0 0.25  0.05
	tax_rate_2kink  1984 phi    tot_inc   2 4 "Income tax"          "total income"        0 0.3   0.05
	tax_rate_2kink  1984 transf tot_inc   2 5 "Transfers"           "total income"        0 1     0.2
	tax_rate_nokink 1984 k      pat_cn        "Capital tax"         "net wealth"          0 0.008 0.002


	* 1988
	*******
	tax_rate_2kink  1988 w      labor_inc 2 6 "Social security tax" "pretax labor income" 0 0.25  0.05
	tax_rate_2kink  1988 phi    tot_inc   2 4 "Income tax"          "total income"        0 0.3   0.05
	tax_rate_2kink  1988 transf tot_inc   2 5 "Transfers"           "total income"        0 1     0.2   
	tax_rate_nokink 1988 k      pat_cn        "Capital tax"         "net wealth"          0 0.008 0.002


	* 1994
	********
	tax_rate_2kink  1994 w      labor_inc 2 7 "Social security tax" "pretax labor income" 0 0.25  0.05
	tax_rate_2kink  1994 phi    tot_inc   2 6 "Income tax"          "total income"        0 0.3   0.05
	tax_rate_2kink  1994 transf tot_inc   2 5 "Transfers"           "total income"        0 1     0.2
	tax_rate_nokink 1994 k      pat_cn        "Capital tax"         "net wealth"          0 0.008 0.002
	
	*1995-2018
	foreach year of numlist 1995 (1) 2018 {
		tax_rate_2kink  `year' w      labor_inc 2 7 "Social security tax" "pretax labor income" 0 0.25  0.05
		tax_rate_2kink  `year' phi    tot_inc   2 9 "Income tax"          "total income"        0 0.3   0.05
		tax_rate_2kink  `year' transf tot_inc   2 5 "Transfers"           "total income"        0 1     0.2

		tax_rate_nokink `year' k      pat_cn        "Capital tax"         "net wealth"          0 0.008 0.002
	}


	* Gather all the different files together 
	foreach year of numlist 1984 1988 1994/2018 {
		use "${calibwftax}/Reg/temp/temp_`year'_results_transf.dta",clear
		merge 1:1 year using "${calibwftax}/Reg/temp/temp_`year'_results_w.dta" 
		drop _merge
		merge 1:1 year using "${calibwftax}/Reg/temp/temp_`year'_results_phi.dta" 
		drop _merge
		merge 1:1 year using "${calibwftax}/Reg/temp/temp_`year'_results_k.dta" 
		drop _merge
		
		if `year'>1984 {
				append using `temp'
				erase `temp'
		}	
		tempfile temp
		save "`temp'", replace	
		erase "${calibwftax}/Reg/temp/temp_`year'_results_transf.dta"
		erase "${calibwftax}/Reg/temp/temp_`year'_results_w.dta" 
		erase "${calibwftax}/Reg/temp/temp_`year'_results_phi.dta" 
		erase "${calibwftax}/Reg/temp/temp_`year'_results_k.dta" 	
	}
	order year twbar1 twbar2 twbar3 twbarmax thres_tw1 thres_tw2 thres_tw3 eta_tw1 eta_tw2 eta_tw3 ///
		tphibar1 tphibar2 tphibar3 tphibarmax thres_tphi1 thres_tphi2 thres_tphi3 eta_tphi1 eta_tphi2 eta_tphi3 ///
		tkbar1 tkbar2 /*tkbar3*/ tkbarmax thres_tk1 thres_tk2 thres_tk3 eta_tk1 eta_tk2 /*eta_tk3*/ ///
		ttransfbar1 ttransfbar2 ttransfbar3 ttransfbarmax thres_ttransf1 thres_ttransf2 thres_ttransf3 eta_ttransf1 eta_ttransf2 eta_ttransf3 *		
	sort year
	compress
	save  "${calibwftax}/Reg/results_full.dta", replace


* III) Variant with a unique aggregate tax rate for year 1984  
*******************************************************************

* Program for tax parameters without any kink and any specific point for the very top	
	cap program drop aggregate_tax_rate 
	program aggregate_tax_rate 
		args var  
		local year 1984
		local rate one_rate
		local var tot_inc 
		use "${calibrawdata}/Tax Rates/temp_`year'_`rate'.dta", clear 
			g at_rate = t_`rate'*pondn
			collapse (sum) at_`rate' a`var', by(log`var'_bin label_perc`var')
			sort label_perc`var'	
			g taux_`rate'  = at_`rate'/a`var'
			g lt_`rate'    = log(1-taux_`rate')	
			reg lt_`rate' log`var'_bin [aw=a`var'], r	
			g t`rate'bar1  = round(1-exp(_b[_cons]),0.0001)
			g eta_t`rate'1 =round( _b[log`var'_bin],0.0001)
			keep t`rate'* eta*  
			duplicates drop		 
			g year=`year'
			order year tone_ratebar1 eta_tone_rate1
			save "${calibwftax}/Reg/results_one_rate.dta",replace
			*summ eta_t`rate'1
	end

* Launch Program
	aggregate_tax_rate   
