import numpy as _np
from scipy.fftpack import fft as _fft


def resolution(template, noisespectrum, energy = 1):
    template.normalize(inplace=True)
    template.data = template.data / energy
    frequencyspectrum = template.frequencyspectrum()

    nep = frequencyspectrum.data / noisespectrum.data
    sigma = 1 / _np.sqrt(_np.nansum(nep))
    resolution = 2 * _np.sqrt(2 * _np.log(2)) * sigma

    return resolution


def termination(r_out, r_in):
    termination = r_out / (r_out + r_in)

    return termination


def frequency(samplingrate, oversampling, samples):
    sampling = samplingrate / oversampling
    frequency = _fft.rfftfreq(samples, d = 1 / sampling)

    return frequency


def time(samples, oversampling, samplingrate, pretrigger):
    sampling = samplingrate / oversampling
    time = (_np.arange(samples) - pretrigger) / sampling

    return time


def flux(voltage, rf, mf):
    flux = voltage / (rf * mf)

    return flux


def voltage_conversion(voltagerange, coderange):
    voltage_conversion = voltagerange / coderange

    return voltage_conversion


def flux_conversion(rf, mf, voltagerange, coderange):
    voltage = voltage_conversion(voltagerange, coderange)
    fluxconversion = flux(voltage, rf, mf)

    return fluxconversion


def cutoff(tau):
    cutoff = 1 / (2 * _np.pi * tau)

    return cutoff