import pandas as _pd
import numpy as _np


def _get_unique_value(fitfile: _pd.DataFrame, key: str):
    values = fitfile[key]

    if not hasattr(values, '__iter__'):
        value = values
    else:
        valueSet = set(values)
        if len(valueSet) == 1:
            value = valueSet.pop()
        else:
            raise ValueError(f'Values of {key} are not unique.')

    return value


def _get_parameter(fitfile : _pd.DataFrame, prefix : str) -> dict:

    parameter = {}

    for key in fitfile.keys():
        if key.startswith(prefix + '_'):
            parameter[key[len(prefix) + 1:]] = _get_unique_value(fitfile, key)

    return parameter


def _get_distribution(input):
    if callable(input):
        function = input
    elif isinstance(input, str):
        def function():
            return input
    elif hasattr(input, '__iter__'):
        def function():
            return _np.random.choice(input)
    else:
        def function():
            return input
    
    return function


def _yield_prefix(columns : list, root : str):
    prefix_set = set(column.split('_')[0] for column in columns)

    for prefix in prefix_set:
        if prefix.startswith(root):
            yield prefix