 # mineral data for the Wr model; general data (densities, formulas, ...) + Wr sensu Palandra and Kharaka 2004 
# automize & get from a database later
# For illite (clay) and Hematite, zeros are entered as this mineral weathers very slow

Mineral <- c("augite","plagioclase","olivine","illite","chlorite","forsterite", "hematite")


density <- c(augite = 3.4,plagioclase = 2.73, olivine = 3.25, illite = 2.75, chlorite = 2.95, forsterite = 3.25, hematite = 5.26) #kg/L
molarmass <- c(augite = 236.36, plagioclase = 270.23, olivine = 170.97, illite = 383.90, chlorite = 555.73,  forsterite = 140.691, hematite = 159.69) #g/mol


atomicformula <- c("Ca0.9Mg0.9Na0.1Al0.4Fe0.2Si1.9Ti0.1O6","Ca0.5Na0.5Al1.5Si2.5O8", "Mg1.04Fe0.96SiO4 ","K0.6Mg0.25Al2.3Si3.5O10(OH)2","Mg5Al2Si3O10(OH)8","Mg2SiO4","Fe2O3") 


# create data frame with the properties in the columns and names of the mineral as row names

mineral_data <- data.frame(density = density, molarmass = molarmass, atomicformula = atomicformula, row.names = Mineral)



# Palandra and Kharaka 2004 Wr data

k_acid <- c(10^(-6.82),10^(-7.87),10^(-6.85),0,10^(-11.11),10^(-6.85),0) 
k_neutr <- c(10^(-11.97),10^(-10.91),10^(-10.64),0,10^(-12.52),10^(-10.64),0)
k_base <- c(0,4*10^(-15.6),0,0,10^(-21.2),0,0)
Ea_acid <- c(78,42.1,67.2,0,88,67.2,0)
Ea_neutr <- c(78,45.2,79,0,88,79,0)
Ea_base <- c(0,71,0,0,0,0,0)
n_acid <- c(0.7,0.626,0.47,0,0.5,0.47,0)
n_base <- c(0,-0.572,0,0,0,0,0)


# create data frame with the parameters in the columns, parameter names as the column names and names of the mineral as row names

Wr_data <- data.frame(k_acid = k_acid , k_neutr = k_neutr, k_base = k_base, Ea_acid = Ea_acid, Ea_neutr = Ea_neutr, Ea_base = Ea_base, n_acid = n_acid, n_base = n_base, row.names = Mineral)




