flux2pCO2 <- function(flux, temp, SWC, Bulkdensity, depth = 0.07, C_atmosphere = 424) {
  # flux in mol/m2/s
  # temp in °C
  # SWC in m3/m3
  # Bulkdensity in kg/m3
  # output in log atm
  # depth of system in m
  # C_atmosphere in ppmv  = µmol CO2/ mol air

  total_porosity <- 1- (Bulkdensity/2.65)
  SCE <-  flux    #mol/m2 area/s 
  Da_2 <- 1.47*10^(-5)*((273.15+temp)/273.15)^(1.75) #relationship from roland et al. 2015
  
  # total_porosity <-   1- (Bulkdensity/2.65)
  Airfilled_porosity <- total_porosity-SWC
  tortuosity <- (Airfilled_porosity^2/(total_porosity)^(2/3))
  Ds_2 <- tortuosity*Da_2 # m2 s-1
  
  dZ <-  depth # average depth system (m)
  molarvolume_air <- 101325 / (8.314*(273.15+temp)) # mol air /m³ air
  C_atmosphere <- C_atmosphere*molarvolume_air/10^(6) #mol CO2/ m³ air #realistc OK

    C_soil <- (SCE*dZ/Ds_2) + C_atmosphere # mol CO2/m3 air
    
    # C_soil_ppmv <- C_soil*10^(6)/molarvolume_air #ppmv
    
  if (C_soil < 0) {
    C_soil = 1 *10^(-10)
  }
    
  Soilpressure <- C_soil*8.314*(273.15+temp)    # pCO2 [Pa] 
  Soilpressure_logatm <- log10 (Soilpressure/101325.25) # pCO2 [log atm]
  
  return(Soilpressure_logatm)
}

relativemass2relativesurface <- function(massfraction, SSA, mineral_data){
  # compute relative surface of individual minerals based on spherical assumption of Volume to surface ratio
  # massfraction: vector of mass fractions of minerals in the rock
  # mineral_data: data frame with mineral properties (density, )
  # SSA: specific surface area of the rock [m²/g]
  density <- mineral_data[names(massfraction), "density"] # kg/L   # density of individual minerals in the rock
  rockdensity <- sum(massfraction/density)^(-1) # kg/L # total rock density
  volfrac <- (rockdensity*massfraction/density) # L/L   # volume fraction of each mineral in the rock
  Areafrac <- (volfrac)^(2/3) #m²/m² spherical assumption of surface to volume ratio
  RelativeSSA_vector <- Areafrac/sum(Areafrac) # [-]
  return(RelativeSSA_vector)
}
