library ("readxl")

treatments <- c("C1", "C3", "FB1", "FB3", "CB3", "FD3", "MD3", "CD3")

# uncomment when script is not called from the main script where simtime is defined
simtime <- 390 #days

# new data frame to interpolate all data; different models have different time variable names
new_Day <- data.frame(Day=seq(0, simtime, 1.0))
new_Day$DayCO2 <- new_Day$Day 
new_time_leaching <- data.frame(time_leaching=seq(0, simtime, 1.0))
new_DayCO2 <- data.frame(DayCO2=seq(0, simtime, 1.0))

# empty list of interpolation models and input vectors for PhreeqCentury model
modelT <- temperaturevectors <- list()
modelleaching <- flux_vectors <- list()
modelK <- K_vectors <- list()
modelCa <- Ca_vectors <- list()
modelMg <- Mg_vectors <- list()
modelTA_mgCaCO3_L <- TA_vectors<- list()
modelpH <- list()
modelFe <- Fe_vectors <- list()
modelAl <- Al_vectors <- list()
modelSi <- Si_vectors <- list()
modelSCE <- SCEvectors <- list()
modelSWC <- SWCvectors <- list()
modelSSA <- SSAvectors <- list()

for (tr in treatments){
  #read all data
  experimentaldata <- read_excel("./paper/Experimentalvectors.xlsx", sheet= tr)
  if (is.element(tr, c("C1", "C3"))){
    # interpolate Temperature, leachate_flux, Cations, pH and TA from controls 
    # add polynom to fit values at every time 
    modelT[[tr]] <- lm(Temperature~poly(DayCO2,5, raw= TRUE), data =experimentaldata)
    modelleaching[[tr]] <- lm(Leachateflux_L_d~poly(time_leaching,5, raw= TRUE), data =experimentaldata)
    # modelK[[tr]] <- lm(K~poly(time_leaching,3, raw= TRUE), data =experimentaldata)
    # modelCa[[tr]] <- lm(Ca~poly(time_leaching,3, raw= TRUE), data =experimentaldata)
    # modelMg[[tr]] <- lm(Mg~poly(time_leaching,3, raw= TRUE), data =experimentaldata)
    # modelTA_mgCaCO3_L[[tr]] <- lm(TA_mgCaCO3_L~poly(time_leaching,2, raw= TRUE), data =experimentaldata)
    # modelpH[[tr]] <- lm(pH~poly(time_leaching,3, raw= TRUE), data =experimentaldata)
    # modelFe[[tr]] <- lm(Fe~poly(time_leaching,3, raw= TRUE), data =experimentaldata)
    # modelAl[[tr]] <- lm(Al~poly(time_leaching,3, raw= TRUE), data =experimentaldata)
    # modelSi[[tr]] <- lm(Si~poly(time_leaching,3, raw= TRUE), data =experimentaldata)
    temperaturevectors[[tr]] <- predict(modelT[[tr]], newdata=new_Day)
    flux_vectors[[tr]] <- predict(modelleaching[[tr]], newdata=new_time_leaching)
    
    K_vectors[[tr]] <- experimentaldata$K[1]
    Mg_vectors[[tr]] <- experimentaldata$Mg[1]
    Ca_vectors[[tr]] <- experimentaldata$Ca[1]
    TA_vectors[[tr]] <- experimentaldata$TA_mgCaCO3_L[1]
    TA_vectors[[tr]][which(TA_vectors[[tr]]<0)] <- 0
#    data4$pH <- predict(modelpH, newdata=data4)
    Fe_vectors[[tr]] <- experimentaldata$Fe[1]
    Al_vectors[[tr]] <- experimentaldata$Al[1]
    Si_vectors[[tr]] <- experimentaldata$Si[1]
    }
  
  #  interpolate observed SCE, SWC  from all treatments to use as input for for all models control model
 
   # This can be done if there are datagaps for SCE, SWC or SSA, now we just use daily experimental data from the experimental file.
  # modelSCE[[tr]] <- lm(SCE~poly(DayCO2,3, raw= TRUE), data =experimentaldata)
  # modelSWC[[tr]] <- lm(SWC_~poly(DayCO2,5, raw= TRUE), data =experimentaldata)
  #SCEvectors[[tr]] <- predict(modelSCE[[tr]], newdata=new_DayCO2)
  # SWCvectors[[tr]] <- predict(modelSWC[[tr]], newdata=new_DayCO2)
  SCEvectors[[tr]] <- experimentaldata$SCE
  SWCvectors[[tr]] <- experimentaldata$SWC_
  
  #linear regression for  SSA datapoints (interpolate)
  modelSSA[[tr]] <- lm(SSA~poly(Day,1, raw= TRUE), data =experimentaldata) #use SWC dataset also for SSA.
  SSAvectors[[tr]] <- predict(modelSSA[[tr]], newdata=new_Day)
}