# #All treatments
treatments <- c("FB1","CB3","CD3","MD3","FD3","FB3")
i=4 #adapt i to run a different treatment 
treatment <- treatments[i]
##----specify treatment and associated control -------------------------------------
area = 0.22 #m2 (moved up, needed to calculate soil mass)

if (grepl(1, treatment)){ 
  control <- "C1"
  manure_mass <- 0.55 #kg 
  soilmass_control <- 30 + manure_mass #kg 
  soilmass <- soilmass_control
  SOC_content_init = 0.01 #% 
  total_porosity <-   0.35   #0.35 max soil water content for C1, 0.45 for C3.
  
} else {
  control <- "C3"
  manure_mass <- 3.35
  soilmass_control <- 30 + manure_mass
  soilmass <- soilmass_control
  SOC_content_init = 0.03
  total_porosity <-   0.45   #0.35 max soil water content for C1, 0.45 for C3.
  
}


if (grepl("D", treatment)){ # Dunite is applied
  rock_application <- 5 # ton/ha
  massfraction  <- c(forsterite = 0.93, hematite = 0.07) 
  Rockmass <-  area*rock_application/10 #kg 
  soilmass_with_rock <- soilmass_control + Rockmass
  soilmass <- soilmass_with_rock
} else { # Basalt is applied
  rock_application <- 100 # ton/ha
  massfraction  <- c(augite = 0.5, plagioclase = 0.325, olivine = 0.075, illite = 0.05, chlorite = 0.05) #g/g
  Rockmass <-  area*rock_application/10 #kg 
  soilmass_with_rock <- soilmass_control + Rockmass
  soilmass <- soilmass_with_rock
}



## ----setup---------------------------------------------------------------------------
library(phreeqc)
phrLoadDatabaseString(phreeqc.dat)
source("./paper/Batchmodel_SOM_phases_master_species.R")
source("./paper/functions.R")
source("./paper/phreeqify.R")
source("./paper/mineraldata.R")

time_days <- 1825 #days 
time_years <- time_days/365
simtime <- 390 #days

## ----read and preprocess data--------------------------------------------------------
source("./paper/Batchmodel_SOM_preprocessing.R")

# T, fluxes and leachates are always taken from control.
temperaturevector <- temperaturevectors[[control]] 
flux_vector <- flux_vectors[[control]] 
K_vector <- K_vectors[[control]] 
Mg_vector <- Mg_vectors[[control]] 
Ca_vector <- Ca_vectors[[control]] 
TA_vector <- TA_vectors[[control]] 
Fe_vector <- Fe_vectors[[control]] 
Al_vector <- Al_vectors[[control]] 
Si_vector <- Si_vectors[[control]] 

for (k in (1:2)){ 
  
  if (k == 1){
    # simulate control
    SCEvector <- SCEvectors[[control]] 
    SWCvector <- SWCvectors[[control]] 
    SSAvector <- SSAvectors[[control]]
    soilmass <- soilmass_control
  } else {
    # simulate treatment
    SCEvector <- SCEvectors[[treatment]] 
    SWCvector <- SWCvectors[[treatment]] 
    SSAvector <- SSAvectors[[treatment]]
    soilmass <-  soilmass_with_rock
    
    if (grepl("D", treatment)){ # Dunite is applied
      rock_application <- 5 # ton/ha
      massfraction  <- c(forsterite = 0.93, hematite = 0.07) 
      Rockmass <-  area*rock_application/10 #kg 
      soilmass_with_rock <- soilmass_control + Rockmass
      soilmass <- soilmass_with_rock
    } else { # Basalt is applied
      rock_application <- 100 # ton/ha
      massfraction  <- c(augite = 0.5, plagioclase = 0.325, olivine = 0.075, illite = 0.05, chlorite = 0.05) #g/g
      Rockmass <-  area*rock_application/10 #kg 
      soilmass_with_rock <- soilmass_control + Rockmass
      soilmass <- soilmass_with_rock
    }
  }
  
  
  
  ## ----definition of weathering model--------------------------------------------------
  # 1. Definition of the weathering model
  
  # 1.1 geometry and physical properties of soil
  SWC <- SWCvector[1] # Soil Water Content, replace by a vector in the loop 
  #for 1 mesocosm: 0.22 *0.14m = 30.8 L approx
  depth = 0.14 #m
  V_cell = 1000*depth*area # L 
  V_solution <- SWC*V_cell
  Bulkdensity <- 1.43 #for C3 
  
  
  # 1.2 initial pore water composition
  
  temp = temperaturevector[1] # degree centigrade
  Ca = Ca_vector[1]
  Mg = Mg_vector[1]
  Fe = Fe_vector[1]
  Al = Al_vector[1]
  Si = Si_vector[1] 
  TA = TA_vector[1]
  
  #other elements in mg/L 
  #"N(3)	10.84","N(5)	26.13"
  
  # 1.3 initial equilibrium phases composition
  # 1.3.1 solid equilibrium phases
  #TO DO: add initial amounts of calcite, dolomite, gibbsite and Fe later!!
  goethite = 2266*soilmass/1000/55.85 #mg/kg*kg/1000/g/mol = mol
  gibbsite = 153*soilmass/1000/26.98 
  FeOH3_a = 779*soilmass/1000/55.85
  AlOH3_a = 739*soilmass/1000/26.98
  calcite = 1196*soilmass/1000/40.08
  Nesquehonite = 217*soilmass/1000/24.305
  CaMontmorillonite = 0 
  Chlorite= 0 
  SiO2_a = 0
  
  #   Hematite = 0 # Hemtatite now defined as kinetitc species
  
  
  # 1.3.2 gas equilibrium phases
  # TODO: allow ppmv, % and or Pa as input for gas phases
  SCE <-  SCEvector[1] #mol/m2 area/s 
  Soilpressure_logatm <- flux2pCO2(SCE, temp, SWC,Bulkdensity, depth/2 ,C_atmosphere=424)
  Soilpressure_logatm <- unname(Soilpressure_logatm)
  
  # 1.4 Cation exchange complex and surface complexation
  #C3: 
  CEC <- 7.04 # meQ/100 g 
  CEC <- CEC*(soilmass*10)/1000 # mol 
  
  # not used for the time being:
  HFO_moles <- goethite+FeOH3_a                #moles Fe  
  HFO_mass <- HFO_moles * 88.85 #gFeOOH
  HFO_s <-HFO_moles*0.025
  
  # 1.5 characterize the rock
  #   massfraction  <- c(augite = 0.5, plagioclase = 0.325, olivine = 0.075, illite = 0.05, chlorite = 0.05) #g/g  #-> moved to top of file for clarity
  SSA = SSAvector[1] #approximately (fine basalt!)
  if (k == 1) {
    rockmass_init = 0 #no rock in the control
  } else {
    rockmass_init <- Rockmass*1000 #g rock in the entire volume
  }
  
  ## ----definition of SOC model---------------------------------------------------------
  # 2. Definition of the SOC model
  # Langmuir adsorption equilibrium incorporated by using SumDOC as state variable and expressing DOCf and DOCa as functions of SumDOC
  # 2.1 Specify SOC model parameters 
  clay = 0.04    # clay content in the soil 
  temp_K = unname(temp) + 293.15 # Incubation temperature (°K)
  moist = SWC  # Incubation moisture (unitless 0-1)
  ma = 0.45     # Fraction of metabolic litter going into active soil pool
  stra = 0.3    # Fraction of structural litter going into active soil pool
  ss = 0.3      # Fraction of structural litter going into slow soil pool
  ap = 0.004    # Fraction of active pool going to passive pool 
  as = 1 - (.85-.68*clay) - ap # Fraction of litter pool going to slow pool
  sa=0.42       # Fraction of slow pool going to active 
  sp=0.03       # Fraction of slow pool going to passive
  pa=0.45       # Fraction of passive pool going to active
  
  # Callibration control soil: 2 pool model tested , k1 and k2 from there. 
  #slow pool factor 6 lower than active pool. (from Camino-Serrano et al. 2018)
  #passive pool factor 462 lower than structural (from Camino-Serrano et al. 2018)
  factor <- 2.3
  params <- c(k1 =  0.008/factor, k2 = 0.004/factor , k3 = 0.008/factor,k4 =0.001333333/factor, k5 = 1.731602e-05/factor,  Q10 = 2 )
  
  Tmet= unname(1/params["k1"])*3600*24     #seconds 
  Tstr= unname(1/params["k2"])*3600*24 
  TDOCf=unname(1/params["k3"])*3600*24 
  Ts= unname(1/params["k4"])*3600*24
  Tp= unname(1/params["k5"])*3600*24
  Q10 =unname(params["Q10"])

  
  # if (k == 1) {  
  #   soilmass = 33.35  #30 kg soil + 3.35 kg dry manure
  # } else if (k == 2) {   soilmass = 33.35 +1.1 } #add basalt mass in kg if k =2
  
  LC = 0.41     # Lignin:Carbon ratio in litter
  # cow manure typically 6.1–14.4 % lignin & 25% C manure, so that LC = roughly between 6.1/25 and 14.4/25=0.244 to 0.576, avg value of 0.41 taken
  CN = 13       # soil C:N ratio
  # avg series 1 measurements after experiment
  litterfrac=0.85- 0.018*LC*CN # Metabolic litter fraction 
  
  Initial_Input <-  (SOC_content_init)*soilmass_control*10/area  # ton C/ha 
  #ton /ha
  soil_C_init = Initial_Input*area*10^(6)/10000/soilmass # g/kg 
  b_init = exp(0.32*log10(soil_C_init) + 3.3) # b is a parameter in the DOC adsorption model, and is computed internally from the modelled soil C content
  amendmenttime <- 0 # days
  I = 0           # no continuous Input (g C/m2/d of dry soil) 
  
  
  # Collect all parameters for SOC model
  parameters = c( area = area, # 1
                  b  = b_init, # 3
                  amendmenttime = amendmenttime, # 4
                  I = I, # 5
                  # Initial_Input = Initial_Input, # 6 ; not used as a parameter in the model, only to compute initial state
                  LC = LC, # 7
                  CN = CN, # 8
                  litterfrac = litterfrac, # 9
                  clay = clay, # 10
                  temp = temp_K, # 11
                  moist = SWC, # 12
                  ma = ma, # 13
                  stra = stra, # 14
                  ss = ss, # 15
                  ap = ap,# 16
                  as = as, # 17
                  sa=sa,# 18
                  sp=sp, # 19
                  pa=pa, # 20
                  Tmet=Tmet, # 21
                  Tstr = Tstr, # 22
                  TDOCf=TDOCf, # 23
                  Ts = Ts, # 24
                  Tp = Tp, # 25
                  Q10  = Q10, # 26
                  V_cell = V_cell, # 27
                  total_porosity = total_porosity, # 28
                  soil_mass = soilmass) # 29
  
  # 2.2 specify initial conditions of all SOC-pools; DOC is defined as a function of SumDOC here
  state_init <- c(Met = Initial_Input *litterfrac, 
                  Str = Initial_Input * (1-litterfrac),
                  SumDOC = 0, 
                   DOCf = 0, 
                  DOCa = 0,
                  S = 0,
                  P = 0
  )
  
  
  #
  # generate all phreeqc strings for weathering and SOC model
  #
  
  # generate phreeqc string for initial pore water compostion
  str_init1 <- phreeqify.solution(temperature = temp, 
                                  Ca = Ca, 
                                  Mg = Mg, 
                                  Fe = Fe, 
                                  Al = Al, 
                                  Si = Si, 
                                  Alkalinity = paste(TA, "gfw 100"), 
                                  water = V_solution)
  
  # generate phreeqc string for equilibrium phases
  str_equalize1 <- phreeqify.equi(si=c("CO2(g)" = Soilpressure_logatm, "Nesquehonite" = 1, "Calcite" = 1), # conservative assumption for carbonates 
                                  goethite = goethite, 
                                  gibbsite = gibbsite, 
                                  "Fe(OH)3(a)" = FeOH3_a, 
                                  "Al(OH)3(a)" = AlOH3_a, 
                                  "SiO2(a)" = SiO2_a,
                                  calcite = calcite, 
                                  Nesquehonite = Nesquehonite, 
                                  CaMontmorillonite = CaMontmorillonite, 
                                  Chlorite = Chlorite,
                                  # Hematite = Hematite, # hematite now defined as kinetic species
                                  "CO2(g)" = 1000)
  
  # generate phreeqc string for cation exchange complex
  str_exchange <- phreeqify.exchange(CEC = CEC)
  
  
  # TODO: phreeqify surface definition
  # currently not used
  # str_surface <- paste ("Surface 1", "Hfo_w", HFO_moles, 600, HFO_mass, "  -equilibrate 1")
  
  
  # generate phreeqc string for weathering kinetics and rates
  
  
  
  str_kinetics.weathering <- phreeqify.kinetics.weathering(massfraction = massfraction, rockmass = rockmass_init, SSA = SSA, mineral_data = mineral_data)
  str_rates.weathering <- phreeqify.rates.weathering(massfraction = massfraction, Wr_data = Wr_data)
  
  # generate phreeqc strings for SOC model kinetics and rates
  str_kinetics.soc <- phreeqify.kinetics.soc(state_init = state_init, 
                                             all_pars = parameters)
  str_rates.soc <- phreeqify.rates.soc(all_pars = parameters)
  
  
  # generate phreeqc string for output  
  str_output <- phreeqify.output()
  
  
  # Initial porewater in SOC model; not used in coupled model
  # SOC_pw_init <- c("SOLUTION 1", "temperature = 40") # distilled water
  
  ## ----run coupled model---------------------------------------------------------------
  str_all <- c(c(solutionmasterspecies,solutionspecies),
               phases,
               str_init1,
               str_equalize1,
               # str_surface,
               # str_exchange,
               c(str_rates.soc,str_rates.weathering[2:length(str_rates.weathering)]), # starting at element 2 to omit second RATES keyword
               c(str_kinetics.soc[1:(length(str_kinetics.soc)-1)],str_kinetics.weathering[2:length(str_kinetics.weathering)], "INCREMENTAL_REACTIONS true"),
               str_output ) # starting at element 2 to omit second KINETICS keyword
  
  cat(str_all, sep="\n", file = paste0("./paper/phreeqc_input_", treatment, ".txt"))
  
  phrRunString(str_all) 
  
  phrSOC_EW_out <- phrGetSelectedOutput()$n1
  
  # TODO: simplify this part
  capture.output({
    output1 <- invisible(as.matrix(phrSOC_EW_out[which(phrSOC_EW_out$time == 86400), ]))
  })
  
  #replace nrow = by the no of sim days
  outputmatrix <- matrix (0, nrow = simtime, ncol= length (output1))
  InorgCDR_mol_vector <- rep (0,nrow(outputmatrix))
  InorgCDR_mol_vector[1]<- sum(phrSOC_EW_out[3:nrow(phrSOC_EW_out),]$d_CO2.g.)
  outputmatrix [2,] <- output1
  Column_names <- colnames (output1)
  
  
  ## ------------------------------------------------------------------------------------
  # now run the model day by day, and update SWC, SCE and temperature each day, based on the interpolated vectors
  for (i in (2:(simtime-1))) {
    inputdf  <- as.data.frame(t(outputmatrix [i,]))
    colnames(inputdf) <- Column_names
    
    SWC <- SWCvector [i]
    SCE <- SCEvector [i]
    V_solution <- SWC* V_cell
    temp <- temperaturevector [i]
    
    # final pore water conditions from last model run 
    Ca <- inputdf$Ca.mol.kgw.
    Mg <- inputdf$Mg.mol.kgw.
    Fe <- inputdf$Fe.mol.kgw.
    Al <- inputdf$Al.mol.kgw.
    TA <- inputdf$Alkalinity.mol.kgw.
    Si <- inputdf$Si.mol.kgw.
    
    
    # equilibrium phases at start of next day (equal to final equilibrium phases at end of last day)
    # pCO2 is computed from SCE, the unterpolated flux observations
    Soilpressure_logatm <- flux2pCO2 (SCE, temp, SWC, Bulkdensity, depth/2 ,C_atmosphere = 424)
    Soilpressure_logatm <- unname(Soilpressure_logatm)
    
    goethite <- inputdf$goethite
    gibbsite <- inputdf$gibbsite
    FeOH3_a <- inputdf$Fe.OH.3.a.
    AlOH3_a <- inputdf$Al.OH.3.a.
    SiO2_a <- inputdf$SiO2.a.
    CaMontmorillonite <- inputdf$CaMontmorillonite
    Chlorite <- inputdf$Chlorite
    Calcite <- inputdf$calcite
    Nesquehonite <- inputdf$Nesquehonite
    #    Hematite <- inputdf$Hematite # Hematite now defined as kinetic species
    
    
    # surface complexation 
    # not used for the time being
    HFO_moles <- goethite+FeOH3_a                #moles Fe  
    HFO_mass <- HFO_moles * 88.85 #gFeOOH
    HFO_s <-HFO_moles*0.025
    str_surface <- paste ("Surface 1", "Hfo_w", HFO_moles, 600, HFO_mass, "  -equilibrate 1")
    
    # cation exchange at the end of the last day
    CEC = inputdf$m_AlX3.mol.kgw. + inputdf$m_CaX2.mol.kgw. + inputdf$m_MgX2.mol.kgw. + inputdf$m_KX.mol.kgw. + inputdf$m_NaX.mol.kgw. +inputdf$m_FeX2.mol.kgw.
    
    # rock composition, relative mass fractions, computed from former model step
    # m <- c(inputdf$k_augite,inputdf$k_plagioclase,  inputdf$k_olivine, m0[4], m0[5])
    # m <- c(augite = inputdf$k_augite,plagioclase = inputdf$k_plagioclase, olivine = inputdf$k_olivine, illite =inputdf$k_illite, chlorite = inputdf$k_chlorite)
    
    m <- NULL
    for (mineral in names(massfraction)){
      m <- c(m, inputdf[[paste0("k_", mineral)]])
    }
    names(m) <- names(massfraction)
    basaltmass <- sum(m*mineral_data[names(m), "molarmass"])
    if (basaltmass < 0.0001) {basaltmass <- 0.0001} # avoid division by zero
    massfraction <- (m*mineral_data[names(m), "molarmass"])/basaltmass
    SSA = SSAvector[i]
    
    # generate phreeqc string for initial pore water compostion at start of next day (equal to final pore water composition at end of last day)
    str_init1 <- phreeqify.solution(units ="mol/kgw",
                                    temperature = temp, 
                                    Ca = Ca, 
                                    Mg = Mg, 
                                    Fe = Fe, 
                                    Al = Al, 
                                    Si = Si, 
                                    Alkalinity = TA, 
                                    water = V_solution)  
    
    # generate phreeqc string for equilibrium phases at start of next day (equal to final equilibrium phases at end of last day)
    str_equalize1 <- phreeqify.equi(si=c("CO2(g)" = Soilpressure_logatm, "Nesquehonite" = 1, "Calcite" = 1), # conservative assumption for carbonates 
                                    goethite = goethite, 
                                    gibbsite = gibbsite, 
                                    "Fe(OH)3(a)" = FeOH3_a, 
                                    "Al(OH)3(a)" = AlOH3_a, 
                                    "SiO2(a)" = SiO2_a,
                                    Calcite = Calcite, 
                                    Nesquehonite = Nesquehonite, 
                                    CaMontmorillonite = CaMontmorillonite, 
                                    Chlorite = Chlorite, 
                                    # Hematite = Hematite, # hematite now defined as kinetic species
                                    "CO2(g)" = 1000)
    
    # generate phreeqc string for cation exchange complex at start of next day (equal to final cation exchange complex at end of last day)
    str_exchange <- phreeqify.exchange(CEC = CEC)
    
    # generate phreeqc string for weathering kinetics; rates remain the same
    str_kinetics.weathering <- phreeqify.kinetics.weathering(massfraction = massfraction, rockmass = basaltmass, SSA = SSA, mineral_data = mineral_data)
    
    # generate phreeqc string for SOC model kinetics and rates
    #TO DO : adapt SOC_kinetics 
    state_init <- c(
      Met = inputdf$k_Met,
      Str = inputdf$k_Str,
      P = inputdf$k_Pass,
      S = inputdf$k_Slow,
      SumDOC = inputdf$DOCa + inputdf$DOCf
    )
    
    str_kinetics.soc <- phreeqify.kinetics.soc(state_init = state_init, 
                                               all_pars = parameters)
    
    
    
    #run opnieuw
    str_all <- c(c(solutionmasterspecies,solutionspecies),
                 phases,
                 str_output, 
                 str_init1,
                 str_equalize1,
                 # str_exchange,
                 c(str_rates.soc ,str_rates.weathering[2:length(str_rates.weathering)]),
                 c(str_kinetics.soc[1:(length(str_kinetics.soc)-1)],str_kinetics.weathering[2:length(str_kinetics.weathering)], "INCREMENTAL_REACTIONS true"))
    phrRunString(str_all)
    
    phrSOC_EW_out <- phrGetSelectedOutput()$n1
    
    output <- as.matrix (phrSOC_EW_out[which(phrSOC_EW_out$time==86400),])
    #haal output eruit steek in resultmatrix
    outputmatrix [i+1,] <- output
    Column_names <- colnames (output)
    
    InorgCDR_mol_vector[i]<- sum(phrSOC_EW_out[3:nrow(phrSOC_EW_out),]$d_CO2.g.)
    
  }
  
  
  ## ------------------------------------------------------------------------------------
  df  <- as.data.frame((outputmatrix))
  colnames(df) <- Column_names
  
  #plot minerals (mol/column in time)
  plot (df$k_augite)
  points (df$k_olivine, col='red')
  points (df$k_plagioclase,col='blue')
  
  #secondary minerals
  plot (df$gibbsite, ylim = c(0,4))
  points (df$goethite, col='red')
  
  
  #inorg CDR:
  df$InorgCDR_tonCO2ha <- cumsum(abs (InorgCDR_mol_vector))*44*10000/0.22/1000/1000 #ton CO2/ha
  df$InorgCDR_tonCha  <- df$InorgCDR_tonCO2ha*12/44
  #about 1.6 ton CO2 ha-1 
  
  #plot elements
  plot(df$Ca.mol.kgw.)
  plot(df$Mg.mol.kgw.)
  plot(df$Fe.mol.kgw.)
  plot(df$Al.mol.kgw.)
  
  #plot organic pools
  plot (df$k_Met)
  points (df$k_Str, col='red')
  points (df$k_Slow,col='blue')
  points (df$k_Pass,col='orange')
  points (df$DOCf,col='yellow')
  points (df$DOCa, col = "green") 
  
  
  df$cumulative_CO2emission <- abs(df$soilC[2]-df$soilC) #tonC/ha (from organics)
  df$actualCO2emission_tonCha <- df$cumulative_CO2emission  - df$InorgCDR_tonCha
  df$days <- seq (0:(simtime-1))
  
  if (k == 1) {data_control = df} 
  if(k == 2) {  data_rock = df  }
}
library (writexl)
data_rock$type <- "rock"
data_control$type <- "control"
# Merge the two data frames using rbind
merged_data <- rbind(data_rock, data_control)

# output_path <- paste0("C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_/Simulationdata_",treatment,".xlsx")
output_path <- paste0("./paper/output/Simulationdata_",treatment,".xlsx")
write_xlsx(merged_data, path = output_path)   


#data_control check. 

# setwd("C:/Users/AVienne/OneDrive - Universiteit Antwerpen/organicphreeqc_coupling/paper")
# library(readxl)
# data <- read_excel("CO2_temperature_SWC_treatment.xlsx", sheet = "Sheet1", col_names = TRUE)
# colnames(data) <- c("time", "treatment", "temperature", "SWC", "secumul", "CO2","tonCO2_ha_d", "SCE")
# data_original <- data
# data <- data[which(data$treatment == "C3"),]
# library (dplyr)
# data <- data %>% arrange(time)
# data <- data %>% mutate(across(c(time, CO2, SWC, temperature), as.numeric))
# data$CO2 <- data$CO2 * 12 / 44  # Convert CO2 to ton C/ha
# 
#plot
# plot(data_control$actualCO2emission_tonCha, col = "red")
# points (data$time, data$CO2, col = "green")








