#setwd ("C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_")
setwd("C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_/submission/Zenodo_data_scripts")
data <- read_excel("Calcimetry_19_4_2023.xlsx", sheet = "Ranalysis", col_names = T)

library (dplyr)
library (Rmisc)
library(tidyr)

data$Treatment <- paste0(data$silicate,data$SOC)
data <- data %>%
  mutate(rock = case_when(
    Treatment %in% c("FB1", "FB3","CB3") ~ "basalt",
    Treatment %in% c("MD3", "CD3","FD3") ~ "dunite",
  ))


##### split datasets  & model 
data$sizedunite <- as.numeric (with(data, 
                                    ifelse(Treatment == "FD3", 71, 
                                           ifelse(Treatment == "MD3", 278, 
                                                  ifelse(Treatment == "CD3", 1030, 
                                                         ifelse(Treatment %in% c("FB1", "FB3"), 0, 
                                                                ifelse(Treatment == "CB3", 0, 0)))))))
data$sizebasalt <- as.numeric (with(data, 
                                    ifelse(Treatment == "FD3", 0, 
                                           ifelse(Treatment == "MD3", 0, 
                                                  ifelse(Treatment == "CD3", 0, 
                                                         ifelse(Treatment %in% c("FB1", "FB3"), 292, 
                                                                ifelse(Treatment == "CB3", 670, 0)))))))


data$rock <-  with(data, 
                   ifelse(Treatment == "FB3", "Basalt", 
                          ifelse(Treatment == "CB3","Basalt" ,
                                 ifelse(Treatment == "FB1","Basalt" ,
                                        ifelse(Treatment == "C1","aNone" ,
                                               ifelse(Treatment == "C3", "aNone","Dunite"))))))

data$SOC  <- as.numeric (with(data, 
                              ifelse(Treatment == "C1", 1, 
                                     ifelse(Treatment == "FB1", 1, 3))))

#split dataset 
dataFB_C <- data[which(data$Treatment=="C1"|data$Treatment=="C3"|data$Treatment=="FB3"|data$Treatment=="FB1"),]
dataD_B_size <- data[-which(data$Treatment=="C1"|data$Treatment=="FB1"),]

#basalt x SOC model, N = 10
model <- lm (data= dataFB_C, deltaSIC ~ SOC)
summary (model)   #SOC: + p<0.01
qqnorm(residuals(model))
hist(residuals(model))


#dunite, logical, N=26
model <- lm (data= dataD_B_size, deltaSIC ~ rock + sizebasalt + sizedunite )
summary (model)
#so if the rock is dunite, the delta SIC is more negative. 
qqnorm(residuals(model))
hist(residuals(model))
vif(model)  #max 5.5 for rock, acceptable 


#vizualization
sum = summarySE(data[complete.cases(data$deltaSIC),] ,measurevar="deltaSIC", groupvars=c("silicate","SOC","Time_d"))
library(dplyr)
sum <- sum %>%
  mutate(SOC = replace_na(SOC, 3)) %>%
  mutate(Treatment = paste0(silicate, SOC))

treatment_order <- c("C1", "FB1", "C3","CB3","FB3","CD3","MD3","FD3")
# Convert Treatment column to factor with the specified order
sum$Treatment <- factor(sum$Treatment, levels = treatment_order)
calcimetryFig <- ggplot(sum, aes_string("Treatment", "deltaSIC", col = "Treatment", shape = "Treatment", size = "Treatment", fill = "Treatment" )) +
  theme_bw() + theme(axis.title.y = element_text(size= 10), axis.title.x = element_text(size= 10), axis.title = element_text(face = "bold")) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour= "black"))+
  geom_point() + geom_line (size = 1, linetype = "dotted") +
  geom_errorbar(aes_string(ymin = paste0("deltaSIC", "-se"), ymax = paste0("deltaSIC", "+se")), size = 0.1, width = 0.1) +
  scale_shape_manual(values = c("C1" = 22, "FB1" = 21, "C3" = 22, "CB3" = 21, "CD3" = 23, "FB3" = 21, "FD3" = 23, "MD3" = 23)) + 
  scale_size_manual(values = c("C1" = 4, "FB1" = 2, "C3" = 4, "CB3" = 6, "CD3" = 6, "FB3" = 2, "FD3" = 2, "MD3" = 4)) + 
  scale_color_manual(values = c("C1" = "black", "FB1" = "grey", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
  scale_fill_manual(values = c("C1" = "white", "FB1" = "white", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
  ylab("Delta SIC \n (119 days) \n (%)") + xlab("Treatment")+
  annotate("text", x = Inf, y = -Inf, label = "+ p(SOC) < 0.01", hjust = 1.1, vjust = -3.5, size = 3.5) +
  annotate("text", x = Inf, y = -Inf, label = "+ p(D size) < 0.01", hjust = 1.1, vjust = -5, size = 3.5) +
  annotate("text", x = Inf, y = -Inf, label = "- p(D) = 0.01", hjust = 1.1, vjust = -6.5, size = 3.5) 


output_path <- "C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_/calcimetryFig.jpeg"
ggsave(filename = output_path, plot = calcimetryFig, width = 4.5, height = 4.5, units = "in", dpi = 600)











#temperature 
setwd ("C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_/curve_fitting_SoilR")
data <- read_excel("CO2_temperature_SWC_treatment.xlsx", sheet = "Sheet1", col_names = T)


sum = summarySE(data ,measurevar="temperature", groupvars=c("Day ","treatment"))
sum <- sum[which (sum$treatment=="C1"),]

temperatureplot <- ggplot(sum, aes_string("Day", "temperature")) +
  theme_bw() + theme(axis.title.y = element_text(size= 10), axis.title.x = element_text(size= 10), axis.title = element_text(face = "bold")) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour= "black"))+
  geom_point() + geom_line (size = 1, linetype = "dotted") +
  ylab("Temperature\n (°C)") + xlab("Time\n (Days)")

output_path <- "C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_/temperature.jpeg"
ggsave(filename = output_path, plot = temperatureplot, width = 6, height = 6, units = "in", dpi = 600)

#SWC 
sum = summarySE(data ,measurevar="SWC", groupvars=c("Day ","treatment"))
sum$Treatment <- sum$treatment
treatment_order <- c("C1", "FB1", "C3","CB3","FB3","CD3","MD3","FD3")
# Convert Treatment column to factor with the specified order
sum$Treatment <- factor(sum$Treatment, levels = treatment_order)
treatment_order <- c("C1", "FB1", "C3","CB3","FB3","CD3","MD3","FD3")
# Convert Treatment column to factor with the specified order
sum$Treatment <- factor(sum$Treatment, levels = treatment_order)

#stats SWC
##### split datasets  & model 
data$sizedunite <- as.numeric (with(data, 
                                    ifelse(treatment == "FD3", 71, 
                                           ifelse(treatment == "MD3", 278, 
                                                  ifelse(treatment == "CD3", 1030, 
                                                         ifelse(treatment %in% c("FB1", "FB3"), 0, 
                                                                ifelse(treatment == "CB3", 0, 0)))))))
data$sizebasalt <- as.numeric (with(data, 
                                    ifelse(treatment == "FD3", 0, 
                                           ifelse(treatment == "MD3", 0, 
                                                  ifelse(treatment == "CD3", 0, 
                                                         ifelse(treatment %in% c("FB1", "FB3"), 292, 
                                                                ifelse(treatment == "CB3", 670, 0)))))))


data$rock <-  with(data, 
                   ifelse(treatment == "FB3", "Basalt", 
                          ifelse(treatment == "CB3","Basalt" ,
                                 ifelse(treatment == "FB1","Basalt" ,
                                        ifelse(treatment == "C1","aNone" ,
                                               ifelse(treatment == "C3", "aNone","Dunite"))))))

data$SOC  <- as.numeric (with(data, 
                              ifelse(treatment == "C1", 1, 
                                     ifelse(treatment == "FB1", 1, 3))))

dataFB_C <- data[which(data$treatment=="C1"|data$treatment=="C3"|data$treatment=="FB3"|data$treatment=="FB1"),]
dataD_B_size <- data[-which(data$treatment=="C1"|data$treatment=="FB1"),]

#basalt x SOC model
model <- lm (data= dataFB_C, SWC ~ rock * SOC)
summary (model)   #SOC: + p<0.0
#dunite, logical
model <- lm (data= dataD_B_size, SWC ~ rock + sizebasalt + sizedunite )
summary (model) 



model <- lm (data=data, SWC ~ treatment)
summary (model)


SWCplot <- ggplot(sum, aes_string("Day", "SWC", col = "Treatment", shape = "Treatment", size = "Treatment", fill = "Treatment" )) +
  theme_bw() + theme(axis.title.y = element_text(size= 10), axis.title.x = element_text(size= 10), axis.title = element_text(face = "bold")) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour= "black"))+
  geom_point() +
  scale_shape_manual(values = c("C1" = 22, "FB1" = 21, "C3" = 22, "CB3" = 21, "CD3" = 23, "FB3" = 21, "FD3" = 23, "MD3" = 23)) + 
  scale_size_manual(values = c("C1" = 1.5, "FB1" = 0.5, "C3" = 1.5, "CB3" = 2.5, "CD3" = 2.5, "FB3" = 0.5, "FD3" = 0.5, "MD3" = 1.5)) + 
  scale_color_manual(values = c("C1" = "black", "FB1" = "grey", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
  scale_fill_manual(values = c("C1" = "white", "FB1" = "white", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
  ylab("Soil water content\n (%)") + xlab("Time\n (Days)")

SWC_T_plot <-  plot_grid(SWCplot, temperatureplot, labels = "AUTO", ncol = 2)

output_path <- "C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_/SWC_T_plot.jpeg"
ggsave(filename = output_path, plot = SWC_T_plot, width = 10, height = 6, units = "in", dpi = 600)

#Cumulative leachate volume
data <- read_excel("Leachate_soil_dataframe.xlsx", sheet = "leachate", col_names = T)
data$V_mL <- as.numeric (data$V_mL)
sum = summarySE(data[complete.cases(data$V_mL),] ,measurevar="V_mL", groupvars=c("Treatment","Dayafteramendment"))
sum <- sum[-which(sum$Treatment=="C1Bac" | sum$Treatment=="FB1Bac" ),]

dayvector <- rep (unique(sum$Dayafteramendment),  length((unique(sum$Treatment))))
treatmentvector <- rep (unique(sum$Treatment), each = length(unique(sum$Dayafteramendment)))
cumVolume <- rep (0, length(unique(sum$Dayafteramendment)) * length(unique((sum$Treatment))))
cumse <- rep (0, length(unique(sum$Dayafteramendment)) * length(unique((sum$Treatment))))

for (i in (1: length(unique(sum$Dayafteramendment)))) {
  for (j in (1: length(unique((sum$Treatment)))))   {
    treatment <- unique((sum$Treatment))[j]
    Day <- unique((sum$Dayafteramendment))[i]
    V_mL <- sum[which (sum$Treatment == treatment & sum$Dayafteramendment == Day),]$V_mL
    se <- sum[which (sum$Treatment == treatment & sum$Dayafteramendment == Day),]$se
    
    if (i ==1 & j == 1 ) {
      cumVolume[i+ length(unique(sum$Dayafteramendment))*(j-1)] <- V_mL 
      cumse [i+ length(unique(sum$Dayafteramendment))*(j-1)] <- se
    }
    else {
      cumVolume[i+ length(unique(sum$Dayafteramendment))*(j-1)] <- V_mL + cumVolume[i-1 + length(unique(sum$Dayafteramendment))*(j-1)]
      cumse [i+ length(unique(sum$Dayafteramendment))*(j-1)] <- sqrt (se^2 +  (cumVolume[i-1 + length(unique(sum$Dayafteramendment))*(j-1)])^2)
      
      if (i == 1 & j > 1 ) { cumVolume[i+ length(unique(sum$Dayafteramendment))*(j-1)] <-   cumVolume[i+ length(unique(sum$Dayafteramendment))*(j-1)] -  cumVolume[length(unique(sum$Dayafteramendment))*(j-1)]
      cumse[i+ length(unique(sum$Dayafteramendment))*(j-1)] <-   se
      }
    }}}

df <- as.data.frame(cbind (dayvector, cumVolume, treatmentvector, cumse))
df$Treatment <- df$treatmentvector
df$cumVolume <- as.numeric (df$cumVolume)

df <- df[which(df$dayvector== max (df$dayvector)),]
treatment_order <- c("C1", "FB1", "C3","CB3","FB3","CD3","MD3","FD3")
# Convert Treatment column to factor with the specified order
df$Treatment <- factor(df$Treatment, levels = treatment_order)


V_leachate_plot <- ggplot(df, aes_string("Treatment", "cumVolume", col = "Treatment", shape = "Treatment", size = "Treatment", fill = "Treatment" )) +
  theme_bw() + theme(axis.title.y = element_text(size= 10), axis.title.x = element_text(size= 10), axis.title = element_text(face = "bold")) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour= "black"))+
  geom_point() + 
  geom_errorbar(aes_string(ymin = paste0("cumVolume", "-se"), ymax = paste0("cumVolume", "+se")), size = 0.1, width = 0.1) +
  scale_shape_manual(values = c("C1" = 22, "FB1" = 21, "C3" = 22, "CB3" = 21, "CD3" = 23, "FB3" = 21, "FD3" = 23, "MD3" = 23)) + 
  scale_size_manual(values = c("C1" = 4, "FB1" = 2, "C3" = 4, "CB3" = 6, "CD3" = 6, "FB3" = 2, "FD3" = 2, "MD3" = 4)) + 
  scale_color_manual(values = c("C1" = "black", "FB1" = "grey", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
  scale_fill_manual(values = c("C1" = "white", "FB1" = "white", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
  ylab("Volume\n (mL)") + xlab("")+
  theme(axis.text.x = element_blank(), axis.ticks.x = element_blank(), axis.text.y = element_text(size = 10))   # Remove x-axis text and ticks

#5.7 L / 1000 / 0.22 / 392 = m3/m2/d = 6.609462e-05 m/d
# * 365 = 0.02412454 m / y
# 24 mm / y ? 

#water input = 1L / mesocosm / week 
# 1/7/0.22/1000 = 0.0006493506 m3/m2 / d

#10 percent leached: 6.609462e-05 m/d / 0.0006493506

output_path <- "C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_/V_leachate.jpeg"
ggsave(filename = output_path, plot = V_leachate_plot, width = 6, height = 6, units = "in", dpi = 600)


