#solute figures Lab experiment 3: 
# averages DIC, TA , 
library ("Rmisc")
library ("ggplot2")
library ("readxl")
setwd ("C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_")
data <- read_excel("Leachate_soil_dataframe.xlsx", sheet = "leachate", col_names = T)
data <- data[-which(data$Bacillus=="Yes"),]


yvariables <- c("DIC_mg_L", "DOC_mg_L", "TA_mEQ_L", "pH", "Ca",	"Mg",	"Na",	"K","Fe",	"Al",	"Si",	"Ni",	"P")
ylabs <- c("DIC \n (mg L-1)","DOC \n (mg L-1)","TA \n (mEq L-1)", "pH", "Ca \n (mg L-1)","Mg \n (mg L-1)", "Na \n (mg L-1)", "K \n (mg L-1)","Fe \n (mg L-1)", "Al \n (mg L-1)", "Si \n (mg L-1)", "Ni \n (mg L-1)", "P \n (mg L-1)")

#bereken alle yvariables new 
data$Ca_mg <- data$Ca * (as.numeric (data$V_mL) / 1000)
data$Mg_mg <- data$Mg * (as.numeric (data$V_mL) / 1000)
data$DIC_mg <- data$DIC_mg_L * (as.numeric (data$V_mL) / 1000)
data$DOC_mg <- data$DOC_mg_L * (as.numeric (data$V_mL) / 1000)
data$TA_mEQ <- data$TA_mEQ_L * (as.numeric (data$V_mL) / 1000)
data$Na_mg <- data$Na * (as.numeric (data$V_mL) / 1000)
data$K_mg <- data$K * (as.numeric (data$V_mL) / 1000)
data$Ni_mg <- data$Ni * (as.numeric (data$V_mL) / 1000)
data$Fe_mg <- data$Fe * (as.numeric (data$V_mL) / 1000)
data$Al_mg <- data$Al * (as.numeric (data$V_mL) / 1000)
data$P_mg <- data$P * (as.numeric (data$V_mL) / 1000)
data$Si_mg <- data$Si * (as.numeric (data$V_mL) / 1000)

#
ylabsnew <- c("DIC \n (mg)","DOC \n (mg)","TA \n (mEq)", "pH", "Ca \n (mg)","Mg \n (mg)", "Na \n (mg)", "K \n (mg)","Fe \n (mg)", "Al \n (mg)", "Si \n (mg)", "Ni \n (mg)", "P \n (mg)")
yvariablesnew <- c("DIC_mg", "DOC_mg", "TA_mEQ", "pH", "Ca_mg",	"Mg_mg",	"Na_mg",	"K_mg","Fe_mg",	"Al_mg",	"Si_mg",	"Ni_mg",	"P_mg")


myplotsavgnew <- list()  # new empty list
myplots_allintimenew <- list()  # new empty list


for (i in 1:length(yvariablesnew)) {
  yvar = yvariablesnew[i]
  lab = ylabsnew [i]
  
  sum = summarySE( data[complete.cases(data[[yvar]]),] ,measurevar=yvar,groupvars=c("Treatment","Dayafteramendment", "silicate_type"))
  treatment_order <- c("C1", "FB1", "C3","CB3","FB3","CD3","MD3","FD3")
  # Convert Treatment column to factor with the specified order
  sum$Treatment <- factor(sum$Treatment, levels = treatment_order)
  
  plot_time <-  ggplot(sum, aes_string("Dayafteramendment ", yvar, col = "silicate_type", shape = "Treatment", size = "Treatment", fill = "Treatment" ) )+
    theme_bw() + geom_point() + 
    scale_shape_manual(values = c("C1" = 22, "FB1" = 21, "C3" = 22, "CB3" = 21, "CD3" = 23, "FB3" = 21, "FD3" = 23, "MD3" = 23)) + 
    scale_size_manual(values = c("C1" = 4, "FB1" = 2, "C3" = 4, "CB3" = 6, "CD3" = 6, "FB3" = 2, "FD3" = 2, "MD3" = 4)) + 
    scale_color_manual(values = c("C1" = "black", "FB1" = "grey", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
    scale_fill_manual(values = c("C1" = "white", "FB1" = "white", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
    geom_errorbar(aes_string(ymin = paste0(yvar, "-se"), ymax = paste0(yvar, "+se")), size = 0.1)   +
    theme(axis.title.y = element_text(size= 10), axis.title.x = element_text(size= 10), axis.title = element_text(face = "bold")) +
    theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour= "black")) +
    ylab(lab) + xlab("Time \n (Days)") +  theme(legend.position = "none")
  myplots_allintimenew[[i]] <- plot_time  
  
  
  #avg in time
  sum = summarySE(data[complete.cases(data[[yvar]]),], measurevar = yvar, groupvars = c("Treatment","silicate_type"))
  sum <- subset(sum, !is.na(Treatment) & !Treatment %in% c("C1Bac", "FB1Bac"))
  treatment_order <- c("C1", "FB1", "C3","CB3","FB3","CD3","MD3","FD3")
  # Convert Treatment column to factor with the specified order
  sum$Treatment <- factor(sum$Treatment, levels = treatment_order)
  plot2 <- ggplot(sum, aes_string("Treatment", yvar, col = "Treatment", shape = "Treatment", size = "Treatment", fill = "Treatment" ) )+
    theme_bw() + geom_point() + 
    scale_shape_manual(values = c("C1" = 22, "FB1" = 21, "C3" = 22, "CB3" = 21, "CD3" = 23, "FB3" = 21, "FD3" = 23, "MD3" = 23)) + 
    scale_size_manual(values = c("C1" = 4, "FB1" = 2, "C3" = 4, "CB3" = 6, "CD3" = 6, "FB3" = 2, "FD3" = 2, "MD3" = 4)) + 
    scale_color_manual(values = c("C1" = "black", "FB1" = "grey", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
    scale_fill_manual(values = c("C1" = "white", "FB1" = "white", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
    geom_errorbar(aes_string(ymin = paste0(yvar, "-se"), ymax = paste0(yvar, "+se")), size = 0.5)   +
    theme(axis.title.y = element_text(size= 10), axis.title.x = element_text(size= 10), axis.title = element_text(face = "bold")) +
    theme(axis.text.x = element_blank(), axis.ticks.x = element_blank(), axis.text.y = element_text(size = 10)) +  # Remove x-axis text and ticks
    theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour= "black")) +
    ylab(lab) + xlab("")+
    theme(legend.position = "none")
  
  myplotsavgnew[[i]] <- plot2 
  
}





#do stats!
#Stats solutes
library("lme4")
library("car")
setwd ("C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_")
#yvariables <- c("DIC_mg_L", "DOC_mg_L", "TA_mEQ_L", "pH", "Ca",	"Mg",	"Na",	"K","Fe",	"Al",	"Si",	"Ni",	"P")
yvariables <- yvariablesnew
#data <- read_excel("Leachate_soil_dataframe.xlsx", sheet = "leachate", col_names = T)
#####
data$sizedunite <- as.numeric (with(data, 
                                    ifelse(Treatment == "FD3", 71, 
                                           ifelse(Treatment == "MD3", 278, 
                                                  ifelse(Treatment == "CD3", 1030, 
                                                         ifelse(Treatment %in% c("FB1", "FB3"), 0, 
                                                                ifelse(Treatment == "CB3", 0, 0)))))))
data$sizebasalt <- as.numeric (with(data, 
                                    ifelse(Treatment == "FD3", 0, 
                                           ifelse(Treatment == "MD3", 0, 
                                                  ifelse(Treatment == "CD3", 0, 
                                                         ifelse(Treatment %in% c("FB1", "FB3"), 292, 
                                                                ifelse(Treatment == "CB3", 670, 0)))))))


data$rock <-  with(data, 
                   ifelse(Treatment == "FB3", "Basalt", 
                          ifelse(Treatment == "CB3","Basalt" ,
                                 ifelse(Treatment == "FB1","Basalt" ,
                                        ifelse(Treatment == "C1","aNone" ,
                                               ifelse(Treatment == "C3", "aNone","Dunite"))))))

data$SOC  <- as.numeric (with(data, 
                              ifelse(Treatment == "C1", 1, 
                                     ifelse(Treatment == "FB1", 1, 3))))

### split dataset
datafullfact <- data[which(data$Treatment=="C1"|data$Treatment=="C3"|data$Treatment=="FB1"|data$Treatment=="FB3"),]
datapsize <- data[-which(data$Treatment=="C1"|data$Treatment=="FB1"),]
#### make vectors
p_values_amended_D <-  rep (0, length (yvariables))
p_values_size_D <-  rep (0, length (yvariables))
p_values_size_B <-  rep (0, length (yvariables))
p_values_SOC_B <-  rep (0, length (yvariables))
p_values_amended_B <-  rep (0, length (yvariables))
p_values_SOC_silicate_B <-  rep (0, length (yvariables))
p_values_amended_B_3percent <-  rep (0, length (yvariables))

effects_amended_D <-  rep (0, length (yvariables))
effects_size_D <-  rep (0, length (yvariables))
effects_size_B <-  rep (0, length (yvariables))
effects_SOC_B <-  rep (0, length (yvariables))
effects_amended_B <-  rep (0, length (yvariables))
effects_SOC_silicate_B <-  rep (0, length (yvariables))
effects_amended_B_3percent<-  rep (0, length (yvariables))
#####

#  dataBasaltControl <- data[which(data$silicate_type=="Basalt"|data$silicate_type=="Control"),]
# dataBasaltControl$size <- with(dataBasaltControl, ifelse(Treatment %in% c("FB1", "FB3"), 292, 
#                                            ifelse(Treatment == "CB3", 670, 0)))
# dataBasaltControl$SOC <- with(dataBasaltControl, ifelse(Treatment %in% c("FB1", "C1"), 1, 
#                                           ifelse(Treatment %in% c("CB3", "FB3"), 3, 3)))
# dataBasaltControl$amended <- with(dataBasaltControl, ifelse(Treatment %in% c("C1", "C3"), 0, 1))
# #only 3% for size effect
# 
# dataBasalt3 <- dataBasaltControl[which(dataBasaltControl$silicate_type=="Basalt" & dataBasaltControl$SOC == 3),]
# 
#  dataControlDunite <- data[which(data$silicate_type == "Control"|data$silicate_type == "Dunite" ),]
#   dataControlDunite$SOC <- ifelse(dataControlDunite$Treatment == "C1", 1, 3)
#  dataControlDunite$amended  <- with(dataControlDunite, ifelse(Treatment %in% c("C1", "C3"), 0, 1))
#    
#  dataDuniteControl3 <- dataControlDunite[which (dataControlDunite$SOC == 3),]
#  
#  dataDuniteControl3$size <- with(dataDuniteControl3, 
#                        ifelse(Treatment == "FD3", 71, 
#                        ifelse(Treatment == "MD3", 278, 
#                        ifelse(Treatment == "CD3", 1030, NA))))        
#  #only 3% for size effect
# dataDunite3 <- dataDuniteControl3[which(dataDuniteControl3$silicate_type=="Dunite" ),]
# 


#for basalt we can investigate the interaction between SOC and rock amendment. 
#this cannot be done for dunite

#for basalt we can also assess particle size in a dataset with only FB3 and CB3

#install.packages("emmeans")
library(emmeans)

#for Al  there was a rock:time interaction
#dataset 1
i=10
model<-lmer(   as.formula(paste0(yvariables[i] , "~ SOC + rock + (1|code) + Dayafteramendment*rock ")) ,data =  datafullfact)
summary (model)
aov <- Anova(model)
vif (model)
hist(residuals(model))

#dataset 2
model<-lmer(as.formula(paste0(yvariables[i] , "~ sizebasalt + sizedunite  + rock*Dayafteramendment + (1|code)")) ,data =  datapsize)
summary (model)
aov <- Anova(model)
emm <- emtrends(model, ~ rock, var = "Dayafteramendment")

pairs(emm)
hist(residuals(model))
vif (model)
emm <- emmeans(model, ~ rock, at = list(Dayafteramendment = 0))
summary(emm, infer = TRUE)


### K ###
i=8
model<-lmer(   as.formula(paste0(yvariables[i] , "~  (1|code) + SOC*rock + Dayafteramendment")) ,data =  datafullfact)
summary (model)
Anova(model)
vif (model)
hist(residuals(model))
#K other dataset
model<-lmer(as.formula(paste0(yvariables[i] , "~ sizebasalt + sizedunite  + rock + Dayafteramendment + (1|code)")) ,data =  datapsize)
summary (model)
aov <- Anova(model)
emmeans(model, pairwise ~  rock, adjust = "tukey")

### Fe ###
i=9
model<-lmer(   as.formula(paste0(yvariables[i] , "~  (1|code) + SOC*rock + Dayafteramendment")) ,data =  datafullfact)
summary (model)
Anova(model)
vif (model) #vif 6 
hist(residuals(model)) #slightly right skewed?


#for dunite, we can only assess the effect of amendment and of particle size
for (i in 1:length(yvariables)) {
  # model<-lmer(   as.formula(paste0(yvariables[i] , "~ SOC * rock + (1|code)")) ,data =  datafullfact)
  # aov <- Anova(model)
  
  model<-lmer(   as.formula(paste0(yvariables[i] , "~ SOC * rock + (1|code) + Dayafteramendment ")) ,data =  datafullfact)
  aov <- Anova(model)
  aov $`Pr(>Chisq)`[rownames(aov) == "rock:Dayafteramendment"]
  
  
  if (aov $`Pr(>Chisq)`[rownames(aov) == "SOC:rock"] < 0.05) {
    p_SOC <- aov $`Pr(>Chisq)`[rownames(aov) == "SOC"]
    p_amended <- aov $`Pr(>Chisq)`[rownames(aov) == "rock"]
    p_amended_SOC <- aov $`Pr(>Chisq)`[rownames(aov) == "SOC:rock"]

    SOC <- fixef(model)[["SOC"]]
    amended <- fixef(model)[["rockBasalt"]]
    SOC_amendedeffect <- fixef(model)[["SOC:rockBasalt"]]
    if (p_SOC < 0.01) {p_SOC <- "<0.01"}
    if (p_amended < 0.01) {p_amended <- "<0.01"}
    if (p_amended_SOC < 0.01) {p_amended_SOC <- "<0.01"}
    
    effects_SOC_B[i] <-  round(SOC , 2)
    effects_amended_B [i]<-  round(amended , 2)
    effects_SOC_silicate_B[i] <- round(SOC_amendedeffect , 2)
    
    p_values_SOC_B[i] <-   ifelse(p_SOC == "<0.01", p_SOC, round(as.numeric(p_SOC), 2)) 
    p_values_amended_B[i] <-    ifelse(p_amended == "<0.01", p_amended, round(as.numeric(p_amended), 2))  
    p_values_SOC_silicate_B [i]<-    ifelse(p_amended_SOC == "<0.01", p_amended_SOC, round(as.numeric(p_amended_SOC), 2))  
    
    
    
  }  
  else {
    model<-lmer(   as.formula(paste0(yvariables[i] , "~ SOC + rock +Dayafteramendment + (1|code)")) ,data =  datafullfact)
    aov <- Anova(model)
    SOC <- fixef(model)[["SOC"]]
    amended <- fixef(model)[["rockBasalt"]]
    SOC_amendedeffect <- ""
    p_SOC <- aov $`Pr(>Chisq)`[rownames(aov) == "SOC"]
    p_amended <- aov $`Pr(>Chisq)`[rownames(aov) == "rock"]
    if (p_SOC < 0.01) {p_SOC <- "<0.01"}
    if (p_amended < 0.01) {p_amended <- "<0.01"} 
    effects_SOC_B[i] <-  round(SOC , 2) 
    effects_amended_B [i]<- round(amended , 2) 
    effects_SOC_silicate_B[i] <-  ifelse(SOC_amendedeffect == "", SOC_amendedeffect, round(as.numeric(SOC_amendedeffect), 2))  
    
    
    p_values_SOC_B[i] <-   ifelse(p_SOC == "<0.01", p_SOC, round(as.numeric(p_SOC), 2)) 
    p_values_amended_B[i] <-    ifelse(p_amended == "<0.01", p_amended, round(as.numeric(p_amended), 2))  
    p_values_SOC_silicate_B [i]<- ">0.05"
    
  }
  
 #  
  
  #size for basalt and dunite
  model<-lmer(as.formula(paste0(yvariables[i] , "~ sizebasalt + sizedunite + rock + Dayafteramendment + (1|code)")) ,data =  datapsize)
  aov <- Anova(model)
  posthoc <- as.data.frame(summary (emmeans(model, pairwise ~  rock, adjust = "tukey")))
  
  
  #size basalt
  size <- fixef(model)[["sizebasalt"]]
  p_size <- aov $`Pr(>Chisq)`[rownames(aov) == "sizebasalt"]
  if (p_size < 0.01) {p_size <- "<0.01"} 
  effects_size_B[i] <- round(size , 2)   
  p_values_size_B[i] <-   ifelse(p_size == "<0.01", p_size, round(as.numeric(p_size), 2))
  
  #qualitative basalt or not
  size <- fixef(model)[["rockBasalt"]]
  p_size <- posthoc$p.value[4]
  
  if (p_size < 0.01) {p_size <- "<0.01"} 
  effects_amended_B_3percent[i] <- round(size , 2)   
  p_values_amended_B_3percent[i] <-   ifelse(p_size == "<0.01", p_size, round(as.numeric(p_size), 2))
  
  
  
  #qualitative dunite or not
  size <- fixef(model)[["rockDunite"]]
  p_size <- posthoc$p.value[5]
  
  if (p_size < 0.01) {p_size <- "<0.01"} 
  effects_amended_D[i] <- round(size , 2)   
  p_values_amended_D[i] <-   ifelse(p_size == "<0.01", p_size, round(as.numeric(p_size), 2))
  
  #size dunite
  size <- fixef(model)[["sizedunite"]]
  p_size <- aov $`Pr(>Chisq)`[rownames(aov) == "sizedunite"]
  if (p_size < 0.01) {p_size <- "<0.01"} 
  effects_size_D[i] <- round(size , 2)   
  p_values_size_D[i] <-   ifelse(p_size == "<0.01", p_size, round(as.numeric(p_size), 2))
}


results <- data.frame (cbind (yvariables, p_values_size_B, effects_size_B,p_values_size_D, effects_size_D,p_values_SOC_B, effects_SOC_B,p_values_amended_B, effects_amended_B,p_values_amended_D,effects_amended_D,p_values_SOC_silicate_B, effects_SOC_silicate_B,effects_amended_B_3percent,p_values_amended_B_3percent))

#merge columns together
library(dplyr)
library(officer)

# Function to merge two columns with the first value above the second
merge_columns <- function(col1, col2) {
  paste0(col1, "\n(", col2, ")")
}

# Merging the columns
merged_results <- results %>%
  mutate(
    effects_size_B = merge_columns(effects_size_B, p_values_size_B),
    effects_size_D = merge_columns(effects_size_D, p_values_size_D),
    effects_SOC_B = merge_columns(effects_SOC_B, p_values_SOC_B),
    effects_amended_B = merge_columns(effects_amended_B, p_values_amended_B),
    effects_amended_D = merge_columns(effects_amended_D, p_values_amended_D),
    effects_SOC_silicate_B = merge_columns(effects_SOC_silicate_B, p_values_SOC_silicate_B),
    effects_amendedB_3percent = merge_columns(effects_amended_B_3percent, p_values_amended_B_3percent)
  )  %>%
  dplyr::select(yvariables, effects_size_B, effects_size_D, effects_SOC_B,
                effects_amended_B, effects_amended_D, effects_SOC_silicate_B,effects_amendedB_3percent)

doc <- read_docx()
doc <- doc %>%
  body_add_table(value = merged_results, style = "table_template")
# Save the Word document
print(doc, target = "merged_results.docx")


#annotate myplotsavgnew
myplotsavgnew[[8]] <- myplotsavgnew[[8]] +
    annotate("text", x = Inf, y = 2200, label = "- p(BxSOC) = 0.03", hjust = 1.1, vjust = -3.5, size = 3.5) +
annotate("text", x = Inf, y = 2000, label = "- p(D) = 0.02", hjust = 1.1, vjust = -3.5, size = 3.5) 

myplotsavgnew[[9]] <- myplotsavgnew[[9]] +
  annotate("text", x = Inf, y = 50, label = "- p(BxSOC) = 0.05", hjust = 1.1, vjust = -3.5, size = 3.5) 

myplotsavgnew[[10]] <- myplotsavgnew[[10]] +
  annotate("text", x = Inf, y = 0.9, label = "- p(B) < 0.01", hjust = 1.1, vjust = -3.5, size = 3.5) +
  annotate("text", x = Inf, y = 0.8, label = "- p(D) < 0.01", hjust = 1.1, vjust = -3.5, size = 3.5) +
  annotate("text", x = Inf, y = 0.7  , label = "+ p(Bxt)<0.01", hjust = 1.1, vjust = -3.5, size = 3.5) 

library (cowplot)
forlegend <- ggplot(sum, aes_string("silicate_type ", yvar, col = "silicate_type", shape = "Treatment", size = "Treatment", fill = "Treatment" ) )+
  theme_bw() + geom_point() + 
  scale_shape_manual(values = c("C1" = 22, "FB1" = 21, "C3" = 22, "CB3" = 21, "CD3" = 23, "FB3" = 21, "FD3" = 23, "MD3" = 23)) + 
  scale_size_manual(values = c("C1" = 4, "FB1" = 2, "C3" = 4, "CB3" = 6, "CD3" = 6, "FB3" = 2, "FD3" = 2, "MD3" = 4)) + 
  scale_color_manual(values = c("C1" = "black", "FB1" = "grey", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
  scale_fill_manual(values = c("C1" = "white", "FB1" = "white", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
  geom_errorbar(aes_string(ymin = paste0(yvar, "-se"), ymax = paste0(yvar, "+se")), size = 0.1)   +
  theme(axis.title.y = element_text(size= 10), axis.title.x = element_text(size= 10), axis.title = element_text(face = "bold")) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour= "black")) +
  ylab(lab) + xlab("Time \n (Days)") 

legend <- get_legend(forlegend)
elementplot_mass <- plot_grid(
  plot_grid(myplotsavgnew[[1]], myplotsavgnew[[2]],myplotsavgnew[[3]],
            myplotsavgnew[[7]], myplotsavgnew[[8]],myplotsavgnew[[6]],
            myplotsavgnew[[5]],myplotsavgnew[[10]],myplotsavgnew[[9]],
            labels = "AUTO", ncol = 3), 
  legend, ncol = 2,  rel_widths  = c(1, 0.2))


output_path <- "C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_/elementsMASS.jpeg"
ggsave(filename = output_path, plot = elementplot_mass, width = 10, height = 10, units = "in", dpi = 600)


 
 
 
# myplotsavg[[2]] <- myplotsavg[[2]] +
#   annotate("text", x = Inf, y = -Inf, label = "- p(D) < 0.01", hjust = 1.1, vjust = -3.5, size = 3.5) +
#   annotate("text", x = Inf, y = -Inf, label = "+ p(D size) < 0.01", hjust = 1.1, vjust = -5, size = 3.5) +
#   annotate("text", x = Inf, y = -Inf, label = "- p(BxSOC)= 0.01", hjust = 1.1, vjust = -6.5, size = 3.5)
# 
# myplotsavg[[3]] <- myplotsavg[[3]] +
#   annotate("text", x = Inf, y = -Inf, label = "- p(D) < 0.01", hjust = 1.1, vjust = -3.5, size = 3.5) +
#   annotate("text", x = Inf, y = -Inf, label = "+ p(D size) < 0.01", hjust = 1.1, vjust = -5, size = 3.5)+
#   annotate("text", x = Inf, y = -Inf, label = "- p(BxSOC)= 0.02", hjust = 1.1, vjust = -6.5, size = 3.5)
# 
# myplotsavg[[4]] <- myplotsavg[[4]] +
#   annotate("text", x = Inf, y = -Inf, label = "- p(D) < 0.01", hjust = 1.1, vjust = -3.5, size = 3.5) +
#   annotate("text", x = Inf, y = -Inf, label = "+ p(D size) < 0.01", hjust = 1.1, vjust = -5, size = 3.5)+
#   annotate("text", x = Inf, y = -Inf, label = "+ p(B) < 0.01", hjust = 1.1, vjust = -6.5, size = 3.5)+
#   annotate("text", x = Inf, y = -Inf, label = "- p(BxSOC)= 0.02", hjust = 1.1, vjust = -8, size = 3.5)
# 
# myplotsavg[[5]] <- myplotsavg[[5]] +
#   annotate("text", x = Inf, y = -Inf, label = "- p(D) < 0.01", hjust = 1.1, vjust = -3.5, size = 3.5) +
#   annotate("text", x = Inf, y = -Inf, label = "+ p(D size) = 0.02", hjust = 1.1, vjust = -5, size = 3.5)+
#   annotate("text", x = Inf, y = -Inf, label = "- p(BxSOC)= 0.02", hjust = 1.1, vjust = -6.5, size = 3.5)
# 
# myplotsavg[[6]]<- myplotsavg[[6]] +
#   annotate("text", x = Inf, y = -Inf, label = "- p(B) = 0.04", hjust = 1.1, vjust = -2, size = 3.5)
# 
# myplotsavg[[7]] <- myplotsavg[[7]] +
#   annotate("text", x = Inf, y = -Inf, label = "+ p(D size) =0.02", hjust = 1.1, vjust = -6.5, size = 3.5)
# 
# 
# myplotsavg[[8]] <- myplotsavg[[8]] +
#   annotate("text", x = Inf, y = -Inf, label = "+ p(D size) <0.01", hjust = 1.1, vjust = -5, size = 3.5)+
#   annotate("text", x = Inf, y = -Inf, label = "- p(D) =0.02", hjust = 1.1, vjust = -3.5, size = 3.5)
# 
# myplotsavg[[9]] <- myplotsavg[[9]] +
#   annotate("text", x = Inf, y = -Inf, label = "+ p(D size) <0.01", hjust = 1.1, vjust = -5, size = 3.5)+
#   annotate("text", x = Inf, y = -Inf, label = "- p(D) =0.02", hjust = 1.1, vjust = -3.5, size = 3.5)


yvariablesDIC <- yvariables[1:4]
ylabsDIC <- ylabs [1:4]

yvariableselements <- yvariables[5:length(yvariables)]
ylabselements <- ylabs[5:length(ylabs)]

myplotsavg <- list()  # new empty list
myplots_allintime <- list()  # new empty list

for (i in 1:length(yvariablesDIC)) {
  yvar = yvariablesDIC[i]
  lab = ylabsDIC [i]
  
  sum = summarySE( data[complete.cases(data[[yvar]]),] ,measurevar=yvar,groupvars=c("Treatment","Dayafteramendment", "silicate_type"))
  treatment_order <- c("C1", "FB1", "C3","CB3","FB3","CD3","MD3","FD3")
  # Convert Treatment column to factor with the specified order
  sum$Treatment <- factor(sum$Treatment, levels = treatment_order)
  
  plot_time <-  ggplot(sum, aes_string("Dayafteramendment ", yvar, col = "silicate_type", shape = "Treatment", size = "Treatment", fill = "Treatment" ) )+
    theme_bw() + geom_point() + 
    scale_shape_manual(values = c("C1" = 22, "FB1" = 21, "C3" = 22, "CB3" = 21, "CD3" = 23, "FB3" = 21, "FD3" = 23, "MD3" = 23)) + 
    scale_size_manual(values = c("C1" = 4, "FB1" = 2, "C3" = 4, "CB3" = 6, "CD3" = 6, "FB3" = 2, "FD3" = 2, "MD3" = 4)) + 
    scale_color_manual(values = c("C1" = "black", "FB1" = "grey", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
    scale_fill_manual(values = c("C1" = "white", "FB1" = "white", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
    geom_errorbar(aes_string(ymin = paste0(yvar, "-se"), ymax = paste0(yvar, "+se")), size = 0.1)   +
    theme(axis.title.y = element_text(size= 10), axis.title.x = element_text(size= 10), axis.title = element_text(face = "bold")) +
    theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour= "black")) +
    ylab(lab) + xlab("Time \n (Days)") +  theme(legend.position = "none")
  myplots_allintime[[i]] <- plot_time  
  

  #avg in time
  sum = summarySE(data[complete.cases(data[[yvar]]),], measurevar = yvar, groupvars = c("Treatment","silicate_type"))
  sum <- subset(sum, !is.na(Treatment) & !Treatment %in% c("C1Bac", "FB1Bac"))
  treatment_order <- c("C1", "FB1", "C3","CB3","FB3","CD3","MD3","FD3")
  # Convert Treatment column to factor with the specified order
  sum$Treatment <- factor(sum$Treatment, levels = treatment_order)
  plot2 <- ggplot(sum, aes_string("Treatment", yvar, col = "Treatment", shape = "Treatment", size = "Treatment", fill = "Treatment" ) )+
    theme_bw() + geom_point() + 
    scale_shape_manual(values = c("C1" = 22, "FB1" = 21, "C3" = 22, "CB3" = 21, "CD3" = 23, "FB3" = 21, "FD3" = 23, "MD3" = 23)) + 
    scale_size_manual(values = c("C1" = 4, "FB1" = 2, "C3" = 4, "CB3" = 6, "CD3" = 6, "FB3" = 2, "FD3" = 2, "MD3" = 4)) + 
    scale_color_manual(values = c("C1" = "black", "FB1" = "grey", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
    scale_fill_manual(values = c("C1" = "white", "FB1" = "white", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
      geom_errorbar(aes_string(ymin = paste0(yvar, "-se"), ymax = paste0(yvar, "+se")), size = 0.5)   +
    theme(axis.title.y = element_text(size= 10), axis.title.x = element_text(size= 10), axis.title = element_text(face = "bold")) +
    theme(axis.text.x = element_blank(), axis.ticks.x = element_blank(), axis.text.y = element_text(size = 10)) +  # Remove x-axis text and ticks
    theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour= "black")) +
    ylab(lab) + xlab("")+
    theme(legend.position = "none")

  myplotsavg[[i]] <- plot2 
  
}
library (cowplot)

treatment_order <- c("C1", "FB1", "C3","CB3","FB3","CD3","MD3","FD3")
# Convert Treatment column to factor with the specified order
sum$Treatment <- factor(sum$Treatment, levels = treatment_order)


#annotate statistics for myplotsavg



DIC_DOC_TA_pHplot <- plot_grid(
  plot_grid(myplotsavg[[1]], myplotsavg[[2]], myplotsavg[[3]], myplotsavg[[4]], labels = "AUTO", ncol = 2), 
  legend, ncol = 2,  rel_widths  = c(1, 0.2))
output_path <- "C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_/DIC_DOC_TA_pHplot.jpeg"
ggsave(filename = output_path, plot = DIC_DOC_TA_pHplot, width = 6, height = 6, units = "in", dpi = 600)


DIC_DOC_TA_pHplot_time <- plot_grid(
  plot_grid(myplots_allintime[[1]], myplots_allintime[[2]], myplots_allintime[[3]], myplots_allintime[[4]], labels = "AUTO", ncol = 2), 
  legend, ncol = 2,  rel_widths  = c(1, 0.2))
output_path <- "C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_/DIC_DOC_TA_pHplot_time.jpeg"
ggsave(filename = output_path, plot = DIC_DOC_TA_pHplot_time, width = 6, height = 6, units = "in", dpi = 600)


#elements
myplotsavg <- list()  # new empty list
myplots_allintime <- list()  # new empty list
for (i in 1:length(yvariableselements)) {
  yvar = yvariableselements[i]
  lab = ylabselements [i]
  
  sum = summarySE( data[complete.cases(data[[yvar]]),] ,measurevar=yvar,groupvars=c("Treatment","Dayafteramendment", "silicate_type"))
  plot_time <-  ggplot(sum, aes_string("Dayafteramendment ", yvar, col = "silicate_type", shape = "Treatment", size = "Treatment", fill = "Treatment" ) )+
    theme_bw() + geom_point() + 
    scale_shape_manual(values = c("C1" = 22, "FB1" = 21, "C3" = 22, "CB3" = 21, "CD3" = 23, "FB3" = 21, "FD3" = 23, "MD3" = 23)) + 
    scale_size_manual(values = c("C1" = 4, "FB1" = 2, "C3" = 4, "CB3" = 6, "CD3" = 6, "FB3" = 2, "FD3" = 2, "MD3" = 4)) + 
    scale_color_manual(values = c("C1" = "black", "FB1" = "grey", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
    scale_fill_manual(values = c("C1" = "white", "FB1" = "white", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
    geom_errorbar(aes_string(ymin = paste0(yvar, "-se"), ymax = paste0(yvar, "+se")), size = 0.1)   +
    theme(axis.title.y = element_text(size= 10), axis.title.x = element_text(size= 10), axis.title = element_text(face = "bold")) +
    theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour= "black")) +
    ylab(lab) + xlab("Time \n (Days)") +  theme(legend.position = "none")
  myplots_allintime[[i]] <- plot_time  
  
  treatment_order <- c("C1", "FB1", "C3","CB3","FB3","CD3","MD3","FD3")
  # Convert Treatment column to factor with the specified order
  sum$Treatment <- factor(sum$Treatment, levels = treatment_order)
  
  forlegend <- ggplot(sum, aes_string("Dayafteramendment ", yvar, col = "silicate_type", shape = "Treatment", size = "Treatment", fill = "Treatment" ) )+
    theme_bw() + geom_point() + 
    scale_shape_manual(values = c("C1" = 22, "FB1" = 21, "C3" = 22, "CB3" = 21, "CD3" = 23, "FB3" = 21, "FD3" = 23, "MD3" = 23)) + 
    scale_size_manual(values = c("C1" = 4, "FB1" = 2, "C3" = 4, "CB3" = 6, "CD3" = 6, "FB3" = 2, "FD3" = 2, "MD3" = 4)) + 
    scale_color_manual(values = c("C1" = "black", "FB1" = "grey", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
    scale_fill_manual(values = c("C1" = "white", "FB1" = "white", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
    geom_errorbar(aes_string(ymin = paste0(yvar, "-se"), ymax = paste0(yvar, "+se")), size = 0.1)   +
    theme(axis.title.y = element_text(size= 10), axis.title.x = element_text(size= 10), axis.title = element_text(face = "bold")) +
    theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour= "black")) +
    ylab(lab) + xlab("Time \n (Days)") 
  
  
  #avg in time
  sum = summarySE(data[complete.cases(data[[yvar]]),], measurevar = yvar, groupvars = c("Treatment","silicate_type"))
  sum <- subset(sum, !is.na(Treatment) & !Treatment %in% c("C1Bac", "FB1Bac"))
  treatment_order <- c("C1", "FB1", "C3","CB3","FB3","CD3","MD3","FD3")
  # Convert Treatment column to factor with the specified order
  sum$Treatment <- factor(sum$Treatment, levels = treatment_order)
  
 #do & add statistics
  
  
  
  
  plot2 <- ggplot(sum, aes_string("Treatment", yvar, col = "Treatment", shape = "Treatment", size = "Treatment", fill = "Treatment" ) )+
    theme_bw() + geom_point() + 
    scale_shape_manual(values = c("C1" = 22, "FB1" = 21, "C3" = 22, "CB3" = 21, "CD3" = 23, "FB3" = 21, "FD3" = 23, "MD3" = 23)) + 
    scale_size_manual(values = c("C1" = 4, "FB1" = 2, "C3" = 4, "CB3" = 6, "CD3" = 6, "FB3" = 2, "FD3" = 2, "MD3" = 4)) + 
    scale_color_manual(values = c("C1" = "black", "FB1" = "grey", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
    scale_fill_manual(values = c("C1" = "white", "FB1" = "white", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
    geom_errorbar(aes_string(ymin = paste0(yvar, "-se"), ymax = paste0(yvar, "+se")), size = 0.5)   +
    theme(axis.title.y = element_text(size= 10), axis.title.x = element_text(size= 10), axis.title = element_text(face = "bold")) +
    theme(axis.text.x = element_blank(), axis.ticks.x = element_blank(), axis.text.y = element_text(size = 10)) +  # Remove x-axis text and ticks
    theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour= "black")) +
    ylab(lab) + xlab("")+
    theme(legend.position = "none")
  
  myplotsavg[[i]] <- plot2 
  
}

#annotate plots


myplotsavg[[1]] <- myplotsavg[[1]] 
myplotsavg[[2]] <- myplotsavg[[2]] +
  annotate("text", x = Inf, y = -Inf, label = "- p(D) < 0.01", hjust = 1.1, vjust = -3.5, size = 3.5) +
  annotate("text", x = Inf, y = -Inf, label = "+ p(D size) < 0.01", hjust = 1.1, vjust = -5, size = 3.5) +
  annotate("text", x = Inf, y = -Inf, label = "- p(BxSOC)= 0.01", hjust = 1.1, vjust = -6.5, size = 3.5)

myplotsavg[[3]] <- myplotsavg[[3]] +
  annotate("text", x = Inf, y = -Inf, label = "- p(D) < 0.01", hjust = 1.1, vjust = -3.5, size = 3.5) +
  annotate("text", x = Inf, y = -Inf, label = "+ p(D size) < 0.01", hjust = 1.1, vjust = -5, size = 3.5)+
annotate("text", x = Inf, y = -Inf, label = "- p(BxSOC)= 0.02", hjust = 1.1, vjust = -6.5, size = 3.5)

myplotsavg[[4]] <- myplotsavg[[4]] +
  annotate("text", x = Inf, y = -Inf, label = "- p(D) < 0.01", hjust = 1.1, vjust = -3.5, size = 3.5) +
  annotate("text", x = Inf, y = -Inf, label = "+ p(D size) < 0.01", hjust = 1.1, vjust = -5, size = 3.5)+
  annotate("text", x = Inf, y = -Inf, label = "+ p(B) < 0.01", hjust = 1.1, vjust = -6.5, size = 3.5)+
  annotate("text", x = Inf, y = -Inf, label = "- p(BxSOC)= 0.02", hjust = 1.1, vjust = -8, size = 3.5)

myplotsavg[[5]] <- myplotsavg[[5]] +
  annotate("text", x = Inf, y = -Inf, label = "- p(D) < 0.01", hjust = 1.1, vjust = -3.5, size = 3.5) +
  annotate("text", x = Inf, y = -Inf, label = "+ p(D size) = 0.02", hjust = 1.1, vjust = -5, size = 3.5)+
  annotate("text", x = Inf, y = -Inf, label = "- p(BxSOC)= 0.02", hjust = 1.1, vjust = -6.5, size = 3.5)

myplotsavg[[6]]<- myplotsavg[[6]] +
  annotate("text", x = Inf, y = -Inf, label = "- p(B) = 0.04", hjust = 1.1, vjust = -2, size = 3.5)

myplotsavg[[7]] <- myplotsavg[[7]] +
  annotate("text", x = Inf, y = -Inf, label = "+ p(D size) =0.02", hjust = 1.1, vjust = -6.5, size = 3.5)


myplotsavg[[8]] <- myplotsavg[[8]] +
  annotate("text", x = Inf, y = -Inf, label = "+ p(D size) <0.01", hjust = 1.1, vjust = -5, size = 3.5)+
  annotate("text", x = Inf, y = -Inf, label = "- p(D) =0.02", hjust = 1.1, vjust = -3.5, size = 3.5)


myplotsavg[[9]] <- myplotsavg[[9]] +
  annotate("text", x = Inf, y = -Inf, label = "+ p(D size) <0.01", hjust = 1.1, vjust = -5, size = 3.5)+
  annotate("text", x = Inf, y = -Inf, label = "- p(D) =0.02", hjust = 1.1, vjust = -3.5, size = 3.5)


library (cowplot)
legend <- get_legend(forlegend)
elementplot <- plot_grid(
  plot_grid(myplotsavg[[1]], myplotsavg[[2]], myplotsavg[[3]], myplotsavg[[4]],myplotsavg[[5]], myplotsavg[[6]], myplotsavg[[7]], myplotsavg[[8]], myplotsavg[[9]],labels = "AUTO", ncol = 3), 
  legend, ncol = 2,  rel_widths  = c(1, 0.2))
output_path <- "C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_/elements.jpeg"
ggsave(filename = output_path, plot = elementplot, width = 10, height = 10, units = "in", dpi = 600)

elementplot_time <- plot_grid(
  plot_grid(myplots_allintime[[1]], myplots_allintime[[2]], myplots_allintime[[3]], myplots_allintime[[4]],myplots_allintime[[5]], myplots_allintime[[6]], myplots_allintime[[7]], myplots_allintime[[8]], myplots_allintime[[9]],labels = "AUTO", ncol = 3), 
  legend, ncol = 2,  rel_widths  = c(1, 0.2))
output_path <- "C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_/elementplot_time.jpeg"
ggsave(filename = output_path, plot = elementplot_time, width = 6, height = 6, units = "in", dpi = 600)











#add statistics (in the loops?): 
# model <- lmer (data = data, yvar ~ SOC + silicate_type + psize )

setwd ("C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_")
data <- read_excel("Leachate_soil_dataframe.xlsx", sheet = "leachate", col_names = T)
#Cumulative DIC plot
data$DIC_microgram <- data$DIC_mg_L * as.numeric(data$V_mL)  #microgram at each time
data$DIC_gram <- (data$DIC_microgram/10^(6))
sum = summarySE(data[complete.cases(data$DIC_gram),] ,measurevar="DIC_gram", groupvars=c("Treatment","Dayafteramendment","silicate_type"))
sum <- sum[-which (sum$Dayafteramendment == 244 | sum$Dayafteramendment == 323| sum$Dayafteramendment == 1| sum$Treatment == "FB1Bac" | sum$Treatment == "C1Bac" | sum$Treatment == "" ),]

# No DIC measured on day 244, day 323 ? , first day not measured OK
#check in data !!!

plot (data$Dayafteramendment, data$DIC_gram)
library(dplyr)
library(tidyr)

dayvector <- rep (unique(sum$Dayafteramendment),  length((unique(sum$Treatment))))
treatmentvector <- rep (unique(sum$Treatment), each = length(unique(sum$Dayafteramendment)))
cumDIC <- rep (0, length(unique(sum$Dayafteramendment)) * length(unique((sum$Treatment))))
cumse <- rep (0, length(unique(sum$Dayafteramendment)) * length(unique((sum$Treatment))))
for (i in (1: length(unique(sum$Dayafteramendment)))) {
  for (j in (1: length(unique((sum$Treatment)))))   {
    treatment <- unique((sum$Treatment))[j]
    Day <- unique((sum$Dayafteramendment))[i]
    DIC <- sum[which (sum$Treatment == treatment & sum$Dayafteramendment == Day),]$DIC_gram
    se <- sum[which (sum$Treatment == treatment & sum$Dayafteramendment == Day),]$se
    
    if (i ==1 & j == 1 ) {
      cumDIC[i+ length(unique(sum$Dayafteramendment))*(j-1)] <- DIC 
      cumse [i+ length(unique(sum$Dayafteramendment))*(j-1)] <- se
      }
    else {
      cumDIC[i+ length(unique(sum$Dayafteramendment))*(j-1)] <- DIC + cumDIC[i-1 + length(unique(sum$Dayafteramendment))*(j-1)]
      cumse [i+ length(unique(sum$Dayafteramendment))*(j-1)] <- sqrt (se^2 +  (cumDIC[i-1 + length(unique(sum$Dayafteramendment))*(j-1)])^2)
      
      if (i == 1 & j > 1 ) { cumDIC[i+ length(unique(sum$Dayafteramendment))*(j-1)] <-   cumDIC[i+ length(unique(sum$Dayafteramendment))*(j-1)] -  cumDIC[length(unique(sum$Dayafteramendment))*(j-1)]
      cumse[i+ length(unique(sum$Dayafteramendment))*(j-1)] <-   se
      }
    }}}

df <- as.data.frame(cbind (dayvector, cumDIC, treatmentvector, cumse))
df <- df %>%
  mutate(silicate_type = case_when(
    treatmentvector %in% c("CD3", "MD3", "FD3") ~ "Dunite",
    treatmentvector %in% c("CB3", "FB3", "FB1") ~ "Basalt",
    TRUE ~ "Control"
  ),
  SOC = case_when(
    treatmentvector %in% c("FB1", "C1") ~ "1%",   # Assign 1% for FB1 and C1
    TRUE ~ "3%"                           # Assign 3% for others
  ))

#numeric & convert units to ton C / ha, 0.22 m² / mesocosm
#gC/m2*1/10^6 gC/tonC*10 000 m2/ha
df$cumDIC <- as.numeric (df$cumDIC)*10^(4)/0.22/10^(6)
df$cumse <- as.numeric (df$cumse)*10^(4)/0.22/10^(6)
df$dayvector <- as.numeric (df$dayvector)

treatment_order <- c("C1", "FB1", "C3","CB3","FB3","CD3","MD3","FD3")
# Convert Treatment column to factor with the specified order
df$treatmentvector <- factor(df$treatmentvector, levels = treatment_order)
df$Treatment <- df$treatmentvector


 Cumul_DIC_tonCha <-  ggplot(df, aes_string("dayvector", "cumDIC", col = "Treatment", shape = "Treatment", size = "Treatment", fill = "Treatment" )) +
    theme_bw() + theme(axis.title.y = element_text(size= 10), axis.title.x = element_text(size= 10), axis.title = element_text(face = "bold")) +
    theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour= "black"))+
    geom_point() + 
    geom_errorbar(aes_string(ymin = paste0("cumDIC", "-cumse"), ymax = paste0("cumDIC", "+cumse")), size = 0.1) +
    # Customize aesthetics for each treatment
    scale_shape_manual(values = c("C1" = 22, "FB1" = 21, "C3" = 22, "CB3" = 21, "CD3" = 23, "FB3" = 21, "FD3" = 23, "MD3" = 23)) + 
    scale_size_manual(values = c("C1" = 4, "FB1" = 2, "C3" = 4, "CB3" = 6, "CD3" = 6, "FB3" = 2, "FD3" = 2, "MD3" = 4)) + 
    scale_color_manual(values = c("C1" = "black", "FB1" = "grey", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
    scale_fill_manual(values = c("C1" = "white", "FB1" = "white", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
     ylab("DIC \n (ton C ha-1)") + xlab("Time \n (days)")

 output_path <- "C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_/DIC_cumul_time.jpeg"
 ggsave(filename = output_path, plot = Cumul_DIC_tonCha, width = 6, height = 6, units = "in", dpi = 600)
 

 
 df <- df[which(df$dayvector==392),]
 Cumul_DIC_tonCha <-  ggplot(df, aes_string("Treatment", "cumDIC", col = "Treatment", shape = "Treatment", size = "Treatment", fill = "Treatment" )) +
   theme_bw() + theme(axis.title.y = element_text(size= 10), axis.title.x = element_text(size= 10), axis.title = element_text(face = "bold")) +
   theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour= "black"))+
   geom_point() + 
   geom_errorbar(aes_string(ymin = paste0("cumDIC", "-cumse"), ymax = paste0("cumDIC", "+cumse")), size = 0.1) +
   # Customize aesthetics for each treatment
   scale_shape_manual(values = c("C1" = 22, "FB1" = 21, "C3" = 22, "CB3" = 21, "CD3" = 23, "FB3" = 21, "FD3" = 23, "MD3" = 23)) + 
   scale_size_manual(values = c("C1" = 4, "FB1" = 2, "C3" = 4, "CB3" = 6, "CD3" = 6, "FB3" = 2, "FD3" = 2, "MD3" = 4)) + 
   scale_color_manual(values = c("C1" = "black", "FB1" = "grey", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
   scale_fill_manual(values = c("C1" = "white", "FB1" = "white", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
   ylab("DIC \n (ton C ha-1)") + xlab("")+
   theme(axis.text.x = element_blank(), axis.ticks.x = element_blank(), axis.text.y = element_text(size = 10))   # Remove x-axis text and ticks
   
 output_path <- "C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_/DIC_cumul.jpeg"
 ggsave(filename = output_path, plot = Cumul_DIC_tonCha, width = 6, height = 6, units = "in", dpi = 600)
 
 
 
 
 
 
 
 ###################################################################
 #Stats solutes
 library("lme4")
 library("car")
 setwd ("C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_")
 yvariables <- c("DIC_mg_L", "DOC_mg_L", "TA_mEQ_L", "pH", "Ca",	"Mg",	"Na",	"K","Fe",	"Al",	"Si",	"Ni",	"P")
 data <- read_excel("Leachate_soil_dataframe.xlsx", sheet = "leachate", col_names = T)
#####
 data$sizedunite <- as.numeric (with(data, 
                                              ifelse(Treatment == "FD3", 71, 
                                                     ifelse(Treatment == "MD3", 278, 
                                                            ifelse(Treatment == "CD3", 1030, 
                                                                   ifelse(Treatment %in% c("FB1", "FB3"), 0, 
                                                                          ifelse(Treatment == "CB3", 0, 0)))))))
  data$sizebasalt <- as.numeric (with(data, 
                                              ifelse(Treatment == "FD3", 0, 
                                                     ifelse(Treatment == "MD3", 0, 
                                                            ifelse(Treatment == "CD3", 0, 
                                                                   ifelse(Treatment %in% c("FB1", "FB3"), 292, 
                                                                          ifelse(Treatment == "CB3", 670, 0)))))))
 
 
  data$rock <-  with(data, 
                              ifelse(Treatment == "FB3", "Basalt", 
                                     ifelse(Treatment == "CB3","Basalt" ,
                                            ifelse(Treatment == "FB1","Basalt" ,
                                                   ifelse(Treatment == "C1","aNone" ,
                                                          ifelse(Treatment == "C3", "aNone","Dunite"))))))
  
  data$SOC  <- as.numeric (with(data, 
                                         ifelse(Treatment == "C1", 1, 
                                                ifelse(Treatment == "FB1", 1, 3))))
 
### split dataset
 datafullfact <- data[which(data$Treatment=="C1"|data$Treatment=="C3"|data$Treatment=="FB1"|data$Treatment=="FB3"),]
 datapsize <- data[-which(data$Treatment=="C1"|data$Treatment=="FB1"),]
#### make vectors
 p_values_amended_D <-  rep (0, length (yvariables))
 p_values_size_D <-  rep (0, length (yvariables))
 p_values_size_B <-  rep (0, length (yvariables))
 p_values_SOC_B <-  rep (0, length (yvariables))
 p_values_amended_B <-  rep (0, length (yvariables))
 p_values_SOC_silicate_B <-  rep (0, length (yvariables))
 
 effects_amended_D <-  rep (0, length (yvariables))
 effects_size_D <-  rep (0, length (yvariables))
 effects_size_B <-  rep (0, length (yvariables))
 effects_SOC_B <-  rep (0, length (yvariables))
 effects_amended_B <-  rep (0, length (yvariables))
 effects_SOC_silicate_B <-  rep (0, length (yvariables))
 #####

 #  dataBasaltControl <- data[which(data$silicate_type=="Basalt"|data$silicate_type=="Control"),]
 # dataBasaltControl$size <- with(dataBasaltControl, ifelse(Treatment %in% c("FB1", "FB3"), 292, 
 #                                            ifelse(Treatment == "CB3", 670, 0)))
 # dataBasaltControl$SOC <- with(dataBasaltControl, ifelse(Treatment %in% c("FB1", "C1"), 1, 
 #                                           ifelse(Treatment %in% c("CB3", "FB3"), 3, 3)))
 # dataBasaltControl$amended <- with(dataBasaltControl, ifelse(Treatment %in% c("C1", "C3"), 0, 1))
 # #only 3% for size effect
 # 
 # dataBasalt3 <- dataBasaltControl[which(dataBasaltControl$silicate_type=="Basalt" & dataBasaltControl$SOC == 3),]
 # 
 #  dataControlDunite <- data[which(data$silicate_type == "Control"|data$silicate_type == "Dunite" ),]
 #   dataControlDunite$SOC <- ifelse(dataControlDunite$Treatment == "C1", 1, 3)
 #  dataControlDunite$amended  <- with(dataControlDunite, ifelse(Treatment %in% c("C1", "C3"), 0, 1))
 #    
 #  dataDuniteControl3 <- dataControlDunite[which (dataControlDunite$SOC == 3),]
 #  
 #  dataDuniteControl3$size <- with(dataDuniteControl3, 
 #                        ifelse(Treatment == "FD3", 71, 
 #                        ifelse(Treatment == "MD3", 278, 
 #                        ifelse(Treatment == "CD3", 1030, NA))))        
  #  #only 3% for size effect
  # dataDunite3 <- dataDuniteControl3[which(dataDuniteControl3$silicate_type=="Dunite" ),]
  # 


#for basalt we can investigate the interaction between SOC and rock amendment. 
#this cannot be done for dunite

#for basalt we can also assess particle size in a dataset with only FB3 and CB3

# install.packages("emmeans")
 library(emmeans)

#for dunite, we can only assess the effect of amendment and of particle size
 for (i in 1:length(yvariables)) {
   model<-lmer(   as.formula(paste0(yvariables[i] , "~ SOC * rock + (1|code)")) ,data =  datafullfact)
   aov <- Anova(model)
   
   if (aov $`Pr(>Chisq)`[rownames(aov) == "SOC:rock"] < 0.05) {
     p_SOC <- aov $`Pr(>Chisq)`[rownames(aov) == "SOC"]
     p_amended <- aov $`Pr(>Chisq)`[rownames(aov) == "rock"]
     p_amended_SOC <- aov $`Pr(>Chisq)`[rownames(aov) == "SOC:rock"]
     SOC <- fixef(model)[["SOC"]]
     amended <- fixef(model)[["rockBasalt"]]
     SOC_amendedeffect <- fixef(model)[["SOC:rockBasalt"]]
     if (p_SOC < 0.01) {p_SOC <- "<0.01"}
     if (p_amended < 0.01) {p_amended <- "<0.01"}
     if (p_amended_SOC < 0.01) {p_amended_SOC <- "<0.01"}
     
     effects_SOC_B[i] <-  round(SOC , 2)
     effects_amended_B [i]<-  round(amended , 2)
     effects_SOC_silicate_B[i] <- round(SOC_amendedeffect , 2)
    
      p_values_SOC_B[i] <-   ifelse(p_SOC == "<0.01", p_SOC, round(as.numeric(p_SOC), 2)) 
     p_values_amended_B[i] <-    ifelse(p_amended == "<0.01", p_amended, round(as.numeric(p_amended), 2))  
     p_values_SOC_silicate_B [i]<-    ifelse(p_amended_SOC == "<0.01", p_amended_SOC, round(as.numeric(p_amended_SOC), 2))  
     

     
     }  
   else {
     model<-lmer(   as.formula(paste0(yvariables[i] , "~ SOC + rock + (1|code)")) ,data =  datafullfact)
     aov <- Anova(model)
     SOC <- fixef(model)[["SOC"]]
     amended <- fixef(model)[["rockBasalt"]]
     SOC_amendedeffect <- ""
     p_SOC <- aov $`Pr(>Chisq)`[rownames(aov) == "SOC"]
     p_amended <- aov $`Pr(>Chisq)`[rownames(aov) == "rock"]
     if (p_SOC < 0.01) {p_SOC <- "<0.01"}
     if (p_amended < 0.01) {p_amended <- "<0.01"} 
     effects_SOC_B[i] <-  round(SOC , 2) 
     effects_amended_B [i]<- round(amended , 2) 
     effects_SOC_silicate_B[i] <-  ifelse(SOC_amendedeffect == "", SOC_amendedeffect, round(as.numeric(SOC_amendedeffect), 2))  
       

     p_values_SOC_B[i] <-   ifelse(p_SOC == "<0.01", p_SOC, round(as.numeric(p_SOC), 2)) 
     p_values_amended_B[i] <-    ifelse(p_amended == "<0.01", p_amended, round(as.numeric(p_amended), 2))  
     p_values_SOC_silicate_B [i]<-  p_amended_SOC
     
     }
   
   
   
  #size for basalt and dunite
  model<-lmer(as.formula(paste0(yvariables[i] , "~ sizebasalt + sizedunite + rock + (1|code)")) ,data =  datapsize)
  aov <- Anova(model)
  posthoc <- as.data.frame(summary (emmeans(model, pairwise ~  rock, adjust = "tukey")))

  #size basalt
  size <- fixef(model)[["sizebasalt"]]
  p_size <- aov $`Pr(>Chisq)`[rownames(aov) == "sizebasalt"]
  if (p_size < 0.01) {p_size <- "<0.01"} 
  effects_size_B[i] <- round(size , 2)   
  p_values_size_B[i] <-   ifelse(p_size == "<0.01", p_size, round(as.numeric(p_size), 2))
  
  #qualitative dunite or not
  size <- fixef(model)[["rockDunite"]]
  p_size <- posthoc$p.value[5]
  
  if (p_size < 0.01) {p_size <- "<0.01"} 
  effects_amended_D[i] <- round(size , 2)   
  p_values_amended_D[i] <-   ifelse(p_size == "<0.01", p_size, round(as.numeric(p_size), 2))
  
  #size dunite
  size <- fixef(model)[["sizedunite"]]
  p_size <- aov $`Pr(>Chisq)`[rownames(aov) == "sizedunite"]
  if (p_size < 0.01) {p_size <- "<0.01"} 
  effects_size_D[i] <- round(size , 2)   
  p_values_size_D[i] <-   ifelse(p_size == "<0.01", p_size, round(as.numeric(p_size), 2))
    }
  

results <- data.frame (cbind (yvariables, p_values_size_B, effects_size_B,p_values_size_D, effects_size_D,p_values_SOC_B, effects_SOC_B,p_values_amended_B, effects_amended_B,p_values_amended_D,effects_amended_D,p_values_SOC_silicate_B, effects_SOC_silicate_B))

#merge columns together
library(dplyr)
library(officer)

# Function to merge two columns with the first value above the second
merge_columns <- function(col1, col2) {
  paste0(col1, "\n(", col2, ")")
}

# Merging the columns
merged_results <- results %>%
  mutate(
    effects_size_B = merge_columns(effects_size_B, p_values_size_B),
    effects_size_D = merge_columns(effects_size_D, p_values_size_D),
    effects_SOC_B = merge_columns(effects_SOC_B, p_values_SOC_B),
    effects_amended_B = merge_columns(effects_amended_B, p_values_amended_B),
    effects_amended_D = merge_columns(effects_amended_D, p_values_amended_D),
    effects_SOC_silicate_B = merge_columns(effects_SOC_silicate_B, p_values_SOC_silicate_B)
  ) %>%
  select(yvariables, effects_size_B, effects_size_D, effects_SOC_B, effects_amended_B, effects_amended_D, effects_SOC_silicate_B)

doc <- read_docx()
doc <- doc %>%
  body_add_table(value = merged_results, style = "table_template")
# Save the Word document
print(doc, target = "merged_results.docx")





# library(writexl)
# # Assuming your dataframe is called 'df'
# write_xlsx(results, path = "statistics_output.xlsx")
#write word table
df <- results
install.packages ("officer")
install.packages ("flextable")
library(officer)
library(flextable)
doc <- read_docx()
doc <- doc %>% body_add_par("Analysis Results", style = "heading 1")
# Create a flextable from the dataframe
ft <- flextable(df)
# Add the flextable to the Word document
doc <- doc %>% body_add_flextable(ft)
# Save the Word document
print(doc, target = "results.docx")
 
 
 
 
 
 

