#SSAplot 
setwd("C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_")
#TO DO read in experimental SIC
SSAdata <- read_excel("SSAdataset.xlsx", sheet = "Blad4", col_names = TRUE)
library (cowplot)
#SSAdata <- SSAdata %>% mutate(se = sd / sqrt(3))
data <- SSAdata


data$sizedunite <- as.numeric (with(data, 
                                    ifelse(Treatment == "FD3", 71, 
                                           ifelse(Treatment == "MD3", 278, 
                                                  ifelse(Treatment == "CD3", 1030, 
                                                         ifelse(Treatment %in% c("FB1", "FB3"), 0, 
                                                                ifelse(Treatment == "CB3", 0, 0)))))))

data$sizebasalt <- as.numeric (with(data, 
                                    ifelse(Treatment == "FD3", 0, 
                                           ifelse(Treatment == "MD3", 0, 
                                                  ifelse(Treatment == "CD3", 0, 
                                                         ifelse(Treatment %in% c("FB1", "FB3"), 292, 
                                                                ifelse(Treatment == "CB3", 670, 0)))))))

data$rock <-  with(data, 
                   ifelse(Treatment == "FB3", "Basalt", 
                          ifelse(Treatment == "CB3","Basalt" ,
                                 ifelse(Treatment == "FB1","Basalt" ,
                                        ifelse(Treatment == "C1","aNone" ,
                                               ifelse(Treatment == "C3", "aNone","Dunite"))))))

data$SOC  <- as.numeric (with(data, 
                              ifelse(Treatment == "C1", 1, 
                                     ifelse(Treatment == "FB1", 1, 3))))


#
#data<-data[which(data$days<131),]


#split up dataset
### split dataset
dataoriginal<- data
datafullfact <- data[which(data$Treatment=="C1"|data$Treatment=="C3"|data$Treatment=="FB1"|data$Treatment=="FB3"),]
datapsize <- data[-which(data$Treatment=="C1"|data$Treatment=="FB1"),]

# # Separate the changes in SSA for the two groups
# change_SSA_3_SOM <- datafullfact %>% filter(SOM == 3) %>% select(change_SSA) %>% unlist()
# change_SSA_1_SOM <- datafullfact %>% filter(SOM == 1) %>% select(change_SSA) %>% unlist()
# # Perform a t-test to compare the changes in SSA between the two groups
# t_test_result <- t.test(change_SSA_3_SOM, change_SSA_1_SOM)
# print(t_test_result)

#Statistical tests ###########
library(lme4)
library (car)
# Fit the linear mixed-effects model 
model <- lmer (data= datafullfact, SSA ~ SOC*days +  (1|Treatment))
summary (model) 
Anova(model)
#sign SOC X TIME EFFECT for basalt p<0.01
qqnorm(residuals(model))
car::vif(model) #VIF = 5, still OK. 


#for dunite size
model <- lmer (data= datapsize, SSA ~ days + rock +  sizedunite + sizebasalt + days:rock   +  (1|Treatment))
summary (model) 
Anova(model)
#sign + DUNITE X TIME EFFECT p<0.01
qqnorm(residuals(model))
vif(model) #<5 OK

emm <- emtrends(model, ~ rock, var = "days")
pairs(emm)

# library(emmeans)
# emmeans(model, pairwise ~ rock, adjust = "tukey") => not needed here!





treatment_order <- c( "FB1", "CB3","FB3","CD3","MD3","FD3")
# Convert Treatment column to factor with the specified order
SSAdata$Treatment <- factor(SSAdata$Treatment, levels = treatment_order)

library (ggplot2)
#TO DO: -1 in superscript; add geom_errorbar errors zie mails reinaldy.
library (Rmisc)
sumSSA = summarySE(SSAdata[complete.cases(SSAdata$SSA),],measurevar="SSA",groupvar=c("Treatment","days"))


forlegend <- ggplot(data = SSAdata, aes (x= days, y=SSA, col = Treatment, fill =Treatment,shape=Treatment, size = Treatment)) +
   labs( x = "Time (Days)", y = "BET-SSA \n (m² rock g-1 rock)") +
   geom_point ()+ geom_line (linetype = "dotted", size = 0.5)+
  # geom_errorbar(data = SSAdata, aes(x=days,  ymin = (SSA - se)  , ymax = (SSA +se )),  size = 0.1, width = 0.1) +
   scale_shape_manual(values = c("C1" = 22, "FB1" = 21, "C3" = 22, "CB3" = 21, "CD3" = 23, "FB3" = 21, "FD3" = 23, "MD3" = 23)) + 
  scale_size_manual(values = c("C1" = 4, "FB1" = 2, "C3" = 4, "CB3" = 6, "CD3" = 6, "FB3" = 2, "FD3" = 2, "MD3" = 4)) + 
  scale_color_manual(values = c("C1" = "black", "FB1" = "grey", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
  scale_fill_manual(values = c("C1" = "white", "FB1" = "white", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen"))+
  theme_bw() + theme(axis.title.y = element_text(size= 20), axis.title.x = element_text(size= 20), axis.title = element_text(face = "bold")) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour= "black"))+
  theme(
    axis.text.x = element_text(size = 14),  # Increase size of x-axis ticks
    axis.text.y = element_text(size = 14)   # Increase size of y-axis ticks
  )
legend <- get_legend(forlegend)

SSA_fig <- ggplot(data = sumSSA, aes (x= days, y=SSA, col = Treatment, fill =Treatment,shape=Treatment, size = Treatment)) +
  geom_point ()+ geom_line (linetype = "dotted", size = 0.5)+
  labs(
    x = "Time (Days)",
    y = expression("BET-SSA"~"(m"^2~"rock g"^{-1}~"rock)") )+
  geom_errorbar(aes(ymin = SSA - se, ymax = SSA + se),
                width = 0.2,
                position = position_dodge(width = 0.2))+
scale_shape_manual(values = c("C1" = 22, "FB1" = 21, "C3" = 22, "CB3" = 21, "CD3" = 23, "FB3" = 21, "FD3" = 23, "MD3" = 23)) + 
  scale_size_manual(values = c("C1" = 4, "FB1" = 2, "C3" = 4, "CB3" = 6, "CD3" = 6, "FB3" = 2, "FD3" = 2, "MD3" = 4)) + 
  scale_color_manual(values = c("C1" = "black", "FB1" = "grey", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
  scale_fill_manual(values = c("C1" = "white", "FB1" = "white", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen"))+
  theme_bw() + theme(axis.title.y = element_text(size= 10), axis.title.x = element_text(size= 10), axis.title = element_text(face = "bold")) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour= "black"))+
 theme(legend.position = "none")+
  annotate("text", x = Inf, y = -Inf, label = "- p(SOC x time) < 0.01", hjust = 1.1, vjust = -18, size = 3.5)+
  annotate("text", x = Inf, y = -Inf, label = "+ p((D-B) x time) < 0.01", hjust = 1.1, vjust = -10, size = 3.5)


  
  
  #roughness:
# Fit the linear mixed-effects model 
model <- lmer (data= datafullfact, LogRF ~ SOC*days +  (1|Treatment))
summary (model) 
Anova(model)
#sign SOC X TIME EFFECT for basalt


#for dunite size
datapsize<- datapsize[-which(datapsize$Treatment=="CD3"),]
model <- lmer (data= datapsize, LogRF ~ days + rock +  sizedunite + sizebasalt   +  (1|Treatment))
summary (model) 
Anova(model)


sumlogRF = summarySE(SSAdata[complete.cases(SSAdata$LogRF),],measurevar="LogRF",groupvar=c("Treatment","days"))
sumRF = summarySE(SSAdata[complete.cases(SSAdata$roughness),],measurevar="roughness",groupvar=c("Treatment","days"))



#calculate roughness
Roughness_figure <- ggplot(data = sumlogRF[-which(sumlogRF$Treatment=="CD3"),], aes (x= days, y=LogRF, col = Treatment, fill =Treatment,shape=Treatment, size = Treatment)) +
  labs( x = "Time (Days)", y = "Log Roughness factor \n  log10(BET-SSA/geometric SSA)") +
  geom_point ()+ geom_line (linetype = "dotted", size = 0.5)+
  scale_shape_manual(values = c("C1" = 22, "FB1" = 21, "C3" = 22, "CB3" = 21, "CD3" = 23, "FB3" = 21, "FD3" = 23, "MD3" = 23)) + 
  scale_size_manual(values = c("C1" = 4, "FB1" = 2, "C3" = 4, "CB3" = 6, "CD3" = 6, "FB3" = 2, "FD3" = 2, "MD3" = 4)) + 
  scale_color_manual(values = c("C1" = "black", "FB1" = "grey", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
  scale_fill_manual(values = c("C1" = "white", "FB1" = "white", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen"))+
  theme_bw() + theme(axis.title.y = element_text(size= 15), axis.title.x = element_text(size= 20), axis.title = element_text(face = "bold")) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour= "black"))+
  theme(
    axis.text.x = element_text(size = 14),  # Increase size of x-axis ticks
    axis.text.y = element_text(size = 14)   # Increase size of y-axis ticks
  )+ xlim (c(0,135))+ theme(legend.position = "none")+
  annotate("text", x = Inf, y = -Inf, label = "- p(SOC x time) < 0.01", hjust = 1.1, vjust = -25, size = 3.5)



#combined plot 
library (cowplot)
legend <- get_legend(forlegend)


# SSA_roughness  <- plot_grid(plot_grid(SSA_fig, Roughness_figure , labels = "AUTO", ncol = 2), 
#                           legend, ncol = 2,  rel_widths  = c(1, 0.2))


SSA  <- plot_grid((SSA_fig), 
                            legend, ncol = 2,  rel_widths  = c(1, 0.2))

output_path <- "C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_/SSA.jpeg"
#ggsave(filename = output_path, plot = SSA_roughness, width = 10, height = 4, units = "in", dpi = 600)

ggsave(filename = output_path, plot = SSA, width = 6, height = 4, units = "in", dpi = 600)

