#SIC calculation
  setwd ("C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_")
library (readxl)
  library (Rmisc)
  library (dplyr)
  
  
  data <- read_excel("SIC_calculationdata.xlsx", sheet = "Carbonate", col_names = T)
data <- data [-which (data$Treatment=="FB1Bac"|data$Treatment=="C1Bac"),]
blankdata <- data[which (data$Treatment=="BLANK"),]
elements <- c("Fe","K","Mg","Na")
data <- data[-which (data$Treatment=="BLANK"),]

#Blank normalization
data$Fe_fraction2  <- data$Fe_fraction2 - mean (blankdata$Fe_fraction2)
data$K_fraction2  <- data$K_fraction2 - mean (blankdata$Fe_fraction2)
data$Mg_fraction2 <- data$Mg_fraction2 - mean (blankdata$Fe_fraction2)
data$Ca_fraction2  <- data$Ca_fraction2 - mean (blankdata$Fe_fraction2)

data$Fe <- data$Fe_fraction2* data$V_mL_fraction2/data$sampleMass_g #µg/g
data$K <- data$K_fraction2* data$V_mL_fraction2/data$sampleMass_g #µg/g
data$Mg<- data$Mg_fraction2* data$V_mL_fraction2/data$sampleMass_g #µg/g
data$Ca<- data$Ca_fraction2* data$V_mL_fraction2/data$sampleMass_g #µg/g

Puresilicatesdata <- data[is.na(data$soilmass), ]
data <- data[!is.na(data$soilmass), ]
Treatments <- unique (data$Treatment)
Treatments_letters <- unique(gsub("[0-9]", "", Treatments))
Treatments <- Treatments_letters [-which (Treatments_letters=="C")]

#rock/soil ratio? 
combined_data <- data.frame()

for (i in (1: length (Treatments))) {
  data$ Dunite_soil <- 0.11 / data$soilmass #g/g
  data$Basalt_soil <- 1.1 / data$soilmass #g/g
  treatment <- Treatments[i]
  
  corrected_data <- data[grep(paste0("^",treatment), data$Treatment), ]
  
  #to do add if to use dunite or basalt/soil ratio if the rock is dunite or basalt 
  
#correction for all elements:
  if (treatment == "FB" |treatment == "CB" ){  
  corrected_data$Ca <- corrected_data$Ca - corrected_data$Basalt_soil * mean (Puresilicatesdata [which (Puresilicatesdata$Treatment==treatment),]$Ca)
  corrected_data$Fe <- corrected_data$Fe - corrected_data$Basalt_soil * mean (Puresilicatesdata [which (Puresilicatesdata$Treatment==treatment),]$Fe)
  corrected_data$K <- corrected_data$K - corrected_data$Basalt_soil * mean (Puresilicatesdata [which (Puresilicatesdata$Treatment==treatment),]$K)
  corrected_data$Mg <- corrected_data$Mg - corrected_data$Basalt_soil * mean (Puresilicatesdata [which (Puresilicatesdata$Treatment==treatment),]$Mg)}
  
  if (treatment == "CD" |treatment == "MD" |treatment == "FD" ){ 
    corrected_data$Ca <- corrected_data$Ca - corrected_data$Dunite_soil * mean (Puresilicatesdata [which (Puresilicatesdata$Treatment==treatment),]$Ca)
    corrected_data$Fe <- corrected_data$Fe - corrected_data$Dunite_soil * mean (Puresilicatesdata [which (Puresilicatesdata$Treatment==treatment),]$Fe)
    corrected_data$K <- corrected_data$K - corrected_data$Dunite_soil * mean (Puresilicatesdata [which (Puresilicatesdata$Treatment==treatment),]$K)
    corrected_data$Mg <- corrected_data$Mg - corrected_data$Dunite_soil * mean (Puresilicatesdata [which (Puresilicatesdata$Treatment==treatment),]$Mg)}
  
  combined_data <- rbind(combined_data, corrected_data)
}
  
data_control <- data[which (data$Treatment=="C3"|data$Treatment=="C1" ),]
combined_data <- rbind(combined_data, data_control)

#elements in combined_data are in µg/g --> µmol/g
combined_data$Fe_mol <- combined_data$Fe / 55.845
combined_data$K_mol <- combined_data$K / 39.098
combined_data$Ca_mol <- combined_data$Ca / 40.078
combined_data$Mg_mol <- combined_data$Mg / 24.305
  
#µmol C 
combined_data$molC_g <- 10^(-6)*((combined_data$Fe_mol+combined_data$Mg_mol+combined_data$Ca_mol)*2+combined_data$K_mol)
combined_data$SICpercent <- 100*combined_data$molC_g*12 

#SICpercent ==> stats
combined_data$sizedunite <- as.numeric (with(combined_data, 
                        ifelse(Treatment == "FD3", 71, 
                        ifelse(Treatment == "MD3", 278, 
                        ifelse(Treatment == "CD3", 1030, 
                        ifelse(Treatment %in% c("FB1", "FB3"), 0, 
                        ifelse(Treatment == "CB3", 0, 0)))))))

combined_data$sizebasalt <- as.numeric (with(combined_data, 
                                             ifelse(Treatment == "FD3", 0, 
                                                    ifelse(Treatment == "MD3", 0, 
                                                           ifelse(Treatment == "CD3", 0, 
                                                                  ifelse(Treatment %in% c("FB1", "FB3"), 292, 
                                                                         ifelse(Treatment == "CB3", 670, 0)))))))


combined_data$SOC <- c("")
combined_data$SOC  <- as.numeric (with(combined_data, 
                        ifelse(Treatment == "C1", 1, 
                        ifelse(Treatment == "FB1", 1, 3))))

combined_data$Basalt <- as.numeric (with(combined_data, 
                        ifelse(Treatment == "FB1", 1, 
                               ifelse(Treatment == "FB3", 1,
                               ifelse(Treatment == "CB3", 1,0)))))

combined_data$Dunite <- as.numeric (with(combined_data, 
                                         ifelse(Treatment == "FD3", 1, 
                                                ifelse(Treatment == "CD3", 1,
                                                       ifelse(Treatment == "MD3", 1,0)))))


combined_data$rock <-  with(combined_data, 
                                         ifelse(Treatment == "FB3", "Basalt", 
                                                ifelse(Treatment == "CB3","Basalt" ,
                                                       ifelse(Treatment == "FB1","Basalt" ,
                                                              ifelse(Treatment == "C1","aNone" ,
                                                       ifelse(Treatment == "C3", "aNone","Dunite"))))))

combined_dataFB_C <- combined_data[which(combined_data$Treatment=="C1"|combined_data$Treatment=="C3"|combined_data$Treatment=="FB3"|combined_data$Treatment=="FB1"),]
combined_dataD_B_size <- combined_data[-which(combined_data$Treatment=="C1"|combined_data$Treatment=="FB1"),]



#basalt x SOC
model <- lm (data= combined_dataFB_C, SICpercent ~ SOC*Basalt)
summary (model)   #p interact > 0.05  
#basalt + SOC
model <- lm (data= combined_dataFB_C, SICpercent ~ SOC + Basalt)
summary (model) 
qqnorm(residuals(model))
vif(model) #<5 OK

#dunite, logical
model <- lm (data= combined_dataD_B_size, SICpercent ~ rock + sizebasalt + sizedunite )
summary (model) 







##################################################################################



#relative contribution elements
combined_data$fraction_Fe <- combined_data$Fe_mol*2*10^(-6)/ combined_data$molC_g
combined_data$fraction_Ca <- combined_data$Ca_mol*2 *10^(-6)/ combined_data$molC_g
combined_data$fraction_Mg <- combined_data$Mg_mol*2 *10^(-6)/ combined_data$molC_g
combined_data$fraction_K <- combined_data$K_mol*10^(-6) / combined_data$molC_g


sumCa = summarySE(  combined_data     , measurevar = "fraction_Ca", groupvar = "Treatment" )
sumFe = summarySE(  combined_data     , measurevar = "fraction_Fe", groupvar = "Treatment" )
sumMg = summarySE(  combined_data     , measurevar = "fraction_Mg", groupvar = "Treatment" )
sumK = summarySE(  combined_data     , measurevar = "fraction_K", groupvar = "Treatment" )

# merged_data <- merge(sumCa, sumK, by = "Treatment", suffixes = c("_Ca", "_K"))
# merged_data <- merge(merged_data, sumFe, by = "Treatment", suffixes = c("", "_Fe"))
# merged_data <- merge(merged_data, sumMg, by = "Treatment", suffixes = c("", "_Mg"))

sumCa$Element <- "Ca"
sumK$Element <- "K"
sumFe$Element <- "Fe"
sumMg$Element <- "Mg"

#select relevant columns
combined_data2 <- bind_rows(
  sumCa %>% dplyr::select(Treatment, fraction_Ca = fraction_Ca, se_Ca = se, Element),
  sumK  %>% dplyr::select(Treatment, fraction_K = fraction_K, se_K = se, Element),
  sumFe %>% dplyr::select(Treatment, fraction_Fe = fraction_Fe, se_Fe = se, Element),
  sumMg %>% dplyr::select(Treatment, fraction_Mg = fraction_Mg, se_Mg = se, Element)
)

# # Reshape combined_data into long format for plotting
# library (tidyr)
# long_data <- pivot_longer(combined_data2, 
#                           cols = starts_with("fraction_"), 
#                           names_to = "Fraction_Type", 
#                           values_to = "Fraction_Value")
# 
# # Plot using ggplot
# fractionplot <- ggplot(long_data, aes(x = Treatment, y = Fraction_Value, color = Element)) +
#   geom_point(position = position_dodge(width = 0.5), size = 3) +  # Points for different datasets
#   labs( x = "Treatment",
#        y = "Fraction of carbonate charges") +
#   scale_color_manual(values = c("blue", "red", "green", "purple")) +  # Custom colors for datasets
#   theme(axis.text.x = element_text(angle = 45, hjust = 1))+
#   theme_bw() +
#   theme(axis.title.y = element_text(size= 10), axis.title.x = element_text(size= 10), axis.title = element_text(face = "bold")) +
#   theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour= "black"))
#   
# output_path <- "C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_/fractionplot.jpeg"
# ggsave(filename = output_path, plot = fractionplot, width = 6, height = 6, units = "in", dpi = 600)




library (Rmisc)
sum = summarySE(  combined_data     , measurevar = "SICpercent", groupvar = "Treatment" )
library (ggplot2)




treatment_order <- c("C1", "FB1", "C3","CB3","FB3","CD3","MD3","FD3")
# Convert Treatment column to factor with the specified order
sum$Treatment <- factor(sum$Treatment, levels = treatment_order)
#normalize for control soil
calculate_difference <- function(SIC1, SE1, SIC2, SE2) {
  diff <- SIC1 - SIC2
  propagated_se <- sqrt(SE1^2 + SE2^2)
  return(c(diff, propagated_se))
}
# Initialize results list for the comparisons
results_list <- list()
# FB1 - C1 comparison
results_list[["FB1 - C1"]] <- calculate_difference(
  sum$SICpercent[sum$Treatment == "FB1"], 
  sum$se[sum$Treatment == "FB1"], 
  sum$SICpercent[sum$Treatment == "C1"], 
  sum$se[sum$Treatment == "C1"]
)

# Loop through treatments ending with '3' and subtract from C3
for (treatment in sum$Treatment[grepl("3$", sum$Treatment) & sum$Treatment != "C3"]) {
  comparison_name <- paste(treatment, "- C3")
  results_list[[comparison_name]] <- calculate_difference(
    sum$SICpercent[sum$Treatment == treatment], 
    sum$se[sum$Treatment == treatment], 
    sum$SICpercent[sum$Treatment == "C3"], 
    sum$se[sum$Treatment == "C3"]
  )
}

# Convert the results list into a data frame
results <- do.call(rbind, lapply(names(results_list), function(name) {
  cbind(Comparison = name, as.data.frame(t(results_list[[name]])))
}))
colnames(results) <- c("Comparison", "Difference", "Propagated_SE")

results$Treatment <- c("FB1","CB3","CD3","FB3","FD3","MD3")
treatment_order <- c( "FB1", "CB3","FB3","CD3","MD3","FD3")
# Convert Treatment column to factor with the specified order
results$Treatment <- factor(results$Treatment, levels = treatment_order)
results$SICpercent <- results$Difference
results$se <- results$Propagated_SE 
results$soilmass <- c (31.65, 34.40 ,33.41 , 34.40,33.41 ,33.41)
  
#ton C/ha
results$tonC_ha <- (results$SICpercent/100)*results$soilmass*10000/0.22/1000
results$tonC_ha_se <- (results$se/100)*results$soilmass*10000/0.22/1000
library(writexl)
write_xlsx(results, "C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_/SICdataset.xlsx")


  deltaSIC_tonC_ha <-  ggplot(results, aes_string("Treatment ", "tonC_ha", col = "Treatment", shape = "Treatment", size = "Treatment", fill = "Treatment" ) )+
  theme_bw() + geom_point() + 
  scale_shape_manual(values = c("C1" = 22, "FB1" = 21, "C3" = 22, "CB3" = 21, "CD3" = 23, "FB3" = 21, "FD3" = 23, "MD3" = 23)) + 
  scale_size_manual(values = c("C1" = 4, "FB1" = 2, "C3" = 4, "CB3" = 6, "CD3" = 6, "FB3" = 2, "FD3" = 2, "MD3" = 4)) + 
  scale_color_manual(values = c("C1" = "black", "FB1" = "grey", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
  scale_fill_manual(values = c("C1" = "white", "FB1" = "white", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
  geom_errorbar(aes_string(ymin = paste0("tonC_ha","-tonC_ha_se"), ymax = paste0("tonC_ha","+tonC_ha_se")), size = 0.1)   +
  theme(axis.title.y = element_text(size= 10), axis.title.x = element_text(size= 10), axis.title = element_text(face = "bold")) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour= "black")) +
  ylab(paste("\u394","SIC\n (ton C ha-1)")) + xlab("") +  
  theme(legend.position = "none")+
  theme(axis.text.x = element_blank(), axis.ticks.x = element_blank(), axis.text.y = element_text(size = 10))   # Remove x-axis text and ticks

output_path <- "C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_/DeltaSIC.jpeg"
ggsave(filename = output_path, plot = deltaSIC_tonC_ha, width = 6, height = 6, units = "in", dpi = 600)
######################################################################

#DIC leaching
setwd ("C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_")
data <- read_excel("Leachate_soil_dataframe.xlsx", sheet = "leachate", col_names = T)
#Cumulative DIC plot
data$DIC_microgram <- data$DIC_mg_L * as.numeric(data$V_mL)  #microgram at each time
data$DIC_gram <- (data$DIC_microgram/10^(6))
sum = summarySE(data[complete.cases(data$DIC_gram),] ,measurevar="DIC_gram", groupvars=c("Treatment","Dayafteramendment","silicate_type"))
sum <- sum[-which (sum$Dayafteramendment == 244 | sum$Dayafteramendment == 323| sum$Dayafteramendment == 1| sum$Treatment == "FB1Bac" | sum$Treatment == "C1Bac" | sum$Treatment == "" ),]

# No DIC measured on day 244, day 323 ? , first day not measured OK
#check in data !!!

plot (data$Dayafteramendment, data$DIC_gram)
library(dplyr)
library(tidyr)

dayvector <- rep (unique(sum$Dayafteramendment),  length((unique(sum$Treatment))))
treatmentvector <- rep (unique(sum$Treatment), each = length(unique(sum$Dayafteramendment)))
cumDIC <- rep (0, length(unique(sum$Dayafteramendment)) * length(unique((sum$Treatment))))
cumse <- rep (0, length(unique(sum$Dayafteramendment)) * length(unique((sum$Treatment))))
for (i in (1: length(unique(sum$Dayafteramendment)))) {
  for (j in (1: length(unique((sum$Treatment)))))   {
    treatment <- unique((sum$Treatment))[j]
    Day <- unique((sum$Dayafteramendment))[i]
    DIC <- sum[which (sum$Treatment == treatment & sum$Dayafteramendment == Day),]$DIC_gram
    se <- sum[which (sum$Treatment == treatment & sum$Dayafteramendment == Day),]$se
    
    if (i ==1 & j == 1 ) {
      cumDIC[i+ length(unique(sum$Dayafteramendment))*(j-1)] <- DIC 
      cumse [i+ length(unique(sum$Dayafteramendment))*(j-1)] <- se
    }
    else {
      cumDIC[i+ length(unique(sum$Dayafteramendment))*(j-1)] <- DIC + cumDIC[i-1 + length(unique(sum$Dayafteramendment))*(j-1)]
      cumse [i+ length(unique(sum$Dayafteramendment))*(j-1)] <- sqrt (se^2 +  (cumDIC[i-1 + length(unique(sum$Dayafteramendment))*(j-1)])^2)
      
      if (i == 1 & j > 1 ) { cumDIC[i+ length(unique(sum$Dayafteramendment))*(j-1)] <-   cumDIC[i+ length(unique(sum$Dayafteramendment))*(j-1)] -  cumDIC[length(unique(sum$Dayafteramendment))*(j-1)]
      cumse[i+ length(unique(sum$Dayafteramendment))*(j-1)] <-   se
      }
    }}}

df <- as.data.frame(cbind (dayvector, cumDIC, treatmentvector, cumse))
df <- df %>%
  mutate(silicate_type = case_when(
    treatmentvector %in% c("CD3", "MD3", "FD3") ~ "Dunite",
    treatmentvector %in% c("CB3", "FB3", "FB1") ~ "Basalt",
    TRUE ~ "Control"
  ),
  SOC = case_when(
    treatmentvector %in% c("FB1", "C1") ~ "1%",   # Assign 1% for FB1 and C1
    TRUE ~ "3%"                           # Assign 3% for others
  ))

#numeric & convert units to ton C / ha, 0.22 m² / mesocosm
#gC/m2*1/10^6 gC/tonC*10 000 m2/ha
df$cumDIC <- as.numeric (df$cumDIC)*10^(4)/0.22/10^(6)
df$cumse <- as.numeric (df$cumse)*10^(4)/0.22/10^(6)
df$dayvector <- as.numeric (df$dayvector)

treatment_order <- c("C1", "FB1", "C3","CB3","FB3","CD3","MD3","FD3")
# Convert Treatment column to factor with the specified order
df$treatmentvector <- factor(df$treatmentvector, levels = treatment_order)
df$Treatment <- df$treatmentvector

#add psize for stats
# df$basaltsize <- with(df, ifelse(Treatment %in% c("FB1", "FB3"), 292, 
#                                                          ifelse(Treatment == "CB3", 670, "")))
# df$dunitesize <- with(df, ifelse(Treatment == "FD3", 71, 
#                                        ifelse(Treatment == "MD3", 278, 
#                                               ifelse(Treatment == "CD3", 1030, ""))))     
# 
# #model dunite
# dfdunite <- df[-which(df$silicate_type=="Basalt"),]
 dfbasalt <- df[-which(df$silicate_type=="Dunite"),]

#no sign. basalt effect
model <- lm (data=dfbasalt,cumDIC ~ silicate_type+SOC )
summary (model)

Cumul_DIC_tonCha <-  ggplot(df, aes_string("dayvector", "cumDIC", col = "Treatment", shape = "Treatment", size = "Treatment", fill = "Treatment" )) +
  theme_bw() + theme(axis.title.y = element_text(size= 10), axis.title.x = element_text(size= 10), axis.title = element_text(face = "bold")) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour= "black"))+
  geom_point() + 
  geom_errorbar(aes_string(ymin = paste0("cumDIC", "-cumse"), ymax = paste0("cumDIC", "+cumse")), size = 0.1) +
  # Customize aesthetics for each treatment
  scale_shape_manual(values = c("C1" = 22, "FB1" = 21, "C3" = 22, "CB3" = 21, "CD3" = 23, "FB3" = 21, "FD3" = 23, "MD3" = 23)) + 
  scale_size_manual(values = c("C1" = 4, "FB1" = 2, "C3" = 4, "CB3" = 6, "CD3" = 6, "FB3" = 2, "FD3" = 2, "MD3" = 4)) + 
  scale_color_manual(values = c("C1" = "black", "FB1" = "grey", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
  scale_fill_manual(values = c("C1" = "white", "FB1" = "white", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
  ylab("DIC \n (ton C ha-1)") + xlab("Time \n (days)")+
  theme(legend.position = "none")

output_path <- "C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_/DIC_cumul_time.jpeg"
ggsave(filename = output_path, plot = Cumul_DIC_tonCha, width = 6, height = 6, units = "in", dpi = 600)


df <- df[which(df$dayvector==392),]
calculate_difference <- function(DIC1, SE1, DIC2, SE2) {
  diff <- DIC1 - DIC2
  propagated_se <- sqrt(SE1^2 + SE2^2)
  return(c(diff, propagated_se))
}

# Initialize results list for the comparisons
results_list <- list()

# FB1 - C1 comparison
results_list[["FB1 - C1"]] <- calculate_difference(
  df$cumDIC[df$Treatment == "FB1"], 
  df$cumse[df$Treatment == "FB1"], 
  df$cumDIC[df$Treatment == "C1"], 
  df$cumse[df$Treatment == "C1"]
)

# Loop through treatments ending with '3' and subtract from C3
for (treatment in df$Treatment[grepl("3$", df$Treatment) & df$Treatment != "C3"]) {
  comparison_name <- paste(treatment, "- C3")
  results_list[[comparison_name]] <- calculate_difference(
    df$cumDIC[df$Treatment == treatment], 
    df$cumse[df$Treatment == treatment], 
    df$cumDIC[df$Treatment == "C3"], 
    df$cumse[df$Treatment == "C3"]
  )
}

# Convert the results list into a data frame
results <- do.call(rbind, lapply(names(results_list), function(name) {
  cbind(Comparison = name, as.data.frame(t(results_list[[name]])))
}))
colnames(results) <- c("Comparison", "Difference", "Propagated_SE")

results$Treatment <- c("FB1","CB3","CD3","FB3","FD3","MD3")
treatment_order <- c( "FB1", "CB3","FB3","CD3","MD3","FD3")
# Convert Treatment column to factor with the specified order
results$Treatment <- factor(results$Treatment, levels = treatment_order)
results$cumDIC <- results$Difference
results$cumse <- results$Propagated_SE 


delta_Cumul_DIC_tonCha <-  ggplot(results, aes_string("Treatment", "cumDIC", col = "Treatment", shape = "Treatment", size = "Treatment", fill = "Treatment" )) +
  theme_bw() + theme(axis.title.y = element_text(size= 10), axis.title.x = element_text(size= 10), axis.title = element_text(face = "bold")) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour= "black"))+
  geom_point() + 
  geom_errorbar(aes_string(ymin = paste0("cumDIC", "-cumse"), ymax = paste0("cumDIC", "+cumse")), size = 0.1) +
  # Customize aesthetics for each treatment
  scale_shape_manual(values = c("C1" = 22, "FB1" = 21, "C3" = 22, "CB3" = 21, "CD3" = 23, "FB3" = 21, "FD3" = 23, "MD3" = 23)) + 
  scale_size_manual(values = c("C1" = 4, "FB1" = 2, "C3" = 4, "CB3" = 6, "CD3" = 6, "FB3" = 2, "FD3" = 2, "MD3" = 4)) + 
  scale_color_manual(values = c("C1" = "black", "FB1" = "grey", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
  scale_fill_manual(values = c("C1" = "white", "FB1" = "white", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
  ylab("DIC \n (ton C ha-1)") + xlab("")+
  theme(axis.text.x = element_blank(), axis.ticks.x = element_blank(), axis.text.y = element_text(size = 10))  +  
  theme(legend.position = "none") # Remove x-axis text and ticks

forlegend <-  ggplot(results, aes_string("Treatment", "cumDIC", col = "Treatment", shape = "Treatment", size = "Treatment", fill = "Treatment" )) +
  theme_bw() + theme(axis.title.y = element_text(size= 10), axis.title.x = element_text(size= 10), axis.title = element_text(face = "bold")) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour= "black"))+
  geom_point() + 
  geom_errorbar(aes_string(ymin = paste0("cumDIC", "-cumse"), ymax = paste0("cumDIC", "+cumse")), size = 0.1) +
  # Customize aesthetics for each treatment
  scale_shape_manual(values = c("C1" = 22, "FB1" = 21, "C3" = 22, "CB3" = 21, "CD3" = 23, "FB3" = 21, "FD3" = 23, "MD3" = 23)) + 
  scale_size_manual(values = c("C1" = 4, "FB1" = 2, "C3" = 4, "CB3" = 6, "CD3" = 6, "FB3" = 2, "FD3" = 2, "MD3" = 4)) + 
  scale_color_manual(values = c("C1" = "black", "FB1" = "grey", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
  scale_fill_manual(values = c("C1" = "white", "FB1" = "white", "C3" = "black", "CB3" = "grey", "CD3" = "darkgreen", "FB3" = "grey", "FD3" = "darkgreen", "MD3" = "darkgreen")) +
  ylab("DIC \n (ton C ha-1)") + xlab("")+
  theme(axis.text.x = element_blank(), axis.ticks.x = element_blank(), axis.text.y = element_text(size = 10))  

output_path <- "C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_/DIC_cumul.jpeg"
ggsave(filename = output_path, plot = delta_Cumul_DIC_tonCha, width = 6, height = 6, units = "in", dpi = 600)

#combined plot 
library (cowplot)
  legend <- get_legend(forlegend)

  
DIC_SICplot  <- plot_grid(plot_grid(delta_Cumul_DIC_tonCha, deltaSIC_tonC_ha , labels = "AUTO", ncol = 2), 
                          legend, ncol = 2,  rel_widths  = c(1, 0.2))
output_path <- "C:/Users/AVienne/OneDrive - Universiteit Antwerpen/Labexp 3 (start Oct 2022)/PAPER_/DIC_SIC_plot.jpeg"
ggsave(filename = output_path, plot = DIC_SICplot, width = 6, height = 4, units = "in", dpi = 600)

