#!/usr/bin/env bash
set -Eeuo pipefail

LOG_DIR="zz-logs/cleanup_assets"
mkdir -p "$LOG_DIR"
TS="$(date -u +'%Y%m%dT%H%M%SZ')"
LOG_FILE="$LOG_DIR/delete_run_${TS}.log"

echo "==============================================="
echo " SCRIPT DE SUPPRESSION RÉELLE DES ASSETS"
echo "  - Source : CLEANUP_ASSETS_DELETE_CANDIDATES.tsv"
echo "  - Tous les fichiers ci-dessous sont considérés delete-safe"
echo "==============================================="
echo ""
echo "Total candidats à la suppression : 1317"
echo "Par classe :"
echo "  BACKUP_OR_RESCUE: 1202"
echo "  BYTECODE: 107"
echo "  ENV_REQUIREMENTS_DUP: 8"
echo ""
echo "Par chapitre :"
echo "  Chapitre 1: 105"
echo "  Chapitre 2: 125"
echo "  Chapitre 3: 72"
echo "  Chapitre 4: 46"
echo "  Chapitre 5: 53"
echo "  Chapitre 6: 107"
echo "  Chapitre 7: 150"
echo "  Chapitre 8: 99"
echo "  Chapitre 9: 191"
echo "  Chapitre 10: 369"
echo ""
echo ""
echo "ATTENTION : ce script VA SUPPRIMER définitivement ces fichiers."
echo "Avant de continuer, assure-toi d'avoir : "
echo "  - fait un git commit propre,"
echo "  - tagué/branché si nécessaire,"
echo "  - relu le DRY-RUN (CLEANUP_ASSETS_DELETE_DRYRUN.sh)."
echo ""
read -r -p "Confirmer la suppression ? (yes/NO) : " CONFIRM
if [ "$CONFIRM" != "yes" ] && [ "$CONFIRM" != "YES" ]; then
  echo "Abandon : confirmation manquante."
  exit 1
fi
echo ""
echo "Tape EXACTEMENT : DELETE_ASSETS_NOW pour continuer."
read -r FINAL
if [ "$FINAL" != "DELETE_ASSETS_NOW" ]; then
  echo "Abandon : phrase de sécurité incorrecte."
  exit 1
fi
echo ""
echo "[OK] Début des suppressions..."
echo "[INFO] Log : $LOG_FILE"
echo ""
echo "----- SUPPRESSIONS -----"
echo ""
if [ -e 'zz-scripts/chapter01/generate_data_chapter01.py.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/generate_data_chapter01.py.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/generate_data_chapter01.py.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/generate_data_chapter01.py.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/generate_data_chapter01.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/generate_data_chapter01.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/generate_data_chapter01.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/generate_data_chapter01.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/generate_data_chapter01.py.bak.20251104T204632Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/generate_data_chapter01.py.bak.20251104T204632Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/generate_data_chapter01.py.bak.20251104T204632Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/generate_data_chapter01.py.bak.20251104T204632Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/generate_data_chapter01.py.bak.20251104T204932Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/generate_data_chapter01.py.bak.20251104T204932Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/generate_data_chapter01.py.bak.20251104T204932Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/generate_data_chapter01.py.bak.20251104T204932Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/generate_data_chapter01.py.bak_20251031T173332Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/generate_data_chapter01.py.bak_20251031T173332Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/generate_data_chapter01.py.bak_20251031T173332Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/generate_data_chapter01.py.bak_20251031T173332Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/generate_data_chapter01.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/generate_data_chapter01.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/generate_data_chapter01.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/generate_data_chapter01.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/generate_data_chapter01.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/generate_data_chapter01.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/generate_data_chapter01.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/generate_data_chapter01.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/generate_data_chapter01.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/generate_data_chapter01.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/generate_data_chapter01.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/generate_data_chapter01.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/generate_data_chapter01.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/generate_data_chapter01.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/generate_data_chapter01.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/generate_data_chapter01.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak_20251031T173332Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak_20251031T173332Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak_20251031T173332Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak_20251031T173332Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig01_early_plateau.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig01_early_plateau.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig01_early_plateau.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig01_early_plateau.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig01_early_plateau.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig01_early_plateau.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig01_early_plateau.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig01_early_plateau.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig01_early_plateau.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig01_early_plateau.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig01_early_plateau.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig01_early_plateau.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig01_early_plateau.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig01_early_plateau.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig01_early_plateau.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig01_early_plateau.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig01_early_plateau.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak_20251031T173332Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak_20251031T173332Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak_20251031T173332Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak_20251031T173332Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak_20251031T223650Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak_20251031T223650Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak_20251031T223650Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.bak_20251031T223650Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig02_logistic_calibration.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak_20251031T173333Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak_20251031T173333Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak_20251031T173333Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak_20251031T173333Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak_20251031T223650Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak_20251031T223650Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak_20251031T223650Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.bak_20251031T223650Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig03_relative_error_timeline.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T173333Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T173333Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T173333Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T173333Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T224414Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T224414Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T224414Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T224414Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T224607Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T224607Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T224607Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T224607Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T224902Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T224902Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T224902Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251031T224902Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251101T000932Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251101T000932Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251101T000932Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251101T000932Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251101T001424Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251101T001424Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251101T001424Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251101T001424Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251101T001910Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251101T001910Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251101T001910Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251101T001910Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251101T002047Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251101T002047Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251101T002047Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.bak_20251101T002047Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig04_P_vs_T_evolution.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak_20251031T173334Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak_20251031T173334Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak_20251031T173334Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak_20251031T173334Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak_20251031T223650Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak_20251031T223650Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak_20251031T223650Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.bak_20251031T223650Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig05_I1_vs_T.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T173334Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T173334Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T173334Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T173334Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T224414Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T224414Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T224414Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T224414Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T224607Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T224607Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T224607Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T224607Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T224902Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T224902Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T224902Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251031T224902Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251101T000932Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251101T000932Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251101T000932Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251101T000932Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251101T001424Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251101T001424Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251101T001424Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251101T001424Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251101T001910Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251101T001910Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251101T001910Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251101T001910Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251101T002144Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251101T002144Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251101T002144Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.bak_20251101T002144Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter01/plot_fig06_P_derivative_comparison.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/__pycache__/generate_data_chapter01.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter01/__pycache__/generate_data_chapter01.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/__pycache__/generate_data_chapter01.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter01/__pycache__/generate_data_chapter01.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/__pycache__/plot_fig01_early_plateau.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter01/__pycache__/plot_fig01_early_plateau.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/__pycache__/plot_fig01_early_plateau.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter01/__pycache__/plot_fig01_early_plateau.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/__pycache__/plot_fig02_logistic_calibration.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter01/__pycache__/plot_fig02_logistic_calibration.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/__pycache__/plot_fig02_logistic_calibration.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter01/__pycache__/plot_fig02_logistic_calibration.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/__pycache__/plot_fig03_relative_error_timeline.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter01/__pycache__/plot_fig03_relative_error_timeline.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/__pycache__/plot_fig03_relative_error_timeline.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter01/__pycache__/plot_fig03_relative_error_timeline.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/__pycache__/plot_fig04_P_vs_T_evolution.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter01/__pycache__/plot_fig04_P_vs_T_evolution.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/__pycache__/plot_fig04_P_vs_T_evolution.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter01/__pycache__/plot_fig04_P_vs_T_evolution.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/__pycache__/plot_fig05_I1_vs_T.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter01/__pycache__/plot_fig05_I1_vs_T.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/__pycache__/plot_fig05_I1_vs_T.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter01/__pycache__/plot_fig05_I1_vs_T.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/__pycache__/plot_fig06_P_derivative_comparison.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter01/__pycache__/plot_fig06_P_derivative_comparison.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/__pycache__/plot_fig06_P_derivative_comparison.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter01/__pycache__/plot_fig06_P_derivative_comparison.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter01/requirements.txt' ]; then echo "[DELETE] [ENV_REQUIREMENTS_DUP] rm 'zz-scripts/chapter01/requirements.txt'  # requirements.txt local dupliqué (environnement spécifique)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter01/requirements.txt'; else echo "[MISSING] [ENV_REQUIREMENTS_DUP] 'zz-scripts/chapter01/requirements.txt'  # (déjà absent) requirements.txt local dupliqué (environnement spécifique)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/generate_data_chapter02.py.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/generate_data_chapter02.py.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/generate_data_chapter02.py.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/generate_data_chapter02.py.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/generate_data_chapter02.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/generate_data_chapter02.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/generate_data_chapter02.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/generate_data_chapter02.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/generate_data_chapter02.py.bak.20251104T205140Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/generate_data_chapter02.py.bak.20251104T205140Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/generate_data_chapter02.py.bak.20251104T205140Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/generate_data_chapter02.py.bak.20251104T205140Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/generate_data_chapter02.py.bak.20251104T205352Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/generate_data_chapter02.py.bak.20251104T205352Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/generate_data_chapter02.py.bak.20251104T205352Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/generate_data_chapter02.py.bak.20251104T205352Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/generate_data_chapter02.py.bak.20251104T205837Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/generate_data_chapter02.py.bak.20251104T205837Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/generate_data_chapter02.py.bak.20251104T205837Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/generate_data_chapter02.py.bak.20251104T205837Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/generate_data_chapter02.py.bak.20251104T210206Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/generate_data_chapter02.py.bak.20251104T210206Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/generate_data_chapter02.py.bak.20251104T210206Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/generate_data_chapter02.py.bak.20251104T210206Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/generate_data_chapter02.py.bak_20251031T173334Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/generate_data_chapter02.py.bak_20251031T173334Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/generate_data_chapter02.py.bak_20251031T173334Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/generate_data_chapter02.py.bak_20251031T173334Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/generate_data_chapter02.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/generate_data_chapter02.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/generate_data_chapter02.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/generate_data_chapter02.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/generate_data_chapter02.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/generate_data_chapter02.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/generate_data_chapter02.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/generate_data_chapter02.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/generate_data_chapter02.py.r10.20251104T210441Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/generate_data_chapter02.py.r10.20251104T210441Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/generate_data_chapter02.py.r10.20251104T210441Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/generate_data_chapter02.py.r10.20251104T210441Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/generate_data_chapter02.py.r11.20251104T211127Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/generate_data_chapter02.py.r11.20251104T211127Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/generate_data_chapter02.py.r11.20251104T211127Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/generate_data_chapter02.py.r11.20251104T211127Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/generate_data_chapter02.py.r12.20251104T211548Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/generate_data_chapter02.py.r12.20251104T211548Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/generate_data_chapter02.py.r12.20251104T211548Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/generate_data_chapter02.py.r12.20251104T211548Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/generate_data_chapter02.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/generate_data_chapter02.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/generate_data_chapter02.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/generate_data_chapter02.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/generate_data_chapter02.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/generate_data_chapter02.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/generate_data_chapter02.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/generate_data_chapter02.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak_20251031T173334Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak_20251031T173334Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak_20251031T173334Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak_20251031T173334Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig00_spectrum.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig00_spectrum.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig00_spectrum.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig00_spectrum.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig00_spectrum.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig00_spectrum.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig00_spectrum.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig00_spectrum.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig00_spectrum.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig00_spectrum.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig00_spectrum.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig00_spectrum.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig00_spectrum.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig00_spectrum.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig00_spectrum.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig00_spectrum.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig00_spectrum.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T173334Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T173334Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T173334Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T173334Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T224414Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T224414Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T224414Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T224414Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T224607Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T224607Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T224607Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T224607Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T224902Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T224902Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T224902Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251031T224902Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251101T000932Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251101T000932Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251101T000932Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251101T000932Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251101T001424Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251101T001424Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251101T001424Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251101T001424Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251101T001910Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251101T001910Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251101T001910Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251101T001910Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251101T002144Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251101T002144Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251101T002144Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.bak_20251101T002144Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig01_P_vs_T_evolution.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig02_calibration.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig02_calibration.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig02_calibration.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig02_calibration.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig02_calibration.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig02_calibration.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig02_calibration.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig02_calibration.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig02_calibration.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig02_calibration.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig02_calibration.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig02_calibration.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig02_calibration.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig02_calibration.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig02_calibration.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig02_calibration.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig02_calibration.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig02_calibration.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig02_calibration.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig02_calibration.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig02_calibration.py.bak_20251031T173334Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig02_calibration.py.bak_20251031T173334Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig02_calibration.py.bak_20251031T173334Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig02_calibration.py.bak_20251031T173334Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig02_calibration.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig02_calibration.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig02_calibration.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig02_calibration.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig02_calibration.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig02_calibration.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig02_calibration.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig02_calibration.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig02_calibration.py.bak_20251031T223650Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig02_calibration.py.bak_20251031T223650Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig02_calibration.py.bak_20251031T223650Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig02_calibration.py.bak_20251031T223650Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig02_calibration.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig02_calibration.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig02_calibration.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig02_calibration.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig02_calibration.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig02_calibration.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig02_calibration.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig02_calibration.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig02_calibration.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig02_calibration.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig02_calibration.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig02_calibration.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig02_calibration.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig02_calibration.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig02_calibration.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig02_calibration.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T173335Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T173335Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T173335Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T173335Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T224414Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T224414Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T224414Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T224414Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T224607Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T224607Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T224607Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T224607Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T224902Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T224902Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T224902Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251031T224902Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251101T000932Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251101T000932Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251101T000932Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251101T000932Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251101T001424Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251101T001424Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251101T001424Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251101T001424Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251101T001910Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251101T001910Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251101T001910Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251101T001910Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251101T002144Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251101T002144Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251101T002144Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig03_relative_errors.py.bak_20251101T002144Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig03_relative_errors.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig03_relative_errors.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig03_relative_errors.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig03_relative_errors.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig03_relative_errors.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig03_relative_errors.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig03_relative_errors.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig03_relative_errors.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig03_relative_errors.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig03_relative_errors.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig03_relative_errors.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig03_relative_errors.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig03_relative_errors.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig03_relative_errors.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig03_relative_errors.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig03_relative_errors.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak_20251031T173335Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak_20251031T173335Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak_20251031T173335Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak_20251031T173335Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig04_pipeline_diagram.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251031T173335Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251031T173335Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251031T173335Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251031T173335Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251031T224902Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251031T224902Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251031T224902Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251031T224902Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T000932Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T000932Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T000932Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T000932Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T001424Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T001424Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T001424Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T001424Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T001910Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T001910Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T001910Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T001910Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T002144Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T002144Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T002144Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T002144Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T002655Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T002655Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T002655Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T002655Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T002916Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T002916Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T002916Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T002916Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T003102Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T003102Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T003102Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T003102Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T003313Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T003313Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T003313Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig05_FG_series.py.bak_20251101T003313Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak_20251031T173335Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak_20251031T173335Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak_20251031T173335Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak_20251031T173335Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/plot_fig06_alpha_fit.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/primordial_spectrum.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/primordial_spectrum.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/primordial_spectrum.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/primordial_spectrum.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/primordial_spectrum.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/primordial_spectrum.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/primordial_spectrum.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/primordial_spectrum.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/primordial_spectrum.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/primordial_spectrum.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/primordial_spectrum.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/primordial_spectrum.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/primordial_spectrum.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/primordial_spectrum.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/primordial_spectrum.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/primordial_spectrum.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/primordial_spectrum.py.bak_20251031T182357Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/primordial_spectrum.py.bak_20251031T182357Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/primordial_spectrum.py.bak_20251031T182357Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/primordial_spectrum.py.bak_20251031T182357Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/primordial_spectrum.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/primordial_spectrum.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/primordial_spectrum.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/primordial_spectrum.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/primordial_spectrum.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter02/primordial_spectrum.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/primordial_spectrum.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter02/primordial_spectrum.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/__pycache__/generate_data_chapter02.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter02/__pycache__/generate_data_chapter02.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/__pycache__/generate_data_chapter02.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter02/__pycache__/generate_data_chapter02.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/__pycache__/plot_fig00_spectrum.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter02/__pycache__/plot_fig00_spectrum.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/__pycache__/plot_fig00_spectrum.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter02/__pycache__/plot_fig00_spectrum.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/__pycache__/plot_fig01_P_vs_T_evolution.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter02/__pycache__/plot_fig01_P_vs_T_evolution.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/__pycache__/plot_fig01_P_vs_T_evolution.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter02/__pycache__/plot_fig01_P_vs_T_evolution.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/__pycache__/plot_fig02_calibration.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter02/__pycache__/plot_fig02_calibration.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/__pycache__/plot_fig02_calibration.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter02/__pycache__/plot_fig02_calibration.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/__pycache__/plot_fig03_relative_errors.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter02/__pycache__/plot_fig03_relative_errors.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/__pycache__/plot_fig03_relative_errors.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter02/__pycache__/plot_fig03_relative_errors.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/__pycache__/plot_fig04_pipeline_diagram.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter02/__pycache__/plot_fig04_pipeline_diagram.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/__pycache__/plot_fig04_pipeline_diagram.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter02/__pycache__/plot_fig04_pipeline_diagram.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/__pycache__/plot_fig05_FG_series.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter02/__pycache__/plot_fig05_FG_series.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/__pycache__/plot_fig05_FG_series.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter02/__pycache__/plot_fig05_FG_series.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/__pycache__/plot_fig06_alpha_fit.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter02/__pycache__/plot_fig06_alpha_fit.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/__pycache__/plot_fig06_alpha_fit.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter02/__pycache__/plot_fig06_alpha_fit.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/__pycache__/primordial_spectrum.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter02/__pycache__/primordial_spectrum.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/__pycache__/primordial_spectrum.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter02/__pycache__/primordial_spectrum.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter02/requirements.txt' ]; then echo "[DELETE] [ENV_REQUIREMENTS_DUP] rm 'zz-scripts/chapter02/requirements.txt'  # requirements.txt local dupliqué (environnement spécifique)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter02/requirements.txt'; else echo "[MISSING] [ENV_REQUIREMENTS_DUP] 'zz-scripts/chapter02/requirements.txt'  # (déjà absent) requirements.txt local dupliqué (environnement spécifique)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/generate_data_chapter03.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/generate_data_chapter03.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/generate_data_chapter03.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/generate_data_chapter03.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/generate_data_chapter03.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/generate_data_chapter03.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/generate_data_chapter03.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/generate_data_chapter03.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/generate_data_chapter03.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/generate_data_chapter03.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/generate_data_chapter03.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/generate_data_chapter03.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/generate_data_chapter03.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/generate_data_chapter03.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/generate_data_chapter03.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/generate_data_chapter03.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/generate_data_chapter03.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/generate_data_chapter03.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/generate_data_chapter03.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/generate_data_chapter03.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/generate_data_chapter03.py.bak_20251031T173335Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/generate_data_chapter03.py.bak_20251031T173335Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/generate_data_chapter03.py.bak_20251031T173335Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/generate_data_chapter03.py.bak_20251031T173335Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/generate_data_chapter03.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/generate_data_chapter03.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/generate_data_chapter03.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/generate_data_chapter03.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/generate_data_chapter03.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/generate_data_chapter03.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/generate_data_chapter03.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/generate_data_chapter03.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak_20251031T173335Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak_20251031T173335Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak_20251031T173335Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak_20251031T173335Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig01_fR_stability_domain.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak_20251031T173335Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak_20251031T173335Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak_20251031T173335Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak_20251031T173335Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig02_fR_fRR_vs_f.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak_20251031T173335Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak_20251031T173335Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak_20251031T173335Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak_20251031T173335Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig03_ms2_R0_vs_f.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak_20251031T173335Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak_20251031T173335Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak_20251031T173335Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak_20251031T173335Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig04_fR_fRR_vs_f.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak_20251031T173335Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak_20251031T173335Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak_20251031T173335Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak_20251031T173335Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig05_interpolated_milestones.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak_20251031T173335Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak_20251031T173335Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak_20251031T173335Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak_20251031T173335Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig06_grid_quality.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig07_ricci_fR_vs_z.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig07_ricci_fR_vs_z.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig07_ricci_fR_vs_z.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig07_ricci_fR_vs_z.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig07_ricci_fR_vs_z.py.bak_20251031T173336Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig07_ricci_fR_vs_z.py.bak_20251031T173336Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig07_ricci_fR_vs_z.py.bak_20251031T173336Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig07_ricci_fR_vs_z.py.bak_20251031T173336Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig07_ricci_fR_vs_z.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig07_ricci_fR_vs_z.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig07_ricci_fR_vs_z.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig07_ricci_fR_vs_z.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig07_ricci_fR_vs_z.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig07_ricci_fR_vs_z.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig07_ricci_fR_vs_z.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig07_ricci_fR_vs_z.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig08_ricci_fR_vs_T.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig08_ricci_fR_vs_T.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig08_ricci_fR_vs_T.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig08_ricci_fR_vs_T.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig08_ricci_fR_vs_T.py.bak_20251031T173336Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig08_ricci_fR_vs_T.py.bak_20251031T173336Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig08_ricci_fR_vs_T.py.bak_20251031T173336Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig08_ricci_fR_vs_T.py.bak_20251031T173336Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig08_ricci_fR_vs_T.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig08_ricci_fR_vs_T.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig08_ricci_fR_vs_T.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig08_ricci_fR_vs_T.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/plot_fig08_ricci_fR_vs_T.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/plot_fig08_ricci_fR_vs_T.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/plot_fig08_ricci_fR_vs_T.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/plot_fig08_ricci_fR_vs_T.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/utils/convert_milestones.py.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/utils/convert_milestones.py.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/utils/convert_milestones.py.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/utils/convert_milestones.py.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/utils/convert_milestones.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/utils/convert_milestones.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/utils/convert_milestones.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/utils/convert_milestones.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/utils/convert_milestones.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter03/utils/convert_milestones.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/utils/convert_milestones.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter03/utils/convert_milestones.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/__pycache__/generate_data_chapter03.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter03/__pycache__/generate_data_chapter03.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/__pycache__/generate_data_chapter03.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter03/__pycache__/generate_data_chapter03.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/__pycache__/plot_fig01_fR_stability_domain.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter03/__pycache__/plot_fig01_fR_stability_domain.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/__pycache__/plot_fig01_fR_stability_domain.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter03/__pycache__/plot_fig01_fR_stability_domain.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/__pycache__/plot_fig02_fR_fRR_vs_f.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter03/__pycache__/plot_fig02_fR_fRR_vs_f.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/__pycache__/plot_fig02_fR_fRR_vs_f.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter03/__pycache__/plot_fig02_fR_fRR_vs_f.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/__pycache__/plot_fig03_ms2_R0_vs_f.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter03/__pycache__/plot_fig03_ms2_R0_vs_f.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/__pycache__/plot_fig03_ms2_R0_vs_f.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter03/__pycache__/plot_fig03_ms2_R0_vs_f.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/__pycache__/plot_fig04_fR_fRR_vs_f.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter03/__pycache__/plot_fig04_fR_fRR_vs_f.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/__pycache__/plot_fig04_fR_fRR_vs_f.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter03/__pycache__/plot_fig04_fR_fRR_vs_f.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/__pycache__/plot_fig05_interpolated_milestones.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter03/__pycache__/plot_fig05_interpolated_milestones.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/__pycache__/plot_fig05_interpolated_milestones.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter03/__pycache__/plot_fig05_interpolated_milestones.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/__pycache__/plot_fig06_grid_quality.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter03/__pycache__/plot_fig06_grid_quality.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/__pycache__/plot_fig06_grid_quality.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter03/__pycache__/plot_fig06_grid_quality.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/__pycache__/plot_fig07_ricci_fR_vs_z.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter03/__pycache__/plot_fig07_ricci_fR_vs_z.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/__pycache__/plot_fig07_ricci_fR_vs_z.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter03/__pycache__/plot_fig07_ricci_fR_vs_z.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/__pycache__/plot_fig08_ricci_fR_vs_T.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter03/__pycache__/plot_fig08_ricci_fR_vs_T.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/__pycache__/plot_fig08_ricci_fR_vs_T.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter03/__pycache__/plot_fig08_ricci_fR_vs_T.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/utils/__pycache__/convert_milestones.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter03/utils/__pycache__/convert_milestones.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/utils/__pycache__/convert_milestones.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter03/utils/__pycache__/convert_milestones.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter03/requirements.txt' ]; then echo "[DELETE] [ENV_REQUIREMENTS_DUP] rm 'zz-scripts/chapter03/requirements.txt'  # requirements.txt local dupliqué (environnement spécifique)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter03/requirements.txt'; else echo "[MISSING] [ENV_REQUIREMENTS_DUP] 'zz-scripts/chapter03/requirements.txt'  # (déjà absent) requirements.txt local dupliqué (environnement spécifique)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/generate_data_chapter04.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/generate_data_chapter04.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/generate_data_chapter04.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/generate_data_chapter04.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/generate_data_chapter04.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/generate_data_chapter04.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/generate_data_chapter04.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/generate_data_chapter04.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/generate_data_chapter04.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/generate_data_chapter04.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/generate_data_chapter04.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/generate_data_chapter04.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/generate_data_chapter04.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/generate_data_chapter04.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/generate_data_chapter04.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/generate_data_chapter04.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/generate_data_chapter04.py.bak_20251031T173336Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/generate_data_chapter04.py.bak_20251031T173336Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/generate_data_chapter04.py.bak_20251031T173336Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/generate_data_chapter04.py.bak_20251031T173336Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/generate_data_chapter04.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/generate_data_chapter04.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/generate_data_chapter04.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/generate_data_chapter04.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/generate_data_chapter04.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/generate_data_chapter04.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/generate_data_chapter04.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/generate_data_chapter04.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak_20251031T173336Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak_20251031T173336Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak_20251031T173336Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak_20251031T173336Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig01_invariants_schematic.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak_20251031T173336Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak_20251031T173336Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak_20251031T173336Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak_20251031T173336Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig02_invariants_histogram.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak_20251031T173336Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak_20251031T173336Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak_20251031T173336Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak_20251031T173336Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig03_invariants_vs_T.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak.20251104T204632Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak.20251104T204632Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak.20251104T204632Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak.20251104T204632Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak.20251104T205352Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak.20251104T205352Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak.20251104T205352Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak.20251104T205352Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak_20251031T173336Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak_20251031T173336Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak_20251031T173336Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak_20251031T173336Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter04/plot_fig04_relative_deviations.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/__pycache__/generate_data_chapter04.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter04/__pycache__/generate_data_chapter04.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/__pycache__/generate_data_chapter04.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter04/__pycache__/generate_data_chapter04.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/__pycache__/plot_fig01_invariants_schematic.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter04/__pycache__/plot_fig01_invariants_schematic.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/__pycache__/plot_fig01_invariants_schematic.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter04/__pycache__/plot_fig01_invariants_schematic.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/__pycache__/plot_fig02_invariants_histogram.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter04/__pycache__/plot_fig02_invariants_histogram.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/__pycache__/plot_fig02_invariants_histogram.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter04/__pycache__/plot_fig02_invariants_histogram.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/__pycache__/plot_fig03_invariants_vs_T.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter04/__pycache__/plot_fig03_invariants_vs_T.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/__pycache__/plot_fig03_invariants_vs_T.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter04/__pycache__/plot_fig03_invariants_vs_T.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/__pycache__/plot_fig04_relative_deviations.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter04/__pycache__/plot_fig04_relative_deviations.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/__pycache__/plot_fig04_relative_deviations.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter04/__pycache__/plot_fig04_relative_deviations.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter04/requirements.txt' ]; then echo "[DELETE] [ENV_REQUIREMENTS_DUP] rm 'zz-scripts/chapter04/requirements.txt'  # requirements.txt local dupliqué (environnement spécifique)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter04/requirements.txt'; else echo "[MISSING] [ENV_REQUIREMENTS_DUP] 'zz-scripts/chapter04/requirements.txt'  # (déjà absent) requirements.txt local dupliqué (environnement spécifique)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/generate_data_chapter05.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/generate_data_chapter05.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/generate_data_chapter05.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/generate_data_chapter05.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/generate_data_chapter05.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/generate_data_chapter05.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/generate_data_chapter05.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/generate_data_chapter05.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/generate_data_chapter05.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/generate_data_chapter05.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/generate_data_chapter05.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/generate_data_chapter05.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/generate_data_chapter05.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/generate_data_chapter05.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/generate_data_chapter05.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/generate_data_chapter05.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/generate_data_chapter05.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/generate_data_chapter05.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/generate_data_chapter05.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/generate_data_chapter05.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/generate_data_chapter05.py.bak_20251031T173336Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/generate_data_chapter05.py.bak_20251031T173336Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/generate_data_chapter05.py.bak_20251031T173336Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/generate_data_chapter05.py.bak_20251031T173336Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/generate_data_chapter05.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/generate_data_chapter05.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/generate_data_chapter05.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/generate_data_chapter05.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/generate_data_chapter05.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/generate_data_chapter05.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/generate_data_chapter05.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/generate_data_chapter05.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/generate_data_chapter05.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/generate_data_chapter05.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/generate_data_chapter05.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/generate_data_chapter05.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/generate_data_chapter05.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/generate_data_chapter05.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/generate_data_chapter05.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/generate_data_chapter05.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/generate_data_chapter05.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/generate_data_chapter05.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/generate_data_chapter05.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/generate_data_chapter05.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/generate_data_chapter05.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/generate_data_chapter05.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/generate_data_chapter05.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/generate_data_chapter05.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak_20251031T173336Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak_20251031T173336Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak_20251031T173336Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak_20251031T173336Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig01_bbn_reaction_network.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak_20251031T173337Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak_20251031T173337Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak_20251031T173337Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak_20251031T173337Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig02_dh_model_vs_obs.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak_20251031T173337Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak_20251031T173337Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak_20251031T173337Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak_20251031T173337Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig03_yp_model_vs_obs.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak_20251031T173338Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak_20251031T173338Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak_20251031T173338Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak_20251031T173338Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter05/plot_fig04_chi2_vs_T.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/__pycache__/generate_data_chapter05.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter05/__pycache__/generate_data_chapter05.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/__pycache__/generate_data_chapter05.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter05/__pycache__/generate_data_chapter05.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/__pycache__/plot_fig01_bbn_reaction_network.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter05/__pycache__/plot_fig01_bbn_reaction_network.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/__pycache__/plot_fig01_bbn_reaction_network.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter05/__pycache__/plot_fig01_bbn_reaction_network.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/__pycache__/plot_fig02_dh_model_vs_obs.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter05/__pycache__/plot_fig02_dh_model_vs_obs.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/__pycache__/plot_fig02_dh_model_vs_obs.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter05/__pycache__/plot_fig02_dh_model_vs_obs.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/__pycache__/plot_fig03_yp_model_vs_obs.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter05/__pycache__/plot_fig03_yp_model_vs_obs.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/__pycache__/plot_fig03_yp_model_vs_obs.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter05/__pycache__/plot_fig03_yp_model_vs_obs.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/__pycache__/plot_fig04_chi2_vs_T.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter05/__pycache__/plot_fig04_chi2_vs_T.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/__pycache__/plot_fig04_chi2_vs_T.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter05/__pycache__/plot_fig04_chi2_vs_T.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter05/requirements.txt' ]; then echo "[DELETE] [ENV_REQUIREMENTS_DUP] rm 'zz-scripts/chapter05/requirements.txt'  # requirements.txt local dupliqué (environnement spécifique)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter05/requirements.txt'; else echo "[MISSING] [ENV_REQUIREMENTS_DUP] 'zz-scripts/chapter05/requirements.txt'  # (déjà absent) requirements.txt local dupliqué (environnement spécifique)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T205140Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T205140Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T205140Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T205140Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T205352Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T205352Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T205352Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T205352Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T205837Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T205837Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T205837Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T205837Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T210206Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T210206Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T210206Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_data_chapter06.py.bak.20251104T210206Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_data_chapter06.py.bak_20251031T173338Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_data_chapter06.py.bak_20251031T173338Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_data_chapter06.py.bak_20251031T173338Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_data_chapter06.py.bak_20251031T173338Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_data_chapter06.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_data_chapter06.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_data_chapter06.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_data_chapter06.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_data_chapter06.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_data_chapter06.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_data_chapter06.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_data_chapter06.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_data_chapter06.py.r10.20251104T210441Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_data_chapter06.py.r10.20251104T210441Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_data_chapter06.py.r10.20251104T210441Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_data_chapter06.py.r10.20251104T210441Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_data_chapter06.py.r11.20251104T211127Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_data_chapter06.py.r11.20251104T211127Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_data_chapter06.py.r11.20251104T211127Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_data_chapter06.py.r11.20251104T211127Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_data_chapter06.py.r12.20251104T211548Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_data_chapter06.py.r12.20251104T211548Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_data_chapter06.py.r12.20251104T211548Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_data_chapter06.py.r12.20251104T211548Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_data_chapter06.py.r12b.20251104T211740Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_data_chapter06.py.r12b.20251104T211740Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_data_chapter06.py.r12b.20251104T211740Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_data_chapter06.py.r12b.20251104T211740Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_data_chapter06.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_data_chapter06.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_data_chapter06.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_data_chapter06.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_data_chapter06.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_data_chapter06.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_data_chapter06.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_data_chapter06.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_data_chapter06.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_data_chapter06.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_data_chapter06.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_data_chapter06.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_data_chapter06.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_data_chapter06.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_data_chapter06.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_data_chapter06.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T205140Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T205140Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T205140Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T205140Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T205352Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T205352Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T205352Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T205352Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T205837Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T205837Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T205837Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak.20251104T205837Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak_20251031T173338Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak_20251031T173338Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak_20251031T173338Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak_20251031T173338Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.r10.20251104T210441Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.r10.20251104T210441Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.r10.20251104T210441Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.r10.20251104T210441Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.r11.20251104T211127Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.r11.20251104T211127Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.r11.20251104T211127Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.r11.20251104T211127Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.r12.20251104T211548Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.r12.20251104T211548Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.r12.20251104T211548Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.r12.20251104T211548Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/generate_pdot_plateau_vs_z.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak_20251031T173339Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak_20251031T173339Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak_20251031T173339Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak_20251031T173339Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig01_cmb_dataflow_diagram.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak_20251031T173339Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak_20251031T173339Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak_20251031T173339Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak_20251031T173339Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig02_cls_lcdm_vs_mcgt.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak_20251031T173339Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak_20251031T173339Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak_20251031T173339Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak_20251031T173339Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig03_delta_cls_relative.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T173340Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T173340Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T173340Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T173340Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T224414Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T224414Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T224414Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T224414Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T224607Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T224607Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T224607Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T224607Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T224902Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T224902Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T224902Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251031T224902Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251101T000932Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251101T000932Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251101T000932Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251101T000932Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251101T001424Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251101T001424Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251101T001424Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251101T001424Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251101T001910Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251101T001910Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251101T001910Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251101T001910Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251101T002144Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251101T002144Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251101T002144Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.bak_20251101T002144Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig04_delta_rs_vs_params.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak_20251031T173340Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak_20251031T173340Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak_20251031T173340Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak_20251031T173340Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter06/plot_fig05_delta_chi2_heatmap.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/__pycache__/generate_data_chapter06.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter06/__pycache__/generate_data_chapter06.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/__pycache__/generate_data_chapter06.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter06/__pycache__/generate_data_chapter06.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/__pycache__/generate_pdot_plateau_vs_z.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter06/__pycache__/generate_pdot_plateau_vs_z.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/__pycache__/generate_pdot_plateau_vs_z.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter06/__pycache__/generate_pdot_plateau_vs_z.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/__pycache__/plot_fig01_cmb_dataflow_diagram.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter06/__pycache__/plot_fig01_cmb_dataflow_diagram.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/__pycache__/plot_fig01_cmb_dataflow_diagram.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter06/__pycache__/plot_fig01_cmb_dataflow_diagram.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/__pycache__/plot_fig02_cls_lcdm_vs_mcgt.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter06/__pycache__/plot_fig02_cls_lcdm_vs_mcgt.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/__pycache__/plot_fig02_cls_lcdm_vs_mcgt.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter06/__pycache__/plot_fig02_cls_lcdm_vs_mcgt.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/__pycache__/plot_fig03_delta_cls_relative.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter06/__pycache__/plot_fig03_delta_cls_relative.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/__pycache__/plot_fig03_delta_cls_relative.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter06/__pycache__/plot_fig03_delta_cls_relative.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/__pycache__/plot_fig04_delta_rs_vs_params.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter06/__pycache__/plot_fig04_delta_rs_vs_params.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/__pycache__/plot_fig04_delta_rs_vs_params.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter06/__pycache__/plot_fig04_delta_rs_vs_params.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/__pycache__/plot_fig05_delta_chi2_heatmap.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter06/__pycache__/plot_fig05_delta_chi2_heatmap.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/__pycache__/plot_fig05_delta_chi2_heatmap.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter06/__pycache__/plot_fig05_delta_chi2_heatmap.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter06/requirements.txt' ]; then echo "[DELETE] [ENV_REQUIREMENTS_DUP] rm 'zz-scripts/chapter06/requirements.txt'  # requirements.txt local dupliqué (environnement spécifique)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter06/requirements.txt'; else echo "[MISSING] [ENV_REQUIREMENTS_DUP] 'zz-scripts/chapter06/requirements.txt'  # (déjà absent) requirements.txt local dupliqué (environnement spécifique)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/generate_data_chapter07.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/generate_data_chapter07.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/generate_data_chapter07.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/generate_data_chapter07.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/generate_data_chapter07.py.bak_20251031T173340Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/generate_data_chapter07.py.bak_20251031T173340Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/generate_data_chapter07.py.bak_20251031T173340Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/generate_data_chapter07.py.bak_20251031T173340Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/generate_data_chapter07.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/generate_data_chapter07.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/generate_data_chapter07.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/generate_data_chapter07.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/generate_data_chapter07.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/generate_data_chapter07.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/generate_data_chapter07.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/generate_data_chapter07.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak_20251031T182357Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak_20251031T182357Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak_20251031T182357Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak_20251031T182357Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/launch_scalar_perturbations_solver.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak_20251031T173341Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak_20251031T173341Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak_20251031T173341Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak_20251031T173341Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig01_cs2_heatmap.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak_20251031T173341Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak_20251031T173341Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak_20251031T173341Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak_20251031T173341Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig02_delta_phi_heatmap.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T173341Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T173341Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T173341Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T173341Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T224414Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T224414Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T224414Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T224414Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T224607Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T224607Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T224607Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T224607Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T224902Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T224902Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T224902Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251031T224902Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251101T000932Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251101T000932Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251101T000932Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251101T000932Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251101T001424Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251101T001424Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251101T001424Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251101T001424Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251101T001910Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251101T001910Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251101T001910Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251101T001910Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251101T002144Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251101T002144Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251101T002144Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.bak_20251101T002144Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig03_invariant_I1.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T191835Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T191835Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T191835Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T191835Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T173341Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T173341Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T173341Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T173341Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T224414Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T224414Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T224414Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T224414Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T224607Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T224607Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T224607Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T224607Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T224902Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T224902Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T224902Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig04_dcs2_vs_k.py.bak_20251031T224902Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T173342Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T173342Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T173342Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T173342Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T224414Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T224414Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T224414Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T224414Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T224607Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T224607Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T224607Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T224607Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T224902Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T224902Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T224902Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251031T224902Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251101T000932Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251101T000932Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251101T000932Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251101T000932Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251101T001424Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251101T001424Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251101T001424Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251101T001424Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251101T001910Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251101T001910Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251101T001910Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251101T001910Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251101T002144Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251101T002144Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251101T002144Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.bak_20251101T002144Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.rescue3c.20251105T163042Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.rescue3c.20251105T163042Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.rescue3c.20251105T163042Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig05_ddelta_phi_vs_k.py.rescue3c.20251105T163042Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T205140Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T205140Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T205140Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T205140Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T205352Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T205352Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T205352Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T205352Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T205837Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T205837Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T205837Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T205837Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T210206Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T210206Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T210206Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.bak.20251104T210206Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.bak_20251031T173342Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.bak_20251031T173342Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.bak_20251031T173342Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.bak_20251031T173342Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.r10.20251104T210441Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.r10.20251104T210441Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.r10.20251104T210441Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.r10.20251104T210441Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.r11.20251104T211127Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.r11.20251104T211127Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.r11.20251104T211127Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.r11.20251104T211127Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.r12.20251104T211548Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.r12.20251104T211548Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.r12.20251104T211548Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.r12.20251104T211548Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.r12b.20251104T211740Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.r12b.20251104T211740Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.r12b.20251104T211740Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.r12b.20251104T211740Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue3c.20251105T163042Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue3c.20251105T163042Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue3c.20251105T163042Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue3c.20251105T163042Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue3d.20251105T163331Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue3d.20251105T163331Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue3d.20251105T163331Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig06_comparison.py.rescue3d.20251105T163331Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak_20251031T173342Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak_20251031T173342Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak_20251031T173342Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak_20251031T173342Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/plot_fig07_invariant_I2.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/tests/test_chapter07.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/tests/test_chapter07.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/tests/test_chapter07.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/tests/test_chapter07.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/tests/test_chapter07.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/tests/test_chapter07.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/tests/test_chapter07.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/tests/test_chapter07.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/tests/test_chapter07.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/tests/test_chapter07.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/tests/test_chapter07.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/tests/test_chapter07.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/tests/test_chapter07.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/tests/test_chapter07.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/tests/test_chapter07.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/tests/test_chapter07.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/tests/test_chapter07.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/tests/test_chapter07.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/tests/test_chapter07.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/tests/test_chapter07.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/utils/test_kgrid.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/utils/test_kgrid.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/utils/test_kgrid.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/utils/test_kgrid.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/utils/test_kgrid.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/utils/test_kgrid.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/utils/test_kgrid.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/utils/test_kgrid.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/utils/test_kgrid.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/utils/test_kgrid.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/utils/test_kgrid.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/utils/test_kgrid.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/utils/test_kgrid.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/utils/test_kgrid.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/utils/test_kgrid.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/utils/test_kgrid.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/utils/test_kgrid.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/utils/test_kgrid.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/utils/test_kgrid.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/utils/test_kgrid.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/utils/toy_model.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/utils/toy_model.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/utils/toy_model.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/utils/toy_model.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/utils/toy_model.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/utils/toy_model.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/utils/toy_model.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/utils/toy_model.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/utils/toy_model.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/utils/toy_model.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/utils/toy_model.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/utils/toy_model.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/utils/toy_model.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/utils/toy_model.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/utils/toy_model.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/utils/toy_model.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/utils/toy_model.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/utils/toy_model.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/utils/toy_model.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/utils/toy_model.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/utils/toy_model.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter07/utils/toy_model.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/utils/toy_model.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter07/utils/toy_model.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/__pycache__/generate_data_chapter07.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter07/__pycache__/generate_data_chapter07.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/__pycache__/generate_data_chapter07.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter07/__pycache__/generate_data_chapter07.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/__pycache__/launch_scalar_perturbations_solver.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter07/__pycache__/launch_scalar_perturbations_solver.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/__pycache__/launch_scalar_perturbations_solver.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter07/__pycache__/launch_scalar_perturbations_solver.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/__pycache__/plot_fig01_cs2_heatmap.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter07/__pycache__/plot_fig01_cs2_heatmap.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/__pycache__/plot_fig01_cs2_heatmap.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter07/__pycache__/plot_fig01_cs2_heatmap.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/__pycache__/plot_fig02_delta_phi_heatmap.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter07/__pycache__/plot_fig02_delta_phi_heatmap.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/__pycache__/plot_fig02_delta_phi_heatmap.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter07/__pycache__/plot_fig02_delta_phi_heatmap.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/__pycache__/plot_fig03_invariant_I1.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter07/__pycache__/plot_fig03_invariant_I1.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/__pycache__/plot_fig03_invariant_I1.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter07/__pycache__/plot_fig03_invariant_I1.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/__pycache__/plot_fig04_dcs2_vs_k.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter07/__pycache__/plot_fig04_dcs2_vs_k.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/__pycache__/plot_fig04_dcs2_vs_k.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter07/__pycache__/plot_fig04_dcs2_vs_k.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/__pycache__/plot_fig05_ddelta_phi_vs_k.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter07/__pycache__/plot_fig05_ddelta_phi_vs_k.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/__pycache__/plot_fig05_ddelta_phi_vs_k.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter07/__pycache__/plot_fig05_ddelta_phi_vs_k.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/__pycache__/plot_fig06_comparison.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter07/__pycache__/plot_fig06_comparison.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/__pycache__/plot_fig06_comparison.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter07/__pycache__/plot_fig06_comparison.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/__pycache__/plot_fig07_invariant_I2.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter07/__pycache__/plot_fig07_invariant_I2.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/__pycache__/plot_fig07_invariant_I2.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter07/__pycache__/plot_fig07_invariant_I2.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/tests/__pycache__/test_chapter07.cpython-312-pytest-8.4.2.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter07/tests/__pycache__/test_chapter07.cpython-312-pytest-8.4.2.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/tests/__pycache__/test_chapter07.cpython-312-pytest-8.4.2.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter07/tests/__pycache__/test_chapter07.cpython-312-pytest-8.4.2.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/tests/__pycache__/test_chapter07.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter07/tests/__pycache__/test_chapter07.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/tests/__pycache__/test_chapter07.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter07/tests/__pycache__/test_chapter07.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/utils/__pycache__/test_kgrid.cpython-312-pytest-8.4.2.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter07/utils/__pycache__/test_kgrid.cpython-312-pytest-8.4.2.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/utils/__pycache__/test_kgrid.cpython-312-pytest-8.4.2.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter07/utils/__pycache__/test_kgrid.cpython-312-pytest-8.4.2.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/utils/__pycache__/test_kgrid.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter07/utils/__pycache__/test_kgrid.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/utils/__pycache__/test_kgrid.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter07/utils/__pycache__/test_kgrid.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter07/utils/__pycache__/toy_model.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter07/utils/__pycache__/toy_model.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter07/utils/__pycache__/toy_model.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter07/utils/__pycache__/toy_model.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/generate_coupling_milestones.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/generate_coupling_milestones.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/generate_coupling_milestones.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/generate_coupling_milestones.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/generate_coupling_milestones.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/generate_coupling_milestones.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/generate_coupling_milestones.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/generate_coupling_milestones.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/generate_coupling_milestones.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/generate_coupling_milestones.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/generate_coupling_milestones.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/generate_coupling_milestones.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/generate_coupling_milestones.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/generate_coupling_milestones.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/generate_coupling_milestones.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/generate_coupling_milestones.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/generate_coupling_milestones.py.bak_20251031T173342Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/generate_coupling_milestones.py.bak_20251031T173342Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/generate_coupling_milestones.py.bak_20251031T173342Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/generate_coupling_milestones.py.bak_20251031T173342Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/generate_coupling_milestones.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/generate_coupling_milestones.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/generate_coupling_milestones.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/generate_coupling_milestones.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/generate_coupling_milestones.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/generate_coupling_milestones.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/generate_coupling_milestones.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/generate_coupling_milestones.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/generate_coupling_milestones.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/generate_coupling_milestones.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/generate_coupling_milestones.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/generate_coupling_milestones.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/generate_coupling_milestones.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/generate_coupling_milestones.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/generate_coupling_milestones.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/generate_coupling_milestones.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/generate_coupling_milestones.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/generate_coupling_milestones.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/generate_coupling_milestones.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/generate_coupling_milestones.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/generate_coupling_milestones.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/generate_coupling_milestones.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/generate_coupling_milestones.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/generate_coupling_milestones.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/generate_data_chapter08.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/generate_data_chapter08.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/generate_data_chapter08.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/generate_data_chapter08.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/generate_data_chapter08.py.bak_20251031T173342Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/generate_data_chapter08.py.bak_20251031T173342Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/generate_data_chapter08.py.bak_20251031T173342Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/generate_data_chapter08.py.bak_20251031T173342Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/generate_data_chapter08.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/generate_data_chapter08.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/generate_data_chapter08.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/generate_data_chapter08.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/generate_data_chapter08.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/generate_data_chapter08.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/generate_data_chapter08.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/generate_data_chapter08.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig01_chi2_total_vs_q0.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig01_chi2_total_vs_q0.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig01_chi2_total_vs_q0.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig01_chi2_total_vs_q0.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig01_chi2_total_vs_q0.py.bak_20251031T173342Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig01_chi2_total_vs_q0.py.bak_20251031T173342Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig01_chi2_total_vs_q0.py.bak_20251031T173342Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig01_chi2_total_vs_q0.py.bak_20251031T173342Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig01_chi2_total_vs_q0.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig01_chi2_total_vs_q0.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig01_chi2_total_vs_q0.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig01_chi2_total_vs_q0.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig01_chi2_total_vs_q0.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig01_chi2_total_vs_q0.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig01_chi2_total_vs_q0.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig01_chi2_total_vs_q0.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig02_dv_vs_z.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig02_dv_vs_z.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig02_dv_vs_z.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig02_dv_vs_z.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig02_dv_vs_z.py.bak_20251031T173342Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig02_dv_vs_z.py.bak_20251031T173342Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig02_dv_vs_z.py.bak_20251031T173342Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig02_dv_vs_z.py.bak_20251031T173342Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig02_dv_vs_z.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig02_dv_vs_z.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig02_dv_vs_z.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig02_dv_vs_z.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig02_dv_vs_z.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig02_dv_vs_z.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig02_dv_vs_z.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig02_dv_vs_z.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak_20251031T173342Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak_20251031T173342Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak_20251031T173342Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak_20251031T173342Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig03_mu_vs_z.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak.20251104T200532Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak.20251104T200532Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak.20251104T200532Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak.20251104T200532Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak_20251031T173344Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak_20251031T173344Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak_20251031T173344Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak_20251031T173344Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig04_chi2_heatmap.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig05_residuals.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig05_residuals.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig05_residuals.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig05_residuals.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig05_residuals.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig05_residuals.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig05_residuals.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig05_residuals.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig05_residuals.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig05_residuals.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig05_residuals.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig05_residuals.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig05_residuals.py.bak_20251031T173344Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig05_residuals.py.bak_20251031T173344Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig05_residuals.py.bak_20251031T173344Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig05_residuals.py.bak_20251031T173344Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig05_residuals.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig05_residuals.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig05_residuals.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig05_residuals.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig05_residuals.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig05_residuals.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig05_residuals.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig05_residuals.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak_20251031T173344Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak_20251031T173344Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak_20251031T173344Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak_20251031T173344Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig06_normalized_residuals_distribution.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak_20251031T173344Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak_20251031T173344Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak_20251031T173344Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak_20251031T173344Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/plot_fig07_chi2_profile.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/cosmo.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/utils/cosmo.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/cosmo.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/utils/cosmo.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/cosmo.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/utils/cosmo.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/cosmo.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/utils/cosmo.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/cosmo.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/utils/cosmo.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/cosmo.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/utils/cosmo.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/cosmo.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/utils/cosmo.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/cosmo.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/utils/cosmo.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/cosmo.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/utils/cosmo.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/cosmo.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/utils/cosmo.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/coupling_example_model.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/utils/coupling_example_model.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/coupling_example_model.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/utils/coupling_example_model.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/coupling_example_model.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/utils/coupling_example_model.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/coupling_example_model.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/utils/coupling_example_model.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/coupling_example_model.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/utils/coupling_example_model.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/coupling_example_model.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/utils/coupling_example_model.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/extract_bao_data.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/utils/extract_bao_data.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/extract_bao_data.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/utils/extract_bao_data.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/extract_bao_data.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/utils/extract_bao_data.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/extract_bao_data.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/utils/extract_bao_data.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/extract_pantheon_plus_data.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/utils/extract_pantheon_plus_data.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/extract_pantheon_plus_data.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/utils/extract_pantheon_plus_data.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/extract_pantheon_plus_data.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/utils/extract_pantheon_plus_data.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/extract_pantheon_plus_data.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/utils/extract_pantheon_plus_data.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/generate_coupling_milestones.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/utils/generate_coupling_milestones.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/generate_coupling_milestones.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/utils/generate_coupling_milestones.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/generate_coupling_milestones.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/utils/generate_coupling_milestones.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/generate_coupling_milestones.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/utils/generate_coupling_milestones.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/generate_coupling_milestones.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/utils/generate_coupling_milestones.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/generate_coupling_milestones.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/utils/generate_coupling_milestones.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/generate_coupling_milestones.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/utils/generate_coupling_milestones.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/generate_coupling_milestones.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/utils/generate_coupling_milestones.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/generate_coupling_milestones.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/utils/generate_coupling_milestones.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/generate_coupling_milestones.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/utils/generate_coupling_milestones.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/verify_z_grid.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/utils/verify_z_grid.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/verify_z_grid.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/utils/verify_z_grid.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/verify_z_grid.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter08/utils/verify_z_grid.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/verify_z_grid.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter08/utils/verify_z_grid.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/__pycache__/generate_coupling_milestones.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter08/__pycache__/generate_coupling_milestones.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/__pycache__/generate_coupling_milestones.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter08/__pycache__/generate_coupling_milestones.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/__pycache__/generate_data_chapter08.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter08/__pycache__/generate_data_chapter08.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/__pycache__/generate_data_chapter08.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter08/__pycache__/generate_data_chapter08.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/__pycache__/plot_fig01_chi2_total_vs_q0.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter08/__pycache__/plot_fig01_chi2_total_vs_q0.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/__pycache__/plot_fig01_chi2_total_vs_q0.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter08/__pycache__/plot_fig01_chi2_total_vs_q0.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/__pycache__/plot_fig02_dv_vs_z.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter08/__pycache__/plot_fig02_dv_vs_z.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/__pycache__/plot_fig02_dv_vs_z.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter08/__pycache__/plot_fig02_dv_vs_z.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/__pycache__/plot_fig03_mu_vs_z.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter08/__pycache__/plot_fig03_mu_vs_z.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/__pycache__/plot_fig03_mu_vs_z.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter08/__pycache__/plot_fig03_mu_vs_z.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/__pycache__/plot_fig04_chi2_heatmap.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter08/__pycache__/plot_fig04_chi2_heatmap.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/__pycache__/plot_fig04_chi2_heatmap.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter08/__pycache__/plot_fig04_chi2_heatmap.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/__pycache__/plot_fig05_residuals.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter08/__pycache__/plot_fig05_residuals.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/__pycache__/plot_fig05_residuals.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter08/__pycache__/plot_fig05_residuals.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/__pycache__/plot_fig06_normalized_residuals_distribution.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter08/__pycache__/plot_fig06_normalized_residuals_distribution.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/__pycache__/plot_fig06_normalized_residuals_distribution.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter08/__pycache__/plot_fig06_normalized_residuals_distribution.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/__pycache__/plot_fig07_chi2_profile.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter08/__pycache__/plot_fig07_chi2_profile.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/__pycache__/plot_fig07_chi2_profile.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter08/__pycache__/plot_fig07_chi2_profile.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/__pycache__/cosmo.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter08/utils/__pycache__/cosmo.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/__pycache__/cosmo.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter08/utils/__pycache__/cosmo.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/__pycache__/coupling_example_model.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter08/utils/__pycache__/coupling_example_model.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/__pycache__/coupling_example_model.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter08/utils/__pycache__/coupling_example_model.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/__pycache__/extract_bao_data.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter08/utils/__pycache__/extract_bao_data.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/__pycache__/extract_bao_data.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter08/utils/__pycache__/extract_bao_data.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/__pycache__/extract_pantheon_plus_data.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter08/utils/__pycache__/extract_pantheon_plus_data.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/__pycache__/extract_pantheon_plus_data.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter08/utils/__pycache__/extract_pantheon_plus_data.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/__pycache__/generate_coupling_milestones.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter08/utils/__pycache__/generate_coupling_milestones.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/__pycache__/generate_coupling_milestones.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter08/utils/__pycache__/generate_coupling_milestones.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/utils/__pycache__/verify_z_grid.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter08/utils/__pycache__/verify_z_grid.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/utils/__pycache__/verify_z_grid.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter08/utils/__pycache__/verify_z_grid.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter08/requirements.txt' ]; then echo "[DELETE] [ENV_REQUIREMENTS_DUP] rm 'zz-scripts/chapter08/requirements.txt'  # requirements.txt local dupliqué (environnement spécifique)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter08/requirements.txt'; else echo "[MISSING] [ENV_REQUIREMENTS_DUP] 'zz-scripts/chapter08/requirements.txt'  # (déjà absent) requirements.txt local dupliqué (environnement spécifique)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak_20251031T182357Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak_20251031T182357Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak_20251031T182357Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak_20251031T182357Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/apply_poly_unwrap_rebranch.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/check_p95_methods.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/check_p95_methods.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/check_p95_methods.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/check_p95_methods.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/check_p95_methods.py.bak_20251031T182357Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/check_p95_methods.py.bak_20251031T182357Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/check_p95_methods.py.bak_20251031T182357Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/check_p95_methods.py.bak_20251031T182357Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/check_p95_methods.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/check_p95_methods.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/check_p95_methods.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/check_p95_methods.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/check_p95_methods.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/check_p95_methods.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/check_p95_methods.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/check_p95_methods.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/extract_phenom_phase.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/extract_phenom_phase.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/extract_phenom_phase.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/extract_phenom_phase.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/extract_phenom_phase.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/extract_phenom_phase.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/extract_phenom_phase.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/extract_phenom_phase.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/extract_phenom_phase.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/extract_phenom_phase.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/extract_phenom_phase.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/extract_phenom_phase.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/extract_phenom_phase.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/extract_phenom_phase.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/extract_phenom_phase.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/extract_phenom_phase.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/extract_phenom_phase.py.bak_20251031T182357Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/extract_phenom_phase.py.bak_20251031T182357Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/extract_phenom_phase.py.bak_20251031T182357Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/extract_phenom_phase.py.bak_20251031T182357Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/extract_phenom_phase.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/extract_phenom_phase.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/extract_phenom_phase.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/extract_phenom_phase.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/extract_phenom_phase.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/extract_phenom_phase.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/extract_phenom_phase.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/extract_phenom_phase.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak_20251031T182357Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak_20251031T182357Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak_20251031T182357Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak_20251031T182357Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/fetch_gwtc3_confident.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/flag_jalons.py.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/flag_jalons.py.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/flag_jalons.py.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/flag_jalons.py.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/flag_jalons.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/flag_jalons.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/flag_jalons.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/flag_jalons.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/flag_jalons.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/flag_jalons.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/flag_jalons.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/flag_jalons.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/flag_jalons.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/flag_jalons.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/flag_jalons.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/flag_jalons.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/flag_jalons.py.bak_20251031T182357Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/flag_jalons.py.bak_20251031T182357Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/flag_jalons.py.bak_20251031T182357Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/flag_jalons.py.bak_20251031T182357Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/flag_jalons.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/flag_jalons.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/flag_jalons.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/flag_jalons.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/flag_jalons.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/flag_jalons.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/flag_jalons.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/flag_jalons.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_data_chapter09.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_data_chapter09.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_data_chapter09.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_data_chapter09.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_data_chapter09.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_data_chapter09.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_data_chapter09.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_data_chapter09.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_data_chapter09.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_data_chapter09.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_data_chapter09.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_data_chapter09.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_data_chapter09.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_data_chapter09.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_data_chapter09.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_data_chapter09.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_data_chapter09.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_data_chapter09.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_data_chapter09.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_data_chapter09.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_data_chapter09.py.bak_20251031T182357Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_data_chapter09.py.bak_20251031T182357Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_data_chapter09.py.bak_20251031T182357Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_data_chapter09.py.bak_20251031T182357Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_data_chapter09.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_data_chapter09.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_data_chapter09.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_data_chapter09.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_data_chapter09.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_data_chapter09.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_data_chapter09.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_data_chapter09.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak.20251104T205140Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak.20251104T205140Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak.20251104T205140Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak.20251104T205140Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak.20251104T205352Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak.20251104T205352Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak.20251104T205352Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak.20251104T205352Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak.20251104T205837Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak.20251104T205837Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak.20251104T205837Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak.20251104T205837Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak.20251104T210206Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak.20251104T210206Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak.20251104T210206Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak.20251104T210206Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak_20251031T182357Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak_20251031T182357Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak_20251031T182357Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak_20251031T182357Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.r10.20251104T210441Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.r10.20251104T210441Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.r10.20251104T210441Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.r10.20251104T210441Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.r11.20251104T211127Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.r11.20251104T211127Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.r11.20251104T211127Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.r11.20251104T211127Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.r12.20251104T211548Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.r12.20251104T211548Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.r12.20251104T211548Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.r12.20251104T211548Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.r12b.20251104T211740Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.r12b.20251104T211740Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.r12b.20251104T211740Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.r12b.20251104T211740Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.rescue3d.20251105T163331Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.rescue3d.20251105T163331Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.rescue3d.20251105T163331Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/generate_mcgt_raw_phase.py.rescue3d.20251105T163331Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/opt_poly_rebranch.py.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/opt_poly_rebranch.py.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/opt_poly_rebranch.py.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/opt_poly_rebranch.py.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/opt_poly_rebranch.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/opt_poly_rebranch.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/opt_poly_rebranch.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/opt_poly_rebranch.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/opt_poly_rebranch.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/opt_poly_rebranch.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/opt_poly_rebranch.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/opt_poly_rebranch.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/opt_poly_rebranch.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/opt_poly_rebranch.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/opt_poly_rebranch.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/opt_poly_rebranch.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/opt_poly_rebranch.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/opt_poly_rebranch.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/opt_poly_rebranch.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/opt_poly_rebranch.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/opt_poly_rebranch.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/opt_poly_rebranch.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/opt_poly_rebranch.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/opt_poly_rebranch.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/opt_poly_rebranch.py.bak_20251031T182357Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/opt_poly_rebranch.py.bak_20251031T182357Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/opt_poly_rebranch.py.bak_20251031T182357Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/opt_poly_rebranch.py.bak_20251031T182357Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/opt_poly_rebranch.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/opt_poly_rebranch.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/opt_poly_rebranch.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/opt_poly_rebranch.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/opt_poly_rebranch.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/opt_poly_rebranch.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/opt_poly_rebranch.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/opt_poly_rebranch.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251030T220839' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251030T220839'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251030T220839'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251030T220839'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251030T221014' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251030T221014'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251030T221014'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251030T221014'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251030T221222' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251030T221222'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251030T221222'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251030T221222'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251031T024701Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251031T024701Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251031T024701Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251031T024701Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig01_phase_overlay.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251030T220839' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251030T220839'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251030T220839'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251030T220839'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251030T221014' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251030T221014'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251030T221014'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251030T221014'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251030T221222' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251030T221222'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251030T221222'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251030T221222'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251031T024701Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251031T024701Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251031T024701Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251031T024701Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig02_residual_phase.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue3c.20251105T163042Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue3c.20251105T163042Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue3c.20251105T163042Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue3c.20251105T163042Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue3d.20251105T163331Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue3d.20251105T163331Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue3d.20251105T163331Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig02_residual_phase.py.rescue3d.20251105T163331Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.autofix.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.autofix.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.autofix.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.autofix.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T204632Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T204632Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T204632Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T204632Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T205352Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T205352Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T205352Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T205352Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T205837Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T205837Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T205837Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T205837Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T210206Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T210206Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T210206Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak.20251104T210206Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T155713' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T155713'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T155713'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T155713'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T160451' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T160451'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T160451'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T160451'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T160718' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T160718'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T160718'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T160718'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T160747' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T160747'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T160747'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T160747'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T161444' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T161444'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T161444'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T161444'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T161758' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T161758'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T161758'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T161758'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T162215' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T162215'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T162215'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T162215'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T195710' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T195710'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T195710'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T195710'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T195740' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T195740'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T195740'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T195740'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T195922' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T195922'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T195922'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T195922'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T200119' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T200119'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T200119'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T200119'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T200613' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T200613'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T200613'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T200613'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T201126' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T201126'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T201126'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T201126'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T201148' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T201148'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T201148'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T201148'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T201259' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T201259'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T201259'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T201259'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T201327' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T201327'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T201327'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T201327'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T201420' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T201420'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T201420'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T201420'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T203022' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T203022'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T203022'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T203022'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T203519' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T203519'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T203519'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T203519'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T215146' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T215146'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T215146'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T215146'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T220839' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T220839'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T220839'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T220839'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T221014' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T221014'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T221014'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T221014'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T221222' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T221222'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T221222'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251030T221222'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251031T024701Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251031T024701Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251031T024701Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251031T024701Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.r11.20251104T211127Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.r11.20251104T211127Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.r11.20251104T211127Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.r11.20251104T211127Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.r12.20251104T211548Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.r12.20251104T211548Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.r12.20251104T211548Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.r12.20251104T211548Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.r12b.20251104T211740Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.r12b.20251104T211740Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.r12b.20251104T211740Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.r12b.20251104T211740Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.r12c.20251104T211939Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.r12c.20251104T211939Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.r12c.20251104T211939Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.r12c.20251104T211939Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.rescue.20251105T165113Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.rescue.20251105T165113Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.rescue.20251105T165113Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.rescue.20251105T165113Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.rescue3d.20251105T163331Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.rescue3d.20251105T163331Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.rescue3d.20251105T163331Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig03_hist_absdphi_20_300.py.rescue3d.20251105T163331Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak.20251104T204632Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak.20251104T204632Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak.20251104T204632Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak.20251104T204632Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak.20251104T204932Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak.20251104T204932Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak.20251104T204932Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak.20251104T204932Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251030T220839' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251030T220839'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251030T220839'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251030T220839'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251030T221014' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251030T221014'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251030T221014'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251030T221014'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251030T221222' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251030T221222'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251030T221222'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251030T221222'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251031T024701Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251031T024701Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251031T024701Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251031T024701Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.rescue3d.20251105T163331Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.rescue3d.20251105T163331Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.rescue3d.20251105T163331Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig04_absdphi_milestones_vs_f.py.rescue3d.20251105T163331Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T204632Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T204632Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T204632Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T204632Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T205140Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T205140Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T205140Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T205140Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T205352Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T205352Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T205352Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T205352Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T205837Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T205837Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T205837Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T205837Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T210206Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T210206Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T210206Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak.20251104T210206Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251030T220839' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251030T220839'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251030T220839'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251030T220839'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251030T221014' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251030T221014'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251030T221014'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251030T221014'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251030T221222' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251030T221222'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251030T221222'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251030T221222'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251031T024701Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251031T024701Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251031T024701Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251031T024701Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.r11.20251104T211127Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.r11.20251104T211127Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.r11.20251104T211127Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.r11.20251104T211127Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.r12.20251104T211548Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.r12.20251104T211548Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.r12.20251104T211548Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.r12.20251104T211548Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.r12b.20251104T211740Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.r12b.20251104T211740Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.r12b.20251104T211740Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.r12b.20251104T211740Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.rescue3d.20251105T163331Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.rescue3d.20251105T163331Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.rescue3d.20251105T163331Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter09/plot_fig05_scatter_phi_at_fpeak.py.rescue3d.20251105T163331Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/__pycache__/apply_poly_unwrap_rebranch.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter09/__pycache__/apply_poly_unwrap_rebranch.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/__pycache__/apply_poly_unwrap_rebranch.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter09/__pycache__/apply_poly_unwrap_rebranch.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/__pycache__/check_p95_methods.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter09/__pycache__/check_p95_methods.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/__pycache__/check_p95_methods.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter09/__pycache__/check_p95_methods.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/__pycache__/extract_phenom_phase.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter09/__pycache__/extract_phenom_phase.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/__pycache__/extract_phenom_phase.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter09/__pycache__/extract_phenom_phase.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/__pycache__/fetch_gwtc3_confident.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter09/__pycache__/fetch_gwtc3_confident.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/__pycache__/fetch_gwtc3_confident.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter09/__pycache__/fetch_gwtc3_confident.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/__pycache__/flag_jalons.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter09/__pycache__/flag_jalons.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/__pycache__/flag_jalons.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter09/__pycache__/flag_jalons.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/__pycache__/generate_data_chapter09.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter09/__pycache__/generate_data_chapter09.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/__pycache__/generate_data_chapter09.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter09/__pycache__/generate_data_chapter09.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/__pycache__/generate_mcgt_raw_phase.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter09/__pycache__/generate_mcgt_raw_phase.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/__pycache__/generate_mcgt_raw_phase.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter09/__pycache__/generate_mcgt_raw_phase.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/__pycache__/opt_poly_rebranch.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter09/__pycache__/opt_poly_rebranch.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/__pycache__/opt_poly_rebranch.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter09/__pycache__/opt_poly_rebranch.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/__pycache__/plot_fig01_phase_overlay.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter09/__pycache__/plot_fig01_phase_overlay.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/__pycache__/plot_fig01_phase_overlay.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter09/__pycache__/plot_fig01_phase_overlay.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/__pycache__/plot_fig02_residual_phase.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter09/__pycache__/plot_fig02_residual_phase.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/__pycache__/plot_fig02_residual_phase.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter09/__pycache__/plot_fig02_residual_phase.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/__pycache__/plot_fig03_hist_absdphi_20_300.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter09/__pycache__/plot_fig03_hist_absdphi_20_300.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/__pycache__/plot_fig03_hist_absdphi_20_300.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter09/__pycache__/plot_fig03_hist_absdphi_20_300.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/__pycache__/plot_fig04_absdphi_milestones_vs_f.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter09/__pycache__/plot_fig04_absdphi_milestones_vs_f.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/__pycache__/plot_fig04_absdphi_milestones_vs_f.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter09/__pycache__/plot_fig04_absdphi_milestones_vs_f.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/__pycache__/plot_fig05_scatter_phi_at_fpeak.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter09/__pycache__/plot_fig05_scatter_phi_at_fpeak.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/__pycache__/plot_fig05_scatter_phi_at_fpeak.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter09/__pycache__/plot_fig05_scatter_phi_at_fpeak.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/__pycache__/run_fig03_safe.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter09/__pycache__/run_fig03_safe.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/__pycache__/run_fig03_safe.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter09/__pycache__/run_fig03_safe.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter09/requirements.txt' ]; then echo "[DELETE] [ENV_REQUIREMENTS_DUP] rm 'zz-scripts/chapter09/requirements.txt'  # requirements.txt local dupliqué (environnement spécifique)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter09/requirements.txt'; else echo "[MISSING] [ENV_REQUIREMENTS_DUP] 'zz-scripts/chapter09/requirements.txt'  # (déjà absent) requirements.txt local dupliqué (environnement spécifique)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T205352Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T205352Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T205352Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T205352Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T205837Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T205837Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T205837Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak.20251104T205837Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak_20251031T174106Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak_20251031T174106Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak_20251031T174106Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak_20251031T174106Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak_20251031T174221Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak_20251031T174221Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak_20251031T174221Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak_20251031T174221Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/add_phi_at_fpeak.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/add_phi_at_fpeak.py.r10.20251104T210441Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/add_phi_at_fpeak.py.r10.20251104T210441Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/add_phi_at_fpeak.py.r10.20251104T210441Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/add_phi_at_fpeak.py.r10.20251104T210441Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/add_phi_at_fpeak.py.r12.20251104T211548Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/add_phi_at_fpeak.py.r12.20251104T211548Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/add_phi_at_fpeak.py.r12.20251104T211548Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/add_phi_at_fpeak.py.r12.20251104T211548Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/add_phi_at_fpeak.py.r12b.20251104T211740Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/add_phi_at_fpeak.py.r12b.20251104T211740Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/add_phi_at_fpeak.py.r12b.20251104T211740Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/add_phi_at_fpeak.py.r12b.20251104T211740Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue3c.20251105T163042Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue3c.20251105T163042Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue3c.20251105T163042Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue3c.20251105T163042Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue3d.20251105T163331Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue3d.20251105T163331Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue3d.20251105T163331Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/add_phi_at_fpeak.py.rescue3d.20251105T163331Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak_20251031T182357Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak_20251031T182357Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak_20251031T182357Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak_20251031T182357Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/bootstrap_topk_p95.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T205352Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T205352Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T205352Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T205352Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T205837Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T205837Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T205837Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T205837Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T210206Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T210206Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T210206Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.bak.20251104T210206Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.bak_20251031T174106Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.bak_20251031T174106Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.bak_20251031T174106Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.bak_20251031T174106Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.bak_20251031T174221Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.bak_20251031T174221Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.bak_20251031T174221Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.bak_20251031T174221Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.r10.20251104T210441Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.r10.20251104T210441Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.r10.20251104T210441Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.r10.20251104T210441Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.r11.20251104T211127Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.r11.20251104T211127Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.r11.20251104T211127Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.r11.20251104T211127Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.r12.20251104T211548Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.r12.20251104T211548Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.r12.20251104T211548Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.r12.20251104T211548Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.r12b.20251104T211740Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.r12b.20251104T211740Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.r12b.20251104T211740Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.r12b.20251104T211740Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.r12c.20251104T211939Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.r12c.20251104T211939Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.r12c.20251104T211939Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.r12c.20251104T211939Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.r12f.20251104T212323Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.r12f.20251104T212323Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.r12f.20251104T212323Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.r12f.20251104T212323Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.r12h.20251104T212533Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.r12h.20251104T212533Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.r12h.20251104T212533Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.r12h.20251104T212533Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.r12i.20251105T003854Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.r12i.20251105T003854Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.r12i.20251105T003854Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.r12i.20251105T003854Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.rescue3c.20251105T163042Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.rescue3c.20251105T163042Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.rescue3c.20251105T163042Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.rescue3c.20251105T163042Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/check_metrics_consistency.py.rescue3d.20251105T163331Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/check_metrics_consistency.py.rescue3d.20251105T163331Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/check_metrics_consistency.py.rescue3d.20251105T163331Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/check_metrics_consistency.py.rescue3d.20251105T163331Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.QUARANTINE.20251105T144301Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.QUARANTINE.20251105T144301Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.QUARANTINE.20251105T144301Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.QUARANTINE.20251105T144301Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T205352Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T205352Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T205352Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T205352Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T205837Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T205837Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T205837Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T205837Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T210206Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T210206Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T210206Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.bak.20251104T210206Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.bak_20251031T174106Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.bak_20251031T174106Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.bak_20251031T174106Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.bak_20251031T174106Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.bak_20251031T174221Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.bak_20251031T174221Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.bak_20251031T174221Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.bak_20251031T174221Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.r10.20251104T210441Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.r10.20251104T210441Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.r10.20251104T210441Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.r10.20251104T210441Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.r11.20251104T211127Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.r11.20251104T211127Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.r11.20251104T211127Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.r11.20251104T211127Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.r12.20251104T211548Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.r12.20251104T211548Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.r12.20251104T211548Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.r12.20251104T211548Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.r12M.20251105T010919Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.r12M.20251105T010919Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.r12M.20251105T010919Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.r12M.20251105T010919Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.r12N.20251105T011053Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.r12N.20251105T011053Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.r12N.20251105T011053Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.r12N.20251105T011053Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.r12O.20251105T011225Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.r12O.20251105T011225Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.r12O.20251105T011225Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.r12O.20251105T011225Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.r12Q.20251105T011914Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.r12Q.20251105T011914Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.r12Q.20251105T011914Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.r12Q.20251105T011914Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.r12W.20251105T013450Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.r12W.20251105T013450Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.r12W.20251105T013450Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.r12W.20251105T013450Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.r12X.20251105T013719Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.r12X.20251105T013719Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.r12X.20251105T013719Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.r12X.20251105T013719Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.r12Y.20251105T013956Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.r12Y.20251105T013956Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.r12Y.20251105T013956Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.r12Y.20251105T013956Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.r12Z.20251105T014152Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.r12Z.20251105T014152Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.r12Z.20251105T014152Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.r12Z.20251105T014152Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.r12b.20251104T211740Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.r12b.20251104T211740Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.r12b.20251104T211740Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.r12b.20251104T211740Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.r12c.20251104T211939Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.r12c.20251104T211939Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.r12c.20251104T211939Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.r12c.20251104T211939Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.r12h.20251104T212533Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.r12h.20251104T212533Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.r12h.20251104T212533Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.r12h.20251104T212533Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/diag_phi_fpeak.py.r12i.20251105T003854Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/diag_phi_fpeak.py.r12i.20251105T003854Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/diag_phi_fpeak.py.r12i.20251105T003854Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/diag_phi_fpeak.py.r12i.20251105T003854Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak_20251031T182357Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak_20251031T182357Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak_20251031T182357Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak_20251031T182357Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/eval_primary_metrics_20_300.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/generate_data_chapter10.py.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/generate_data_chapter10.py.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/generate_data_chapter10.py.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/generate_data_chapter10.py.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/generate_data_chapter10.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/generate_data_chapter10.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/generate_data_chapter10.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/generate_data_chapter10.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/generate_data_chapter10.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/generate_data_chapter10.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/generate_data_chapter10.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/generate_data_chapter10.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/generate_data_chapter10.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/generate_data_chapter10.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/generate_data_chapter10.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/generate_data_chapter10.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/generate_data_chapter10.py.bak_20251031T182357Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/generate_data_chapter10.py.bak_20251031T182357Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/generate_data_chapter10.py.bak_20251031T182357Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/generate_data_chapter10.py.bak_20251031T182357Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/generate_data_chapter10.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/generate_data_chapter10.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/generate_data_chapter10.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/generate_data_chapter10.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/generate_data_chapter10.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/generate_data_chapter10.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/generate_data_chapter10.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/generate_data_chapter10.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/generate_data_chapter10.py.broken.20251021T121011' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/generate_data_chapter10.py.broken.20251021T121011'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/generate_data_chapter10.py.broken.20251021T121011'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/generate_data_chapter10.py.broken.20251021T121011'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/inspect_topk_residuals.py.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/inspect_topk_residuals.py.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/inspect_topk_residuals.py.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/inspect_topk_residuals.py.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/inspect_topk_residuals.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/inspect_topk_residuals.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/inspect_topk_residuals.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/inspect_topk_residuals.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/inspect_topk_residuals.py.bak_20251031T182357Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/inspect_topk_residuals.py.bak_20251031T182357Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/inspect_topk_residuals.py.bak_20251031T182357Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/inspect_topk_residuals.py.bak_20251031T182357Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/inspect_topk_residuals.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/inspect_topk_residuals.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/inspect_topk_residuals.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/inspect_topk_residuals.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/inspect_topk_residuals.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/inspect_topk_residuals.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/inspect_topk_residuals.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/inspect_topk_residuals.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.autofix.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.autofix.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.autofix.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.autofix.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T204632Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T204632Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T204632Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T204632Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T205352Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T205352Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T205352Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak.20251104T205352Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251030T154848' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251030T154848'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251030T154848'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251030T154848'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251030T155713' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251030T155713'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251030T155713'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251030T155713'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251030T160451' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251030T160451'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251030T160451'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251030T160451'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251031T171956Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251031T171956Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251031T171956Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251031T171956Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251031T172143Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251031T172143Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251031T172143Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251031T172143Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251031T173142Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251031T173142Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251031T173142Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251031T173142Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.r10.20251104T210441Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.r10.20251104T210441Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.r10.20251104T210441Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.r10.20251104T210441Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.r11.20251104T211127Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.r11.20251104T211127Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.r11.20251104T211127Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.r11.20251104T211127Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.r12.20251104T211548Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.r12.20251104T211548Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.r12.20251104T211548Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.r12.20251104T211548Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue.20251105T165113Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue.20251105T165113Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue.20251105T165113Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue.20251105T165113Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue3b.20251105T162818Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue3b.20251105T162818Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue3b.20251105T162818Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue3b.20251105T162818Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue3c.20251105T163042Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue3c.20251105T163042Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue3c.20251105T163042Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue3c.20251105T163042Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue3d.20251105T163331Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue3d.20251105T163331Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue3d.20251105T163331Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig01_iso_p95_maps.py.rescue3d.20251105T163331Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251030T155144' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251030T155144'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251030T155144'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251030T155144'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251031T171956Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251031T171956Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251031T171956Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251031T171956Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251031T172143Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251031T172143Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251031T172143Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251031T172143Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251031T173142Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251031T173142Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251031T173142Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251031T173142Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig02_scatter_phi_at_fpeak.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.QUARANTINE.20251105T144301Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.QUARANTINE.20251105T144301Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.QUARANTINE.20251105T144301Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.QUARANTINE.20251105T144301Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T205352Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T205352Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T205352Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T205352Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T205837Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T205837Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T205837Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T205837Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T210206Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T210206Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T210206Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak.20251104T210206Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251030T155713' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251030T155713'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251030T155713'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251030T155713'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251031T171956Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251031T171956Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251031T171956Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251031T171956Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251031T172143Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251031T172143Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251031T172143Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251031T172143Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251031T173142Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251031T173142Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251031T173142Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251031T173142Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r10.20251104T210441Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r10.20251104T210441Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r10.20251104T210441Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r10.20251104T210441Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r11.20251104T211127Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r11.20251104T211127Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r11.20251104T211127Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r11.20251104T211127Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12.20251104T211548Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12.20251104T211548Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12.20251104T211548Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12.20251104T211548Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12M.20251105T010919Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12M.20251105T010919Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12M.20251105T010919Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12M.20251105T010919Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12N.20251105T011053Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12N.20251105T011053Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12N.20251105T011053Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12N.20251105T011053Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12O.20251105T011225Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12O.20251105T011225Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12O.20251105T011225Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12O.20251105T011225Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12P.20251105T011455Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12P.20251105T011455Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12P.20251105T011455Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12P.20251105T011455Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12Q.20251105T011914Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12Q.20251105T011914Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12Q.20251105T011914Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12Q.20251105T011914Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12W.20251105T013450Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12W.20251105T013450Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12W.20251105T013450Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12W.20251105T013450Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12Z.20251105T014152Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12Z.20251105T014152Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12Z.20251105T014152Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12Z.20251105T014152Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12b.20251104T211740Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12b.20251104T211740Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12b.20251104T211740Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12b.20251104T211740Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12c.20251104T211939Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12c.20251104T211939Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12c.20251104T211939Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12c.20251104T211939Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12f.20251104T212323Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12f.20251104T212323Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12f.20251104T212323Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12f.20251104T212323Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12h.20251104T212533Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12h.20251104T212533Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12h.20251104T212533Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12h.20251104T212533Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12i.20251105T003854Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12i.20251105T003854Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12i.20251105T003854Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03_convergence_p95_vs_n.py.r12i.20251105T003854Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.BROKEN.20251127T183720Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.BROKEN.20251127T183720Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.BROKEN.20251127T183720Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.BROKEN.20251127T183720Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.QUARANTINE.20251105T144301Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.QUARANTINE.20251105T144301Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.QUARANTINE.20251105T144301Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.QUARANTINE.20251105T144301Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T205352Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T205352Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T205352Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T205352Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T205837Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T205837Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T205837Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T205837Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T210206Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T210206Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T210206Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak.20251104T210206Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T171956Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T171956Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T171956Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T171956Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T172143Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T172143Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T172143Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T172143Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T172247Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T172247Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T172247Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T172247Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T173010Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T173010Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T173010Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T173010Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T173142Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T173142Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T173142Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T173142Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r10.20251104T210441Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r10.20251104T210441Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r10.20251104T210441Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r10.20251104T210441Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r11.20251104T211127Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r11.20251104T211127Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r11.20251104T211127Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r11.20251104T211127Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12.20251104T211548Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12.20251104T211548Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12.20251104T211548Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12.20251104T211548Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12M.20251105T010919Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12M.20251105T010919Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12M.20251105T010919Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12M.20251105T010919Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12N.20251105T011053Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12N.20251105T011053Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12N.20251105T011053Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12N.20251105T011053Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12O.20251105T011225Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12O.20251105T011225Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12O.20251105T011225Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12O.20251105T011225Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12P.20251105T011455Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12P.20251105T011455Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12P.20251105T011455Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12P.20251105T011455Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12Q.20251105T011914Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12Q.20251105T011914Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12Q.20251105T011914Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12Q.20251105T011914Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12W.20251105T013450Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12W.20251105T013450Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12W.20251105T013450Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12W.20251105T013450Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12X.20251105T013719Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12X.20251105T013719Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12X.20251105T013719Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12X.20251105T013719Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12b.20251104T211740Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12b.20251104T211740Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12b.20251104T211740Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12b.20251104T211740Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12c.20251104T211939Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12c.20251104T211939Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12c.20251104T211939Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12c.20251104T211939Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12f.20251104T212323Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12f.20251104T212323Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12f.20251104T212323Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12f.20251104T212323Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12h.20251104T212533Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12h.20251104T212533Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12h.20251104T212533Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12h.20251104T212533Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12i.20251105T003854Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12i.20251105T003854Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12i.20251105T003854Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.r12i.20251105T003854Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.tmp' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.tmp'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.tmp'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig03b_bootstrap_coverage_vs_n.py.tmp'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T205352Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T205352Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T205352Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T205352Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T205837Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T205837Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T205837Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T205837Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T210206Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T210206Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T210206Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak.20251104T210206Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251030T155713' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251030T155713'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251030T155713'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251030T155713'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251031T171956Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251031T171956Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251031T171956Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251031T171956Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251031T172143Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251031T172143Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251031T172143Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251031T172143Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251031T173142Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251031T173142Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251031T173142Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251031T173142Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r10.20251104T210441Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r10.20251104T210441Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r10.20251104T210441Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r10.20251104T210441Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r11.20251104T211127Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r11.20251104T211127Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r11.20251104T211127Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r11.20251104T211127Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r12.20251104T211548Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r12.20251104T211548Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r12.20251104T211548Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r12.20251104T211548Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r12b.20251104T211740Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r12b.20251104T211740Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r12b.20251104T211740Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r12b.20251104T211740Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r12c.20251104T211939Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r12c.20251104T211939Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r12c.20251104T211939Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r12c.20251104T211939Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r12f.20251104T212323Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r12f.20251104T212323Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r12f.20251104T212323Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r12f.20251104T212323Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r12h.20251104T212533Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r12h.20251104T212533Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r12h.20251104T212533Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.r12h.20251104T212533Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.rescue3c.20251105T163042Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.rescue3c.20251105T163042Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.rescue3c.20251105T163042Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.rescue3c.20251105T163042Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.rescue3d.20251105T163331Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.rescue3d.20251105T163331Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.rescue3d.20251105T163331Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig04_scatter_p95_recalc_vs_orig.py.rescue3d.20251105T163331Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T205352Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T205352Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T205352Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T205352Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T205837Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T205837Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T205837Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T205837Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T210206Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T210206Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T210206Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak.20251104T210206Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251030T155713' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251030T155713'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251030T155713'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251030T155713'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251031T171956Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251031T171956Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251031T171956Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251031T171956Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251031T172143Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251031T172143Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251031T172143Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251031T172143Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251031T173142Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251031T173142Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251031T173142Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251031T173142Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.r10.20251104T210441Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.r10.20251104T210441Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.r10.20251104T210441Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.r10.20251104T210441Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.r11.20251104T211127Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.r11.20251104T211127Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.r11.20251104T211127Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.r11.20251104T211127Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.r12.20251104T211548Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.r12.20251104T211548Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.r12.20251104T211548Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.r12.20251104T211548Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.r12b.20251104T211740Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.r12b.20251104T211740Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.r12b.20251104T211740Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.r12b.20251104T211740Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.rescue3c.20251105T163042Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.rescue3c.20251105T163042Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.rescue3c.20251105T163042Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.rescue3c.20251105T163042Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.rescue3d.20251105T163331Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.rescue3d.20251105T163331Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.rescue3d.20251105T163331Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig05_hist_cdf_metrics.py.rescue3d.20251105T163331Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.autofix.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.autofix.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.autofix.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.autofix.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T205140Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T205140Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T205140Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T205140Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T205352Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T205352Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T205352Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T205352Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T205837Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T205837Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T205837Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak.20251104T205837Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_20251031T171956Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_20251031T171956Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_20251031T171956Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_20251031T171956Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_20251031T172143Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_20251031T172143Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_20251031T172143Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_20251031T172143Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_20251031T173143Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_20251031T173143Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_20251031T173143Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_20251031T173143Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_autofix' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_autofix'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_autofix'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.bak_autofix'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.r10.20251104T210441Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.r10.20251104T210441Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.r10.20251104T210441Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.r10.20251104T210441Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.r11.20251104T211127Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.r11.20251104T211127Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.r11.20251104T211127Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.r11.20251104T211127Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.r12.20251104T211548Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.r12.20251104T211548Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.r12.20251104T211548Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.r12.20251104T211548Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.r12b.20251104T211740Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.r12b.20251104T211740Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.r12b.20251104T211740Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.r12b.20251104T211740Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.r12c.20251104T211939Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.r12c.20251104T211939Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.r12c.20251104T211939Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.r12c.20251104T211939Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.rescue.20251105T165113Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.rescue.20251105T165113Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.rescue.20251105T165113Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.rescue.20251105T165113Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.rescue3c.20251105T163042Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.rescue3c.20251105T163042Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.rescue3c.20251105T163042Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.rescue3c.20251105T163042Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig06_residual_map.py.rescue3d.20251105T163331Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig06_residual_map.py.rescue3d.20251105T163331Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig06_residual_map.py.rescue3d.20251105T163331Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig06_residual_map.py.rescue3d.20251105T163331Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak_20251031T171956Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak_20251031T171956Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak_20251031T171956Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak_20251031T171956Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak_20251031T172143Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak_20251031T172143Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak_20251031T172143Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak_20251031T172143Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak_20251031T173143Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak_20251031T173143Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak_20251031T173143Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak_20251031T173143Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/plot_fig07_synthesis.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T202139Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T202139Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T202139Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T202139Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T205140Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T205140Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T205140Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T205140Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T205352Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T205352Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T205352Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak.20251104T205352Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak_20251031T182357Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak_20251031T182357Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak_20251031T182357Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak_20251031T182357Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.r11.20251104T211127Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.r11.20251104T211127Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.r11.20251104T211127Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.r11.20251104T211127Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.r12.20251104T211548Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.r12.20251104T211548Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.r12.20251104T211548Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.r12.20251104T211548Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/qc_wrapped_vs_unwrapped.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/recompute_p95_circular.py.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/recompute_p95_circular.py.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/recompute_p95_circular.py.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/recompute_p95_circular.py.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T205140Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T205140Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T205140Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T205140Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T205352Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T205352Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T205352Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T205352Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T205837Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T205837Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T205837Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T205837Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T210206Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T210206Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T210206Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/recompute_p95_circular.py.bak.20251104T210206Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/recompute_p95_circular.py.bak_20251031T174106Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/recompute_p95_circular.py.bak_20251031T174106Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/recompute_p95_circular.py.bak_20251031T174106Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/recompute_p95_circular.py.bak_20251031T174106Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/recompute_p95_circular.py.bak_20251031T174221Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/recompute_p95_circular.py.bak_20251031T174221Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/recompute_p95_circular.py.bak_20251031T174221Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/recompute_p95_circular.py.bak_20251031T174221Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/recompute_p95_circular.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/recompute_p95_circular.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/recompute_p95_circular.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/recompute_p95_circular.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/recompute_p95_circular.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/recompute_p95_circular.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/recompute_p95_circular.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/recompute_p95_circular.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/recompute_p95_circular.py.r10.20251104T210441Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/recompute_p95_circular.py.r10.20251104T210441Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/recompute_p95_circular.py.r10.20251104T210441Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/recompute_p95_circular.py.r10.20251104T210441Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/recompute_p95_circular.py.r11.20251104T211127Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/recompute_p95_circular.py.r11.20251104T211127Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/recompute_p95_circular.py.r11.20251104T211127Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/recompute_p95_circular.py.r11.20251104T211127Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/recompute_p95_circular.py.r12.20251104T211548Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/recompute_p95_circular.py.r12.20251104T211548Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/recompute_p95_circular.py.r12.20251104T211548Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/recompute_p95_circular.py.r12.20251104T211548Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/recompute_p95_circular.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/recompute_p95_circular.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/recompute_p95_circular.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/recompute_p95_circular.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/recompute_p95_circular.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/recompute_p95_circular.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/recompute_p95_circular.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/recompute_p95_circular.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T194759Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T194759Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T194759Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T194759Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T202752Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T202752Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T202752Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T202752Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T204319Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T204319Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T204319Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T204319Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T205352Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T205352Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T205352Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T205352Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T205837Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T205837Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T205837Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T205837Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T210206Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T210206Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T210206Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak.20251104T210206Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak_20251031T174106Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak_20251031T174106Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak_20251031T174106Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak_20251031T174106Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak_20251031T174221Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak_20251031T174221Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak_20251031T174221Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak_20251031T174221Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r10.20251104T210441Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r10.20251104T210441Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r10.20251104T210441Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r10.20251104T210441Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r11.20251104T211127Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r11.20251104T211127Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r11.20251104T211127Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r11.20251104T211127Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r12.20251104T211548Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r12.20251104T211548Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r12.20251104T211548Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r12.20251104T211548Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r12b.20251104T211740Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r12b.20251104T211740Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r12b.20251104T211740Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r12b.20251104T211740Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r12c.20251104T211939Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r12c.20251104T211939Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r12c.20251104T211939Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r12c.20251104T211939Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r12f.20251104T212323Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r12f.20251104T212323Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r12f.20251104T212323Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r12f.20251104T212323Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r12h.20251104T212533Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r12h.20251104T212533Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r12h.20251104T212533Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.r12h.20251104T212533Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.rescue.20251105T160822Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.rescue.20251105T160822Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.rescue.20251105T160822Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.rescue.20251105T160822Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.rescue2.20251105T161809Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.rescue2.20251105T161809Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.rescue2.20251105T161809Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.rescue2.20251105T161809Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.rescue3.20251105T162439Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.rescue3.20251105T162439Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.rescue3.20251105T162439Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.rescue3.20251105T162439Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.rescue3c.20251105T163042Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.rescue3c.20251105T163042Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.rescue3c.20251105T163042Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.rescue3c.20251105T163042Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/regen_fig05_using_circp95.py.rescue3d.20251105T163331Z.bak' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/regen_fig05_using_circp95.py.rescue3d.20251105T163331Z.bak'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/regen_fig05_using_circp95.py.rescue3d.20251105T163331Z.bak'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/regen_fig05_using_circp95.py.rescue3d.20251105T163331Z.bak'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/update_manifest_with_hashes.py.bak.20251104T202456Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/update_manifest_with_hashes.py.bak.20251104T202456Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/update_manifest_with_hashes.py.bak.20251104T202456Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/update_manifest_with_hashes.py.bak.20251104T202456Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/update_manifest_with_hashes.py.bak.20251104T203914Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/update_manifest_with_hashes.py.bak.20251104T203914Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/update_manifest_with_hashes.py.bak.20251104T203914Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/update_manifest_with_hashes.py.bak.20251104T203914Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/update_manifest_with_hashes.py.bak_20251031T182357Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/update_manifest_with_hashes.py.bak_20251031T182357Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/update_manifest_with_hashes.py.bak_20251031T182357Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/update_manifest_with_hashes.py.bak_20251031T182357Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/update_manifest_with_hashes.py.bak_20251031T204500Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/update_manifest_with_hashes.py.bak_20251031T204500Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/update_manifest_with_hashes.py.bak_20251031T204500Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/update_manifest_with_hashes.py.bak_20251031T204500Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/update_manifest_with_hashes.py.bak_20251031T204856Z' ]; then echo "[DELETE] [BACKUP_OR_RESCUE] rm 'zz-scripts/chapter10/update_manifest_with_hashes.py.bak_20251031T204856Z'  # Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/update_manifest_with_hashes.py.bak_20251031T204856Z'; else echo "[MISSING] [BACKUP_OR_RESCUE] 'zz-scripts/chapter10/update_manifest_with_hashes.py.bak_20251031T204856Z'  # (déjà absent) Copie de secours / variante (suffixe .bak/.pass/.broken/.rescue/.tmp...)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/__pycache__/add_phi_at_fpeak.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter10/__pycache__/add_phi_at_fpeak.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/__pycache__/add_phi_at_fpeak.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter10/__pycache__/add_phi_at_fpeak.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/__pycache__/bootstrap_topk_p95.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter10/__pycache__/bootstrap_topk_p95.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/__pycache__/bootstrap_topk_p95.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter10/__pycache__/bootstrap_topk_p95.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/__pycache__/check_metrics_consistency.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter10/__pycache__/check_metrics_consistency.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/__pycache__/check_metrics_consistency.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter10/__pycache__/check_metrics_consistency.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/__pycache__/diag_phi_fpeak.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter10/__pycache__/diag_phi_fpeak.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/__pycache__/diag_phi_fpeak.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter10/__pycache__/diag_phi_fpeak.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/__pycache__/eval_primary_metrics_20_300.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter10/__pycache__/eval_primary_metrics_20_300.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/__pycache__/eval_primary_metrics_20_300.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter10/__pycache__/eval_primary_metrics_20_300.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/__pycache__/generate_data_chapter10.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter10/__pycache__/generate_data_chapter10.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/__pycache__/generate_data_chapter10.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter10/__pycache__/generate_data_chapter10.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/__pycache__/inspect_topk_residuals.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter10/__pycache__/inspect_topk_residuals.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/__pycache__/inspect_topk_residuals.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter10/__pycache__/inspect_topk_residuals.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/__pycache__/plot_fig01_iso_p95_maps.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter10/__pycache__/plot_fig01_iso_p95_maps.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/__pycache__/plot_fig01_iso_p95_maps.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter10/__pycache__/plot_fig01_iso_p95_maps.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/__pycache__/plot_fig01_iso_p95_maps.py.preclean-20251105T182218Z.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter10/__pycache__/plot_fig01_iso_p95_maps.py.preclean-20251105T182218Z.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/__pycache__/plot_fig01_iso_p95_maps.py.preclean-20251105T182218Z.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter10/__pycache__/plot_fig01_iso_p95_maps.py.preclean-20251105T182218Z.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/__pycache__/plot_fig02_scatter_phi_at_fpeak.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter10/__pycache__/plot_fig02_scatter_phi_at_fpeak.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/__pycache__/plot_fig02_scatter_phi_at_fpeak.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter10/__pycache__/plot_fig02_scatter_phi_at_fpeak.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/__pycache__/plot_fig03_convergence_p95_vs_n.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter10/__pycache__/plot_fig03_convergence_p95_vs_n.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/__pycache__/plot_fig03_convergence_p95_vs_n.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter10/__pycache__/plot_fig03_convergence_p95_vs_n.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/__pycache__/plot_fig03b_bootstrap_coverage_vs_n.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter10/__pycache__/plot_fig03b_bootstrap_coverage_vs_n.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/__pycache__/plot_fig03b_bootstrap_coverage_vs_n.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter10/__pycache__/plot_fig03b_bootstrap_coverage_vs_n.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/__pycache__/plot_fig04_scatter_p95_recalc_vs_orig.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter10/__pycache__/plot_fig04_scatter_p95_recalc_vs_orig.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/__pycache__/plot_fig04_scatter_p95_recalc_vs_orig.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter10/__pycache__/plot_fig04_scatter_p95_recalc_vs_orig.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/__pycache__/plot_fig05_hist_cdf_metrics.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter10/__pycache__/plot_fig05_hist_cdf_metrics.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/__pycache__/plot_fig05_hist_cdf_metrics.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter10/__pycache__/plot_fig05_hist_cdf_metrics.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/__pycache__/plot_fig06_residual_map.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter10/__pycache__/plot_fig06_residual_map.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/__pycache__/plot_fig06_residual_map.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter10/__pycache__/plot_fig06_residual_map.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/__pycache__/plot_fig06_residual_map.py.preclean-20251105T182218Z.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter10/__pycache__/plot_fig06_residual_map.py.preclean-20251105T182218Z.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/__pycache__/plot_fig06_residual_map.py.preclean-20251105T182218Z.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter10/__pycache__/plot_fig06_residual_map.py.preclean-20251105T182218Z.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/__pycache__/plot_fig07_synthesis.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter10/__pycache__/plot_fig07_synthesis.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/__pycache__/plot_fig07_synthesis.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter10/__pycache__/plot_fig07_synthesis.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/__pycache__/qc_wrapped_vs_unwrapped.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter10/__pycache__/qc_wrapped_vs_unwrapped.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/__pycache__/qc_wrapped_vs_unwrapped.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter10/__pycache__/qc_wrapped_vs_unwrapped.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/__pycache__/recompute_p95_circular.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter10/__pycache__/recompute_p95_circular.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/__pycache__/recompute_p95_circular.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter10/__pycache__/recompute_p95_circular.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/__pycache__/regen_fig05_using_circp95.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter10/__pycache__/regen_fig05_using_circp95.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/__pycache__/regen_fig05_using_circp95.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter10/__pycache__/regen_fig05_using_circp95.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
if [ -e 'zz-scripts/chapter10/__pycache__/update_manifest_with_hashes.cpython-312.pyc' ]; then echo "[DELETE] [BYTECODE] rm 'zz-scripts/chapter10/__pycache__/update_manifest_with_hashes.cpython-312.pyc'  # Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; rm -f -- 'zz-scripts/chapter10/__pycache__/update_manifest_with_hashes.cpython-312.pyc'; else echo "[MISSING] [BYTECODE] 'zz-scripts/chapter10/__pycache__/update_manifest_with_hashes.cpython-312.pyc'  # (déjà absent) Fichier .pyc compilé (re-générable)." | tee -a "$LOG_FILE"; fi
