from backend.loongarch64 import Loongarch64ArchitecturalState, Loongarch64SocketRunner
import instr_rev_z3

runner = Loongarch64SocketRunner(["backend/qemu-user-loongarch64-static", "backend/runner_socket_loongarch64"])


solver = instr_rev_z3.Z3Solver(max_depth=2, debug=True, display_progress=True)

state_class = Loongarch64ArchitecturalState
state_before = state_class(solver, feature_set=set())
state_after  = state_class(solver, feature_set=set())

bitmap = bytearray(0x100000000 // 8)

for i in range(0x100000000):
    if i % (1024) == 0:
        print("progress:", i, "/", 0x100000000)
    state_before.set_register("pc", 0x8080000)
    runner.run_instructions(i.to_bytes(4, "little") + b"\x00\x00\x00\x00", state_before, state_after)
    if state_after.get_register("error_code")[1] != 4 or state_after.get_register("error_info")[1] != 0x8080000:
        bitmap[i // 8] |= 1 << (i % 8)

open("bitmap.bin", "wb").write(bitmap)
