from backend.loongarch64 import Loongarch64ArchitecturalState, Loongarch64SocketRunner

import instr_rev_z3

import sys
import time

INSTR_AMOUNT = 100000

solver = instr_rev_z3.Z3Solver(max_depth=2)

before = Loongarch64ArchitecturalState(solver)
after  = Loongarch64ArchitecturalState(solver)

instruction = eval(sys.argv[1]) if len(sys.argv) > 1 else 0

runner = Loongarch64SocketRunner(["backend/qemu-user-loongarch64-static", "backend/runner_socket_loongarch64"])

before.set_register("pc", 0x133700000)

start = time.time()
for _ in range(INSTR_AMOUNT):
    runner.run_instructions(instruction.to_bytes(4, "little"), before, after)
end = time.time()

print(f"same state: {int(INSTR_AMOUNT / (end - start))} executions / second")


constants = list(range(10000))

start = time.time()
for _ in range(INSTR_AMOUNT):
    solver.create_random_sample(constants, before, [], dict(), dict())
    runner.run_instructions(instruction.to_bytes(4, "little"), before, after)
end = time.time()

print(f"random state: {int(INSTR_AMOUNT / (end - start))} executions / second")

runner.kill_runner()
