import instr_rev, backend.generic_backend
class X86_64ArchitecturalState(backend.generic_backend.GenericArchitecturalState):
    def __init__(self, solver, feature_set=None):
        super().__init__(0x1000, [instr_rev.Register(f"r{i+8}", 64, [], [(3, i)], encoding_group="gpr_new") for i in range(8)] + 
            [instr_rev.Register(name, 64, [], [(3, i)], encoding_group="gpr") for name, i in 
                    [("rdi", 7), ("rsi", 6), ("rbp", 5), ("rbx", 3), ("rdx", 2), ("rax", 0), ("rcx", 1), ("rsp", 4)]] +
            [instr_rev.Register("pc", 64, [solver.create_less_constraint("pc", 64, 1 << 46), solver.create_greatereq_constraint("pc", 64, 0x40008)], [], encoding_group="pc")])
class X86_64SocketRunner(backend.generic_backend.GenericSocketRunner):
    def __init__(self, command, **kwargs):
        super().__init__(command, pc_reg_name = "pc", prefix_instructions = b"\x48\x8b\x7f\x40", trapping_instruction = b"\xff\xff\xff\xff", **kwargs)
