#ifndef TIME_H
#define TIME_H

#include "syscall.h"

#define CLOCK_REALTIME            0
#define CLOCK_MONOTONIC           1
#define CLOCK_PROCESS_CPUTIME_ID  2
#define CLOCK_THREAD_CPUTIME_ID   3
#define CLOCK_MONOTONIC_RAW       4
#define CLOCK_REALTIME_COARSE     5
#define CLOCK_MONOTONIC_COARSE    6
#define CLOCK_BOOTTIME            7
#define CLOCK_REALTIME_ALARM      8
#define CLOCK_BOOTTIME_ALARM      9
#define CLOCK_SGI_CYCLE           10
#define CLOCK_TAI                 11


struct timespec {
    int64_t tv_secs;
    uint64_t tv_nsec;
};

// TODO: move out of header and not static
static uint64_t nano_time() {
    struct timespec ts;
    sys_clock_gettime(CLOCK_MONOTONIC_RAW, &ts);
    return ts.tv_secs * 1000000000lu + ts.tv_nsec;
}

#endif /* TIME_H */
