#ifndef SIGNAL_H
#define SIGNAL_H

// syscalls for signal handler stuff
#include "syscall.h"

// for use with sigaltstack
struct sigstack {
    void *ss_sp;
    uint64_t ss_flags;
    uint64_t ss_size;
};

// TODO: for some reason this is a bit broken
struct sigset {
    uint64_t __val[16];
};

// TODO: make sure this works
struct siginfo {
    int si_signo;
    int si_errno;
    int si_code;
    struct {
        void *si_addr;
    } _sigfault; // SIGILL, SIGFPE, SIGSEGV, SIGBUS.
};

// include architecture-dependent signal handling struct stuff
#include "arch_signal.h"

// signals
#define SIGHUB     1
#define SIGINT     2
#define SIGQUIT    3
#define SIGILL     4
#define SIGTRAP    5
#define SIGABRT    6
#define SIGIOT     6
#define SIGBUS     7
#define SIGFPE     8
#define SIGKILL    9
#define SIGUSR1    10
#define SIGSEGV    11
#define SIGUSR2    12
#define SIGPIPE    13
#define SIGALRM    14
#define SIGTERM    15
#define SIGSTKFLT  16
#define SIGCHLD    17
#define SIGCONT    18
#define SIGSTOP    19
#define SIGTSTP    20
#define SIGTTIN    21
#define SIGTTOU    22
#define SIGURT     23
#define SIGXCPU    24
#define SIGXSFZ    25
#define SIGVTALMR  26
#define SIGPROF    27
#define SIGWINCH   28
#define SIGIO      29
#define SIGPOLL    29
#define SIGPWR     30
#define SIGSYS     31
#define SIGRTMIN   32

// for use with rt_sigprocmask (first argument)
#define	SIG_BLOCK    0
#define	SIG_UNBLOCK  1
#define	SIG_SETMASK  2

// flags for sigaction
#define SA_SIGINFO 0x4ul
#define SA_ONSTACK 0x08000000ul

#ifndef SIGSET_SIZE
    // might be different on some platforms, so only define if not defined by platform specific header
    #define SIGSET_SIZE 8
#endif /* SIGSET_SIZE */

// struct sigaction is architecture dependent, so it is not here!
// struct siginfo is also architecture dependent

#ifndef SIG_PC
    #warning "platform does not provide SIG_PC macro!"
#endif /* SIG_PC */

// functions map (almost) directly to syscalls
#define sigaltstack(...) sys_sigaltstack(__VA_ARGS__)
#define sigaction(signum, act, oldact) sys_rt_sigaction(signum, act, oldact, SIGSET_SIZE)
#define sigprocmask(how, set, oldset) sys_rt_sigprocmask(how, set, oldset, SIGSET_SIZE)

#endif /* SIGNAL_H */
