#ifndef X86_64_SIGNAL_H
#define X86_64_SIGNAL_H
struct sigstack;
struct sigset;
struct siginfo;
#define SIGSET_SIZE 8
struct sigaction {
    union {
        void (*sa_handler)(int);
        void (*sa_sigaction) (int, struct siginfo*, void *);
    }  __sigaction_handler;
    #define sa_handler __sigaction_handler.sa_handler
    #define sa_sigaction __sigaction_handler.sa_sigaction
    uint64_t sa_flags;
    void (*sa_restorer) (void);
    uint64_t sa_mask;
};
struct mcontext {
    uint64_t __gregs[23];
    void* fpregs;
    uint64_t reserved[8];
};
struct ucontext {
    uint64_t __uc_flags;
    struct ucontext_t *uc_link;
    struct sigstack uc_stack;
    struct mcontext uc_mcontext;
    struct sigset uc_sigmask;
};
#define SIG_PC(x) (((struct ucontext*)x)->uc_mcontext.__gregs[16])
#define SIG_GPS(x) (((struct ucontext*)x)->uc_mcontext.__gregs)
#define SIG_GPS_COUNT(x) 16
#endif /* X86_64_SIGNAL_H */
