/**
 * Syscall wrapper functions.
 * On riscv64 syscall arguments are passed in a0, ..., a5 (or maybe even a6, I don't know).
 * This is exactly the same as the first few function arguments!
 * And since we invoke these wrappers in a clever way, all that must be done is put the syscall number into a7.
 * The syscall number is passed as last argument to the __syscall_n functions, so the register it is in depends on the number of syscall arguments.
 * To invoke a syscall, linux loongarch64 expects the use of the syscall instruction with immediate 0.
 */

.global __syscall_1
.global __syscall_2
.global __syscall_3
.global __syscall_4
.global __syscall_5
.global __syscall_6

.text

__syscall_1:
    mv a7, a1
    ecall
    ret

__syscall_2:
    mv a7, a2
    ecall
    ret

__syscall_3:
    mv a7, a3
    ecall
    ret

__syscall_4:
    mv a7, a4
    ecall
    ret

__syscall_5:
    mv a7, a5
    ecall
    ret

__syscall_6:
    mv a7, a6
    ecall
    ret
