/**
 * Syscall wrapper functions.
 * On loongarch64 syscall arguments are passed in a0, ..., a5 (or maybe even a6, I don't know).
 * This is exactly the same as the first few function arguments!
 * And since we invoke these wrappers in a clever way, all that must be done is put the syscall number into a7.
 * The syscall number is passed as last argument to the __syscall_n functions, so the register it is in depends on the number of syscall arguments.
 * To invoke a syscall, linux loongarch64 expects the use of the syscall instruction with immediate 0.
 */

.global __syscall_1
.global __syscall_2
.global __syscall_3
.global __syscall_4
.global __syscall_5
.global __syscall_6

.text

__syscall_1:
    add.d $a7, $zero, $a1
    syscall 0
    ret

__syscall_2:
    add.d $a7, $zero, $a2
    syscall 0
    ret

__syscall_3:
    add.d $a7, $zero, $a3
    syscall 0
    ret

__syscall_4:
    add.d $a7, $zero, $a4
    syscall 0
    ret

__syscall_5:
    add.d $a7, $zero, $a5
    syscall 0
    ret

__syscall_6:
    add.d $a7, $zero, $a6
    syscall 0
    ret
